/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.SQLException;
import java.util.Vector;
import javax.datamining.data.AttributeDataType;
import javax.datamining.data.CategoryProperty;
import javax.datamining.data.CategorySet;
import javax.datamining.data.CategorySetFactory;
import javax.datamining.resource.Connection;
import javax.datamining.supervised.classification.CostMatrix;
import javax.datamining.supervised.classification.CostMatrixFactory;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.dmt.dm4j.datasources.DM4JDataSource;
import oracle.dmt.dm4j.datasources.TargetValueDataSource;

public class TargetValueCostMatrixDataSource
extends DM4JDataSource {
    private Vector m_targetValues = null;
    private TargetValueDataSource m_prior = null;
    private String[] m_columns = null;
    private String m_selectedTargetValue = null;

    public TargetValueCostMatrixDataSource() {
        this((Vector)null);
    }

    public TargetValueCostMatrixDataSource(Vector vector) {
        super(null);
        this.m_targetValues = vector;
    }

    public TargetValueCostMatrixDataSource(TargetValueDataSource targetValueDataSource) {
        this(targetValueDataSource, null);
    }

    public TargetValueCostMatrixDataSource(TargetValueDataSource targetValueDataSource, String string) {
        super(null);
        this.m_targetValues = targetValueDataSource.getAttributes(0);
        this.m_prior = targetValueDataSource;
        this.m_selectedTargetValue = string;
    }

    public void setCostMatrix(CostMatrix costMatrix) throws Exception {
        try {
            int n = this.getRowCount();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    Double d = costMatrix.getValue(this.m_columns[i], this.m_columns[j]);
                    this.setData(j, i, d);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected ArrayOneDModel createColumns() throws Exception {
        return this.createColumnsFromDefault();
    }

    private ArrayOneDModel createColumnsFromDefault() throws Exception {
        int n = this.m_targetValues.size();
        this.addColumns(0, n);
        this.m_columns = new String[n];
        for (int i = 0; i < n; ++i) {
            this.m_columns[i] = (String)this.m_targetValues.get(i);
        }
        return new ArrayOneDModel(this.m_columns);
    }

    protected void createData() throws SQLException {
        this.createDataFromDefault();
    }

    private void createDataFromDefault() throws SQLException {
        int n = this.m_targetValues.size();
        this.addRows(0, n);
        for (int i = 0; i < n; ++i) {
            int n2;
            double d = 1.0;
            int n3 = 0;
            String string = (String)this.m_targetValues.get(i);
            if (this.m_prior != null) {
                n2 = this.m_prior.getTargetCountTotal();
                for (int j = 0; j < n; ++j) {
                    int n4;
                    String string2;
                    if (this.m_selectedTargetValue != null) {
                        string2 = (String)this.m_prior.getData(0, j);
                        n4 = (Integer)this.m_prior.getData(1, j);
                        if (this.m_selectedTargetValue.compareTo(string) == 0) {
                            if (string2.compareTo(this.m_selectedTargetValue) != 0) continue;
                            n3 = n4;
                            break;
                        }
                        if (string2.compareTo(this.m_selectedTargetValue) == 0) continue;
                        n3 += n4;
                        continue;
                    }
                    string2 = (String)this.m_prior.getData(0, j);
                    n4 = (Integer)this.m_prior.getData(1, j);
                    if (string2.compareTo(string) != 0) continue;
                    n3 = n4;
                    break;
                }
                d = (double)n2 / (double)n3;
            } else {
                d = 1.0;
            }
            for (n2 = 0; n2 < n; ++n2) {
                try {
                    this.setData(n2, i, new Double(i != n2 ? d : 0.0));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void clone(TargetValueCostMatrixDataSource targetValueCostMatrixDataSource) {
        int n;
        int n2 = targetValueCostMatrixDataSource.getColumnCount();
        this.addColumns(0, n2);
        this.m_columns = new String[n2];
        ArrayOneDModel arrayOneDModel = targetValueCostMatrixDataSource.getColumnDataSource();
        for (n = 0; n < n2; ++n) {
            this.m_columns[n] = (String)arrayOneDModel.getData(n);
        }
        this.m_columnModel = new ArrayOneDModel(this.m_columns);
        this.addRows(0, n2);
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n2; ++i) {
                Double d = (Double)targetValueCostMatrixDataSource.getData(i, n);
                this.setData(i, n, new Double(d));
            }
        }
    }

    private void fillCostMatrix(CostMatrix costMatrix) {
        try {
            int n = this.getRowCount();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    Double d = (Double)this.getData(j, i);
                    costMatrix.setValue(this.m_columns[i], this.m_columns[j], d);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public CostMatrix generateCostMatrix(Connection connection) throws Exception {
        CostMatrix costMatrix = null;
        CategorySetFactory categorySetFactory = (CategorySetFactory)connection.getFactory("javax.datamining.data.CategorySet");
        CostMatrixFactory costMatrixFactory = (CostMatrixFactory)connection.getFactory("javax.datamining.supervised.classification.CostMatrix");
        ArrayOneDModel arrayOneDModel = this.getColumnDataSource();
        CategorySet categorySet = categorySetFactory.create(AttributeDataType.stringType);
        int n = arrayOneDModel.getItemCount();
        for (int i = 0; i < n; ++i) {
            categorySet.addCategory((String)arrayOneDModel.getData(i), CategoryProperty.valid);
        }
        costMatrix = costMatrixFactory.create(categorySet);
        this.fillCostMatrix(costMatrix);
        return costMatrix;
    }

    public void syncrhonizeCostMatrix(TargetValueCostMatrixDataSource targetValueCostMatrixDataSource) {
    }
}

