/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.datasources.OutlierDiscretizeDataSource;
import oracle.dmt.dm4j.wizard.steps.transformsteps.OutlierSigmaSettingsPanel;

public class OutlierPredefinedNumericTreatment {
    OutlierDiscretizeDataSource m_model;

    public OutlierPredefinedNumericTreatment(OutlierDiscretizeDataSource outlierDiscretizeDataSource) {
        this.m_model = outlierDiscretizeDataSource;
    }

    public void processAttributes(ActivityType activityType) {
        if (activityType.equals(ActivityType.SVM_CLASSIFICATION) || activityType.equals(ActivityType.GLM_CLASSIFICATION) || activityType.equals(ActivityType.SVM_SINGLE_CLASS) || activityType.equals(ActivityType.SVM_REGRESSION) || activityType.equals(ActivityType.GLM_REGRESSION)) {
            this.winsorizeEdges();
        } else if (activityType.equals(ActivityType.NON_NEGATIVE_MATIX_FACTORIZATION) || activityType.equals(ActivityType.ASSOCIATION_RULES) || activityType.equals(ActivityType.O_CLUSTER) || activityType.equals(ActivityType.K_MEANS_CLUSTER)) {
            this.winsorizeNulls();
        } else {
            this.clearAll();
        }
    }

    protected void winsorizeEdges() {
        this.doThreeSigmaTreatment(true, 3.0);
    }

    protected void winsorizeNulls() {
        this.doThreeSigmaTreatment(false, 3.0);
    }

    public void clearAll() {
        for (int i = 0; i < this.m_model.getRowCount(); ++i) {
            this.m_model.clearCutoffRange(i);
        }
    }

    public void doThreeSigmaTreatment(boolean bl, double d) {
        for (int i = 0; i < this.m_model.getRowCount(); ++i) {
            Double d2 = this.m_model.getAverage(i);
            Double d3 = this.m_model.getSigma(i);
            if (d2 == null || d3 == null) continue;
            StringBuffer stringBuffer = new StringBuffer(OutlierDiscretizeDataSource.getOpenBracket(bl) + "AVG ");
            stringBuffer.append(OutlierSigmaSettingsPanel.PLUS_MINUS);
            stringBuffer.append(" " + d);
            stringBuffer.append(OutlierSigmaSettingsPanel.SIGMA_SIGN + OutlierDiscretizeDataSource.getCloseBracket(bl));
            double d4 = d2 - d * d3;
            double d5 = d2 + d * d3;
            this.m_model.setMin(i, d4);
            this.m_model.setMax(i, d5);
            this.m_model.setCutoffRange(i, stringBuffer.toString(), d4, d5, d, bl);
        }
    }
}

