/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Vector;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.dm4j.datasources.NormalizeDataSource;
import oracle.dmt.dm4j.wizard.director.transforms.TransformsDirector;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.odm.binning.Bin;
import oracle.dmt.odm.binning.BinningType;
import oracle.dmt.odm.binning.DM4JTransformation;

public class NumericDataSource
extends SortableTwoDModel {
    private static int A = 0;
    protected Connection m_conn;
    protected static int COLUMN_COUNT = COLUMN_NAMES.LAST;
    private static String[] items = new String[COLUMN_COUNT];
    public static int STAT_TOTAL;
    public static int STAT_AVERAGE;
    public static int STAT_MAX;
    public static int STAT_MIN;
    public static int STAT_VARIANCE;
    public static int STAT_STDEV;
    public static int STAT_SKEW;
    public static int STAT_KURT;
    public static int NUMBER_STATS;
    protected String m_attributeMapping;
    protected String m_valueMapping;
    protected String m_seqIdMapping;
    protected boolean m_isTransactional = false;
    protected boolean m_bSingleMetric;
    protected StringBuffer m_txSampledViewDefinition;
    protected int m_nullCount = 0;
    protected static final String[] STAT_SQL_WINSORIZE_1ST_ORDER_2D;
    protected static final String[] STAT_SQL_WINSORIZE_1ST_ORDER_TX;
    protected static final String[] STAT_SQL_WINSORIZE_1ST_ORDER_SIMPLE;
    protected static String[] STAT_SQL_WINSORIZE_2ND_ORDER;
    protected static String[] STAT_SQL_WINSORIZE_2ND_ORDER_TX;
    protected static String STAT_SQL_EQ_WIDTH_1ST_ORDER_2D_PREFIX;
    protected static String STAT_SQL_EQ_WIDTH_1ST_ORDER_2D;
    protected static String STAT_SQL_EQ_WIDTH_1ST_ORDER_TX;
    protected static String STAT_SQL_EQ_WIDTH_1ST_ORDER_SIMPLE;
    protected static String[] STAT_SQL_EQ_WIDTH_2ND_ORDER;
    protected static String MIN_MAX_DISCRETIZE;
    protected static String WINSORIZED_VIEW;
    protected static String FUNCTION_BASED_VIEW_2D;
    protected static String FUNCTION_BASED_VIEW_TX;
    protected static String NUMERIC_BIN_TABLE_PREFIX;
    protected static String CATEGORIC_BIN_TABLE_PREFIX;
    protected static String FUNCTION_BASED_VIEW_PREFIX;
    protected static String RESULT_VIEW_NAME;
    protected String m_numericalDiscretizationTableName = null;
    protected String m_categoricalDiscretizationTableName = null;
    protected String m_originlDataLocation = null;
    protected String m_tableName = null;
    protected String m_functionBasedView = null;
    protected String m_dataSourceSchemaName = null;
    protected String m_userSchemaName = null;
    protected String m_resultViewName = null;
    protected String m_functionName = null;
    protected String m_attributeName = null;
    protected ComplexDataStructure m_sampleCDS;
    protected String m_uniqueName;
    protected NormalizeDataSource m_cdsModel;

    public int getNullCount() {
        return this.m_nullCount;
    }

    protected NumericDataSource(int n, int n2) {
        super(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NumericDataSource(Connection connection, String string, String string2, String string3, String string4, int n, double d) throws Exception {
        super(COLUMN_COUNT, 1);
        this.m_conn = connection;
        this.m_isTransactional = false;
        try {
            try {
                this.m_functionName = string;
                this.m_attributeName = TransformsDirector.getReplacedString(string2, "'", "''");
                this.m_attributeName = "'" + this.m_attributeName + "'";
                this.m_tableName = string3;
                this.m_dataSourceSchemaName = string4;
                this.m_userSchemaName = DM4JConnectionManager.getUser();
                this.m_resultViewName = ValidationUtil.createUniqueTableName(RESULT_VIEW_NAME, this.m_conn, "");
                this.m_originlDataLocation = string4 + "." + string3;
                int n2 = 0;
                String string5 = string2;
                this.setData(COLUMN_NAMES.NAME, n2, string5);
                this.setData(COLUMN_NAMES.BINNUMBER, n2, new Integer(n));
                this.setData(COLUMN_NAMES.TAILPERCENT, n2, new Double(d));
                double[] dArray = this.getWinsorizedStats(this.m_conn, string, d);
                this.setStatistics(dArray);
                this.setBinningType(BinningType.EQ_WIDTH);
                this.m_numericalDiscretizationTableName = ValidationUtil.createUniqueTableName(NUMERIC_BIN_TABLE_PREFIX, this.m_conn, "");
                this.m_categoricalDiscretizationTableName = ValidationUtil.createUniqueTableName(CATEGORIC_BIN_TABLE_PREFIX, this.m_conn, "");
                this.createFunctionBasedView2D(this.m_conn);
            }
            catch (Exception exception) {
                System.out.println(exception.getLocalizedMessage());
                Object var13_13 = null;
            }
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NumericDataSource(Connection connection, String string, String string2, String string3, String string4, int n, double d, String string5, String string6, String string7, boolean bl) throws Exception {
        super(COLUMN_COUNT, 1);
        this.m_conn = connection;
        this.m_isTransactional = true;
        this.m_bSingleMetric = bl;
        this.m_attributeMapping = string5;
        this.m_valueMapping = string6;
        this.m_seqIdMapping = string7;
        try {
            try {
                this.m_functionName = string;
                this.m_attributeName = TransformsDirector.getReplacedString(string2, "'", "''");
                this.m_attributeName = "'" + this.m_attributeName + "'";
                this.m_tableName = string3;
                this.m_dataSourceSchemaName = string4;
                this.m_userSchemaName = DM4JConnectionManager.getUser();
                this.m_resultViewName = ValidationUtil.createUniqueTableName(RESULT_VIEW_NAME, this.m_conn, "");
                this.m_originlDataLocation = string4 + "." + string3;
                int n2 = 0;
                String string8 = string2;
                this.setData(COLUMN_NAMES.NAME, n2, string8);
                this.setData(COLUMN_NAMES.BINNUMBER, n2, new Integer(n));
                this.setData(COLUMN_NAMES.TAILPERCENT, n2, new Double(d));
                double[] dArray = this.getWinsorizedStats(this.m_conn, string, d);
                this.setStatistics(dArray);
                this.setBinningType(BinningType.EQ_WIDTH);
                this.m_numericalDiscretizationTableName = ValidationUtil.createUniqueTableName(NUMERIC_BIN_TABLE_PREFIX, this.m_conn, "");
                this.m_categoricalDiscretizationTableName = ValidationUtil.createUniqueTableName(CATEGORIC_BIN_TABLE_PREFIX, this.m_conn, "");
                if (this.m_bSingleMetric) {
                    this.createFunctionBasedView2D(this.m_conn);
                    return;
                }
                this.createFunctionBasedViewTX(this.m_conn);
                DM4JTransformation.createPhysicalTables(this.m_conn, this.m_numericalDiscretizationTableName, this.m_categoricalDiscretizationTableName, this.m_userSchemaName);
                this.m_txSampledViewDefinition = this.createTXViewDefinition(this.m_originlDataLocation, this.m_userSchemaName, this.m_resultViewName);
                return;
            }
            catch (Exception exception) {
                System.out.println(exception.getLocalizedMessage());
                return;
            }
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp() {
        try {
            try {
                DM4JTransformation.dropDatabaseObject(this.m_numericalDiscretizationTableName, this.m_userSchemaName, "TABLE", true, DiscretizeDataSource.isDebug());
                DM4JTransformation.dropDatabaseObject(this.m_categoricalDiscretizationTableName, this.m_userSchemaName, "TABLE", true, DiscretizeDataSource.isDebug());
                DM4JTransformation.dropDatabaseObject(this.m_resultViewName, this.m_userSchemaName, "VIEW", false, DiscretizeDataSource.isDebug());
                DM4JTransformation.dropDatabaseObject(this.m_functionBasedView, this.m_userSchemaName, "VIEW", false, DiscretizeDataSource.isDebug());
            }
            catch (Exception exception) {
                Object var3_2 = null;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            throw throwable;
        }
    }

    public double[] getWinsorizedStats(Connection connection, String string, double d) {
        if (this.m_isTransactional && !this.m_bSingleMetric) {
            return this.getWinsorizedStatsTX(this.m_conn, string, d);
        }
        return this.getWinsorizedStats2D(this.m_conn, string, d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected double[] getWinsorizedStats2D(Connection connection, String string, double d) {
        double[] dArray;
        block12: {
            ResultSet resultSet;
            Statement statement;
            block11: {
                if (d == 0.0) {
                    return this.getEqualWidthStats2D(connection, string);
                }
                statement = null;
                resultSet = null;
                Object[] objectArray = new Object[]{string, this.m_originlDataLocation, new Double(d)};
                StringBuffer stringBuffer = new StringBuffer();
                String string2 = null;
                for (int i = 0; i < STAT_SQL_WINSORIZE_1ST_ORDER_2D.length; ++i) {
                    string2 = MessageFormat.format(STAT_SQL_WINSORIZE_1ST_ORDER_2D[i], objectArray);
                    stringBuffer.append(string2);
                }
                dArray = new double[NUMBER_STATS];
                statement = connection.createStatement();
                resultSet = statement.executeQuery(stringBuffer.toString());
                if (!resultSet.next()) break block11;
                dArray[NumericDataSource.STAT_TOTAL] = resultSet.getInt("N");
                dArray[NumericDataSource.STAT_AVERAGE] = resultSet.getDouble("Average");
                dArray[NumericDataSource.STAT_MAX] = resultSet.getDouble("Max");
                dArray[NumericDataSource.STAT_MIN] = resultSet.getDouble("Min");
                dArray[NumericDataSource.STAT_VARIANCE] = resultSet.getDouble("Variance");
                dArray[NumericDataSource.STAT_STDEV] = Math.sqrt(dArray[STAT_VARIANCE]);
                resultSet.close();
                statement.close();
                if (dArray[STAT_MAX] == 0.0 || dArray[STAT_MIN] == 0.0 || dArray[STAT_VARIANCE] == 0.0) break block11;
                statement = connection.createStatement();
                objectArray = new Object[]{String.valueOf(dArray[STAT_AVERAGE]), string, String.valueOf((int)dArray[STAT_TOTAL]), String.valueOf(dArray[STAT_STDEV]), this.m_originlDataLocation, String.valueOf(d)};
                string2 = null;
                stringBuffer = null;
                stringBuffer = new StringBuffer();
                for (int i = 0; i < STAT_SQL_WINSORIZE_2ND_ORDER.length; ++i) {
                    string2 = MessageFormat.format(STAT_SQL_WINSORIZE_2ND_ORDER[i], objectArray);
                    stringBuffer.append(string2);
                }
                resultSet = statement.executeQuery(stringBuffer.toString());
                if (!resultSet.next()) break block11;
                dArray[NumericDataSource.STAT_SKEW] = resultSet.getDouble("Skew");
                dArray[NumericDataSource.STAT_KURT] = resultSet.getDouble("Kurtosis");
            }
            Object var13_13 = null;
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
            break block12;
            {
                catch (Exception exception) {
                    dArray = null;
                    Object var13_14 = null;
                    try {
                        resultSet.close();
                        statement.close();
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                try {
                    resultSet.close();
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected double[] getWinsorizedStatsTX(Connection connection, String string, double d) {
        double[] dArray;
        block12: {
            ResultSet resultSet;
            Statement statement;
            block11: {
                if (d == 0.0) {
                    return this.getEqualWidthStatsTX(connection, string);
                }
                statement = null;
                resultSet = null;
                Object[] objectArray = new Object[]{string, this.m_originlDataLocation, new Double(d), "\"" + this.m_attributeMapping + "\"", this.m_attributeName};
                StringBuffer stringBuffer = new StringBuffer();
                String string2 = null;
                for (int i = 0; i < STAT_SQL_WINSORIZE_1ST_ORDER_TX.length; ++i) {
                    string2 = MessageFormat.format(STAT_SQL_WINSORIZE_1ST_ORDER_TX[i], objectArray);
                    stringBuffer.append(string2);
                }
                dArray = new double[NUMBER_STATS];
                statement = connection.createStatement();
                resultSet = statement.executeQuery(stringBuffer.toString());
                if (!resultSet.next()) break block11;
                dArray[NumericDataSource.STAT_TOTAL] = resultSet.getInt("N");
                dArray[NumericDataSource.STAT_AVERAGE] = resultSet.getDouble("Average");
                dArray[NumericDataSource.STAT_MAX] = resultSet.getDouble("Max");
                dArray[NumericDataSource.STAT_MIN] = resultSet.getDouble("Min");
                dArray[NumericDataSource.STAT_VARIANCE] = resultSet.getDouble("Variance");
                dArray[NumericDataSource.STAT_STDEV] = Math.sqrt(dArray[STAT_VARIANCE]);
                resultSet.close();
                statement.close();
                statement = connection.createStatement();
                objectArray = new Object[]{String.valueOf(dArray[STAT_AVERAGE]), string, String.valueOf((int)dArray[STAT_TOTAL]), String.valueOf(dArray[STAT_STDEV]), this.m_originlDataLocation, String.valueOf(d), "\"" + this.m_attributeMapping + "\"", this.m_attributeName};
                string2 = null;
                stringBuffer = null;
                stringBuffer = new StringBuffer();
                for (int i = 0; i < STAT_SQL_WINSORIZE_2ND_ORDER_TX.length; ++i) {
                    string2 = MessageFormat.format(STAT_SQL_WINSORIZE_2ND_ORDER_TX[i], objectArray);
                    stringBuffer.append(string2);
                }
                resultSet = statement.executeQuery(stringBuffer.toString());
                if (!resultSet.next()) break block11;
                dArray[NumericDataSource.STAT_SKEW] = resultSet.getDouble("Skew");
                dArray[NumericDataSource.STAT_KURT] = resultSet.getDouble("Kurtosis");
            }
            Object var13_13 = null;
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
            break block12;
            {
                catch (Exception exception) {
                    dArray = null;
                    Object var13_14 = null;
                    try {
                        resultSet.close();
                        statement.close();
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                try {
                    resultSet.close();
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return dArray;
    }

    protected ArrayOneDModel createColumns() throws Exception {
        this.addColumns(0, COLUMN_COUNT);
        return new ArrayOneDModel(items);
    }

    protected void createData() throws Exception {
    }

    public void setStatistics(double[] dArray) {
        int n = 0;
        this.setData(COLUMN_NAMES.TOTAL, n, dArray == null ? null : new Integer((int)dArray[STAT_TOTAL]));
        this.setData(COLUMN_NAMES.AVG, n, dArray == null ? null : new Double(dArray[STAT_AVERAGE]));
        this.setData(COLUMN_NAMES.MAX, n, dArray == null ? null : new Double(dArray[STAT_MAX]));
        this.setData(COLUMN_NAMES.MIN, n, dArray == null ? null : new Double(dArray[STAT_MIN]));
        this.setData(COLUMN_NAMES.VAR, n, dArray == null ? null : new Double(dArray[STAT_VARIANCE]));
        this.setData(COLUMN_NAMES.STDDEV, n, dArray == null ? null : new Double(dArray[STAT_STDEV]));
        this.setData(COLUMN_NAMES.SKEW, n, dArray == null ? null : new Double(dArray[STAT_SKEW]));
        this.setData(COLUMN_NAMES.KURT, n, dArray == null ? null : new Double(dArray[STAT_KURT]));
    }

    public String getAttributeName() {
        String string = (String)this.getData(COLUMN_NAMES.NAME, 0);
        return string;
    }

    public Integer getNumberOfBins() {
        return (Integer)this.getData(COLUMN_NAMES.BINNUMBER, 0);
    }

    public void setNumberOfBins(int n) {
        this.setData(COLUMN_NAMES.BINNUMBER, 0, new Integer(n));
    }

    public Double getTailPercent() {
        return (Double)this.getData(COLUMN_NAMES.TAILPERCENT, 0);
    }

    public void setTailPercent(double d) {
        this.setData(COLUMN_NAMES.TAILPERCENT, 0, new Double(d));
    }

    public Double getSkew() {
        return (Double)this.getData(COLUMN_NAMES.SKEW, 0);
    }

    public Double getKurtosis() {
        return (Double)this.getData(COLUMN_NAMES.KURT, 0);
    }

    public Double getAverage() {
        return (Double)this.getData(COLUMN_NAMES.AVG, 0);
    }

    public Double getMin() {
        return (Double)this.getData(COLUMN_NAMES.MIN, 0);
    }

    public Double getMax() {
        return (Double)this.getData(COLUMN_NAMES.MAX, 0);
    }

    public Double getVariance() {
        return (Double)this.getData(COLUMN_NAMES.VAR, 0);
    }

    public Double getSigma() {
        return (Double)this.getData(COLUMN_NAMES.STDDEV, 0);
    }

    public Integer getTotalCount() {
        return (Integer)this.getData(COLUMN_NAMES.TOTAL, 0);
    }

    public Vector getBinBounds() {
        return (Vector)this.getData(COLUMN_NAMES.BINBOUNDS, 0);
    }

    public void setBinBounds(Vector vector) {
        this.setData(COLUMN_NAMES.BINBOUNDS, 0, vector);
    }

    public void setBinningType(BinningType binningType) {
        this.setData(COLUMN_NAMES.BINTYPE, 0, binningType);
    }

    public BinningType getBinningType() {
        return (BinningType)this.getData(COLUMN_NAMES.BINTYPE, 0);
    }

    public StringBuffer getViewDefinition() {
        return (StringBuffer)this.getData(COLUMN_NAMES.VIEW_DEFN, 0);
    }

    public void setComplexAttribute(int n, String string) {
        this.setData(COLUMN_NAMES.COMPLEX_ATTRIBUTE, n, string);
    }

    public String getComplexAttribute(int n) {
        return (String)this.getData(COLUMN_NAMES.COMPLEX_ATTRIBUTE, n);
    }

    public int[] getFrequency(Connection connection, String string) {
        if (this.m_isTransactional && !this.m_bSingleMetric) {
            return this.getFrequencyTX(connection, string);
        }
        return this.getFrequency2D(connection, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected int[] getFrequency2D(Connection connection, String string) {
        Integer[] integerArray;
        Object object;
        int n;
        int[] nArray;
        Vector<String> vector;
        Vector<Integer> vector2;
        block26: {
            StringBuffer stringBuffer;
            ResultSet resultSet;
            Statement statement;
            block24: {
                statement = null;
                resultSet = null;
                vector2 = new Vector<Integer>();
                vector = new Vector<String>();
                nArray = null;
                n = 0;
                this.m_nullCount = 0;
                stringBuffer = null;
                object = MessageFormat.format(DiscretizeDataSource.HISTOGRAM_VALUES[0], "\"" + string + "\"");
                integerArray = new StringBuffer((String)object);
                stringBuffer = this.getViewDefinition();
                if (stringBuffer == null) {
                    stringBuffer = this.getSingleNumericAttributeViewDefinition(connection);
                }
                if (stringBuffer != null) break block24;
                int[] nArray2 = nArray;
                Object var17_16 = null;
                try {
                    resultSet.close();
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return nArray2;
            }
            int n2 = stringBuffer.toString().indexOf("SELECT");
            StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.substring(n2));
            integerArray.append(stringBuffer2);
            object = MessageFormat.format(DiscretizeDataSource.HISTOGRAM_VALUES[1], "\"" + string + "\"");
            integerArray.append((String)object);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(integerArray.toString());
            while (resultSet.next()) {
                String string2 = resultSet.getString("BIN_NUMBER");
                int n3 = resultSet.getInt("FREQUENCY");
                if (string2 != null) {
                    ++n;
                    vector2.add(new Integer(n3));
                    vector.add(string2);
                    continue;
                }
                this.m_nullCount = n3;
            }
            Object var17_17 = null;
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception2) {}
            break block26;
            {
                catch (Exception exception) {
                    if (DiscretizeDataSource.isDebug()) {
                        exception.printStackTrace();
                    }
                    nArray = null;
                    var17_17 = null;
                    try {
                        resultSet.close();
                        statement.close();
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var17_18 = null;
                try {
                    resultSet.close();
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (vector2 == null || vector2.isEmpty()) {
            return null;
        }
        object = null;
        integerArray = null;
        Vector vector3 = this.getBinBounds();
        if (vector3 != null && !vector3.isEmpty()) {
            int n4;
            object = new Vector(vector3.size());
            integerArray = new Integer[vector3.size()];
            for (n4 = 0; n4 < vector3.size(); ++n4) {
                ((Vector)object).add(String.valueOf(n4 + 1));
                integerArray[n4] = 0;
            }
            for (n4 = 0; n4 < vector.size(); ++n4) {
                int n5 = ((Vector)object).indexOf(vector.elementAt(n4));
                if (-1 == n5) continue;
                integerArray[n5] = (Integer)vector2.elementAt(n4);
            }
        }
        if (object != null) {
            this.setNumberOfBins(((Vector)object).size());
        } else {
            this.setNumberOfBins(n);
        }
        if (integerArray == null) {
            nArray = new int[vector2.size()];
            for (int i = 0; i < vector2.size(); ++i) {
                Integer n6 = (Integer)vector2.elementAt(i);
                nArray[i] = n6;
            }
        } else {
            nArray = new int[integerArray.length];
            for (int i = 0; i < integerArray.length; ++i) {
                Integer n7 = integerArray[i];
                nArray[i] = n7;
            }
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected int[] getFrequencyTX(Connection connection, String string) {
        Comparable<Integer> comparable;
        int n;
        int[] nArray;
        Vector<Integer> vector;
        block18: {
            String string2;
            StringBuffer stringBuffer;
            ResultSet resultSet;
            Statement statement;
            block16: {
                statement = null;
                resultSet = null;
                vector = new Vector<Integer>();
                nArray = null;
                n = 0;
                this.m_nullCount = 0;
                stringBuffer = null;
                string2 = MessageFormat.format(DiscretizeDataSource.HISTOGRAM_VALUES_TX[0], "\"" + this.m_valueMapping + "\"", "\"" + string + "\"");
                comparable = new StringBuffer(string2);
                stringBuffer = this.getViewDefinition();
                if (stringBuffer == null) {
                    stringBuffer = this.getSingleNumericAttributeViewDefinition(connection);
                }
                if (stringBuffer != null) break block16;
                int[] nArray2 = nArray;
                Object var16_15 = null;
                try {
                    resultSet.close();
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return nArray2;
            }
            int n2 = stringBuffer.toString().indexOf("SELECT");
            StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.substring(n2));
            ((StringBuffer)comparable).append(stringBuffer2);
            string2 = MessageFormat.format(DiscretizeDataSource.HISTOGRAM_VALUES_TX[1], "\"" + this.m_valueMapping + "\"", "'" + string + "'", "\"" + this.m_attributeMapping + "\"");
            ((StringBuffer)comparable).append(string2);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(((StringBuffer)comparable).toString());
            while (resultSet.next()) {
                String string3 = resultSet.getString("BIN_NUMBER");
                int n3 = resultSet.getInt("FREQUENCY");
                if (string3 != null) {
                    ++n;
                    vector.add(new Integer(n3));
                    continue;
                }
                this.m_nullCount = n3;
            }
            Object var16_16 = null;
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception2) {}
            break block18;
            {
                catch (Exception exception) {
                    if (DiscretizeDataSource.isDebug()) {
                        exception.printStackTrace();
                    }
                    nArray = null;
                    var16_16 = null;
                    try {
                        resultSet.close();
                        statement.close();
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var16_17 = null;
                try {
                    resultSet.close();
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (vector == null || vector.isEmpty()) {
            return null;
        }
        this.setNumberOfBins(n);
        nArray = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            comparable = (Integer)vector.elementAt(i);
            nArray[i] = (Integer)comparable;
        }
        return nArray;
    }

    protected StringBuffer getSingleNumericAttributeViewDefinition(Connection connection) {
        StringBuffer stringBuffer = null;
        try {
            String string = this.getAttributeName();
            if (this.m_resultViewName == null) {
                this.m_resultViewName = ValidationUtil.createUniqueTableName(RESULT_VIEW_NAME, connection, "");
            }
            stringBuffer = this.createNumericOpenEndedViewDefinition(string, this.m_functionBasedView, this.m_dataSourceSchemaName, this.m_userSchemaName, this.m_resultViewName);
            this.setData(COLUMN_NAMES.VIEW_DEFN, 0, stringBuffer);
        }
        catch (Exception exception) {
            this.setData(COLUMN_NAMES.VIEW_DEFN, 0, null);
        }
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createFunctionBasedView2D(Connection connection) throws SQLException {
        Statement statement = null;
        String string = null;
        Object[] objectArray = null;
        this.m_functionBasedView = ValidationUtil.createUniqueTableName(FUNCTION_BASED_VIEW_PREFIX, connection, "");
        try {
            try {
                string = FUNCTION_BASED_VIEW_2D;
                objectArray = new Object[]{this.m_functionBasedView, this.m_functionName, "\"" + (this.m_bSingleMetric ? this.m_valueMapping : this.getAttributeName()) + "\"", this.m_tableName};
                string = MessageFormat.format(string, objectArray);
                statement = connection.prepareCall(string);
                statement.execute();
                statement.close();
            }
            catch (Exception exception) {
                System.out.println(exception);
                Object var7_6 = null;
                if (statement == null) return;
                statement.close();
                return;
            }
            Object var7_5 = null;
            if (statement == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (statement == null) throw throwable;
            statement.close();
            throw throwable;
        }
        statement.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createFunctionBasedViewTX(Connection connection) throws SQLException {
        Statement statement = null;
        String string = null;
        Object[] objectArray = null;
        this.m_functionBasedView = ValidationUtil.createUniqueTableName(FUNCTION_BASED_VIEW_PREFIX, connection, "");
        try {
            try {
                string = FUNCTION_BASED_VIEW_TX;
                objectArray = new Object[]{this.m_functionBasedView, this.m_functionName, "\"" + this.m_valueMapping + "\"", this.m_tableName, "\"" + this.m_attributeMapping + "\"", this.m_attributeName};
                string = MessageFormat.format(string, objectArray);
                statement = connection.prepareCall(string);
                statement.execute();
                statement.close();
            }
            catch (Exception exception) {
                System.out.println(exception);
                Object var7_6 = null;
                if (statement == null) return;
                statement.close();
                return;
            }
            Object var7_5 = null;
            if (statement == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (statement == null) throw throwable;
            statement.close();
            throw throwable;
        }
        statement.close();
    }

    public Vector getEqualWidthBounds() {
        Double d = this.getMin();
        if (d == null) {
            return null;
        }
        double d2 = d;
        Double d3 = this.getMax();
        if (d3 == null) {
            return null;
        }
        double d4 = d3;
        int n = this.getNumberOfBins();
        if (d2 > d4) {
            return null;
        }
        Vector<Bin> vector = new Vector<Bin>();
        if (d2 == d4) {
            Bin bin = new Bin(0, d2, d4);
            vector.add(bin);
            return vector;
        }
        double d5 = (d4 - d2) / (double)n;
        double d6 = d2;
        double d7 = d6 + d5;
        for (int i = 0; i < n; ++i) {
            if (i == n - 1) {
                d7 = d4;
            }
            Bin bin = new Bin(i, d6, d7);
            vector.add(bin);
            d6 = d7;
            d7 += d5;
        }
        return vector;
    }

    protected StringBuffer createNumericOpenEndedViewDefinition(String string, String string2, String string3, String string4, String string5) {
        if (this.m_isTransactional && !this.m_bSingleMetric) {
            return this.createNumericOpenEndedViewDefinitionTX(string, string4, string5);
        }
        return this.createNumericOpenEndedViewDefinition2D(string, string2, string3, string4, string5);
    }

    protected StringBuffer createNumericOpenEndedViewDefinition2D(String string, String string2, String string3, String string4, String string5) {
        Vector vector;
        StringBuffer stringBuffer = new StringBuffer("CREATE VIEW " + string4 + "." + string5 + " AS SELECT \n");
        DiscretizeDataSource.BinBoundMap binBoundMap = new DiscretizeDataSource.BinBoundMap(1);
        String string6 = this.getAttributeName();
        BinningType binningType = this.getBinningType();
        Vector vector2 = vector = binningType.equal(BinningType.EQ_WIDTH) ? this.getEqualWidthBounds() : this.getQtileStats();
        if (vector == null || vector.size() == 0) {
            stringBuffer.append(" *  FROM " + string3 + "." + string2);
            return stringBuffer;
        }
        Bin[] binArray = new Bin[vector.size()];
        binArray = vector.toArray(binArray);
        for (int i = 0; i < binArray.length; ++i) {
            int n = binArray[i].getBinNumber();
            double d = binArray[i].getLowerBound();
            double d2 = binArray[i].getUpperBound();
            binBoundMap.addBinBound("\"" + string6 + "\"", new DiscretizeDataSource.BinBound(n, d, d2));
        }
        this.setBinBounds(vector);
        String string7 = "\"" + DM4JStringUtils.trimDoubleQuotes(string) + "\"";
        if (binBoundMap.isEmpty(string7)) {
            stringBuffer.append(this.m_bSingleMetric ? this.m_valueMapping : string7);
        } else if (binBoundMap.size(string7) == 1) {
            stringBuffer.append("( CASE ");
            stringBuffer.append("WHEN ");
            stringBuffer.append(this.m_bSingleMetric ? this.m_valueMapping : string7);
            stringBuffer.append(" is not null then 1 end) " + string7);
        } else if (binningType.equal(BinningType.QTILE)) {
            this.prepareQtileDefinition(stringBuffer, binBoundMap, string7);
        } else {
            this.prepareEqWidthDefinition(stringBuffer, binBoundMap, string7);
        }
        stringBuffer.append("\n");
        binBoundMap.clear();
        Double d = this.getTailPercent();
        String string8 = "\"" + DM4JStringUtils.trimDoubleQuotes(string3) + "\".\"" + DM4JStringUtils.trimDoubleQuotes(string2) + "\"";
        stringBuffer.append(" FROM " + (d == null || d == 0.0 ? string8 : MessageFormat.format(WINSORIZED_VIEW, this.m_functionName, this.m_bSingleMetric ? this.m_valueMapping : string7, string8, this.getTailPercent().toString())));
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StringBuffer createNumericOpenEndedViewDefinitionTX(String string, String string2, String string3) {
        String string4 = "\"" + this.m_userSchemaName + "\".\"" + this.m_numericalDiscretizationTableName + "\"";
        StringBuffer stringBuffer = new StringBuffer("DELETE FROM " + string4 + " WHERE \n");
        stringBuffer.append("COLUMN_NAME = '" + string + "'");
        try {
            try {
                block7: {
                    try {
                        DM4JTransformation.removeAttributesFromBinBoundaryTable(this.m_conn, stringBuffer.toString());
                    }
                    catch (Exception exception) {
                        if (!DiscretizeDataSource.isDebug()) break block7;
                        exception.printStackTrace();
                    }
                }
                this.populateGroupNumericBinBoundaries(this.m_conn, this.m_numericalDiscretizationTableName, this.m_userSchemaName);
            }
            catch (Exception exception) {
                if (DiscretizeDataSource.isDebug()) {
                    exception.printStackTrace();
                }
                Object var8_9 = null;
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            throw throwable;
        }
        return this.m_txSampledViewDefinition;
    }

    protected void prepareQtileDefinition(StringBuffer stringBuffer, DiscretizeDataSource.BinBoundMap binBoundMap, String string) {
        DiscretizeDataSource.BinBound binBound;
        int n;
        stringBuffer.append("( CASE ");
        Vector vector = binBoundMap.getBinBounds(string);
        int n2 = 2;
        NumberFormat numberFormat = DecimalFormat.getNumberInstance();
        numberFormat.setGroupingUsed(true);
        numberFormat.setMaximumFractionDigits(n2);
        numberFormat.setMinimumFractionDigits(0);
        DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
        for (n = 0; n < vector.size(); ++n) {
            binBound = (DiscretizeDataSource.BinBound)vector.elementAt(n);
            DM4JNumericFormat.AdjustFormat(binBound.m_lowerBound, binBound.m_upperBound, decimalFormat);
        }
        for (n = 1; n < vector.size(); ++n) {
            stringBuffer.append("WHEN ");
            binBound = (DiscretizeDataSource.BinBound)vector.elementAt(n);
            if (n == 1) {
                stringBuffer.append(string + " < " + DM4JNumericFormat.SQLFormat(binBound.m_upperBound, decimalFormat) + " THEN ");
                stringBuffer.append(String.valueOf(n));
            } else if (n == vector.size() - 1) {
                stringBuffer.append(string + " > " + DM4JNumericFormat.SQLFormat(binBound.m_lowerBound, decimalFormat) + " THEN " + n);
            } else {
                stringBuffer.append(string + " <= " + DM4JNumericFormat.SQLFormat(binBound.m_upperBound, decimalFormat) + " THEN " + n);
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append(" end) " + string);
    }

    protected void prepareEqWidthDefinition(StringBuffer stringBuffer, DiscretizeDataSource.BinBoundMap binBoundMap, String string) {
        DiscretizeDataSource.BinBound binBound;
        int n;
        stringBuffer.append("( CASE ");
        Vector vector = binBoundMap.getBinBounds(string);
        int n2 = 2;
        NumberFormat numberFormat = DecimalFormat.getNumberInstance();
        numberFormat.setGroupingUsed(true);
        numberFormat.setMaximumFractionDigits(n2);
        numberFormat.setMinimumFractionDigits(0);
        DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
        for (n = 0; n < vector.size(); ++n) {
            binBound = (DiscretizeDataSource.BinBound)vector.elementAt(n);
            DM4JNumericFormat.AdjustFormat(binBound.m_lowerBound, binBound.m_upperBound, decimalFormat);
        }
        for (n = 0; n < vector.size(); ++n) {
            stringBuffer.append("WHEN ");
            binBound = (DiscretizeDataSource.BinBound)vector.elementAt(n);
            if (n == 0) {
                stringBuffer.append((this.m_bSingleMetric ? this.m_valueMapping : string) + " < " + DM4JNumericFormat.SQLFormat(binBound.m_upperBound, decimalFormat) + " THEN ");
                stringBuffer.append(String.valueOf(n + 1));
            } else if (n == vector.size() - 1) {
                stringBuffer.append((this.m_bSingleMetric ? this.m_valueMapping : string) + " >= " + DM4JNumericFormat.SQLFormat(binBound.m_lowerBound, decimalFormat) + " THEN " + (n + 1));
            } else {
                DiscretizeDataSource.BinBound binBound2 = (DiscretizeDataSource.BinBound)vector.elementAt(n - 1);
                stringBuffer.append((this.m_bSingleMetric ? this.m_valueMapping : string) + " >= " + DM4JNumericFormat.SQLFormat(binBound2.m_upperBound, decimalFormat) + " AND " + (this.m_bSingleMetric ? this.m_valueMapping : string) + " < " + DM4JNumericFormat.SQLFormat(binBound.m_upperBound, decimalFormat) + " THEN " + (n + 1));
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append("else null end) " + string);
    }

    protected Vector getQtileStats() {
        return new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected double[] getEqualWidthStats2D(Connection connection, String string) {
        double[] dArray;
        block21: {
            String string2;
            StringBuffer stringBuffer;
            Object[] objectArray;
            block20: {
                ResultSet resultSet2;
                Statement statement2;
                block18: {
                    statement2 = null;
                    resultSet2 = null;
                    objectArray = new Object[]{string, this.m_originlDataLocation};
                    stringBuffer = new StringBuffer(STAT_SQL_EQ_WIDTH_1ST_ORDER_2D_PREFIX);
                    stringBuffer.append(MessageFormat.format(STAT_SQL_EQ_WIDTH_1ST_ORDER_2D, objectArray));
                    dArray = new double[NUMBER_STATS];
                    statement2 = connection.createStatement();
                    resultSet2 = statement2.executeQuery(stringBuffer.toString());
                    if (!resultSet2.next()) break block18;
                    dArray[NumericDataSource.STAT_TOTAL] = resultSet2.getInt("N");
                    dArray[NumericDataSource.STAT_AVERAGE] = resultSet2.getDouble("Average");
                    dArray[NumericDataSource.STAT_MAX] = resultSet2.getDouble("Max");
                    dArray[NumericDataSource.STAT_MIN] = resultSet2.getDouble("Min");
                    dArray[NumericDataSource.STAT_VARIANCE] = resultSet2.getDouble("Variance");
                    dArray[NumericDataSource.STAT_STDEV] = Math.sqrt(dArray[STAT_VARIANCE]);
                }
                string2 = null;
                try {
                    resultSet2.close();
                    statement2.close();
                }
                catch (Exception exception2) {}
                break block20;
                {
                    catch (Exception exception) {
                        dArray = null;
                        string2 = null;
                        try {
                            resultSet2.close();
                            statement2.close();
                        }
                        catch (Exception exception2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var10_9 = null;
                    try {
                        resultSet2.close();
                        statement2.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            if (dArray != null) {
                ResultSet resultSet;
                Statement statement;
                block19: {
                    statement = null;
                    resultSet = null;
                    statement = connection.createStatement();
                    objectArray = new Object[]{String.valueOf(dArray[STAT_AVERAGE]), string, String.valueOf((int)dArray[STAT_TOTAL]), String.valueOf(dArray[STAT_STDEV]), this.m_originlDataLocation};
                    string2 = null;
                    stringBuffer = null;
                    stringBuffer = new StringBuffer();
                    for (int i = 0; i < STAT_SQL_EQ_WIDTH_2ND_ORDER.length; ++i) {
                        string2 = MessageFormat.format(STAT_SQL_EQ_WIDTH_2ND_ORDER[i], objectArray);
                        stringBuffer.append(string2);
                    }
                    resultSet = statement.executeQuery(stringBuffer.toString());
                    if (!resultSet.next()) break block19;
                    dArray[NumericDataSource.STAT_SKEW] = resultSet.getDouble("Skew");
                    dArray[NumericDataSource.STAT_KURT] = resultSet.getDouble("Kurtosis");
                }
                Object var13_18 = null;
                try {
                    resultSet.close();
                    statement.close();
                }
                catch (Exception exception) {}
                break block21;
                {
                    catch (Exception exception) {
                        dArray[NumericDataSource.STAT_SKEW] = 0.0;
                        dArray[NumericDataSource.STAT_KURT] = 0.0;
                        Object var13_19 = null;
                        try {
                            resultSet.close();
                            statement.close();
                        }
                        catch (Exception exception3) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var13_20 = null;
                    try {
                        resultSet.close();
                        statement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected double[] getEqualWidthStatsTX(Connection connection, String string) {
        double[] dArray;
        block21: {
            StringBuffer stringBuffer;
            Object[] objectArray;
            ResultSet resultSet;
            Statement statement;
            block20: {
                block18: {
                    statement = null;
                    resultSet = null;
                    objectArray = new Object[]{string, "\"" + this.m_attributeMapping + "\"", this.m_originlDataLocation, this.m_attributeName};
                    stringBuffer = new StringBuffer(MessageFormat.format(STAT_SQL_EQ_WIDTH_1ST_ORDER_TX, objectArray));
                    dArray = new double[NUMBER_STATS];
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery(stringBuffer.toString());
                    if (!resultSet.next()) break block18;
                    dArray[NumericDataSource.STAT_TOTAL] = resultSet.getInt("N");
                    dArray[NumericDataSource.STAT_AVERAGE] = resultSet.getDouble("Average");
                    dArray[NumericDataSource.STAT_MAX] = resultSet.getDouble("Max");
                    dArray[NumericDataSource.STAT_MIN] = resultSet.getDouble("Min");
                    dArray[NumericDataSource.STAT_VARIANCE] = resultSet.getDouble("Variance");
                    dArray[NumericDataSource.STAT_STDEV] = Math.sqrt(dArray[STAT_VARIANCE]);
                }
                Object var10_8 = null;
                try {
                    resultSet.close();
                    statement.close();
                }
                catch (Exception exception2) {}
                break block20;
                {
                    catch (Exception exception) {
                        dArray = null;
                        var10_8 = null;
                        try {
                            resultSet.close();
                            statement.close();
                        }
                        catch (Exception exception2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var10_9 = null;
                    try {
                        resultSet.close();
                        statement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            if (dArray != null) {
                block19: {
                    statement = connection.createStatement();
                    objectArray = new Object[]{String.valueOf(dArray[STAT_AVERAGE]), string, String.valueOf((int)dArray[STAT_TOTAL]), String.valueOf(dArray[STAT_STDEV]), this.m_originlDataLocation};
                    String string2 = null;
                    stringBuffer = null;
                    stringBuffer = new StringBuffer();
                    for (int i = 0; i < STAT_SQL_EQ_WIDTH_2ND_ORDER.length; ++i) {
                        string2 = MessageFormat.format(STAT_SQL_EQ_WIDTH_2ND_ORDER[i], objectArray);
                        stringBuffer.append(string2);
                    }
                    resultSet = statement.executeQuery(stringBuffer.toString());
                    if (!resultSet.next()) break block19;
                    dArray[NumericDataSource.STAT_SKEW] = resultSet.getDouble("Skew");
                    dArray[NumericDataSource.STAT_KURT] = resultSet.getDouble("Kurtosis");
                }
                Object var13_17 = null;
                try {
                    resultSet.close();
                    statement.close();
                }
                catch (Exception exception) {}
                break block21;
                {
                    catch (Exception exception) {
                        dArray[NumericDataSource.STAT_SKEW] = 0.0;
                        dArray[NumericDataSource.STAT_KURT] = 0.0;
                        Object var13_18 = null;
                        try {
                            resultSet.close();
                            statement.close();
                        }
                        catch (Exception exception3) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var13_19 = null;
                    try {
                        resultSet.close();
                        statement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        return dArray;
    }

    protected StringBuffer createTXViewDefinition(String string, String string2, String string3) {
        String string4 = "\"" + this.m_userSchemaName + "\".\"" + this.m_numericalDiscretizationTableName + "\"";
        String string5 = "\"" + this.m_userSchemaName + "\".\"" + this.m_categoricalDiscretizationTableName + "\"";
        String[] stringArray = new String[]{"CREATE VIEW ", string2, ".", string3, " AS ", "\n", "SELECT /*+ PQ_DISTRIBUTE(tm BROADCAST, NONE) NO_MERGE(tm) NO_MERGE(bm) SWAP_JOIN_INPUTS(bm) USE_HASH(bm tm) */ ", "\n", "tm.id ", this.m_seqIdMapping, ",tm.cn ", "\"" + this.m_attributeMapping + "\"", ", ", "\n", "CASE WHEN tm.b IS NOT NULL THEN tm.b ELSE CASE WHEN bm.b IS NULL THEN tm.nv ", "\n", "ELSE CASE WHEN bm.b != 0 THEN bm.b ELSE NULL END END END ", "\n", "\"" + this.m_valueMapping + "\"", " FROM (SELECT /*+ PQ_DISTRIBUTE(tn BROADCAST, NONE) NO_MERGE(tn) NO_MERGE(bn) SWAP_JOIN_INPUTS(bn) USE_HASH(bn tn) */ ", "\n", "tn.id,tn.cn,tn.nv,CASE WHEN tn.b IS NOT NULL THEN tn.b ELSE bn.b END b ", "\n", "FROM (", "\n", "SELECT /*+ PARALLEL(tr) PQ_DISTRIBUTE(tr BROADCAST, NONE) NO_MERGE(tr) NO_MERGE(br) SWAP_JOIN_INPUTS(br) USE_HASH(br tr) */ ", "\n", "tr.", this.m_seqIdMapping, " id,tr.", "\"" + this.m_attributeMapping + "\"", " cn,tr.", "\"" + this.m_valueMapping + "\"", " nv,br.b FROM ", "\n", string, " tr ", "\n", "LEFT OUTER JOIN (", "\n", "SELECT /*+ PARALLEL(n) */ column_name c, lower_boundary l,upper_boundary u,bin_id b ", "\n", " FROM ", string4, " n ", "\n", "WHERE lower_boundary != upper_boundary) br ", "\n", "ON tr.", "\"" + this.m_attributeMapping + "\"", " = br.c AND tr.", "\"" + this.m_valueMapping + "\"", " > br.l AND tr.", "\"" + this.m_valueMapping + "\"", " < br.u) tn ", "\n", "LEFT OUTER JOIN (SELECT /*+ PARALLEL(c) */ column_name c,category_value n,group_id b ", "\n", " FROM ", string5, " c ", "\n", "WHERE category_value IS NOT NULL ", "\n", "UNION ALL ", "\n", "SELECT /*+ PARALLEL(n) */ column_name c,lower_boundary n,bin_id b ", "\n", " FROM ", string4, " n ", "\n", "WHERE lower_boundary != upper_boundary ", "\n", "UNION ALL ", "\n", "SELECT column_name c,upper_boundary n,bin_id b FROM (", "\n", "SELECT /*+ PARALLEL(n) */ n.*,MAX(bin_id) OVER (PARTITION BY column_name) max_bin ", "\n", " FROM ", string4, " n ", "\n", ") ", "\n", "WHERE bin_id = max_bin) bn ON tn.cn = bn.c AND tn.nv = bn.n) tm LEFT OUTER JOIN (SELECT /*+PARALLEL(c) */ ", "\n", "column_name c,group_id b ", "\n", " FROM ", string5, " c ", "\n", "WHERE category_value IS NULL ", "\n", "UNION ALL SELECT /*+ PARALLEL(n) */ column_name c,0 b ", "\n", " FROM ", string4, " n ", "\n", "WHERE bin_id = 1) bm ON tm.cn = bm.c ", "\n"};
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void populateGroupNumericBinBoundaries(Connection connection, String string, String string2) throws SQLException {
        BinningType binningType = this.getBinningType();
        Vector vector = binningType.equal(BinningType.EQ_WIDTH) ? this.getEqualWidthBounds() : this.getQtileStats();
        if (vector == null) return;
        if (vector.size() == 0) {
            return;
        }
        this.setBinBounds(vector);
        Object[] objectArray = new Object[]{string2, string};
        String string3 = MessageFormat.format("INSERT INTO {0}.{1} VALUES ( ?,?,?,?,?,?)", objectArray);
        PreparedStatement preparedStatement = null;
        try {
            try {
                preparedStatement = connection.prepareStatement(string3);
                String string4 = this.getAttributeName();
                Bin[] binArray = new Bin[vector.size()];
                binArray = vector.toArray(binArray);
                for (int i = 0; i < binArray.length; ++i) {
                    double d = binArray[i].getLowerBound();
                    double d2 = binArray[i].getUpperBound();
                    int n = binArray[i].getBinNumber();
                    StringBuffer stringBuffer = new StringBuffer(String.valueOf(d));
                    if (d < d2) {
                        stringBuffer.append(" - " + String.valueOf(d2));
                    }
                    String string5 = "T";
                    int n2 = 1;
                    try {
                        preparedStatement.setString(n2++, string4);
                        if (d < (double)1.4E-45f) {
                            d = 1.4E-45f;
                        }
                        preparedStatement.setDouble(n2++, d);
                        preparedStatement.setDouble(n2++, d2);
                        preparedStatement.setInt(n2++, n + 1);
                        preparedStatement.setString(n2++, string5);
                        preparedStatement.setString(n2++, stringBuffer.toString());
                        preparedStatement.execute();
                        continue;
                    }
                    catch (Exception exception) {
                        if (!DiscretizeDataSource.isDebug()) continue;
                        exception.printStackTrace();
                    }
                }
                Object var22_20 = null;
                if (preparedStatement == null) return;
            }
            catch (Exception exception) {
                if (DiscretizeDataSource.isDebug()) {
                    exception.printStackTrace();
                }
                Object var22_21 = null;
                if (preparedStatement == null) return;
                preparedStatement.close();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var22_22 = null;
            if (preparedStatement == null) throw throwable;
            preparedStatement.close();
            throw throwable;
        }
        preparedStatement.close();
    }

    static /* synthetic */ int access$008() {
        return A++;
    }

    static /* synthetic */ int access$000() {
        return A;
    }

    static {
        NumericDataSource.items[COLUMN_NAMES.NAME] = ResourceUtilities.getUILabel("DISCRETIZATION_SETTINGS_ATTRIBUTE_LIST_NAME");
        NumericDataSource.items[COLUMN_NAMES.BINNUMBER] = "Bins Number";
        NumericDataSource.items[COLUMN_NAMES.TAILPERCENT] = "Tail Percent";
        NumericDataSource.items[COLUMN_NAMES.BINBOUNDS] = "Bin Boundaries";
        NumericDataSource.items[COLUMN_NAMES.AVG] = ResourceUtilities.getUILabel("DISCRETIZATION_SETTINGS_ATTRIBUTE_LIST_AVERAGE");
        NumericDataSource.items[COLUMN_NAMES.MAX] = ResourceUtilities.getUILabel("DISCRETIZATION_SETTINGS_ATTRIBUTE_LIST_MAX");
        NumericDataSource.items[COLUMN_NAMES.MIN] = ResourceUtilities.getUILabel("DISCRETIZATION_SETTINGS_ATTRIBUTE_LIST_MIN");
        NumericDataSource.items[COLUMN_NAMES.TOTAL] = "Total Count";
        NumericDataSource.items[COLUMN_NAMES.VAR] = "Variance";
        NumericDataSource.items[COLUMN_NAMES.STDDEV] = "Sigma";
        NumericDataSource.items[COLUMN_NAMES.SKEW] = "Skew";
        NumericDataSource.items[COLUMN_NAMES.KURT] = "Kurtosis";
        NumericDataSource.items[COLUMN_NAMES.VIEW_DEFN] = "View Definition";
        NumericDataSource.items[COLUMN_NAMES.BINTYPE] = "Binning Type";
        NumericDataSource.items[COLUMN_NAMES.COMPLEX_ATTRIBUTE] = "CDS";
        STAT_TOTAL = 0;
        STAT_AVERAGE = 1;
        STAT_MAX = 2;
        STAT_MIN = 3;
        STAT_VARIANCE = 4;
        STAT_STDEV = 5;
        STAT_SKEW = 6;
        STAT_KURT = 7;
        NUMBER_STATS = STAT_KURT + 1;
        STAT_SQL_WINSORIZE_1ST_ORDER_2D = new String[]{"SELECT count(val) as N, AVG(val) Average, MAX(val) Max, MIN(val) Min, VARIANCE(val) as Variance  FROM (SELECT val, ROW_NUMBER() OVER (ORDER BY val ASC) pos, COUNT(*) OVER () cnt ", "FROM (SELECT {0} val  FROM {1} ) WHERE val IS NOT NULL) WHERE pos >= TRUNC({2}*cnt/100) + 1 AND pos <= cnt - TRUNC({2}*cnt/100)"};
        STAT_SQL_WINSORIZE_1ST_ORDER_TX = new String[]{"SELECT count(val) as N, AVG(val) Average, MAX(val) Max, MIN(val) Min, VARIANCE(val) as Variance  FROM (SELECT val, ROW_NUMBER() OVER (ORDER BY val ASC) pos, COUNT(*) OVER () cnt ", "FROM (SELECT {0} val  FROM {1} WHERE {3} = {4}) WHERE val IS NOT NULL) WHERE pos >= TRUNC({2}*cnt/100) + 1 AND pos <= cnt - TRUNC({2}*cnt/100)"};
        STAT_SQL_WINSORIZE_1ST_ORDER_SIMPLE = new String[]{"SELECT MAX(val) Max, MIN(val) Min FROM (SELECT val, ROW_NUMBER() OVER (ORDER BY val ASC) pos, COUNT(*) OVER () cnt ", "FROM (SELECT {0} val  FROM {1} ) WHERE val IS NOT NULL) WHERE pos >= TRUNC({2}*cnt/100) + 1 AND pos <= cnt - TRUNC({2}*cnt/100)"};
        STAT_SQL_WINSORIZE_2ND_ORDER = new String[]{"select sum( (power(val - {0},3) / ({2}*power({3},3) ) ) ) as Skew, ", "sum( power(val - {0},4) /( {2}*power({3},4))) - 3 as Kurtosis ", "FROM (SELECT val, ROW_NUMBER() OVER (ORDER BY val ASC) pos, COUNT(*) OVER () cnt ", "FROM (SELECT {1} val  FROM {4} ) WHERE val IS NOT NULL) WHERE pos >= TRUNC({5}*cnt/100) + 1 AND pos <= cnt - TRUNC({5}*cnt/100)"};
        STAT_SQL_WINSORIZE_2ND_ORDER_TX = new String[]{"select sum( (power(val - {0},3) / ({2}*power({3},3) ) ) ) as Skew, ", "sum( power(val - {0},4) /( {2}*power({3},4))) - 3 as Kurtosis ", "FROM (SELECT val, ROW_NUMBER() OVER (ORDER BY val ASC) pos, COUNT(*) OVER () cnt ", "FROM (SELECT {1} val  FROM {4}  WHERE {6} = {7}) WHERE val IS NOT NULL) WHERE pos >= TRUNC({5}*cnt/100) + 1 AND pos <= cnt - TRUNC({5}*cnt/100)"};
        STAT_SQL_EQ_WIDTH_1ST_ORDER_2D_PREFIX = "select count(value) as N, avg(value) as Average, MAX(value) as Max, MIN(value) as Min, VARIANCE(value) as Variance ";
        STAT_SQL_EQ_WIDTH_1ST_ORDER_2D = "from (select value from (select ({0}) as value from ({1}) ) WHERE value IS NOT NULL)";
        STAT_SQL_EQ_WIDTH_1ST_ORDER_TX = "with lNormalised as ( select {0} normal, {1}     from ({2}) WHERE {1} = {3} )      select count(lNormalised.normal) as N,       avg(lNormalised.normal) as Average,      MAX(lNormalised.normal) Max ,      MIN(lNormalised.normal) Min,      VARIANCE(lNormalised.normal) as Variance             from lNormalised WHERE {1} = {3} AND lNormalised.normal IS NOT NULL";
        STAT_SQL_EQ_WIDTH_1ST_ORDER_SIMPLE = "select MAX({0}) Max , MIN({0}) Min from ({1}) WHERE {0} IS NOT NULL";
        STAT_SQL_EQ_WIDTH_2ND_ORDER = new String[]{"select sum( power(value - {0},3) / ({2}*power({3},3) ) ) as Skew, ", "sum( power(value - {0},4) /( {2}*power({3},4))) - 3 as Kurtosis ", "from (select value from (select ({1}) as value from ({4}) ) WHERE value IS NOT NULL)"};
        MIN_MAX_DISCRETIZE = "select MIN(LOWER_BOUNDARY) MINVALUE, MAX(UPPER_BOUNDARY) MAXVALUE from {0} where COLUMN_NAME=?";
        WINSORIZED_VIEW = "(SELECT {0} {1} FROM (\n(SELECT val {1} FROM (\n\tSELECT val, ROW_NUMBER() OVER (ORDER BY val ASC) pos, COUNT(*) OVER () cnt\n\tFROM (SELECT {1} val  FROM {2} ) WHERE val IS NOT NULL)\nWHERE pos >= TRUNC({3}*cnt/100) + 1 AND pos <= cnt - TRUNC({3}*cnt/100))))";
        FUNCTION_BASED_VIEW_2D = "CREATE VIEW {0} AS SELECT {1} {2} FROM ({3})";
        FUNCTION_BASED_VIEW_TX = "CREATE VIEW {0} AS SELECT {1} {2} FROM ({3}) WHERE {4}={5}";
        NUMERIC_BIN_TABLE_PREFIX = "DM4J$N";
        CATEGORIC_BIN_TABLE_PREFIX = "DM4J$C";
        FUNCTION_BASED_VIEW_PREFIX = "DM4J$F";
        RESULT_VIEW_NAME = "DM4J$V";
    }

    public static interface COLUMN_NAMES {
        public static final int NAME = NumericDataSource.access$008();
        public static final int BINNUMBER = NumericDataSource.access$008();
        public static final int TAILPERCENT = NumericDataSource.access$008();
        public static final int BINBOUNDS = NumericDataSource.access$008();
        public static final int AVG = NumericDataSource.access$008();
        public static final int MAX = NumericDataSource.access$008();
        public static final int MIN = NumericDataSource.access$008();
        public static final int TOTAL = NumericDataSource.access$008();
        public static final int VAR = NumericDataSource.access$008();
        public static final int STDDEV = NumericDataSource.access$008();
        public static final int SKEW = NumericDataSource.access$008();
        public static final int KURT = NumericDataSource.access$008();
        public static final int VIEW_DEFN = NumericDataSource.access$008();
        public static final int BINTYPE = NumericDataSource.access$008();
        public static final int COMPLEX_ATTRIBUTE = NumericDataSource.access$008();
        public static final int LAST = NumericDataSource.access$000();
    }
}

