/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Vector;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.data.Column;
import oracle.dmt.dm4j.activity.data.Table;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.datasources.DBDataSource;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.dm4j.datasources.NormalizeScheme;
import oracle.dmt.dm4j.wizard.director.transforms.TransformsDirector;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.jdbc.OraclePreparedStatement;

public class NormalizeDataSource
extends DBDataSource {
    private static final int COLUMN_COUNT = 17;
    private static final String ATTRIBUTE_NAME_COLUMN = "Name";
    private static final String ATTRIBUTE_SKEW_COLUMN = "Skewness";
    private static final String ATTRIBUTE_KURT_COLUMN = "Kurtosis";
    private static final String ATTRIBUTE_MEAN_COLUMN = "Mean";
    private static final String ATTRIBUTE_STD_COLUMN = "Std";
    private static final String ATTRIBUTE_MIN_COLUMN = "Min";
    private static final String ATTRIBUTE_MAX_COLUMN = "Max";
    private static final String ATTRIBUTE_NORM_COLUMN = "Scheme";
    private static final String ATTRIBUTE_SKEW_SAVE_COLUMN = "O_Skewness";
    private static final String ATTRIBUTE_KURT_SAVE_COLUMN = "O_Kurtosis";
    private static final String ATTRIBUTE_MEAN_SAVE_COLUMN = "O_Mean";
    private static final String ATTRIBUTE_STD_SAVE_COLUMN = "O_Std";
    private static final String ATTRIBUTE_MIN_SAVE_COLUMN = "O_Min";
    private static final String ATTRIBUTE_MAX_SAVE_COLUMN = "O_Max";
    private static final String ATTRIBUTE_META_COLUMN = "Meta";
    private static final String COMPLEX_ATTRIBUTE_COLUMN = "CDS";
    private static final String ATTRIBUTE_SPARSE_COLUMN = "Sparsity";
    public static final int ATTRIBUTE_NAME_IDX = 0;
    public static final int ATTRIBUTE_SKEW_IDX = 1;
    public static final int ATTRIBUTE_KURT_IDX = 2;
    public static final int ATTRIBUTE_MEAN_IDX = 3;
    public static final int ATTRIBUTE_STD_IDX = 4;
    public static final int ATTRIBUTE_MIN_IDX = 5;
    public static final int ATTRIBUTE_MAX_IDX = 6;
    public static final int ATTRIBUTE_NORM_IDX = 7;
    public static final int ATTRIBUTE_SKEW_SAVE_IDX = 8;
    public static final int ATTRIBUTE_KURT_SAVE_IDX = 9;
    public static final int ATTRIBUTE_MEAN_SAVE_IDX = 10;
    public static final int ATTRIBUTE_STD_SAVE_IDX = 11;
    public static final int ATTRIBUTE_MIN_SAVE_IDX = 12;
    public static final int ATTRIBUTE_MAX_SAVE_IDX = 13;
    public static final int ATTRIBUTE_META_IDX = 14;
    public static final int COMPLEX_ATTRIBUTE_IDX = 15;
    public static final int ATTRIBUTE_SPARSE_IDX = 16;
    protected AbstractActivity m_activity;
    protected ComplexDataStructure m_originalInputCDS;
    protected ComplexDataStructure m_originalOutputCDS;
    protected ComplexDataStructure m_sampledInputCDS;
    protected ComplexDataStructure m_sampledOutputCDS;
    protected String m_normalizationTableName = null;
    protected String m_schemaName;
    protected String m_tableName;
    protected String m_attributeNameMapping;
    protected String m_valueMapping;
    protected boolean m_isTransactional = false;
    protected boolean m_bSingleMetric;
    protected ArrayList m_unusedAttrs = new ArrayList();
    protected Hashtable m_unusedComplexAttrs = new Hashtable();

    public ComplexDataStructure getSampledInputCDS() {
        return this.m_sampledInputCDS;
    }

    public ComplexDataStructure getSampledOutputCDS() {
        return this.m_sampledOutputCDS;
    }

    public ComplexDataStructure getOriginalInputCDS() {
        return this.m_originalInputCDS;
    }

    public ComplexDataStructure getOutputOriginalCDS() {
        return this.m_originalOutputCDS;
    }

    public String getUserScemaName() {
        return this.m_schemaName;
    }

    public NormalizeDataSource(Connection connection, String string, String string2) {
        this(connection, null, string, string2);
    }

    public NormalizeDataSource(Connection connection, AbstractActivity abstractActivity, String string, String string2) {
        super(connection);
        this.m_activity = abstractActivity;
        this.m_schemaName = string;
        this.m_tableName = string2;
    }

    public NormalizeDataSource(Connection connection, String string, String string2, String string3, String string4, boolean bl, boolean bl2) {
        this(connection, null, string, string2);
        this.m_attributeNameMapping = string3;
        this.m_valueMapping = string4;
        this.m_isTransactional = bl;
        this.m_bSingleMetric = bl2;
    }

    public ArrayList getUnusedAttributes() {
        return this.m_unusedAttrs;
    }

    public Hashtable getUnusedComplexAttributes() {
        return this.m_unusedComplexAttrs;
    }

    protected void createData() throws SQLException {
        if (this.m_isTransactional && !this.m_bSingleMetric) {
            this.createDataFromTransactionalDBTable();
        } else {
            this.createDataFrom2DDBTable();
        }
    }

    protected boolean isExcluded(String string) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createDataFrom2DDBTable() throws SQLException {
        String string = null;
        try {
            string = TransformsDirector.getReplacedString(this.m_tableName, "'", "''");
        }
        catch (Exception exception) {
            string = this.m_tableName;
        }
        String string2 = "SELECT column_name, data_type FROM all_tab_columns WHERE owner = '" + this.m_schemaName + "' and table_name = '" + string + "'";
        StringBuffer stringBuffer = new StringBuffer(1000);
        StringBuffer stringBuffer2 = new StringBuffer(1000);
        StringBuffer stringBuffer3 = new StringBuffer(1000);
        ArrayList<String> arrayList = new ArrayList<String>();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            try {
                statement = this.m_conn.createStatement();
                resultSet = statement.executeQuery(string2);
                int n = 0;
                while (resultSet.next()) {
                    block28: {
                        String string3;
                        block30: {
                            string3 = resultSet.getString("column_name");
                            String string4 = resultSet.getString("data_type");
                            if (this.isExcluded(string3) || !string4.equals("NUMBER") && !string4.equals("FLOAT")) break block30;
                            if (this.m_bSingleMetric) {
                                if (0 == string3.compareTo(this.m_valueMapping)) {
                                    arrayList.add(string3);
                                    break block28;
                                } else {
                                    this.m_unusedAttrs.add(string3);
                                }
                                break block28;
                            } else {
                                arrayList.add(string3);
                            }
                            break block28;
                        }
                        this.m_unusedAttrs.add(string3);
                    }
                    ++n;
                }
                resultSet.close();
                resultSet = null;
                statement.close();
                statement = null;
                n = 1;
                int n2 = 200;
                int n3 = arrayList.size();
                int n4 = Math.min(n2, n3);
                int n5 = 0;
                LinkedHashMap linkedHashMap = this.get2DColumns();
                for (int i = 0; i < n3; ++n, ++i) {
                    String string5 = (String)arrayList.get(i);
                    String string6 = i + "";
                    Object[] objectArray = new Object[]{string6, string5};
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(",");
                    }
                    if (stringBuffer2.length() > 0) {
                        stringBuffer2.append(",");
                    }
                    stringBuffer.append(MessageFormat.format("ROUND((SUM(POWER(\"ATTR_{0}_AVG\",3)) / GREATEST(((COUNT(\"{1}\")-1)*POWER(STDDEV(\"{1}\"),3)),0.001)), 2) ATTR_{0}_SKEW,ROUND((SUM(POWER(\"ATTR_{0}_AVG\",4)) / GREATEST(((COUNT(\"{1}\")-1)*POWER(STDDEV(\"{1}\"),4)),0.001)-3), 2) ATTR_{0}_KURT,ROUND(AVG(\"{1}\"), 2) ATTR_{0}_MEAN,ROUND(STDDEV(\"{1}\"), 2) ATTR_{0}_STD,ROUND(MIN(\"{1}\"), 2) ATTR_{0}_MIN,ROUND(MAX(\"{1}\"), 2) ATTR_{0}_MAX", objectArray));
                    stringBuffer2.append(MessageFormat.format("\"{1}\", (\"{1}\"-(AVG(\"{1}\") OVER())) \"ATTR_{0}_AVG\"", objectArray));
                    if (n != n4) continue;
                    Object[] objectArray2 = new Object[]{stringBuffer.toString(), stringBuffer2.toString(), this.m_schemaName, this.m_tableName};
                    stringBuffer3.append(MessageFormat.format("SELECT {0} FROM (SELECT {1} FROM \"{2}\".\"{3}\")", objectArray2));
                    statement = this.m_conn.createStatement();
                    resultSet = statement.executeQuery(stringBuffer3.toString());
                    if (resultSet.next()) {
                        for (int j = n5; j < n4; ++j) {
                            string5 = (String)arrayList.get(j);
                            string6 = "ATTR_" + j;
                            String string7 = resultSet.getString(string6 + "_SKEW");
                            String string8 = resultSet.getString(string6 + "_KURT");
                            String string9 = resultSet.getString(string6 + "_MEAN");
                            String string10 = resultSet.getString(string6 + "_STD");
                            String string11 = resultSet.getString(string6 + "_MIN");
                            String string12 = resultSet.getString(string6 + "_MAX");
                            this.addRows(j, 1);
                            this.setData(0, j, this.getColumnName(string5));
                            if (string7 != null) {
                                this.setData(1, j, new Float(string7.trim()));
                                this.setData(8, j, new Float(string7.trim()));
                            }
                            if (string8 != null) {
                                this.setData(2, j, new Float(string8.trim()));
                                this.setData(9, j, new Float(string8.trim()));
                            }
                            if (string9 != null) {
                                this.setData(3, j, new Float(string9.trim()));
                                this.setData(10, j, new Float(string9.trim()));
                            }
                            if (string10 != null) {
                                this.setData(4, j, new Float(string10.trim()));
                                this.setData(11, j, new Float(string10.trim()));
                            }
                            if (string11 != null) {
                                this.setData(5, j, new Float(string11.trim()));
                                this.setData(12, j, new Float(string11.trim()));
                            }
                            if (string12 != null) {
                                this.setData(6, j, new Float(string12.trim()));
                                this.setData(13, j, new Float(string12.trim()));
                            }
                            if (linkedHashMap == null) continue;
                            Column column = (Column)linkedHashMap.get(string5);
                            this.setSparsityAttribute(j, new Boolean(column.getIsSparse()));
                        }
                    }
                    stringBuffer.setLength(0);
                    stringBuffer2.setLength(0);
                    stringBuffer3.setLength(0);
                    n5 = n4;
                    n4 = Math.min(n + n2, n3);
                }
                Object var32_32 = null;
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                throw sQLException;
            }
        }
        catch (Throwable throwable) {
            Object var32_33 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement == null) throw throwable;
                statement.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (resultSet != null) {
            resultSet.close();
        }
        if (statement == null) return;
        statement.close();
        return;
    }

    protected LinkedHashMap get2DColumns() {
        LinkedHashMap linkedHashMap = null;
        if (this.m_activity != null) {
            LinkedHashSet linkedHashSet = this.m_activity.getTables();
            for (Table table : linkedHashSet) {
                ArrayList arrayList = table.getTxnMappings();
                if (arrayList != null && arrayList.size() != 0) continue;
                linkedHashMap = table.getColumns();
                break;
            }
        }
        return linkedHashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createDataFromTransactionalDBTable() throws SQLException {
        String string = "SELECT \"" + this.m_attributeNameMapping + "\", " + "ROUND((SUM(power(a,3))/GREATEST(((count(\"" + this.m_valueMapping + "\")-1)*power(stddev(\"" + this.m_valueMapping + "\"),3)),0.001)), 2) skewness, " + "ROUND((SUM(power(a,4))/GREATEST(((count(\"" + this.m_valueMapping + "\")-1)*power(stddev(\"" + this.m_valueMapping + "\"),4)),0.001)-3), 2) kurtosis, " + "ROUND(AVG(\"" + this.m_valueMapping + "\"), 2) mean, " + "ROUND(STDDEV(\"" + this.m_valueMapping + "\"), 2) std, " + "ROUND(MIN(\"" + this.m_valueMapping + "\"), 2) min, " + "ROUND(MAX(\"" + this.m_valueMapping + "\"), 2) max " + "FROM (SELECT \"" + this.m_attributeNameMapping + "\", \"" + this.m_valueMapping + "\", (\"" + this.m_valueMapping + "\"-(AVG(\"" + this.m_valueMapping + "\") OVER(PARTITION BY \"" + this.m_attributeNameMapping + "\"))) a " + "      FROM \"" + this.m_schemaName + "\".\"" + this.m_tableName + "\") " + "GROUP BY \"" + this.m_attributeNameMapping + "\"";
        StringBuffer stringBuffer = new StringBuffer(1000);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            try {
                stringBuffer.append(string);
                statement = this.m_conn.createStatement();
                resultSet = statement.executeQuery(stringBuffer.toString());
                int n = 0;
                while (resultSet.next()) {
                    this.addRows(n, 1);
                    String string2 = resultSet.getString(this.m_attributeNameMapping);
                    String string3 = resultSet.getString("skewness");
                    String string4 = resultSet.getString("kurtosis");
                    String string5 = resultSet.getString("mean");
                    String string6 = resultSet.getString("std");
                    String string7 = resultSet.getString("min");
                    String string8 = resultSet.getString("max");
                    this.setData(0, n, string2);
                    if (string3 != null) {
                        this.setData(1, n, new Float(string3.trim()));
                        this.setData(8, n, new Float(string3.trim()));
                    }
                    if (string4 != null) {
                        this.setData(2, n, new Float(string4.trim()));
                        this.setData(9, n, new Float(string4.trim()));
                    }
                    if (string5 != null) {
                        this.setData(3, n, new Float(string5.trim()));
                        this.setData(10, n, new Float(string5.trim()));
                    }
                    if (string6 != null) {
                        this.setData(4, n, new Float(string6.trim()));
                        this.setData(11, n, new Float(string6.trim()));
                    }
                    if (string7 != null) {
                        this.setData(5, n, new Float(string7.trim()));
                        this.setData(12, n, new Float(string7.trim()));
                    }
                    if (string8 != null) {
                        this.setData(6, n, new Float(string8.trim()));
                        this.setData(13, n, new Float(string8.trim()));
                    }
                    ++n;
                }
                Object var14_14 = null;
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                throw sQLException;
            }
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            try {
                resultSet.close();
                statement.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        resultSet.close();
        statement.close();
        return;
    }

    protected ArrayOneDModel createColumns() throws Exception {
        this.addColumns(0, 17);
        Object[] objectArray = new String[]{ATTRIBUTE_NAME_COLUMN, ATTRIBUTE_SKEW_COLUMN, ATTRIBUTE_KURT_COLUMN, ATTRIBUTE_MEAN_COLUMN, ATTRIBUTE_STD_COLUMN, ATTRIBUTE_MIN_COLUMN, ATTRIBUTE_MAX_COLUMN, ATTRIBUTE_NORM_COLUMN, ATTRIBUTE_SKEW_SAVE_COLUMN, ATTRIBUTE_KURT_SAVE_COLUMN, ATTRIBUTE_MEAN_SAVE_COLUMN, ATTRIBUTE_STD_SAVE_COLUMN, ATTRIBUTE_MIN_SAVE_COLUMN, ATTRIBUTE_MAX_SAVE_COLUMN, ATTRIBUTE_META_COLUMN, COMPLEX_ATTRIBUTE_COLUMN, ATTRIBUTE_SPARSE_COLUMN};
        return new ArrayOneDModel(objectArray);
    }

    public NormalizeScheme getScheme(int n) {
        return (NormalizeScheme)this.getData(14, n);
    }

    public void setScheme(int n, NormalizeScheme normalizeScheme) {
        this.setData(1, n, new Float(normalizeScheme.getNewSkewness()));
        this.setData(2, n, new Float(normalizeScheme.getNewKurtosis()));
        this.setData(3, n, new Float(normalizeScheme.getNewMean()));
        this.setData(4, n, new Float(normalizeScheme.getNewStd()));
        this.setData(5, n, new Float(normalizeScheme.getNewMin()));
        this.setData(6, n, new Float(normalizeScheme.getNewMax()));
        this.setData(7, n, normalizeScheme.toString());
        this.setData(14, n, normalizeScheme);
    }

    public void clearSchemes(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            int n = (Integer)vector.get(i);
            NormalizeScheme normalizeScheme = (NormalizeScheme)this.getData(14, n);
            if (normalizeScheme == null) continue;
            this.setData(1, n, new Float(normalizeScheme.getOrgSkewness()));
            this.setData(2, n, new Float(normalizeScheme.getOrgKurtosis()));
            this.setData(3, n, new Float(normalizeScheme.getOrgMean()));
            this.setData(4, n, new Float(normalizeScheme.getOrgStd()));
            this.setData(5, n, new Float(normalizeScheme.getOrgMin()));
            this.setData(6, n, new Float(normalizeScheme.getOrgMax()));
            this.setData(14, n, null);
            this.setData(7, n, null);
        }
    }

    public void setComplexAttribute(int n, String string) {
        this.setData(15, n, string);
    }

    public String getComplexAttribute(int n) {
        return (String)this.getData(15, n);
    }

    public void setSparsityAttribute(int n, Boolean bl) {
        this.setData(16, n, bl);
    }

    public Boolean getSparsityAttribute(int n) {
        return (Boolean)this.getData(16, n);
    }

    public int getAttributeRow(String string) {
        int n = -1;
        int n2 = this.getRowCount();
        for (int i = 0; i < n2; ++i) {
            String string2 = (String)this.getData(0, i);
            if (0 != string2.compareTo(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    public String getColumnName(String string) {
        return this.m_bSingleMetric ? this.m_attributeNameMapping : string;
    }

    public String getColumnValue(String string) {
        return this.m_bSingleMetric ? this.m_valueMapping : string;
    }

    private String getSingleMetricClause() {
        if (!this.m_bSingleMetric) {
            return "";
        }
        String string = " AND column_name = '" + this.m_valueMapping + "'";
        return string;
    }

    public Vector getDistinctValues(String string) {
        return null;
    }

    public String getNormalizationTableName() {
        return this.m_normalizationTableName;
    }

    public String getNormalizationTableName(Connection connection) {
        if (this.m_normalizationTableName != null) {
            return this.m_normalizationTableName;
        }
        try {
            this.m_normalizationTableName = ValidationUtil.createUniqueTableName("DM4J$M", connection, "");
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return this.m_normalizationTableName;
    }

    public void setNormalizationTableName(String string) {
        this.m_normalizationTableName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void createNormalizationTable(Vector vector, Vector vector2, Vector vector3) {
        block12: {
            Connection connection = null;
            Statement statement = null;
            connection = DM4JConnectionManager.getDbConnection();
            String string = "create table " + this.getNormalizationTableName(connection) + "\n" + " (col      VARCHAR2(30),\n" + "  shift    NUMBER,\n" + "  scale    NUMBER\n" + ")";
            statement = connection.createStatement();
            statement.execute(string);
            statement.close();
            statement = null;
            this.populateNormalizationTable(connection, vector, vector2, vector3);
            Object var8_8 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                connection.close();
            }
            catch (Exception exception) {}
            break block12;
            {
                catch (Exception exception) {
                    if (DiscretizeDataSource.isDebug()) {
                        System.out.println(exception);
                    }
                    Object var8_9 = null;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        connection.close();
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    connection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void populateNormalizationTable(Connection connection, Vector vector, Vector vector2, Vector vector3) {
        block11: {
            Statement statement;
            block10: {
                String string = "insert into " + this.getNormalizationTableName(connection) + "\n" + " values ( ?, ?, ? ) ";
                boolean bl = true;
                boolean bl2 = false;
                statement = null;
                bl = connection.getAutoCommit();
                connection.setAutoCommit(false);
                statement = connection.prepareStatement(string);
                ((OraclePreparedStatement)statement).setExecuteBatch(100);
                for (int i = 0; i < vector.size(); ++i) {
                    String string2 = (String)vector.elementAt(i);
                    Double d = (Double)vector2.elementAt(i);
                    Double d2 = (Double)vector3.elementAt(i);
                    if (string2 == null || d == null || d2 == null) continue;
                    int n = 1;
                    statement.setString(n++, string2);
                    statement.setDouble(n++, d);
                    statement.setDouble(n++, d2);
                    statement.executeUpdate();
                }
                if (!bl2) break block10;
                ((OraclePreparedStatement)statement).sendBatch();
                connection.commit();
            }
            Object var15_15 = null;
            try {
                statement.close();
            }
            catch (Exception exception) {}
            break block11;
            {
                catch (Exception exception) {
                    if (DiscretizeDataSource.isDebug()) {
                        System.out.println(exception);
                    }
                    Object var15_16 = null;
                    try {
                        statement.close();
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }
}

