/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.steps.MissingValuesStepOptions;
import oracle.dmt.dm4j.datasources.MissingValuesDataSource;
import oracle.dmt.dm4j.wizard.steps.transformsteps.MissingValuesNumericalStrategyPanel;

public class MissingValuesPredefinedNumericTreatment {
    MissingValuesDataSource m_model;
    MissingValuesStepOptions m_options;

    public MissingValuesPredefinedNumericTreatment(MissingValuesDataSource missingValuesDataSource) {
        this.m_model = missingValuesDataSource;
        this.m_options = this.m_model.getOptions();
    }

    public void processAttributes(ActivityType activityType) {
        if (this.m_options == null) {
            if (activityType.equals(ActivityType.SVM_CLASSIFICATION) || activityType.equals(ActivityType.SVM_REGRESSION) || activityType.equals(ActivityType.GLM_CLASSIFICATION) || activityType.equals(ActivityType.GLM_REGRESSION) || activityType.equals(ActivityType.K_MEANS_CLUSTER) || activityType.equals(ActivityType.NON_NEGATIVE_MATIX_FACTORIZATION)) {
                this.standardDefault();
            } else {
                this.clearAll();
            }
        } else {
            this.standardOptions();
        }
    }

    public void clearAll() {
        MissingValuesDataSource missingValuesDataSource = this.m_model;
        for (int i = 0; i < this.m_model.getRowCount(); ++i) {
            missingValuesDataSource.setDropAttribute(i, MissingValuesNumericalStrategyPanel.NO);
            missingValuesDataSource.setTransformation(i, MissingValuesNumericalStrategyPanel.NONE);
        }
    }

    public void sparsitySettings() {
        for (int i = 0; i < this.m_model.getRowCount(); ++i) {
            boolean bl = this.m_model.getSparsityFlag(i);
            String string = this.m_model.getComplexAttribute(i);
            if (!bl || string == null) continue;
            this.m_model.setDropAttribute(i, MissingValuesNumericalStrategyPanel.NO);
            this.m_model.setTransformation(i, MissingValuesNumericalStrategyPanel.ZERO);
        }
    }

    public void standardDefault() {
        MissingValuesDataSource missingValuesDataSource = this.m_model;
        for (int i = 0; i < missingValuesDataSource.getRowCount(); ++i) {
            Double d = missingValuesDataSource.getMissingPercentage(i);
            if (d == null) continue;
            if (d == 0.0) {
                missingValuesDataSource.setDropAttribute(i, MissingValuesNumericalStrategyPanel.NO);
                missingValuesDataSource.setTransformation(i, MissingValuesNumericalStrategyPanel.MEAN);
                continue;
            }
            missingValuesDataSource.setDropAttribute(i, MissingValuesNumericalStrategyPanel.NO);
            missingValuesDataSource.setTransformation(i, MissingValuesNumericalStrategyPanel.MEAN);
        }
    }

    public void standardOptions() {
        MissingValuesDataSource missingValuesDataSource = this.m_model;
        int n = this.m_options.getNumericalMissingValueOption();
        String string = this.m_options.getNumericalMissingValueTreatment();
        Double d = this.m_options.getNumericalMissingValueCustomValue();
        for (int i = 0; i < missingValuesDataSource.getRowCount(); ++i) {
            Double d2 = missingValuesDataSource.getMissingPercentage(i);
            if (d2 == null) continue;
            if (n == 1) {
                missingValuesDataSource.setTransformation(i, string);
                missingValuesDataSource.setDropAttribute(i, MissingValuesNumericalStrategyPanel.NO);
                continue;
            }
            if (n == 2) {
                missingValuesDataSource.setTransformation(i, d);
                missingValuesDataSource.setDropAttribute(i, MissingValuesNumericalStrategyPanel.NO);
                continue;
            }
            if (n != 3) continue;
            missingValuesDataSource.setTransformation(i, MissingValuesNumericalStrategyPanel.NONE);
            missingValuesDataSource.setDropAttribute(i, MissingValuesNumericalStrategyPanel.YES);
        }
    }
}

