/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.steps.MissingValuesStepOptions;
import oracle.dmt.dm4j.datasources.MissingValuesCategoricalDataSource;
import oracle.dmt.dm4j.wizard.steps.transformsteps.MissingValuesCategoricalStrategyPanel;

public class MissingValuesPredefinedCategoricTreatment {
    MissingValuesCategoricalDataSource m_model;
    MissingValuesStepOptions m_options;

    public MissingValuesPredefinedCategoricTreatment(MissingValuesCategoricalDataSource missingValuesCategoricalDataSource) {
        this.m_model = missingValuesCategoricalDataSource;
        this.m_options = this.m_model.getOptions();
    }

    public void processAttributes(ActivityType activityType) {
        if (this.m_options == null) {
            if (activityType.equals(ActivityType.SVM_CLASSIFICATION) || activityType.equals(ActivityType.SVM_REGRESSION) || activityType.equals(ActivityType.GLM_CLASSIFICATION) || activityType.equals(ActivityType.GLM_REGRESSION) || activityType.equals(ActivityType.K_MEANS_CLUSTER) || activityType.equals(ActivityType.NON_NEGATIVE_MATIX_FACTORIZATION)) {
                this.standardDefault();
            } else {
                this.clearAll();
            }
        } else {
            this.standardOptions();
        }
    }

    public void clearAll() {
        MissingValuesCategoricalDataSource missingValuesCategoricalDataSource = this.m_model;
        for (int i = 0; i < this.m_model.getRowCount(); ++i) {
            missingValuesCategoricalDataSource.setDropAttribute(i, MissingValuesCategoricalStrategyPanel.NO);
            missingValuesCategoricalDataSource.setTransformation(i, MissingValuesCategoricalStrategyPanel.NONE);
        }
    }

    public void sparsitySettings() {
        for (int i = 0; i < this.m_model.getRowCount(); ++i) {
            boolean bl = this.m_model.getSparsityFlag(i);
            String string = this.m_model.getComplexAttribute(i);
            if (!bl || string == null) continue;
            this.m_model.setDropAttribute(i, MissingValuesCategoricalStrategyPanel.NO);
            this.m_model.setTransformation(i, MissingValuesCategoricalStrategyPanel.SPARSE);
        }
    }

    public void standardDefault() {
        MissingValuesCategoricalDataSource missingValuesCategoricalDataSource = this.m_model;
        for (int i = 0; i < missingValuesCategoricalDataSource.getRowCount(); ++i) {
            Double d = missingValuesCategoricalDataSource.getMissingPercentage(i);
            if (d == null) continue;
            if (d == 0.0) {
                missingValuesCategoricalDataSource.setDropAttribute(i, MissingValuesCategoricalStrategyPanel.NO);
                missingValuesCategoricalDataSource.setTransformation(i, MissingValuesCategoricalStrategyPanel.MODE);
                continue;
            }
            missingValuesCategoricalDataSource.setDropAttribute(i, MissingValuesCategoricalStrategyPanel.NO);
            missingValuesCategoricalDataSource.setTransformation(i, MissingValuesCategoricalStrategyPanel.MODE);
        }
    }

    public void standardOptions() {
        MissingValuesCategoricalDataSource missingValuesCategoricalDataSource = this.m_model;
        int n = this.m_options.getCategoricalMissingValueOption();
        String string = this.m_options.getCategoricalMissingValueTreatment();
        String string2 = this.m_options.getCategoricalMissingValueCustomValue();
        for (int i = 0; i < missingValuesCategoricalDataSource.getRowCount(); ++i) {
            Double d = missingValuesCategoricalDataSource.getMissingPercentage(i);
            if (d == null) continue;
            if (n == 1) {
                missingValuesCategoricalDataSource.setTransformation(i, string);
                missingValuesCategoricalDataSource.setDropAttribute(i, MissingValuesCategoricalStrategyPanel.NO);
                continue;
            }
            if (n == 2) {
                missingValuesCategoricalDataSource.setTransformation(i, string2);
                missingValuesCategoricalDataSource.setDropAttribute(i, MissingValuesCategoricalStrategyPanel.NO);
                continue;
            }
            if (n != 3) continue;
            missingValuesCategoricalDataSource.setTransformation(i, MissingValuesCategoricalStrategyPanel.NONE);
            missingValuesCategoricalDataSource.setDropAttribute(i, MissingValuesCategoricalStrategyPanel.YES);
        }
    }
}

