/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.datasources.DataUtilities;

public class MiningObjects {
    Hashtable m_miningObjects = new Hashtable(9);
    public static final String ASSOCIATION_RULES_MODELS = "ASSOCIATION_RULES_MODELS";
    public static final String ATTRIBUTE_IMPORTANCE_MODELS = "ATTRIBUTE_IMPORTANCE_MODELS";
    public static final String CLASSIFICATION_MODELS = "CLASSIFICATION_MODELS";
    public static final String REGRESSION_MODELS = "REGRESSION_MODELS";
    public static final String FEATURE_EXTRACTION_MODELS = "FEATURE_EXTRACTION_MODELS";
    public static final String ANOMALY_DETECTION_MODELS = "ANOMALY_DETECTION_MODELS";
    public static final String CLUSTERING_MODELS = "CLUSTERING_MODELS";
    public static final String TEST_RESULTS = "TEST_RESULTS";
    public static final String RESIDUAL_PLOT_RESULTS = "RESIDUAL_PLOT_RESULTS";
    public static final String LIFT_RESULTS = "LIFT_RESULTS";
    public static final String APPLY_RESULTS = "APPLY_RESULTS";
    public static final String PREDICT_RESULTS = "PREDICT_RESULTS";
    public static final String EXPLAIN_RESULTS = "EXPLAIN_RESULTS";

    public LeafNodeData[] getMiningNodes(Connection connection, String string) throws SQLException, Exception {
        LeafNodeData[] leafNodeDataArray = (LeafNodeData[])this.m_miningObjects.get(string);
        if (leafNodeDataArray == null) {
            leafNodeDataArray = this.loadNodes(connection, string);
            this.m_miningObjects.put(string, leafNodeDataArray);
        }
        return leafNodeDataArray;
    }

    private LeafNodeData[] createNodeCollection(String[] stringArray, String string) throws Exception {
        LeafNodeData[] leafNodeDataArray = new LeafNodeData[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            leafNodeDataArray[i] = new LeafNodeData(stringArray[i], string);
        }
        return leafNodeDataArray;
    }

    private LeafNodeData[] loadNodes(Connection connection, String string) throws SQLException, Exception {
        LeafNodeData[] leafNodeDataArray = null;
        String[] stringArray = null;
        DMEMetadata dMEMetadata = DMEMetadata.getInstance();
        if (string.equals(ASSOCIATION_RULES_MODELS)) {
            stringArray = dMEMetadata.getModelNames(connection, "ASSOCIATION_RULES");
            leafNodeDataArray = this.createNodeCollection(stringArray, "ASSOCIATION_RULES_MODEL");
        } else if (string.equals(ATTRIBUTE_IMPORTANCE_MODELS)) {
            stringArray = dMEMetadata.getModelNames(connection, "ATTRIBUTE_IMPORTANCE");
            leafNodeDataArray = this.createNodeCollection(stringArray, "ATTRIBUTE_IMPORTANCE_MODEL");
        } else if (string.equals(CLASSIFICATION_MODELS)) {
            int n;
            String[] stringArray2 = dMEMetadata.getModelNames(connection, "CLASSIFICATION", "ADAPTIVE_BAYES_NETWORK");
            LeafNodeData[] leafNodeDataArray2 = this.createNodeCollection(stringArray2, "ABN_MODEL");
            String[] stringArray3 = dMEMetadata.getModelNames(connection, "CLASSIFICATION", "NAIVE_BAYES");
            LeafNodeData[] leafNodeDataArray3 = this.createNodeCollection(stringArray3, "NB_MODEL");
            String[] stringArray4 = dMEMetadata.getModelNames(connection, "CLASSIFICATION", "SUPPORT_VECTOR_MACHINES");
            LeafNodeData[] leafNodeDataArray4 = this.createNodeCollection(stringArray4, "SVM_CLASSIFICATION_MODEL");
            String[] stringArray5 = dMEMetadata.getModelNames(connection, "CLASSIFICATION", "DECISION_TREE");
            LeafNodeData[] leafNodeDataArray5 = this.createNodeCollection(stringArray5, "DT_MODEL");
            int n2 = leafNodeDataArray2.length + leafNodeDataArray3.length + leafNodeDataArray4.length + leafNodeDataArray5.length;
            LeafNodeData[] leafNodeDataArray6 = new LeafNodeData[n2];
            for (n = 0; n < leafNodeDataArray2.length; ++n) {
                leafNodeDataArray6[n] = leafNodeDataArray2[n];
            }
            int n3 = leafNodeDataArray2.length;
            for (n = 0; n < leafNodeDataArray3.length; ++n) {
                leafNodeDataArray6[n3] = leafNodeDataArray3[n];
                ++n3;
            }
            n3 = leafNodeDataArray2.length + leafNodeDataArray3.length;
            for (n = 0; n < leafNodeDataArray4.length; ++n) {
                leafNodeDataArray6[n3] = leafNodeDataArray4[n];
                ++n3;
            }
            for (n = 0; n < leafNodeDataArray5.length; ++n) {
                leafNodeDataArray6[n3] = leafNodeDataArray5[n];
                ++n3;
            }
            leafNodeDataArray = leafNodeDataArray6;
        } else if (string.equals(REGRESSION_MODELS)) {
            stringArray = dMEMetadata.getModelNames(connection, "REGRESSION");
            leafNodeDataArray = this.createNodeCollection(stringArray, "SVM_REGRESSION_MODEL");
        } else if (string.equals(FEATURE_EXTRACTION_MODELS)) {
            stringArray = dMEMetadata.getModelNames(connection, "FEATURE_EXTRACTION");
            leafNodeDataArray = this.createNodeCollection(stringArray, "NMF_MODEL");
        } else if (string.equals(CLUSTERING_MODELS)) {
            int n;
            String[] stringArray6 = dMEMetadata.getModelNames(connection, "CLUSTERING", "O_CLUSTER");
            LeafNodeData[] leafNodeDataArray7 = this.createNodeCollection(stringArray6, "CLUSTERING_OCLUSTER_MODEL");
            String[] stringArray7 = dMEMetadata.getModelNames(connection, "CLUSTERING", "KMEANS");
            LeafNodeData[] leafNodeDataArray8 = this.createNodeCollection(stringArray7, "CLUSTERING_KMEANS_MODEL");
            int n4 = leafNodeDataArray7.length + leafNodeDataArray8.length;
            LeafNodeData[] leafNodeDataArray9 = new LeafNodeData[n4];
            for (n = 0; n < leafNodeDataArray7.length; ++n) {
                leafNodeDataArray9[n] = leafNodeDataArray7[n];
            }
            int n5 = leafNodeDataArray7.length;
            for (n = 0; n < leafNodeDataArray8.length; ++n) {
                leafNodeDataArray9[n5] = leafNodeDataArray8[n];
                ++n5;
            }
            leafNodeDataArray = leafNodeDataArray9;
        } else if (string.equals(ANOMALY_DETECTION_MODELS)) {
            stringArray = dMEMetadata.getModelNames(connection, "ANOMALY_DETECTION");
            leafNodeDataArray = this.createNodeCollection(stringArray, "SVM_ONE_CLASS_MODEL");
        } else if (string.equals(TEST_RESULTS)) {
            stringArray = dMEMetadata.getResultNames(connection, "TEST", null);
            leafNodeDataArray = this.createNodeCollection(stringArray, "TEST_RESULT");
        } else if (string.equals(APPLY_RESULTS)) {
            stringArray = dMEMetadata.getResultNames(connection, "APPLY", null);
            leafNodeDataArray = this.createNodeCollection(stringArray, "APPLY_RESULT");
        } else if (string.equals(RESIDUAL_PLOT_RESULTS)) {
            stringArray = dMEMetadata.getResultNames(connection, "PLOT", null);
            leafNodeDataArray = this.createNodeCollection(stringArray, "RESIDUAL_PLOT_RESULT");
        } else if (string.equals(PREDICT_RESULTS)) {
            stringArray = dMEMetadata.getResultNames(connection, "PRDCT", null);
            leafNodeDataArray = this.createNodeCollection(stringArray, "PREDICT_RESULT");
        } else if (string.equals(EXPLAIN_RESULTS)) {
            stringArray = dMEMetadata.getResultNames(connection, "EXPLN", null);
            leafNodeDataArray = this.createNodeCollection(stringArray, "EXPLAIN_RESULT");
        }
        if (stringArray != null && stringArray.length > 0) {
            DataUtilities.sortStringArray(stringArray);
        }
        if (leafNodeDataArray != null && leafNodeDataArray.length > 0) {
            DataUtilities.sortNodeArray(leafNodeDataArray);
        }
        return leafNodeDataArray;
    }
}

