/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.steps.DiscretizationStepOptions;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.dm4j.datasources.DiscretizeEqualWidthArrayMultipleBins;
import oracle.dmt.dm4j.datasources.DiscretizeQtileArrayMultipleBins;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.odm.binning.BackupData;
import oracle.dmt.odm.binning.BinningType;
import oracle.dmt.odm.binning.DM4JTransformation;

public class DiscretizePredefinedNumericTreatment {
    DiscretizeDataSource m_model;
    DiscretizationStepOptions m_options;
    Hashtable m_backupData = null;
    boolean m_bShowProgress;
    boolean m_bLabels = false;
    static String QUANTILE_BINNING = ResourceUtilities.getUILabel("QUANTILE_BINNING_STRATEGY_DIALOG_DESCRIPTION");
    static String EQUAL_WIDTH_BINNING = ResourceUtilities.getUILabel("EQUAL_WIDTH_BINNING_STRATEGY_DIALOG_DESCRIPTION");
    static String TOPN_BINNING = ResourceUtilities.getUILabel("TOPN_BINNING_STRATEGY_DIALOG_DESCRIPTION");
    static String NONE = ResourceUtilities.getUILabel("NONE");

    public DiscretizePredefinedNumericTreatment(DiscretizeDataSource discretizeDataSource, Hashtable hashtable) {
        this.m_bShowProgress = true;
        this.m_bLabels = discretizeDataSource.isLabels();
        this.m_model = discretizeDataSource;
        this.m_options = this.m_model.getDiscretizationStepOptions();
        this.m_backupData = hashtable;
    }

    public DiscretizePredefinedNumericTreatment(DiscretizeDataSource discretizeDataSource) {
        this.m_bShowProgress = false;
        this.m_bLabels = false;
        this.m_model = discretizeDataSource;
        this.m_options = this.m_model.getDiscretizationStepOptions();
        this.m_backupData = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void processAttributes(ActivityType activityType) {
        block23: {
            String string = this.m_model.getNumericBinBoundatyTableName();
            String string2 = this.m_model.getUserSchemaName();
            if (string != null) {
                String string3 = string2 != null ? "\"" + string2 + "\".\"" : "\"";
                String string4 = string3 + string + "\"";
                Connection connection = null;
                connection = DM4JConnectionManager.getDbConnection();
                DM4JTransformation.removeAttributesFromBinBoundaryTable(connection, "DELETE FROM " + string4);
                Object var9_11 = null;
                try {
                    if (connection != null) {
                        connection.close();
                    }
                    break block23;
                }
                catch (Exception exception) {}
                break block23;
                {
                    catch (Exception exception) {
                        if (DiscretizeDataSource.isDebug()) {
                            exception.printStackTrace();
                        }
                        Object var9_12 = null;
                        try {
                            if (connection != null) {
                                connection.close();
                            }
                            break block23;
                        }
                        catch (Exception exception2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        if (this.m_options == null) {
            if (activityType.equals(ActivityType.ASSOCIATION_RULES) || activityType.equals(ActivityType.O_CLUSTER)) {
                boolean bl = this.m_model.isLabels();
                this.m_model.setLabels(this.m_bLabels);
                this.equalWidth(activityType);
                this.m_model.setLabels(bl);
            } else if (activityType.equals(ActivityType.ADAPTIVE_NAIVE_BAYES) || activityType.equals(ActivityType.NAIVE_BAYES) || activityType.equals(ActivityType.ATTRIBUTE_IMPORTANCE)) {
                boolean bl = this.m_model.isLabels();
                this.m_model.setLabels(this.m_bLabels);
                this.quantile(activityType);
                this.m_model.setLabels(bl);
            } else {
                this.unbinAll();
            }
        } else if (this.m_options.getNumericalDiscretizeTreatment().equalsIgnoreCase(EQUAL_WIDTH_BINNING)) {
            boolean bl = this.m_model.isLabels();
            this.m_model.setLabels(this.m_bLabels);
            this.equalWidth(activityType);
            this.m_model.setLabels(bl);
        } else if (this.m_options.getNumericalDiscretizeTreatment().equalsIgnoreCase(QUANTILE_BINNING)) {
            boolean bl = this.m_model.isLabels();
            this.m_model.setLabels(this.m_bLabels);
            this.quantile(activityType);
            this.m_model.setLabels(bl);
        } else {
            this.unbinAll();
        }
    }

    private int getDefaultBinNumber(ActivityType activityType, int n) {
        Integer n2;
        int n3;
        int n4 = n3 = true == activityType.equals(ActivityType.ADAPTIVE_NAIVE_BAYES) ? DiscretizeDataSource.DEFAULT_ABN_BIN_NUMBER : DiscretizeDataSource.DEFAULT_BIN_NUMBER;
        if (this.m_options != null) {
            n3 = this.m_options.getNumericalBinNumber();
        }
        int n5 = (n2 = this.m_model.getDistinctValue(n)) == null ? n3 : n2;
        int n6 = n3;
        if (activityType.equals(ActivityType.ADAPTIVE_NAIVE_BAYES) || activityType.equals(ActivityType.ASSOCIATION_RULES)) {
            n6 = Math.min(n5, n3);
        } else if (activityType.equals(ActivityType.NAIVE_BAYES) || activityType.equals(ActivityType.ATTRIBUTE_IMPORTANCE)) {
            double d = (-30.0 + Math.sqrt(900.0 + 4.0 * (double)n5)) / 2.0;
            n6 = Math.max(3, Math.min((int)d, 126));
        } else if (activityType.equals(ActivityType.O_CLUSTER)) {
            n6 = this.m_model.calculateBinNumber(null, this.m_model.getAttributeName(n));
        }
        return n6;
    }

    public void unbinAll() {
        for (int i = 0; i < this.m_model.getRowCount(); ++i) {
            this.m_model.markAttributeUnBinned(i);
            this.m_model.setActivityType(i, null);
        }
    }

    public void equalWidth(ActivityType activityType) {
        if (this.m_backupData != null) {
            this.m_backupData.clear();
        }
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
        for (int i = 0; i < this.m_model.getRowCount(); ++i) {
            BackupData backupData = new BackupData(this.m_model, i);
            int n = this.getDefaultBinNumber(activityType, i);
            String string = this.m_model.getAttributeName(i);
            hashtable.put(string, new Integer(i));
            hashtable2.put(string, new Integer(n));
            this.m_model.setNumberOfBins(i, n);
            this.m_model.markAttributeBinned(i, BinningType.EQ_WIDTH, n);
            if (this.m_backupData == null) continue;
            this.m_backupData.put(new Integer(i), backupData);
        }
        if (this.m_bShowProgress) {
            this.getEqualWidthBounds(hashtable, hashtable2);
        } else {
            this.getEqualWidthBoundsSilent(hashtable, hashtable2);
        }
    }

    public void quantile(ActivityType activityType) {
        Integer n;
        int n2;
        Object object;
        Object object2;
        String string;
        Enumeration enumeration;
        if (this.m_backupData != null) {
            this.m_backupData.clear();
        }
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
        for (int i = 0; i < this.m_model.getRowCount(); ++i) {
            enumeration = new BackupData(this.m_model, i);
            int n3 = this.getDefaultBinNumber(activityType, i);
            string = this.m_model.getAttributeName(i);
            hashtable.put(string, new Integer(i));
            hashtable2.put(string, new Integer(n3));
            this.m_model.setNumberOfBins(i, n3);
            this.m_model.markAttributeBinned(i, BinningType.QTILE, n3);
            if (this.m_backupData == null) continue;
            this.m_backupData.put(new Integer(i), enumeration);
        }
        if (this.m_bShowProgress) {
            this.getQtileWidthBounds(hashtable, hashtable2);
        } else {
            this.getQtileWidthBoundsSilent(hashtable, hashtable2);
        }
        Vector<Object> vector = new Vector<Object>();
        enumeration = hashtable.keys();
        Hashtable<String, Integer> hashtable3 = new Hashtable<String, Integer>();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object2 = (Integer)hashtable.get(string);
            int n4 = (Integer)object2;
            object = this.m_model.getBinBounds(n4);
            n2 = object != null ? ((Vector)object).size() : 0;
            n = (Integer)hashtable2.get(string);
            int n5 = n;
            if (n2 != 0) {
                if (n2 == n5) continue;
                hashtable3.put(string, new Integer(n2));
                this.m_model.setNumberOfBins(n4, n2);
                this.m_model.markAttributeBinned(n4, BinningType.QTILE, n2);
                continue;
            }
            vector.add(object2);
            this.m_model.setViewDefinition(n4, null);
            this.m_model.setBinTypeNONE(n4);
            this.m_model.setNumberOfBins(n4, 0);
            this.m_model.setBinBounds(n4, null);
        }
        int n6 = hashtable3.size();
        if (n6 != 0) {
            object2 = null;
            if (n6 <= 5) {
                StringBuffer stringBuffer = new StringBuffer();
                enumeration = hashtable3.keys();
                while (enumeration.hasMoreElements()) {
                    object = (String)enumeration.nextElement();
                    stringBuffer.append("\"" + (String)object + "\": " + hashtable3.get(object).toString());
                    stringBuffer.append("\n");
                }
                object2 = vector.isEmpty() ? MessageFormat.format(ResourceUtilities.getUILabel("QTILE_BINNING_STRATEGY_DIALOG_WARNING"), stringBuffer.toString()) : MessageFormat.format(ResourceUtilities.getUILabel("QTILE_BINNING_STRATEGY_DIALOG_WARNING_UNBINNED"), stringBuffer.toString());
            } else {
                object2 = vector.isEmpty() ? ResourceUtilities.getUILabel("QTILE_BINNING_STRATEGY_DIALOG_WARNING_DETAILS") : ResourceUtilities.getUILabel("QTILE_BINNING_STRATEGY_DIALOG_WARNING_DETAILS_UNBINNED");
            }
            if (this.m_bShowProgress) {
                JOptionPane.showMessageDialog(null, object2, ResourceUtilities.getUILabel("WARNING_DIALOG_TITLE"), 1);
            }
        } else {
            int n7 = vector.size();
            if (n7 > 0) {
                String string2 = null;
                if (n7 <= 5) {
                    object = new StringBuffer();
                    for (n2 = 0; n2 < vector.size(); ++n2) {
                        n = (Integer)vector.elementAt(n2);
                        ((StringBuffer)object).append("\"" + this.m_model.getAttributeName(n) + "\"\n");
                    }
                    string2 = MessageFormat.format(ResourceUtilities.getUILabel("QTILE_BINNING_STRATEGY_DIALOG_UNBINNED_DETAILS"), ((StringBuffer)object).toString());
                } else {
                    string2 = ResourceUtilities.getUILabel("QTILE_BINNING_STRATEGY_DIALOG_UNBINNED_LIST");
                }
                if (this.m_bShowProgress) {
                    JOptionPane.showMessageDialog(null, string2, ResourceUtilities.getUILabel("WARNING_DIALOG_TITLE"), 1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void getQtileWidthBounds(Hashtable hashtable, Hashtable hashtable2) {
        block13: {
            Connection connection;
            block12: {
                connection = null;
                connection = DM4JConnectionManager.getDbConnection();
                DiscretizeQtileArrayMultipleBins discretizeQtileArrayMultipleBins = new DiscretizeQtileArrayMultipleBins(connection, this.m_model, hashtable, hashtable2);
                ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_TITLE"), discretizeQtileArrayMultipleBins, true);
                discretizeQtileArrayMultipleBins.setProgressBar(progressBar);
                progressBar.start(ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_TITLE"), ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_DESC"));
                if (discretizeQtileArrayMultipleBins.getException() != null) {
                    this.restoreAttrubuteValues(hashtable);
                    break block12;
                }
                if (!progressBar.hasUserCancelled()) break block12;
                this.restoreAttrubuteValues(hashtable);
            }
            Object var7_7 = null;
            try {
                if (connection != null) {
                    connection.close();
                }
                break block13;
            }
            catch (Exception exception) {}
            break block13;
            {
                catch (Exception exception) {
                    Object var7_8 = null;
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                        break block13;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void getQtileWidthBoundsSilent(Hashtable hashtable, Hashtable hashtable2) {
        block12: {
            Connection connection = null;
            connection = DM4JConnectionManager.getDbConnection();
            DiscretizeQtileArrayMultipleBins discretizeQtileArrayMultipleBins = new DiscretizeQtileArrayMultipleBins(connection, this.m_model, hashtable, hashtable2);
            discretizeQtileArrayMultipleBins.calculate();
            Object var6_6 = null;
            try {
                if (connection != null) {
                    connection.close();
                }
                break block12;
            }
            catch (Exception exception) {}
            break block12;
            {
                catch (Exception exception) {
                    if (DiscretizeDataSource.isDebug()) {
                        System.out.println(exception);
                    }
                    Object var6_7 = null;
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                        break block12;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void getEqualWidthBounds(Hashtable hashtable, Hashtable hashtable2) {
        block13: {
            Connection connection;
            block12: {
                connection = null;
                connection = DM4JConnectionManager.getDbConnection();
                DiscretizeEqualWidthArrayMultipleBins discretizeEqualWidthArrayMultipleBins = new DiscretizeEqualWidthArrayMultipleBins(connection, this.m_model, hashtable, hashtable2);
                ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_TITLE"), discretizeEqualWidthArrayMultipleBins, true);
                discretizeEqualWidthArrayMultipleBins.setProgressBar(progressBar);
                progressBar.start(ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_TITLE"), ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_DESC"));
                if (discretizeEqualWidthArrayMultipleBins.getException() != null) {
                    this.restoreAttrubuteValues(hashtable);
                    break block12;
                }
                if (!progressBar.hasUserCancelled()) break block12;
                this.restoreAttrubuteValues(hashtable);
            }
            Object var7_7 = null;
            try {
                if (connection != null) {
                    connection.close();
                }
                break block13;
            }
            catch (Exception exception) {}
            break block13;
            {
                catch (Exception exception) {
                    Object var7_8 = null;
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                        break block13;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void getEqualWidthBoundsSilent(Hashtable hashtable, Hashtable hashtable2) {
        block12: {
            Connection connection = null;
            connection = DM4JConnectionManager.getDbConnection();
            DiscretizeEqualWidthArrayMultipleBins discretizeEqualWidthArrayMultipleBins = new DiscretizeEqualWidthArrayMultipleBins(connection, this.m_model, hashtable, hashtable2);
            discretizeEqualWidthArrayMultipleBins.calculate();
            Object var6_6 = null;
            try {
                if (connection != null) {
                    connection.close();
                }
                break block12;
            }
            catch (Exception exception) {}
            break block12;
            {
                catch (Exception exception) {
                    if (DiscretizeDataSource.isDebug()) {
                        System.out.println(exception);
                    }
                    Object var6_7 = null;
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                        break block12;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    protected void restoreAttrubuteValues(Hashtable hashtable) {
        if (this.m_backupData == null) {
            return;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Integer n = (Integer)hashtable.get(string);
            if (n == null) continue;
            BackupData backupData = (BackupData)this.m_backupData.get(n);
            int n2 = n;
            backupData.restoreBackupData(this.m_model);
        }
    }
}

