/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.Connection;
import java.util.Vector;
import oracle.bali.ewt.event.Cancelable;
import oracle.dmt.dm4j.browser.LongRunningProcess;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.dm4j.datasources.NumericDataSource;
import oracle.dmt.odm.binning.BinningType;

public class DataQueryResult
extends LongRunningProcess
implements Cancelable {
    protected Connection m_conn;
    protected boolean m_canceled = false;
    protected NumericDataSource m_numericDataSource;
    protected String m_attributeName;
    protected String m_functionName;
    protected String m_dataTableName;
    protected String m_dataSchemaName;
    protected String[] m_attrNames;
    protected double[] m_stats;
    protected int[] m_frequency = null;
    protected int m_numberofBins = 0;
    protected double m_tailPercent = 0.0;
    protected String m_failedAttributes = null;
    protected String m_attributeMapping;
    protected String m_valueMapping;
    protected String m_seqIdMapping;
    protected boolean m_isTransactional;
    protected boolean m_bSingleMetric;

    public String getFailed() {
        return this.m_failedAttributes;
    }

    public String getFunctionName() {
        return this.m_functionName;
    }

    public String getDataTableName() {
        return this.m_dataTableName;
    }

    public String getDataSchemaName() {
        return this.m_dataSchemaName;
    }

    public String getAttributeName() {
        return this.m_attributeName;
    }

    public int getNumberofBins() {
        return this.m_numericDataSource == null ? DiscretizeDataSource.DEFAULT_BIN_NUMBER : this.m_numericDataSource.getNumberOfBins();
    }

    public void setNumberofBins(int n) {
        if (this.m_numericDataSource != null) {
            this.m_numericDataSource.setNumberOfBins(n);
        }
    }

    public double getTailPercent() {
        return this.m_numericDataSource == null ? DiscretizeDataSource.DEFAULT_TAIL_PERCENT : this.m_numericDataSource.getTailPercent();
    }

    public void setTailPercent(double d) {
        if (this.m_numericDataSource != null) {
            this.m_numericDataSource.setTailPercent(d);
        }
    }

    public Double getSkew() {
        return this.m_numericDataSource.getSkew();
    }

    public Double getKurtosis() {
        return this.m_numericDataSource.getKurtosis();
    }

    public Double getAverage() {
        return this.m_numericDataSource.getAverage();
    }

    public Double getSigma() {
        return this.m_numericDataSource.getSigma();
    }

    public Double getMax() {
        return this.m_numericDataSource.getMax();
    }

    public Double getMin() {
        return this.m_numericDataSource.getMin();
    }

    public Integer getTotal() {
        return this.m_numericDataSource.getTotalCount();
    }

    public DataQueryResult(Connection connection, String string, String string2, String string3, String[] stringArray, String string4, int n, double d, boolean bl, String string5, String string6, String string7, boolean bl2) throws Exception {
        this.m_conn = connection;
        this.m_attributeName = string4;
        this.m_functionName = string;
        this.m_dataTableName = string2;
        this.m_dataSchemaName = string3;
        this.m_attrNames = stringArray;
        this.m_numberofBins = n;
        this.m_tailPercent = d;
        this.m_isTransactional = bl;
        this.m_attributeMapping = string5;
        this.m_valueMapping = string6;
        this.m_seqIdMapping = string7;
        this.m_bSingleMetric = bl2;
    }

    protected NumericDataSource get2dNumericDataSource() throws Exception {
        return new NumericDataSource(this.m_conn, this.m_functionName, this.m_attributeName, this.m_dataTableName, this.m_dataSchemaName, this.m_numberofBins, this.m_tailPercent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block11: {
            this.m_numericDataSource = this.m_isTransactional ? new NumericDataSource(this.m_conn, this.m_functionName, this.m_attributeName, this.m_dataTableName, this.m_dataSchemaName, this.m_numberofBins, this.m_tailPercent, this.m_attributeMapping, this.m_valueMapping, this.m_seqIdMapping, this.m_bSingleMetric) : this.get2dNumericDataSource();
            this.m_frequency = this.m_numericDataSource.getFrequency(this.m_conn, this.m_attributeName);
            this.getProgressBar().setDoneStatus();
            Object var3_1 = null;
            try {
                if (this.m_numericDataSource != null) {
                    this.m_numericDataSource.cleanUp();
                }
                break block11;
            }
            catch (Exception exception) {}
            break block11;
            {
                catch (Exception exception) {
                    this.setException(exception);
                    this.getProgressBar().setDoneStatus();
                    Object var3_2 = null;
                    try {
                        if (this.m_numericDataSource != null) {
                            this.m_numericDataSource.cleanUp();
                        }
                        break block11;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                try {
                    if (this.m_numericDataSource != null) {
                        this.m_numericDataSource.cleanUp();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public boolean isCancelled() {
        return this.m_canceled;
    }

    public void cancel() {
        this.m_canceled = true;
    }

    public double[] getAttributeValues() {
        return this.m_stats;
    }

    public int[] getFrequency() {
        return this.m_frequency;
    }

    public Vector getBinBounds() {
        return this.m_numericDataSource.getBinBounds();
    }

    public int getNullCount() {
        return this.m_numericDataSource.getNullCount();
    }

    public String getBinningType() {
        BinningType binningType = this.m_numericDataSource.getBinningType();
        return binningType == null ? BinningType.EQ_WIDTH.getName() : binningType.getName();
    }
}

