/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.dm4j.datasources.TXColumn;
import oracle.dmt.dm4j.datasources.TableColumnsModel;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;

public class ComplexDataStructure
implements Serializable {
    protected String m_name = null;
    protected String m_caseTable = null;
    protected String m_sampledCaseTable;
    protected String m_caseSchema = null;
    protected String m_caseId = null;
    protected StringBuffer m_sqlCaseQuery = new StringBuffer();
    protected TreeMap m_columnMap = new TreeMap();

    public ComplexDataStructure() {
    }

    public ComplexDataStructure(String string, String string2, String string3, String string4) {
        this();
        this.m_name = string;
        this.m_caseTable = string2;
        this.m_caseSchema = string3;
        this.m_caseId = string4;
    }

    public StringBuffer getSQLCaseQuery() {
        return this.m_sqlCaseQuery;
    }

    public void setSQLCaseQuery(StringBuffer stringBuffer) {
        this.m_sqlCaseQuery = stringBuffer;
    }

    public String getCaseTable() {
        return this.m_caseTable;
    }

    public void setCaseTable(String string) {
        this.m_caseTable = string;
    }

    public String getSampledCaseTable() {
        return this.m_sampledCaseTable;
    }

    public void setSampledCaseTable(String string) {
        this.m_sampledCaseTable = string;
    }

    public String getCaseSchema() {
        return this.m_caseSchema;
    }

    public void setCaseSchema(String string) {
        this.m_caseSchema = string;
    }

    public TreeMap getColumnMap() {
        return this.m_columnMap;
    }

    public void setColumnMap(TreeMap treeMap) {
        this.m_columnMap = treeMap;
    }

    public TXColumn getTXColumn(String string) {
        return (TXColumn)this.m_columnMap.get(string);
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public String getCaseId() {
        return this.m_caseId;
    }

    public void setCaseId(String string) {
        this.m_caseId = string;
    }

    public String getValueColumn(String string) {
        TXColumn tXColumn = (TXColumn)this.m_columnMap.get(string);
        if (tXColumn == null) {
            return null;
        }
        String string2 = tXColumn.getValueColumn();
        return string2;
    }

    public static String createUniqueName(String string, String string2, String string3) {
        return string + ":" + string2 + ":" + string3;
    }

    public TXColumn getTXColumn() throws Exception {
        Collection collection = this.m_columnMap.values();
        if (collection == null || collection.size() != 1) {
            return null;
        }
        Iterator iterator = collection.iterator();
        TXColumn tXColumn = (TXColumn)iterator.next();
        if (tXColumn == null) {
            throw new Exception();
        }
        return tXColumn;
    }

    public String getValueColumn() throws Exception {
        TXColumn tXColumn = this.getTXColumn();
        return tXColumn != null ? tXColumn.getValueColumn() : null;
    }

    public String getAttributeNameColumn() throws Exception {
        TXColumn tXColumn = this.getTXColumn();
        return tXColumn != null ? tXColumn.getNameColumn() : null;
    }

    public String getCaseIdColumn() throws Exception {
        TXColumn tXColumn = this.getTXColumn();
        return tXColumn != null ? tXColumn.getTxColumnCaseId() : null;
    }

    public String getTableName() throws Exception {
        TXColumn tXColumn = this.getTXColumn();
        return tXColumn != null ? tXColumn.getTxTableName() : null;
    }

    public String getDataLocation() throws Exception {
        TXColumn tXColumn = this.getTXColumn();
        return tXColumn != null ? tXColumn.getDataLocation() : null;
    }

    public boolean isSingleMetric() throws Exception {
        TXColumn tXColumn = this.getTXColumn();
        return tXColumn != null ? tXColumn.getIsSingleMetrics() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComplexDataStructure createOutputComplexDataStructure(String string, ComplexDataStructure complexDataStructure, String string2) {
        Connection connection = null;
        ComplexDataStructure complexDataStructure2 = null;
        String string3 = DM4JStringUtils.trimDoubleQuotes(string2);
        try {
            connection = DM4JConnectionManager.getDbConnection();
            complexDataStructure2 = new ComplexDataStructure(string, string3, complexDataStructure.getCaseSchema(), complexDataStructure.getCaseId());
            TreeMap treeMap = complexDataStructure.getColumnMap();
            if (treeMap == null || treeMap.isEmpty()) {
                ComplexDataStructure complexDataStructure3 = complexDataStructure2;
                return complexDataStructure3;
            }
            Set set = treeMap.keySet();
            Iterator iterator = set.iterator();
            String string4 = null;
            string4 = string3.startsWith("DM4J$V") ? string3.substring("DM4J$V".length(), string3.length()) : string3;
            while (iterator.hasNext()) {
                String string5 = (String)iterator.next();
                TXColumn tXColumn = (TXColumn)treeMap.get(string5);
                if (tXColumn == null) continue;
                String string6 = ValidationUtil.createUniqueTableNameUsingRandom("DM4J$X" + string4, connection, "");
                complexDataStructure2.addTxDataSourceTable(tXColumn, string6);
            }
        }
        catch (Exception exception) {
            complexDataStructure2 = null;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
        return complexDataStructure2;
    }

    public static ComplexDataStructure createOutputComplexDataStructureDual(String string, ComplexDataStructure complexDataStructure, String string2) {
        Object var3_3 = null;
        ComplexDataStructure complexDataStructure2 = null;
        try {
            complexDataStructure2 = new ComplexDataStructure(string, string2, complexDataStructure.getCaseSchema(), complexDataStructure.getCaseId());
            TreeMap treeMap = complexDataStructure.getColumnMap();
            if (treeMap == null || treeMap.isEmpty()) {
                return complexDataStructure2;
            }
            complexDataStructure2.m_columnMap = complexDataStructure.m_columnMap;
        }
        catch (Exception exception) {
            complexDataStructure2 = null;
        }
        return complexDataStructure2;
    }

    public void addTxDataSource(String string, String string2, int n, boolean bl, String string3, String string4, String string5, String string6) {
        TXColumn tXColumn = new TXColumn(string, string2, n, bl, string3, string4, string5, string6);
        tXColumn.setIsTable(true);
        this.m_columnMap.put(tXColumn.getUniqueName(), tXColumn);
    }

    public void addTxDataSource(TXColumn tXColumn) {
        TXColumn tXColumn2 = new TXColumn(tXColumn);
        this.m_columnMap.put(tXColumn2.getUniqueName(), tXColumn2);
    }

    public void addTxDataSourceTable(TXColumn tXColumn, String string) {
        if (tXColumn == null) {
            return;
        }
        TXColumn tXColumn2 = new TXColumn(tXColumn);
        tXColumn2.m_txTableName = string;
        tXColumn2.m_viewDefinition = null;
        tXColumn2.m_isTable = true;
        this.m_columnMap.put(tXColumn2.getUniqueName(), tXColumn2);
    }

    public void addTxDataSourceView(TXColumn tXColumn, String string) {
        TXColumn tXColumn2 = new TXColumn(tXColumn.m_txSchemaName, tXColumn.m_txTableName, tXColumn.m_dataType, tXColumn.m_isSingleMetrics, tXColumn.m_nameColumn, tXColumn.m_txColumnCaseId, tXColumn.m_valueColumn, tXColumn.m_uniqueName);
        tXColumn2.m_txTableName = null;
        tXColumn2.m_viewDefinition = string;
        tXColumn2.m_sqlQuery = new StringBuffer(string);
        tXColumn2.m_isTable = false;
        this.m_columnMap.put(tXColumn2.getUniqueName(), tXColumn2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSQLComplexQueryViewDefinition(String string, String string2) {
        String string3 = null;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            TableColumnsModel tableColumnsModel = new TableColumnsModel(connection, this.m_caseSchema, this.m_caseTable);
            Vector vector = tableColumnsModel.getColumnsByDataType(1, true);
            for (int i = 0; i < vector.size(); ++i) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("caseTable.\"" + vector.get(i) + "\" \n");
            }
            stringBuffer2.append("\"" + DM4JStringUtils.trimDoubleQuotes(this.m_caseSchema) + "\".\"" + DM4JStringUtils.trimDoubleQuotes(this.m_caseTable) + "\" caseTable \n");
            TreeMap treeMap = this.getColumnMap();
            Iterator iterator = treeMap.values().iterator();
            int n = 1;
            while (iterator.hasNext()) {
                TXColumn tXColumn = (TXColumn)iterator.next();
                String string4 = tXColumn.getTxSchemaName();
                String string5 = tXColumn.getTxTableName();
                String string6 = tXColumn.getTxColumnCaseId();
                String string7 = tXColumn.getNameColumn();
                String string8 = tXColumn.getValueColumn();
                String string9 = tXColumn.getUniqueName();
                boolean bl = tXColumn.isNumeric();
                stringBuffer.append(", ");
                stringBuffer.append("txnTable" + n + "." + "\"" + string9 + "\" \n");
                String string10 = "(SELECT \"" + string6 + "\", \n" + "  CAST(COLLECT(" + (bl ? "DM_Nested_Numerical" : "DM_Nested_Categorical") + "(\"" + string7 + "\", \"" + string8 + "\")) " + "    AS " + (bl ? "DM_Nested_Numericals" : "DM_Nested_Categoricals") + ") \"" + string9 + "\" \n" + "FROM \"" + string4 + "\".\"" + string5 + "\" \n" + "GROUP BY \"" + string6 + "\") txnTable" + n;
                stringBuffer2.append(", \n");
                stringBuffer2.append(string10);
                if (stringBuffer3.length() > 0) {
                    stringBuffer3.append(" AND ");
                }
                stringBuffer3.append("caseTable.\"" + this.m_caseId + "\" = txnTable" + n + ".\"" + string6 + "\"(+) \n");
                ++n;
            }
            string3 = "CREATE OR REPLACE VIEW \"" + DM4JStringUtils.trimDoubleQuotes(string) + "\".\"" + DM4JStringUtils.trimDoubleQuotes(string2) + "\" AS SELECT " + stringBuffer + " FROM " + stringBuffer2 + "\n";
            if (stringBuffer3.length() > 0) {
                string3 = string3 + " WHERE " + stringBuffer3;
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
        return string3;
    }

    public static ComplexDataStructure createComplexDataStructure1() {
        String string = "CENSUS_2D_BUILD_UNBINNED";
        String string2 = "PERSON_ID";
        ComplexDataStructure complexDataStructure = new ComplexDataStructure("TestStructure", string, "DMUSER", string2);
        complexDataStructure.addTxDataSource("DMUSER", "CUSTOMER_INVESTMENT", 0, true, "INVESTMNET_ID", "CUST_ID", "QUANTITY", "NAME");
        complexDataStructure.addTxDataSource("DMUSER", "CUSTOMER_ASSETS", 1, true, "ASSET_TYPE", "CUST_ID", "ASSET_DESCRIPTION", "NAME");
        return complexDataStructure;
    }

    public static ComplexDataStructure createComplexDataStructure2() {
        String string = "CENSUS_2D_BUILD_UNBINNED";
        String string2 = "PERSON_ID";
        ComplexDataStructure complexDataStructure = new ComplexDataStructure("TestStructure", string, "DMUSER", string2);
        return complexDataStructure;
    }

    public static ComplexDataStructure createComplexDataStructure3() {
        ComplexDataStructure complexDataStructure = new ComplexDataStructure("TestStructure", null, null, null);
        complexDataStructure.addTxDataSource("DMUSER", "CENSUS_TX_BUILD", 0, false, "ANAME", "SEQ_ID", "VALUE", "NAME");
        return complexDataStructure;
    }

    public static ComplexDataStructure createComplexDataStructure4() {
        ComplexDataStructure complexDataStructure = new ComplexDataStructure("TestStructure", null, null, null);
        complexDataStructure.addTxDataSource("DMUSER", "CENSUS_TX_BUILD", 0, true, "ANAME", "SEQ_ID", "VALUE", "NAME");
        return complexDataStructure;
    }

    public void drop(Connection connection) throws Exception {
        try {
            this.dropTable(connection, this.getCaseSchema(), this.getCaseTable());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Set set = this.m_columnMap.keySet();
        for (Object k : set) {
            TXColumn tXColumn = (TXColumn)this.m_columnMap.get(k);
            try {
                this.dropTable(connection, tXColumn.getTxSchemaName(), tXColumn.getTxTableName());
            }
            catch (Exception exception) {}
        }
    }

    private void dropTable(Connection connection, String string, String string2) throws Exception {
        try {
            DatabaseMetadata.dropView(connection, string, string2);
        }
        catch (Exception exception) {
            DatabaseMetadata.dropTable(connection, string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getARSQLComplexQueryViewDefinition(String string, String string2) {
        String string3 = null;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            TableColumnsModel tableColumnsModel = new TableColumnsModel(connection, this.m_caseSchema, this.m_caseTable);
            Vector vector = tableColumnsModel.getColumnsByDataType(1, true);
            for (int i = 0; i < vector.size(); ++i) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("caseTable.\"" + vector.get(i) + "\"");
            }
            stringBuffer2.append("\"" + DM4JStringUtils.trimDoubleQuotes(this.m_caseSchema) + "\".\"" + DM4JStringUtils.trimDoubleQuotes(this.m_caseTable) + "\" caseTable");
            TreeMap treeMap = this.getColumnMap();
            Iterator iterator = treeMap.values().iterator();
            int n = 1;
            while (iterator.hasNext()) {
                TXColumn tXColumn = (TXColumn)iterator.next();
                String string4 = tXColumn.getTxSchemaName();
                String string5 = tXColumn.getTxTableName();
                String string6 = tXColumn.getTxColumnCaseId();
                String string7 = tXColumn.getNameColumn();
                String string8 = tXColumn.getValueColumn();
                String string9 = tXColumn.getUniqueName();
                boolean bl = tXColumn.isNumeric();
                stringBuffer.append(", ");
                stringBuffer.append("txnTable" + n + "." + "\"" + string9 + "\"");
                String string10 = "(SELECT \"" + string6 + "\", " + "  CAST(COLLECT(" + (bl ? "DM_Nested_Numerical" : "DM_Nested_Categorical") + "(\"" + string7 + "\", \"" + string8 + "\")) " + "    AS " + (bl ? "DM_Nested_Numericals" : "DM_Nested_Categoricals") + ") \"" + string9 + "\" " + "FROM \"" + string4 + "\".\"" + string5 + "\" " + "GROUP BY \"" + string6 + "\") txnTable" + n;
                stringBuffer2.append(", ");
                stringBuffer2.append(string10);
                if (stringBuffer3.length() > 0) {
                    stringBuffer3.append(" AND ");
                }
                stringBuffer3.append("caseTable.\"" + this.m_caseId + "\" = txnTable" + n + ".\"" + string6 + "\"");
                ++n;
            }
            string3 = "CREATE OR REPLACE VIEW \"" + DM4JStringUtils.trimDoubleQuotes(string) + "\".\"" + DM4JStringUtils.trimDoubleQuotes(string2) + "\" AS SELECT " + stringBuffer + " FROM " + stringBuffer2;
            if (stringBuffer3.length() > 0) {
                string3 = string3 + " WHERE " + stringBuffer3;
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
        return string3;
    }
}

