/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.awt.Component;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.dmt.dm4j.ConnectionPersistenceInfo;
import oracle.dmt.dm4j.datasources.CodeGenDBDescriptor;
import oracle.dmt.dm4j.wizard.DM4JWizardHelp;

public abstract class CodeGenDataSource {
    public static final String USER_NAME = "USER_NAME";
    public static final String DRIVER = "DRIVER";
    public static final String CONN_STRING = "CONN_STRING";
    private Hashtable m_htConnections;
    private String m_selConnName;
    protected Hashtable m_selectedActivities = null;
    private final String m_contextConnName;
    protected boolean m_bCancel = false;

    public CodeGenDataSource(Hashtable hashtable, String string) {
        this.m_contextConnName = string;
        this.m_selConnName = string;
        this.m_selectedActivities = hashtable;
    }

    public CodeGenDataSource(Hashtable hashtable) {
        this(null, hashtable);
    }

    public CodeGenDataSource(String string, Hashtable hashtable) {
        this.m_contextConnName = string;
        this.m_selConnName = string;
        this.m_htConnections = hashtable;
    }

    public void registerConnectionHelpTopic(Component component) {
        DM4JWizardHelp.registerTopic(component, "dm4j_xform_codegen_connection_html");
    }

    public void registerActivityHelpTopic(Component component) {
        DM4JWizardHelp.registerTopic(component, "dm4j_xform_codegen_activity_html");
    }

    public void registerPackageDetailsHelpTopic(Component component) {
        DM4JWizardHelp.registerTopic(component, "dm4j_xform_codegen_package_html");
    }

    public void registerResultsHelpTopic(Component component) {
        DM4JWizardHelp.registerTopic(component, "dm4j_xform_codegen_generate_html");
    }

    public boolean isEmptySelectedConnectionName() {
        return this.m_selConnName == null || 0 == this.m_selConnName.length();
    }

    public String getSelectedConnectionName() {
        return this.m_selConnName;
    }

    public String getContextConnName() {
        return this.m_contextConnName;
    }

    public void setSelectedConnectionName(String string) {
        this.m_selConnName = string;
    }

    public ConnectionPersistenceInfo getConnectionInfo(String string) {
        if (this.m_htConnections == null) {
            return null;
        }
        return (ConnectionPersistenceInfo)this.m_htConnections.get(string);
    }

    public Vector getConnectionNames() {
        Vector vector = new Vector();
        if (this.m_htConnections == null || this.m_htConnections.isEmpty()) {
            return vector;
        }
        Enumeration enumeration = this.m_htConnections.keys();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        return vector;
    }

    public boolean isEmpty() {
        if (this.m_htConnections == null) {
            return true;
        }
        return this.m_htConnections.isEmpty();
    }

    public Hashtable getSelectedActivities() {
        return this.m_selectedActivities;
    }

    public abstract void showConnectiionErrorMessage(Exception var1, String var2);

    public abstract CodeGenDBDescriptor getProjectContextSchemas();

    public abstract Hashtable getConnectionDetails(String var1);

    public void setUserCancelled(boolean bl) {
        this.m_bCancel = bl;
    }

    public boolean hasUserCancelled() {
        return this.m_bCancel;
    }
}

