/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.datamining.JDMException;
import javax.datamining.NamedObject;
import javax.datamining.clustering.Cluster;
import javax.datamining.clustering.ClusteringModel;
import javax.datamining.resource.Connection;
import javax.swing.JOptionPane;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.datasources.DM4JDataSource;
import oracle.dmt.dm4j.wizard.director.minings.ClusteringModelApplyBuilder;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;

public class ClusteringClusterNumberSource
extends DM4JDataSource {
    private HashMap m_clusterPredictionColumns = null;
    private Vector m_selectedClusterIds = null;
    protected static final int COLUMN_COUNT = 3;
    public static final int INCLUDE = 0;
    public static final int CLUSTER_ID = 1;
    public static final int CLUSTER_PREDICTION = 2;

    public ClusteringClusterNumberSource(Connection connection, String string) {
        super(connection, string);
    }

    public ClusteringClusterNumberSource(Connection connection, String string, HashMap hashMap, Vector vector) {
        super(connection, string);
        this.m_clusterPredictionColumns = hashMap;
        this.m_selectedClusterIds = vector;
    }

    protected void createData() throws SQLException, JDMException {
        this.createDataFromDB();
    }

    protected void createDataFromDB() throws SQLException, JDMException {
        ClusteringModel clusteringModel = (ClusteringModel)this.m_jdmConn.retrieveObject(this.m_odmObjectName.toUpperCase(), NamedObject.model);
        Collection collection = clusteringModel.getLeafClusters();
        Iterator iterator = collection.iterator();
        int n = 0;
        boolean bl = false;
        if (this.m_clusterPredictionColumns != null && this.m_clusterPredictionColumns.size() > 0) {
            bl = true;
        }
        while (iterator.hasNext()) {
            this.addRows(n, 1);
            Cluster cluster = (Cluster)iterator.next();
            Integer n2 = new Integer(cluster.getClusterId());
            this.setData(1, n, n2);
            String string = null;
            string = bl ? (String)this.m_clusterPredictionColumns.get(n2) : ((Object)n2).toString();
            this.setData(2, n, string);
            boolean bl2 = false;
            if (this.m_selectedClusterIds != null) {
                bl2 = this.m_selectedClusterIds.contains(n2);
            }
            this.setData(0, n, bl2 ? Boolean.TRUE : Boolean.FALSE);
            ++n;
        }
    }

    protected ArrayOneDModel createColumns() throws Exception {
        this.addColumns(0, 3);
        Object[] objectArray = new String[]{ResourceUtilities.getUILabel("DATA_USAGE_INCLUDE"), ResourceUtilities.getUILabel("CLUSTER_ID"), ResourceUtilities.getUILabel("TARGET_PREDICTION_COLUMN")};
        return new ArrayOneDModel(objectArray);
    }

    public int getIncludedCount() {
        int n = 0;
        Boolean bl = new Boolean(false);
        for (int i = 0; i < this.getRowCount(); ++i) {
            bl = (Boolean)this.getData(0, i);
            if (!bl.booleanValue()) continue;
            ++n;
        }
        return n;
    }

    public Vector getIncludedClusterIDs(boolean bl) {
        Vector<Object> vector = new Vector<Object>(this.getRowCount());
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (bl) {
                Boolean bl2 = (Boolean)this.getData(0, i);
                if (!bl2.booleanValue()) continue;
                vector.add(this.getData(1, i));
                continue;
            }
            vector.add(this.getData(1, i));
        }
        return vector;
    }

    public int getAttributeIndex(String string) {
        int n = -1;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!((String)this.getData(2, i)).equals(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    public HashMap getClusterPredictionColumns(boolean bl) {
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            Object object = this.getData(1, i);
            String string = (String)this.getData(2, i);
            if (bl) {
                Boolean bl2 = (Boolean)this.getData(0, i);
                if (!bl2.booleanValue()) continue;
                hashMap.put(object, string);
                continue;
            }
            hashMap.put(object, string);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean validateBaseColumnName(String var1_1) {
        block18: {
            var2_2 = 0;
            var2_2 = Math.max(30 - (new String(ClusteringModelApplyBuilder.CLUSTER_ID_COLUMN_NAME).length() + 1), var2_2);
            var2_2 = Math.max(30 - (new String(ClusteringModelApplyBuilder.DISTANCE_COLUMN_NAME).length() + 1), var2_2);
            var2_2 = Math.max(30 - (new String(ClusteringModelApplyBuilder.FIT_COLUMN_NAME).length() + 1), var2_2);
            var3_3 = null;
            if (var1_1 == null) {
                var4_4 = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
                var5_6 = new Object[]{ResourceUtilities.getUILabel("COLUMN_NAME_ONLY")};
                var3_3 = MessageFormat.format(var4_4, var5_6);
            } else {
                var4_5 = DM4JStringUtils.isDoubleQuotedString(var1_1);
                if (var4_5) {
                    var1_1 = DM4JStringUtils.trimDoubleQuotes(var1_1);
                }
                if (!ValidationUtil.checkStringLength(var1_1, var2_2)) {
                    var5_7 = ResourceUtilities.getstateExceptionMessage("FIELD_LENGTH_EXCEEDED");
                    var6_9 = new Object[]{ResourceUtilities.getUILabel("COLUMN_NAME_ONLY"), Integer.toString(var2_2)};
                    var3_3 = MessageFormat.format(var5_7, var6_9);
                } else {
                    var5_8 = null;
                    try {
                        block17: {
                            var5_8 = DM4JConnectionManager.getDbConnection();
                            if (ValidationUtil.checkStringDBLengthMax(var1_1, var5_8, var2_2)) break block17;
                            var6_10 = ResourceUtilities.getstateExceptionMessage("APPLY_OUTPUT_COLUMN_NAME_MAX_BTYES_EXCEEDED");
                            var7_12 = new Object[]{Integer.toString(var2_2)};
                            var3_3 = MessageFormat.format(var6_10, var7_12);
                        }
                        var9_13 = null;
                        ** if (var5_8 == null) goto lbl-1000
                    }
                    catch (Throwable var8_19) {
                        var9_15 = null;
                        if (var5_8 != null) {
                            try {
                                var5_8.close();
                            }
                            catch (Exception var10_18) {
                                // empty catch block
                            }
                        }
                        throw var8_19;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            var5_8.close();
                        }
                        catch (Exception var10_16) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block18;
                        catch (Exception var6_11) {
                            var9_14 = null;
                            if (var5_8 != null) {
                                try {
                                    var5_8.close();
                                }
                                catch (Exception var10_17) {}
                            }
                        }
                    }
                }
            }
        }
        if (var3_3 != null) {
            JOptionPane.showOptionDialog(BrowserFrame.getMainFrame(), var3_3, DM4JVersion.getFullBrowserName(), -1, 0, null, null, null);
            return false;
        }
        return true;
    }

    public String setClusterPredictionAtIndex(int n, String string) {
        int n2 = this.getAttributeIndex(string);
        if (n2 >= 0 && n >= 0 && n != n2) {
            String string2 = ResourceUtilities.getstateExceptionMessage("OUTPUT_COLUMN_DUPLICATE_NAME");
            JOptionPane.showOptionDialog(BrowserFrame.getMainFrame(), string2, DM4JVersion.getFullBrowserName(), -1, 0, null, null, null);
            String string3 = (String)this.getData(2, n);
            return string3;
        }
        if (!this.validateBaseColumnName(string)) {
            String string4 = (String)this.getData(2, n);
            return string4;
        }
        return string;
    }
}

