/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.dmt.dm4j.datasources.DBDataSource;

public class CaseCountDataSource
extends DBDataSource {
    private static final int COLUMN_COUNT = 1;
    private static final String CASE_COUNT_COLUMN_NAME = "Case count";
    public static final int CASE_COUNT = 0;
    protected int m_caseCount = -1;
    protected String m_schemaName;
    protected String m_tableName;
    private String m_sequenceIdColumn;
    protected boolean m_isTransactional = false;

    public CaseCountDataSource(Connection connection, String string, String string2) {
        super(connection);
        this.m_schemaName = string;
        this.m_tableName = string2;
    }

    public CaseCountDataSource(Connection connection, String string, String string2, String string3) {
        this(connection, string, string2);
        this.m_sequenceIdColumn = string3;
        this.m_isTransactional = true;
    }

    public int getCaseCount() {
        return this.m_caseCount;
    }

    protected void createData() throws SQLException {
        if (this.m_isTransactional) {
            this.countCasesFromTransactionalDBTable();
        } else {
            this.countCasesFrom2DDBTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void countCasesFrom2DDBTable() throws SQLException {
        ResultSet resultSet;
        block5: {
            String string = "select COUNT(*) from \"" + this.m_schemaName + "\".\"" + this.m_tableName + "\"";
            CallableStatement callableStatement = null;
            resultSet = null;
            try {
                callableStatement = this.m_conn.prepareCall(string);
                this.m_statement = callableStatement;
                resultSet = callableStatement.executeQuery();
                resultSet.next();
                this.m_caseCount = resultSet.getInt(1);
                this.addRows(0, 1);
                this.setData(0, 0, new Integer(this.m_caseCount));
                Object var5_4 = null;
                if (callableStatement == null) break block5;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (callableStatement != null) {
                    callableStatement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                throw throwable;
            }
            callableStatement.close();
        }
        if (resultSet != null) {
            resultSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void countCasesFromTransactionalDBTable() throws SQLException {
        ResultSet resultSet;
        block5: {
            String string = "select COUNT(DISTINCT (\"" + this.m_sequenceIdColumn + "\")) " + "from \"" + this.m_schemaName + "\".\"" + this.m_tableName + "\"";
            CallableStatement callableStatement = null;
            resultSet = null;
            try {
                callableStatement = this.m_conn.prepareCall(string);
                this.m_statement = callableStatement;
                resultSet = callableStatement.executeQuery();
                resultSet.next();
                this.m_caseCount = resultSet.getInt(1);
                this.addRows(0, 1);
                this.setData(0, 0, new Integer(this.m_caseCount));
                callableStatement.close();
                Object var5_4 = null;
                if (callableStatement == null) break block5;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (callableStatement != null) {
                    callableStatement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                throw throwable;
            }
            callableStatement.close();
        }
        if (resultSet != null) {
            resultSet.close();
        }
    }

    protected ArrayOneDModel createColumns() throws Exception {
        this.addColumns(0, 1);
        Object[] objectArray = new String[]{CASE_COUNT_COLUMN_NAME};
        return new ArrayOneDModel(objectArray);
    }
}

