/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.datasources.CDSDataSource;
import oracle.dmt.dm4j.datasources.CDSLDSDataSource;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.datasources.DiscretizationLDSDataSource;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.dm4j.datasources.OutlierDiscretizeDataSource;
import oracle.dmt.dm4j.datasources.TXColumn;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.odm.binning.DM4JTransformation;

public class CDSOutlierDiscretizeDataSource
extends OutlierDiscretizeDataSource {
    public CDSOutlierDiscretizeDataSource(Connection connection, DiscretizationLDSDataSource discretizationLDSDataSource, String string, String string2, String string3, boolean bl) throws Exception {
        this(connection, discretizationLDSDataSource, string, string2, string3);
        this.m_bAutoRun = bl;
    }

    public CDSOutlierDiscretizeDataSource(Connection connection, DiscretizationLDSDataSource discretizationLDSDataSource, String string, String string2, String string3) throws Exception {
        super(connection);
        this.m_preferences = UserPreferences.getInstance();
        this.setLabels(false);
        this.m_lds = discretizationLDSDataSource;
        if (discretizationLDSDataSource instanceof CDSLDSDataSource) {
            this.m_sampledInputCDS = ((CDSLDSDataSource)discretizationLDSDataSource).getSampledDataStructure();
            this.m_origInputCDS = ((CDSLDSDataSource)discretizationLDSDataSource).getOriginalDataStructure();
        }
        this.m_userSchemaName = string;
        if (string2 == null) {
            this.m_resultViewName = ValidationUtil.createUniqueTableName(RESULT_VIEW_NAME, connection, "");
            this.m_bRemoveResultView = true;
        } else {
            this.m_resultViewName = string2;
        }
        if (string3 == null) {
            this.m_originalResultViewName = ValidationUtil.createUniqueTableName(RESULT_VIEW_NAME, connection, "");
            this.m_bRemoveResultView = true;
        } else {
            this.m_originalResultViewName = string3;
        }
        String string4 = this.m_sampledInputCDS.getCaseTable();
        String string5 = this.m_sampledInputCDS.getCaseSchema();
        if (string4 != null && string4.length() != 0) {
            this.m_sDataLocation = string5 != null && string5.length() != 0 ? "\"" + string5 + "\".\"" + string4 + "\"" : "\"" + string4 + "\"";
            this.getSampledDataLocation();
        } else if (!this.m_sampledInputCDS.isSingleMetric()) {
            this.m_sDataLocation = this.m_sampledInputCDS.getDataLocation();
            this.m_samplingTableName = ValidationUtil.createUniqueTableName(SAMPLING_TABLE_PREFIX, connection, "");
            this.m_attributeMapping = this.m_sampledInputCDS.getAttributeNameColumn();
            this.m_valueMapping = this.m_sampledInputCDS.getValueColumn();
            this.m_seqIdMapping = this.m_sampledInputCDS.getCaseIdColumn();
            this.m_isTransactional = true;
            this.m_numericalDiscretizationTableName = ValidationUtil.createUniqueTableName(NUMERIC_BIN_TABLE_PREFIX, connection, "");
            this.m_categoricalDiscretizationTableName = ValidationUtil.createUniqueTableName(CATEGORIC_BIN_TABLE_PREFIX, connection, "");
            DM4JTransformation.createPhysicalTables(connection, this.m_numericalDiscretizationTableName, this.m_categoricalDiscretizationTableName, this.m_userSchemaName);
            this.m_sampledInternallySampledCDS = new ComplexDataStructure(this.m_sampledInputCDS.getName() + "_SAMPLED", null, null, null);
            TXColumn tXColumn = this.m_sampledInputCDS.getTXColumn();
            this.m_sampledInternallySampledCDS.addTxDataSource(tXColumn);
            this.m_txSampledViewDefinition = this.createTXViewDefinition(this.m_sampledInternallySampledCDS.getDataLocation(), this.m_userSchemaName, this.m_resultViewName);
            this.m_txViewDefinition = this.createTXViewDefinition(this.m_sDataLocation, this.m_userSchemaName, this.m_resultViewName);
        } else {
            this.getSampledDataLocation();
        }
    }

    protected void createData() throws Exception {
        this.m_helper.createData();
    }

    public String getSampledDataLocation() {
        if (this.m_sampledInputCDS == null) {
            return null;
        }
        if (this.m_helper == null) {
            this.m_helper = new CDSDataSource(this, this.m_collectColumnNames);
        }
        return this.m_helper.getSamplingViewDefinition();
    }

    protected Object getOutlierViewDefinition2D(String string) {
        StringBuffer stringBuffer;
        block5: {
            stringBuffer = null;
            try {
                if (this.m_sampledInputCDS != null && null == this.m_sampledInputCDS.getCaseTable() && this.m_sampledInputCDS.isSingleMetric()) {
                    int n = this.m_tableColumns.size();
                    for (int i = 0; i < n; ++i) {
                        String string2 = (String)this.m_tableColumns.elementAt(i);
                        String string3 = this.m_lds.getComplexAttributeInfo(string2);
                        if (string3 == null) continue;
                        int n2 = this.getAttributeRow(string2);
                        if (n2 != -1) {
                            stringBuffer = this.getViewDefinition(n2);
                        }
                        break block5;
                    }
                    break block5;
                }
                StringBuffer stringBuffer2 = (StringBuffer)super.getOutlierViewDefinition2D(null);
                StringBuffer stringBuffer3 = new StringBuffer("CREATE VIEW " + string + "\n");
                stringBuffer3.append(stringBuffer2);
                stringBuffer3.append(this.getOriginalDataLocation());
                StringBuffer stringBuffer4 = new StringBuffer("CREATE VIEW ");
                ComplexDataStructure complexDataStructure = this.getOriginalOutputCDS();
                stringBuffer4.append(DM4JStringUtils.isDoubleQuotedString(complexDataStructure.getCaseSchema()) ? complexDataStructure.getCaseSchema() : DM4JStringUtils.addDoubleQuotes(complexDataStructure.getCaseSchema()));
                stringBuffer4.append(".");
                stringBuffer4.append(DM4JStringUtils.isDoubleQuotedString(complexDataStructure.getCaseTable()) ? complexDataStructure.getCaseTable() : DM4JStringUtils.addDoubleQuotes(complexDataStructure.getCaseTable()));
                stringBuffer4.append("\n");
                stringBuffer4.append(stringBuffer2);
                ComplexDataStructure complexDataStructure2 = this.getOriginalInputCDS();
                stringBuffer4.append(DM4JStringUtils.isDoubleQuotedString(complexDataStructure2.getCaseSchema()) ? complexDataStructure2.getCaseSchema() : DM4JStringUtils.addDoubleQuotes(complexDataStructure2.getCaseSchema()));
                stringBuffer4.append(".");
                stringBuffer4.append(DM4JStringUtils.isDoubleQuotedString(complexDataStructure2.getCaseTable()) ? complexDataStructure2.getCaseTable() : DM4JStringUtils.addDoubleQuotes(complexDataStructure2.getCaseTable()));
                this.getSampledOutputCDS().setSQLCaseQuery(stringBuffer3);
                this.getOriginalOutputCDS().setSQLCaseQuery(stringBuffer4);
                return this;
            }
            catch (Exception exception) {
                stringBuffer = new StringBuffer();
            }
        }
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addNumericStatsComplexData(Vector vector) {
        if (vector == null || vector.isEmpty()) {
            return;
        }
        Connection connection = null;
        Vector<String> vector2 = new Vector<String>();
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        Vector<String> vector3 = new Vector<String>();
        Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
        connection = DM4JConnectionManager.getDbConnection();
        int n = -1;
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            String string2 = this.m_lds.getComplexAttributeInfo(string);
            n = this.getAttributeRow(string);
            if (string2 == null) {
                vector2.add(string);
                hashtable.put(string, new Integer(n));
                continue;
            }
            vector3.add(string);
            hashtable2.put(string, new Integer(n));
        }
        super.addNumericStats2D(connection, vector2, hashtable, null);
        this.m_helper.addComplexStatsNum(connection, vector3, hashtable2);
        Object var12_12 = null;
        hashtable.clear();
        vector2.clear();
        vector3.clear();
        hashtable2.clear();
        if (connection == null) return;
        try {
            connection.close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return;
        {
            catch (Exception exception) {
                if (CDSOutlierDiscretizeDataSource.isDebug()) {
                    exception.printStackTrace();
                }
                Object var12_13 = null;
                hashtable.clear();
                vector2.clear();
                vector3.clear();
                hashtable2.clear();
                if (connection == null) return;
                try {
                    connection.close();
                    return;
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            hashtable.clear();
            vector2.clear();
            vector3.clear();
            hashtable2.clear();
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void setOutlierPercent2D(Connection connection, int n, String string, double d, double d2, boolean bl) {
        block12: {
            ResultSet resultSet;
            Statement statement;
            block11: {
                String string2 = this.m_lds.getComplexAttributeInfo(string);
                if (string2 == null) {
                    super.setOutlierPercent2D(connection, n, string, d, d2, bl);
                    return;
                }
                TXColumn tXColumn = this.m_sampledInternallySampledCDS.getTXColumn(string2);
                if (tXColumn == null) {
                    return;
                }
                Object[] objectArray = new Object[]{"\"" + tXColumn.getValueColumn() + "\"", tXColumn.getDataLocation(), DM4JNumericFormat.SQLFormat(d), DM4JNumericFormat.SQLFormat(d2)};
                StringBuffer stringBuffer = new StringBuffer(STAT_SQL_OUTLIER_PERCENT_2D[0]);
                String string3 = MessageFormat.format(STAT_SQL_OUTLIER_PERCENT_2D[1], objectArray);
                stringBuffer.append(string3);
                statement = null;
                resultSet = null;
                statement = connection.createStatement();
                resultSet = statement.executeQuery(stringBuffer.toString());
                if (!resultSet.next()) break block11;
                double d3 = resultSet.getDouble("Average");
                double d4 = resultSet.getDouble("Max");
                double d5 = resultSet.getDouble("Min");
                double d6 = resultSet.getDouble("Variance");
                this.setAverage(n, d3);
                this.setMin(n, d5);
                this.setMax(n, d4);
                this.setVariance(n, Math.sqrt(d6));
                StringBuffer stringBuffer2 = new StringBuffer((bl ? "(" : "[") + String.valueOf(d) + "%, ");
                stringBuffer2.append(" ");
                stringBuffer2.append(String.valueOf(d2) + "%" + (bl ? ")" : "]"));
                this.setCutoffRange(this.getAttributeRow(string), stringBuffer2.toString(), d5, d4, d, d2, bl);
            }
            Object var26_20 = null;
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break block12;
            {
                catch (Exception exception) {
                    if (CDSOutlierDiscretizeDataSource.isDebug()) {
                        exception.printStackTrace();
                    }
                    Object var26_21 = null;
                    try {
                        resultSet.close();
                        statement.close();
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var26_22 = null;
                try {
                    resultSet.close();
                    statement.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    protected void getQtileStats(Connection connection, Vector vector, Hashtable hashtable, String string, int n) {
        this.m_helper.quantileBinning2D(connection, vector, hashtable, string, n);
    }

    public int[] getNumericFrequency(Connection connection, String string, int n, boolean bl) {
        if (!this.isNumeric(n)) {
            return this.getCategoricAttributeFrequency(connection, n, string, this.getSampledDataLocation());
        }
        String string2 = (String)this.getData(DiscretizeDataSource.COLUMN_NAMES.COMPLEX_ATTRIBUTE, n);
        if (string2 == null) {
            return super.getNumericFrequency(connection, string, n, bl);
        }
        return this.m_helper.getNumericFrequency(connection, string, n, bl);
    }

    public StringBuffer getSingleNumericAttributeViewDefinition(Connection connection, int n, boolean bl) {
        return this.m_helper.getSingleNumericAttributeViewDefinition(connection, n, bl);
    }

    protected void processNumTxSource(String string, String string2, String string3, Object object, Hashtable hashtable) throws Exception {
        this.m_helper.processNumTxSource(string, string2, string3, object, hashtable);
    }

    public void getEqualWidth2ndorderStats(Connection connection, int n, double[] dArray, String string, String string2) {
        String string3 = (String)this.getData(DiscretizeDataSource.COLUMN_NAMES.COMPLEX_ATTRIBUTE, n);
        if (string3 == null) {
            super.getEqualWidth2ndorderStats(connection, n, dArray, string, string2);
            return;
        }
        this.m_helper.getEqualWidth2ndorderStats(connection, n, dArray, string, string2);
    }
}

