/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.GLMRegressionActivity;
import oracle.dmt.dm4j.activity.GLMRegressionApplyActivity;
import oracle.dmt.dm4j.activity.SVMRegressionActivity;
import oracle.dmt.dm4j.activity.SVMRegressionApplyActivity;
import oracle.dmt.dm4j.activity.data.Column;
import oracle.dmt.dm4j.activity.data.Mapping;
import oracle.dmt.dm4j.activity.data.Table;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.dm4j.datasources.NormalizeDataSource;
import oracle.dmt.dm4j.datasources.TXColumn;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;

public class CDSNormalizeDataSource
extends NormalizeDataSource {
    private Hashtable m_excludedAttributes;
    private String m_sampledResultView;
    private String m_originalResultView;

    public CDSNormalizeDataSource(Connection connection, AbstractActivity abstractActivity, ComplexDataStructure complexDataStructure, ComplexDataStructure complexDataStructure2, String string, String string2) {
        block2: {
            super(connection, abstractActivity, complexDataStructure.getCaseSchema(), complexDataStructure.getCaseTable());
            this.m_excludedAttributes = new Hashtable();
            this.m_sampledInputCDS = complexDataStructure;
            this.m_originalInputCDS = complexDataStructure2;
            this.m_sampledResultView = string;
            this.m_originalResultView = string2;
            this.initExcludedAttributes();
            try {
                this.createOutputCDS(connection);
            }
            catch (Exception exception) {
                if (!DiscretizeDataSource.isDebug()) break block2;
                System.out.println(exception);
            }
        }
    }

    private void createOutputCDS(Connection connection) {
        block7: {
            try {
                if (this.m_sampledResultView == null) {
                    this.m_sampledResultView = ValidationUtil.createUniqueTableName("DM4J$T", connection, "_S");
                }
                this.m_sampledOutputCDS = ComplexDataStructure.createOutputComplexDataStructure(this.m_sampledInputCDS.getName() + "_RESULT", this.m_sampledInputCDS, this.m_sampledResultView);
                if (this.m_originalResultView == null) {
                    this.m_originalResultView = ValidationUtil.createUniqueTableName("DM4J$T", connection, "");
                }
                if (this.m_originalInputCDS != null) {
                    try {
                        this.m_originalOutputCDS = new ComplexDataStructure(this.m_originalInputCDS.getName() + "ORIGINAL_RESULT", this.m_originalResultView, this.m_sampledOutputCDS.getCaseSchema(), this.m_sampledOutputCDS.getCaseId());
                        this.m_originalOutputCDS.setColumnMap(this.m_sampledOutputCDS.getColumnMap());
                    }
                    catch (Exception exception) {
                        this.m_originalOutputCDS = null;
                        exception.printStackTrace();
                    }
                }
            }
            catch (Exception exception) {
                if (!DiscretizeDataSource.isDebug()) break block7;
                System.out.println(exception);
            }
        }
    }

    private void initExcludedAttributes() {
        String string;
        Column column;
        if (this.m_activity == null) {
            return;
        }
        if (!(this.m_activity instanceof SVMRegressionActivity || this.m_activity instanceof SVMRegressionApplyActivity || this.m_activity instanceof GLMRegressionActivity || this.m_activity instanceof GLMRegressionApplyActivity || (column = this.m_activity.getTargetColumn()) == null)) {
            string = column.getAlias();
            this.m_excludedAttributes.put(string, "TARGET");
        }
        if ((column = this.m_activity.getCaseColumn()) != null) {
            string = column.getAlias();
            this.m_excludedAttributes.put(string, "CASEID");
        }
    }

    protected boolean isExcluded(String string) {
        return null != this.m_excludedAttributes.get(string);
    }

    protected LinkedHashMap get2DColumns() {
        Table table = this.m_activity.getTwodDataSource();
        return table.getColumns();
    }

    protected void createDataFrom2DDBTable() throws SQLException {
        super.createDataFrom2DDBTable();
        TreeMap treeMap = this.m_sampledInputCDS.getColumnMap();
        if (treeMap == null || treeMap.isEmpty()) {
            return;
        }
        Set set = treeMap.keySet();
        for (String string : set) {
            TXColumn tXColumn = (TXColumn)treeMap.get(string);
            if (tXColumn == null || !tXColumn.getIsSingleMetrics()) continue;
            try {
                String string2 = tXColumn.getUniqueName();
                if (tXColumn.isNumeric()) {
                    this.processSingleMetricTxData(tXColumn, string2);
                    continue;
                }
                this.processSingleMetricTxCatData(string, tXColumn.getUniqueName());
            }
            catch (Exception exception) {
                if (!DiscretizeDataSource.isDebug()) continue;
                System.out.println(exception);
            }
        }
    }

    private boolean isSparseColumn(String string) {
        boolean bl = false;
        LinkedHashSet linkedHashSet = this.m_activity.getTables();
        for (Table table : linkedHashSet) {
            Mapping mapping;
            ArrayList arrayList = table.getTxnMappings();
            if (arrayList == null || arrayList.size() <= 0 || (mapping = (Mapping)arrayList.get(0)).getAlias().compareTo(string) != 0) continue;
            bl = mapping.getIsSparse();
            break;
        }
        return bl;
    }

    private void processSingleMetricTxCatData(String string, String string2) {
        this.m_unusedComplexAttrs.put(string, string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processSingleMetricTxData(TXColumn tXColumn, String string) throws SQLException, Exception {
        String string2 = "SELECT  ROUND((SUM(power(a,3))/GREATEST(((count(\"" + tXColumn.getValueColumn() + "\")-1)*power(stddev(\"" + tXColumn.getValueColumn() + "\"),3)),0.001)), 2) skewness,  " + "ROUND((SUM(power(a,4))/GREATEST(((count(\"" + tXColumn.getValueColumn() + "\")-1)*power(stddev(\"" + tXColumn.getValueColumn() + "\"),4)),0.001)-3), 2) kurtosis,  " + "ROUND(AVG(\"" + tXColumn.getValueColumn() + "\"), 2) mean, ROUND(STDDEV(\"" + tXColumn.getValueColumn() + "\"), 2) std,  " + "ROUND(MIN(\"" + tXColumn.getValueColumn() + "\"), 2) min,  " + "ROUND(MAX(\"" + tXColumn.getValueColumn() + "\"), 2) max      " + "FROM ( " + "SELECT \"" + tXColumn.getValueColumn() + "\", (\"" + tXColumn.getValueColumn() + "\"-(AVG(\"" + tXColumn.getValueColumn() + "\") OVER())) a  " + "      FROM " + tXColumn.getDataLocation() + ")";
        StringBuffer stringBuffer = new StringBuffer(1000);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            try {
                stringBuffer.append(string2);
                statement = this.m_conn.createStatement();
                resultSet = statement.executeQuery(stringBuffer.toString());
                int n = 0;
                while (resultSet.next()) {
                    this.addRows(n, 1);
                    String string3 = resultSet.getString("skewness");
                    String string4 = resultSet.getString("kurtosis");
                    String string5 = resultSet.getString("mean");
                    String string6 = resultSet.getString("std");
                    String string7 = resultSet.getString("min");
                    String string8 = resultSet.getString("max");
                    this.setData(0, n, tXColumn.getUniqueName());
                    if (string3 != null) {
                        this.setData(1, n, new Float(string3.trim()));
                        this.setData(8, n, new Float(string3.trim()));
                    }
                    if (string4 != null) {
                        this.setData(2, n, new Float(string4.trim()));
                        this.setData(9, n, new Float(string4.trim()));
                    }
                    if (string5 != null) {
                        this.setData(3, n, new Float(string5.trim()));
                        this.setData(10, n, new Float(string5.trim()));
                    }
                    if (string6 != null) {
                        this.setData(4, n, new Float(string6.trim()));
                        this.setData(11, n, new Float(string6.trim()));
                    }
                    if (string7 != null) {
                        this.setData(5, n, new Float(string7.trim()));
                        this.setData(12, n, new Float(string7.trim()));
                    }
                    if (string8 != null) {
                        this.setData(6, n, new Float(string8.trim()));
                        this.setData(13, n, new Float(string8.trim()));
                    }
                    this.setComplexAttribute(n, string);
                    this.setSparsityAttribute(n, new Boolean(this.isSparseColumn(string)));
                    ++n;
                }
                Object var15_15 = null;
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                throw sQLException;
            }
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            try {
                resultSet.close();
                statement.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        resultSet.close();
        statement.close();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Vector getDistinctValues(String string) {
        Vector<String> vector;
        block9: {
            TXColumn tXColumn = this.m_sampledInputCDS.getTXColumn(string);
            String string2 = "SELECT DISTINCT \"" + tXColumn.getNameColumn() + "\" FROM " + tXColumn.getDataLocation();
            vector = new Vector<String>();
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            connection = DM4JConnectionManager.getDbConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                String string3 = resultSet.getString(1);
                vector.add(string3);
            }
            Object var10_10 = null;
            try {
                resultSet.close();
                statement.close();
                connection.close();
            }
            catch (Exception exception) {}
            break block9;
            {
                catch (Exception exception) {
                    System.out.println(exception);
                    Object var10_11 = null;
                    try {
                        resultSet.close();
                        statement.close();
                        connection.close();
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    resultSet.close();
                    statement.close();
                    connection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return vector;
    }
}

