/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.Connection;
import java.util.Hashtable;
import java.util.Vector;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.datasources.CDSDataSource;
import oracle.dmt.dm4j.datasources.CDSLDSDataSource;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.datasources.DiscretizationLDSDataSource;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.dm4j.datasources.MissingValuesDataSource;
import oracle.dmt.dm4j.datasources.TXColumn;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.odm.binning.DM4JTransformation;

public class CDSMissingValuesDataSource
extends MissingValuesDataSource {
    protected CDSMissingValuesDataSource(Connection connection) throws Exception {
        super(connection);
    }

    public CDSMissingValuesDataSource(Connection connection, DiscretizationLDSDataSource discretizationLDSDataSource, String string, String string2, String string3, boolean bl) throws Exception {
        this(connection, discretizationLDSDataSource, string, string2, string3);
        this.m_autoRun = bl;
    }

    public CDSMissingValuesDataSource(Connection connection, DiscretizationLDSDataSource discretizationLDSDataSource, String string, String string2, String string3) throws Exception {
        super(connection);
        this.m_preferences = UserPreferences.getInstance();
        this.setLabels(false);
        this.m_lds = discretizationLDSDataSource;
        if (discretizationLDSDataSource instanceof CDSLDSDataSource) {
            this.m_sampledInputCDS = ((CDSLDSDataSource)discretizationLDSDataSource).getSampledDataStructure();
            this.m_origInputCDS = ((CDSLDSDataSource)discretizationLDSDataSource).getOriginalDataStructure();
        }
        this.m_userSchemaName = string;
        if (string2 == null) {
            this.m_resultViewName = ValidationUtil.createUniqueTableName(RESULT_VIEW_NAME, connection, "");
            this.m_bRemoveResultView = true;
        } else {
            this.m_resultViewName = string2;
        }
        if (string3 == null) {
            this.m_originalResultViewName = ValidationUtil.createUniqueTableName(RESULT_VIEW_NAME, connection, "");
            this.m_bRemoveResultView = true;
        } else {
            this.m_originalResultViewName = string3;
        }
        String string4 = this.m_sampledInputCDS.getCaseTable();
        String string5 = this.m_sampledInputCDS.getCaseSchema();
        if (string4 != null && string4.length() != 0) {
            this.m_sDataLocation = string5 != null && string5.length() != 0 ? "\"" + string5 + "\".\"" + string4 + "\"" : "\"" + string4 + "\"";
            this.getSampledDataLocation();
        } else if (!this.m_sampledInputCDS.isSingleMetric()) {
            this.m_sDataLocation = this.m_sampledInputCDS.getDataLocation();
            this.m_samplingTableName = ValidationUtil.createUniqueTableName(SAMPLING_TABLE_PREFIX, connection, "");
            this.m_attributeMapping = this.m_sampledInputCDS.getAttributeNameColumn();
            this.m_valueMapping = this.m_sampledInputCDS.getValueColumn();
            this.m_seqIdMapping = this.m_sampledInputCDS.getCaseIdColumn();
            this.m_isTransactional = true;
            this.m_numericalDiscretizationTableName = ValidationUtil.createUniqueTableName(NUMERIC_BIN_TABLE_PREFIX, connection, "");
            this.m_categoricalDiscretizationTableName = ValidationUtil.createUniqueTableName(CATEGORIC_BIN_TABLE_PREFIX, connection, "");
            DM4JTransformation.createPhysicalTables(connection, this.m_numericalDiscretizationTableName, this.m_categoricalDiscretizationTableName, this.m_userSchemaName);
            this.m_sampledInternallySampledCDS = new ComplexDataStructure(this.m_sampledInputCDS.getName() + "_SAMPLED", null, null, null);
            TXColumn tXColumn = this.m_sampledInputCDS.getTXColumn();
            this.m_sampledInternallySampledCDS.addTxDataSource(tXColumn);
            this.m_txSampledViewDefinition = this.createTXViewDefinition(this.m_sampledInternallySampledCDS.getDataLocation(), this.m_userSchemaName, this.m_resultViewName);
            this.m_txViewDefinition = this.createTXViewDefinition(this.m_sDataLocation, this.m_userSchemaName, this.m_resultViewName);
        } else {
            this.getSampledDataLocation();
        }
    }

    public CDSMissingValuesDataSource(Connection connection, DiscretizationLDSDataSource discretizationLDSDataSource, String string, String string2, String string3, String string4, String string5, String string6, String string7) throws Exception {
        super(connection, discretizationLDSDataSource, string, string2, string3, string4, string5, string6, string7, false);
    }

    public String getSampledDataLocation() {
        if (this.m_sampledInputCDS == null) {
            return null;
        }
        if (this.m_helper == null) {
            this.m_helper = new CDSDataSource(this, this.m_collectColumnNames);
        }
        return this.m_helper.getSamplingViewDefinition();
    }

    protected void createData() throws Exception {
        this.m_helper.createData();
        this.m_helper.intSparseAttributes();
    }

    protected void getQtileStats(Connection connection, Vector vector, Hashtable hashtable, String string, int n) {
        this.m_helper.quantileBinning2D(connection, vector, hashtable, string, n);
    }

    public int[] getNumericFrequency(Connection connection, String string, int n, boolean bl) {
        if (!this.isNumeric(n)) {
            return this.getCategoricAttributeFrequency(connection, n, string, this.getSampledDataLocation());
        }
        String string2 = (String)this.getData(DiscretizeDataSource.COLUMN_NAMES.COMPLEX_ATTRIBUTE, n);
        if (string2 == null) {
            return super.getNumericFrequency(connection, string, n, bl);
        }
        return this.m_helper.getNumericFrequency(connection, string, n, bl);
    }

    protected void processNumTxSource(String string, String string2, String string3, Object object, Hashtable hashtable) throws Exception {
        this.m_helper.processNumTxSource(string, string2, string3, object, hashtable);
    }

    public void getEqualWidth2ndorderStats(Connection connection, int n, double[] dArray, String string, String string2) {
        String string3 = (String)this.getData(DiscretizeDataSource.COLUMN_NAMES.COMPLEX_ATTRIBUTE, n);
        if (string3 == null) {
            super.getEqualWidth2ndorderStats(connection, n, dArray, string, string2);
            return;
        }
        this.m_helper.getEqualWidth2ndorderStats(connection, n, dArray, string, string2);
    }
}

