/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.dmt.dm4j.datasources.DBDataSource;
import oracle.dmt.dm4j.wizard.director.transforms.TransformsDirector;

public class AttrValueCountDataSource
extends DBDataSource {
    private static final int COLUMN_COUNT = 1;
    private static final String ATTR_VALUE_COUNT_COLUMN_NAME = "Attribute Value count";
    public static final int VALUE_COUNT = 0;
    private ArrayList[] m_values = new ArrayList[10];
    private String m_tableFullName;
    private String m_attrName;
    private long m_totalCount;
    private long m_samplePercentageOfCases;
    private double m_samplePercentage;
    private boolean m_isAttrValNumber = false;
    private String m_sequenceIdColumn;
    private String m_attrNameColumn;
    private String m_attrValColumn;
    private boolean m_isTransactional = false;
    private boolean m_bSingleMetric = false;

    public long getSamplePercentageOfCases() {
        return this.m_samplePercentageOfCases;
    }

    public void setSingleMetric() {
        this.m_bSingleMetric = true;
    }

    public AttrValueCountDataSource(Connection connection, String string, String string2, String string3, long l, double d, long l2) {
        super(connection);
        this.m_tableFullName = string == null ? "\"" + string2 + "\"" : "\"" + string + "\"" + "." + "\"" + string2 + "\"";
        this.m_attrName = string3;
        this.m_totalCount = l;
        this.m_samplePercentage = d;
        this.m_samplePercentageOfCases = l2;
        this.m_values[0] = new ArrayList();
        this.m_values[1] = new ArrayList();
        this.m_values[2] = new ArrayList();
        this.m_values[3] = new ArrayList();
        this.m_values[4] = new ArrayList();
        this.m_values[5] = new ArrayList();
        this.m_values[6] = new ArrayList();
        this.m_values[7] = new ArrayList();
        this.m_values[8] = new ArrayList();
        this.m_values[9] = new ArrayList();
    }

    public AttrValueCountDataSource(Connection connection, String string, String string2, String string3, long l, double d, long l2, String string4, String string5, String string6) {
        this(connection, string, string2, string3, l, d, l2);
        this.m_sequenceIdColumn = string4;
        this.m_attrNameColumn = string5;
        this.m_attrValColumn = string6;
        this.m_isTransactional = true;
    }

    public ArrayList[] getAttributeValueCounts() {
        return this.m_values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createData() throws SQLException, Exception {
        ResultSet resultSet;
        block17: {
            Object[] objectArray;
            String string = null;
            if (this.m_isTransactional) {
                if (!this.m_bSingleMetric) {
                    objectArray = new String[]{this.m_attrName, "" + this.m_totalCount, "" + this.m_samplePercentage, this.m_tableFullName, TransformsDirector.getReplacedString(this.m_attrNameColumn, "'", "''"), TransformsDirector.getReplacedString(this.m_attrValColumn, "'", "''")};
                    string = MessageFormat.format("SELECT /*+ noparallel(t)*/ {5}, count(*), ROUND(count(*)*100/{1}), {2}*count(*)/100 FROM {3} t WHERE {4}=''{0}'' GROUP BY {5}", objectArray);
                } else {
                    objectArray = new String[]{"\"" + TransformsDirector.getReplacedString(this.m_attrValColumn, "'", "''") + "\"", "" + this.m_totalCount, "" + this.m_samplePercentage, this.m_tableFullName};
                    string = MessageFormat.format("SELECT /*+ noparallel(t)*/ {0}, count(*), count(*)*100/{1}, {2}*count(*)/100 FROM {3} t WHERE {0} IS NOT NULL GROUP BY {0}", objectArray);
                }
            } else {
                objectArray = new String[]{"\"" + this.m_attrName + "\"", "" + this.m_totalCount, "" + this.m_samplePercentage, this.m_tableFullName};
                string = MessageFormat.format("SELECT /*+ noparallel(t)*/ {0}, count(*), count(*)*100/{1}, {2}*count(*)/100 FROM {3} t WHERE {0} IS NOT NULL GROUP BY {0}", objectArray);
            }
            long l = 0L;
            CallableStatement callableStatement = null;
            resultSet = null;
            try {
                callableStatement = this.m_conn.prepareCall(string);
                this.m_statement = callableStatement;
                resultSet = callableStatement.executeQuery();
                boolean bl = false;
                while (resultSet.next()) {
                    Object object = resultSet.getObject(1);
                    if (object == null) {
                        this.m_values[0].add(null);
                    } else if (object instanceof Number) {
                        this.m_values[0].add(object);
                        this.m_isAttrValNumber = true;
                    } else {
                        this.m_values[0].add(object.toString());
                    }
                    long l2 = resultSet.getLong(2);
                    this.m_values[1].add(false == resultSet.wasNull() ? new Long(l2) : new Long(0L));
                    double d = false == resultSet.wasNull() ? resultSet.getDouble(3) : 0.0;
                    this.m_values[2].add(new Double(d));
                    long l3 = Math.round((double)l2 * this.m_samplePercentage / 100.0);
                    if (!bl) {
                        long l4 = (l += l3) - this.m_samplePercentageOfCases;
                        if (l4 > 0L) {
                            bl = true;
                            l = this.m_samplePercentageOfCases;
                            l3 -= l4;
                        }
                    } else {
                        l3 = 0L;
                    }
                    double d2 = 100.0 * (double)l3 / (double)this.m_samplePercentageOfCases;
                    this.m_values[3].add(new Double(d2));
                    this.m_values[4].add(new Long(l3));
                    this.m_values[6].add(new Boolean(true));
                }
                this.m_values[7].addAll(this.m_values[4]);
                this.m_values[8].addAll(this.m_values[3]);
                this.m_values[9].addAll(this.m_values[5]);
                Object var17_13 = null;
                if (callableStatement == null) break block17;
            }
            catch (Throwable throwable) {
                Object var17_14 = null;
                if (callableStatement != null) {
                    callableStatement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                throw throwable;
            }
            callableStatement.close();
        }
        if (resultSet != null) {
            resultSet.close();
        }
    }

    public boolean isAttrValNumber() {
        return this.m_isAttrValNumber;
    }

    protected ArrayOneDModel createColumns() throws Exception {
        this.addColumns(0, 1);
        Object[] objectArray = new String[]{ATTR_VALUE_COUNT_COLUMN_NAME};
        return new ArrayOneDModel(objectArray);
    }

    static interface SQL_TEMPLATES {
        public static final String QUERY_ATTRVALCOUNT_2D_DATA = "SELECT /*+ noparallel(t)*/ {0}, count(*), count(*)*100/{1}, {2}*count(*)/100 FROM {3} t WHERE {0} IS NOT NULL GROUP BY {0}";
        public static final String QUERY_ATTRVALCOUNT_XNL_DATA = "SELECT /*+ noparallel(t)*/ {5}, count(*), ROUND(count(*)*100/{1}), {2}*count(*)/100 FROM {3} t WHERE {4}=''{0}'' GROUP BY {5}";
    }
}

