/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.codegen;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.codegen.Templates;

public class CodeTemplate {
    private static final String BASE_PATH = "oracle/dmt/dm4j/codegen/";
    public static final String TAG_PACKAGE_COMMENT = "<PACKAGE COMMENT>";
    public static final String TAG_PACKAGE_NAME = "<PACKAGE NAME>";
    public static final String TAG_INPUT_DATA_PREPARATION = "<INPUT DATA PREPARATION>";
    public static final String TAG_DATA_TRANSFORMATIONS = "<DATA TRANSFORMATIONS>";
    public static final String TAG_MINING_DATA_PREPARATION = "<MINING DATA PREPARATION>";
    public static final String TAG_MINING_TEST_DATA_PREPARATION = "<MINING TEST DATA PREPARATION>";
    public static final String TAG_APPLY_OPERATION = "<APPLY OPERATION>";
    public static final String TAG_API_NAME = "<API NAME>";
    public static final String TAG_API_HP = "<API NAME HP>";
    public static final String TAG_API_BT = "<API NAME BT>";
    public static final String TAG_API_TT = "<API NAME TT>";
    public static final String TAG_API_ST = "<API NAME ST>";
    public static final String TAG_API_RT = "<API NAME RT>";
    public static final String TAG_API_SR = "<API NAME SR>";
    public static final String TAG_API_SC = "<API NAME SC>";
    public static final String TAG_API_NAME_WF = "<API NAME WF>";
    public static final String TAG_RECORD_NAME = "<TYPE RECORD NAME>";
    public static final String TAG_TABLE_NAME = "<TYPE TABLE NAME>";
    public static final String TAG_CASEID = "<CASEID>";
    public static final String TAG_XNORM_SHIFT = "<XNORM_SHIFT>";
    public static final String TAG_XNORM_SCALE = "<XNORM_SCALE>";
    public static final String TAG_GENERATE_CASEID_DEFAULT = "<generate caseid default>";
    public static final String TAG_GENERATE_TEXT_DEFAULT = "<generate text default>";
    public static final String TAG_CASE_TABLE_SCHEMA_DEFAULT = "<case_table_schema default>";
    public static final String TAG_CASE_TABLE_DEFAULT = "<case_table default>";
    public static final String TAG_ADDITIONAL_SCHEMA_PARAMS = "<additional_schema_params>";
    public static final String TAG_ADDITIONAL_TABLE_PARAMS = "<additional_table_params>";
    public static final String TAG_ADDITIONAL_TABLE_ARRAY = "<additional_table_array>";
    public static final String TAG_MODEL_NAME_DEFAULT = "<model_name default>";
    public static final String TAG_CONFUSION_MATRIX_NAME_DEFAULT = "<confusion_matrix_name default>";
    public static final String TAG_LIFT_RESULT_NAME_DEFAULT = "<lift_result_name default>";
    public static final String TAG_ROC_RESULT_NAME_DEFAULT = "<roc_result_name default>";
    public static final String TAG_TEST_METRIC_NAME_DEFAULT = "<test_metric_name default>";
    public static final String TAG_FEATURE_TABLE_NAME_DEFAULT = "<feature_table_name default>";
    public static final String TAG_MAPPING_TABLE_NAME_DEFAULT = "<mapping_table_name default>";
    public static final String TAG_APPLY_RESULT_NAME_DEFAULT = "<apply_result_name default>";
    public static final String TAG_TABLE_OUTPUT_DEFAULT = "<table_output default>";
    public static final String TAG_RESIDUAL_PLOT_DATA_NAME_DEFAULT = "<residual_plot_data_name default>";
    public static final String TAG_DROP_OUTPUT_DEFAULT = "<drop_output default>";
    public static final String TAG_ADDITIONAL_SCHEMA_PARAMS_VALUES = "additional_schema_";
    public static final String TAG_ADDITIONAL_TABLE_PARAMS_VALUES = "additional_table_";
    public static final String TAG_ADDITIONAL_SQL_PARAMS = "<additional_sql_params>";
    public static final String TAG_ADDITIONAL_SQL_ARRAY = "<additional_sql_array>";
    public static final String TAG_ADDITIONAL_SQL_PARAMS_VALUES = "additional_sql_";
    public static final String TAG_TARGET_DEFAULT = "<target default>";
    public static final String TAG_NON_QUOTE_TARGET_DEFAULT = "<non-quote target default>";
    public static final String TAG_POS_TARGET_VALUE_DEFAULT = "<positive target value default>";
    public static final String TAG_NUM_QUANTILES_DEFAULT = "<num_quantiles default>";
    public static final String TAG_PRIOR_SETTING = "<PRIOR SETTING>";
    public static final String TAG_BUILD_COST_MATRIX_SETTING = "<BUILD COST MATRIX SETTING>";
    public static final String TAG_BUILD_SETTING = "<BUILD SETTING>";
    public static final String TAG_TEST_COST_MATRIX_SETTING = "<TEST COST MATRIX SETTING>";
    public static final String TAG_APPLY_RESULT_TYPE_LIST = "<apply_result_type_list>";
    public static final String TAG_APPLY_RESULT_COLUMNS_DEFINITION = "<APPLY RESULT COLUMNS DEFINITION>";
    public static final String TAG_APPLY_RESULT_COLUMNS_DECLARATION = "<APPLY RESULT COLUMNS DECLARATION>";
    public static final String TAG_DEFINE_APPLY_RESULT_COLUMNS = "<DEFINE APPLY RESULT COLUMNS>";
    public static final String TAG_RETRIEVE_APPLY_RESULT_COLUMNS = "<RETRIEVE APPLY RESULT COLUMNS>";
    public static final String TAG_WF_ADDITIONAL_TABLES_DECLARATION = "<WF ADDITIONAL TABLES DECLARATION>";
    public static final String TAG_WF_RETRIEVE_ADDITIONAL_TABLES = "<WF RETRIEVE ADDITIONAL TABLES>";
    public static final String TAG_WF_ADDITIONAL_SQLS_DECLARATION = "<WF ADDITIONAL SQLS DECLARATION>";
    public static final String TAG_WF_RETRIEVE_ADDITIONAL_SQLS = "<WF RETRIEVE ADDITIONAL SQLS>";
    public static final String TAG_ADDITIONAL_TABLE_PARAMS_WF = "ADDITIONAL_TABLE_";
    public static final String TAG_ADDITIONAL_SQL_PARAMS_WF = "ADDITIONAL_SQL_";
    public static final String TAG_USE_SCORE_CRITERION_TYPE = "<USE SCORE CRITERION TYPE>";
    private static final String TEMPLATE_COMMON_UTIL = "common_util";
    private static final String TEMPLATE_ASSOC_MODEL_BUILD = "assoc_model_build";
    private static final String TEMPLATE_CLASS_MODEL_BUILD = "class_model_build";
    private static final String TEMPLATE_REGRESS_MODEL_BUILD = "regress_model_build";
    private static final String TEMPLATE_ANOMALY_MODEL_BUILD = "anomaly_model_build";
    private static final String TEMPLATE_ATTRIMP_MODEL_BUILD = "attrImp_model_build";
    private static final String TEMPLATE_CLUST_MODEL_BUILD = "clust_model_build";
    private static final String TEMPLATE_NMF_MODEL_BUILD = "nmf_model_build";
    private static final String TEMPLATE_CLASS_MODEL_TEST = "class_model_test";
    private static final String TEMPLATE_REGRESS_MODEL_TEST = "regress_model_test";
    private static final String TEMPLATE_MODEL_APPLY_BATCH = "model_apply_bt";
    private static final String TEMPLATE_MODEL_APPLY_REALTIME = "model_apply_rt";
    private static final String TEMPLATE_COMMON_MODEL_WF = "common_model_wf";
    private static final String TEMPLATE_ASSOC_MODEL_BUILD_WF = "assoc_model_build_wf";
    private static final String TEMPLATE_CLASS_MODEL_BUILD_WF = "class_model_build_wf";
    private static final String TEMPLATE_REGRESS_MODEL_BUILD_WF = "regress_model_build_wf";
    private static final String TEMPLATE_CLASS_MODEL_TEST_WF = "class_model_test_wf";
    private static final String TEMPLATE_REGRESS_MODEL_TEST_WF = "regress_model_test_wf";
    private static final String TEMPLATE_OTHER_MODEL_BUILD_WF = "other_model_build_wf";
    private static final String TEMPLATE_APPLY_WF = "model_apply_wf";
    private static final String TEMPLATE_HDR_EXT = ".hdr";
    private static final String TEMPLATE_BODY_EXT = ".bdy";
    private static final String TEMPLATE_TYPE_EXT = ".typ";
    private static final String TEMPLATE_RS_EXT = ".rs";
    private static CodeTemplate _instance = null;

    private CodeTemplate() {
    }

    public static CodeTemplate getInstance() {
        if (_instance == null) {
            _instance = new CodeTemplate();
        }
        return _instance;
    }

    protected URL getURL(String string) {
        URL uRL = null;
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            uRL = classLoader.getResource(string);
            if (null == uRL) {
                throw new Exception("Cannot find plsql template: " + string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return uRL;
    }

    public static String createPLSQLTemplate(String string) throws Exception {
        if (_instance == null) {
            _instance = new CodeTemplate();
        }
        String string2 = BASE_PATH + string;
        String string3 = null;
        URL uRL = _instance.getURL(string2);
        if (null != uRL) {
            String string4 = uRL.getProtocol();
            string3 = string4.equals("jar") || string4.equals("JAR") ? CodeTemplate.getTemplateFromJar(uRL, string2) : (string4.equals("code-source") ? CodeTemplate.getTemplateFromCodeSource(uRL, string2) : CodeTemplate.getTemplateFromFile(uRL.toURI().getPath()));
        }
        return string3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getTemplateFromJar(URL uRL, String string) throws Exception {
        BufferedReader bufferedReader = null;
        StringBuffer stringBuffer = new StringBuffer(16384);
        try {
            try {
                String string2;
                ClassLoader classLoader = _instance.getClass().getClassLoader();
                InputStream inputStream = classLoader.getResourceAsStream(string);
                if (null == inputStream) {
                    throw new Exception("Cannot find plsql template from jar: " + string);
                }
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                bufferedReader = new BufferedReader(inputStreamReader);
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string2 + "\n");
                }
                Object var9_9 = null;
                if (bufferedReader == null) return stringBuffer.toString();
            }
            catch (Exception exception) {
                System.out.println("Unable to get template from jar:" + uRL + " Reason:" + exception.getMessage());
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (bufferedReader == null) throw throwable;
            bufferedReader.close();
            throw throwable;
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getTemplateFromCodeSource(URL uRL, String string) throws Exception {
        BufferedReader bufferedReader = null;
        StringBuffer stringBuffer = new StringBuffer(16384);
        try {
            try {
                String string2;
                ClassLoader classLoader = _instance.getClass().getClassLoader();
                InputStream inputStream = classLoader.getResourceAsStream(string);
                if (null == inputStream) {
                    throw new Exception("Cannot find plsql template from jar: " + string);
                }
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                bufferedReader = new BufferedReader(inputStreamReader);
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string2 + "\n");
                }
                Object var9_9 = null;
                if (bufferedReader == null) return stringBuffer.toString();
            }
            catch (Exception exception) {
                System.out.println("Unable to get template from jar:" + uRL + " Reason:" + exception.getMessage());
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (bufferedReader == null) throw throwable;
            bufferedReader.close();
            throw throwable;
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }

    public static void updateHdrTemplate(Templates templates, String string, String string2) {
        String string3 = DM4JStringUtils.getReplacedString(templates.getPackageHdr(), string, string2);
        templates.setPackageHdr(string3);
    }

    public static void updateBodyTemplate(Templates templates, String string, String string2) {
        String string3 = DM4JStringUtils.getReplacedString(templates.getPackageBody(), string, string2);
        templates.setPackageBody(string3);
    }

    public static void updateRecordTypeTemplate(Templates templates, String string, String string2) {
        String string3 = DM4JStringUtils.getReplacedString(templates.getRecordType(), string, string2);
        templates.setRecordType(string3);
    }

    public static void updateTableTypeTemplate(Templates templates, String string, String string2) {
        String string3 = DM4JStringUtils.getReplacedString(templates.getTableType(), string, string2);
        templates.setTableType(string3);
    }

    public static void updateRecordTypeName(Templates templates, String string) {
        templates.setRecordTypeName(string);
    }

    public static void updateTableTypeName(Templates templates, String string) {
        templates.setTableTypeName(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getTemplateFromFile(String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer(16384);
        BufferedReader bufferedReader = null;
        try {
            try {
                String string2;
                bufferedReader = new BufferedReader(new FileReader(string));
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string2 + "\n");
                }
                Object var5_5 = null;
                if (bufferedReader == null) return stringBuffer.toString();
            }
            catch (Exception exception) {
                System.out.println("Unable to get template:" + string + " Reason:" + exception.getMessage());
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (bufferedReader == null) throw throwable;
            bufferedReader.close();
            throw throwable;
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }

    public Templates getCommonTemplate() throws Exception {
        Templates templates = new Templates(null, CodeTemplate.createPLSQLTemplate("common_util.bdy"), null, null, null, null);
        return templates;
    }

    public Templates getTemplate(ActivityType activityType, boolean bl, boolean bl2) throws Exception {
        String string = null;
        String string2 = null;
        if (ActivityType.isBuildActivity(activityType)) {
            if (ActivityType.isAssociationRulesActivity(activityType)) {
                string = TEMPLATE_ASSOC_MODEL_BUILD;
                string2 = TEMPLATE_ASSOC_MODEL_BUILD_WF;
            } else if (ActivityType.isClassificationActivity(activityType)) {
                string = TEMPLATE_CLASS_MODEL_BUILD;
                string2 = TEMPLATE_CLASS_MODEL_BUILD_WF;
            } else if (ActivityType.isRegressionActivity(activityType)) {
                string = TEMPLATE_REGRESS_MODEL_BUILD;
                string2 = TEMPLATE_REGRESS_MODEL_BUILD_WF;
            } else if (ActivityType.isAnomalyDetectionActivity(activityType)) {
                string = TEMPLATE_ANOMALY_MODEL_BUILD;
                string2 = TEMPLATE_OTHER_MODEL_BUILD_WF;
            } else if (ActivityType.isAttributeImportanceActivity(activityType)) {
                string = TEMPLATE_ATTRIMP_MODEL_BUILD;
                string2 = TEMPLATE_OTHER_MODEL_BUILD_WF;
            } else if (ActivityType.isClusteringActivity(activityType)) {
                string = TEMPLATE_CLUST_MODEL_BUILD;
                string2 = TEMPLATE_OTHER_MODEL_BUILD_WF;
            } else if (ActivityType.isFeatureExtractionActivity(activityType)) {
                string = TEMPLATE_NMF_MODEL_BUILD;
                string2 = TEMPLATE_OTHER_MODEL_BUILD_WF;
            }
        } else if (ActivityType.isTestActivity(activityType)) {
            if (ActivityType.isClassificationActivity(activityType)) {
                string = TEMPLATE_CLASS_MODEL_TEST;
                string2 = TEMPLATE_CLASS_MODEL_TEST_WF;
            } else if (ActivityType.isRegressionActivity(activityType)) {
                string = TEMPLATE_REGRESS_MODEL_TEST;
                string2 = TEMPLATE_REGRESS_MODEL_TEST_WF;
            }
        } else if (ActivityType.isApplyActivity(activityType)) {
            string = TEMPLATE_MODEL_APPLY_BATCH;
            string2 = TEMPLATE_APPLY_WF;
        }
        String string3 = CodeTemplate.createPLSQLTemplate(string + TEMPLATE_HDR_EXT);
        if (bl && ActivityType.isApplyActivity(activityType)) {
            string3 = string3 + CodeTemplate.createPLSQLTemplate("model_apply_rt.hdr");
        }
        if (bl2) {
            string3 = string3 + CodeTemplate.createPLSQLTemplate("common_model_wf.hdr");
        }
        String string4 = CodeTemplate.createPLSQLTemplate(string + TEMPLATE_BODY_EXT);
        if (bl && ActivityType.isApplyActivity(activityType)) {
            string4 = string4 + CodeTemplate.createPLSQLTemplate("model_apply_rt.bdy");
        }
        if (bl2) {
            string4 = string4 + CodeTemplate.createPLSQLTemplate(string2 + TEMPLATE_BODY_EXT);
        }
        Templates templates = new Templates(string3, string4, null, null, bl && ActivityType.isApplyActivity(activityType) ? CodeTemplate.createPLSQLTemplate("model_apply_rt.typ") : null, bl && ActivityType.isApplyActivity(activityType) ? CodeTemplate.createPLSQLTemplate("model_apply_rt.rs") : null);
        return templates;
    }
}

