/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.codegen;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.codegen.ActivityDetail;
import oracle.dmt.dm4j.codegen.CodeGenContext;
import oracle.dmt.dm4j.codegen.CodeGenInput;
import oracle.dmt.dm4j.codegen.CodeGenResult;
import oracle.dmt.dm4j.codegen.CodeTemplate;
import oracle.dmt.dm4j.codegen.ProgressDispatcher;
import oracle.dmt.dm4j.codegen.Templates;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;

public class CodeGen {
    private CodeGenInput m_input;
    private CodeGenResult m_result = new CodeGenResult();
    private HashMap m_exceptions = new HashMap();
    private ProgressDispatcher m_listener;

    public CodeGen(CodeGenInput codeGenInput) {
        this.m_input = codeGenInput;
    }

    public CodeGen(CodeGenInput codeGenInput, ProgressDispatcher progressDispatcher) {
        this.m_input = codeGenInput;
        this.m_listener = progressDispatcher;
    }

    private CodeGenResult addPackage(CodeGenContext codeGenContext) {
        Object object;
        Templates templates = null;
        try {
            object = CodeTemplate.getInstance();
            templates = ((CodeTemplate)object).getCommonTemplate();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object = new CodeGenResult();
        ((CodeGenResult)object).setValidations(this.m_exceptions);
        if (this.m_result.getPackageHdr().length() > 0) {
            String string = this.m_input.getPackageName();
            string = DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(string));
            String string2 = null;
            string2 = this.m_input.getPackageComment();
            if (string2 != null && string2.length() > 0) {
                string2 = "/*\n" + string2 + "\n*/\n";
            }
            String string3 = this.m_input.isUseDefinerRight() ? "DEFINER" : "CURRENT_USER";
            ((CodeGenResult)object).setPackageHdr((string2 != null ? string2 : "") + "CREATE PACKAGE " + string + " AUTHID " + string3 + " AS\n " + this.m_result.getPackageHdr() + "\nEND;\n\n");
            ((CodeGenResult)object).setPackageBody((string2 != null ? string2 : "") + "CREATE PACKAGE BODY " + string + " AS\n " + templates.getPackageBody() + this.m_result.getPackageBody() + "\nEND;\n\n");
            ((CodeGenResult)object).setTypeObjects(this.m_result.getTypeObjects());
        }
        return object;
    }

    public CodeGenResult generateCode() {
        boolean bl = false;
        CodeGenContext codeGenContext = new CodeGenContext();
        codeGenContext.setPackageName(this.m_input.getPackageName());
        codeGenContext.setTableOutput(this.m_input.isTableOutput());
        codeGenContext.setUseDefinerRight(this.m_input.isUseDefinerRight());
        codeGenContext.setDropResult(this.m_input.isDropResult());
        codeGenContext.setGenWorkflowAPI(this.m_input.isGenWorkflowAPI());
        AbstractActivity abstractActivity = null;
        int n = 0;
        for (int i = 0; i < this.m_input.getActivityDetails().size(); ++i) {
            ActivityDetail activityDetail = (ActivityDetail)this.m_input.getActivityDetails().get(i);
            try {
                if (this.m_listener != null && this.m_listener.hasUserCanceled()) {
                    bl = true;
                    break;
                }
                AbstractActivity abstractActivity2 = abstractActivity = activityDetail.isRestored() ? activityDetail.getMiningActivity() : AbstractActivity.restore(activityDetail.getActivityName());
                if (this.m_listener != null && this.m_listener.hasUserCanceled()) {
                    bl = true;
                    break;
                }
                CodeTemplate codeTemplate = CodeTemplate.getInstance();
                Templates templates = codeTemplate.getTemplate(abstractActivity.getType(), activityDetail.isGenRealtimeAPI(), codeGenContext.isGenWorkflowAPI());
                codeGenContext.setProcedureId(i + 1);
                codeGenContext.setProcedureName(activityDetail.getProcedureName());
                codeGenContext.setGenRealtimeAPI(activityDetail.isGenRealtimeAPI());
                codeGenContext.setRecordTypeName(activityDetail.getRecordTypeName());
                codeGenContext.setTableTypeName(activityDetail.getTableTypeName());
                codeGenContext.setTemplates(templates);
                codeGenContext.setActivity(abstractActivity);
                if (this.m_listener != null && this.m_listener.hasUserCanceled()) {
                    bl = true;
                    break;
                }
                abstractActivity.generateCode(codeGenContext, this.m_listener, n, activityDetail.getMiningActivity().getName());
                n += abstractActivity.getSteps().size();
                if (this.m_listener != null && this.m_listener.hasUserCanceled()) {
                    bl = true;
                    break;
                }
                Vector vector = codeGenContext.getValidations();
                if (!ValidationUtil.validationsContainsErrors(vector)) {
                    this.m_result.add(codeGenContext.getTemplates());
                    continue;
                }
                this.m_exceptions.put(abstractActivity.getName(), new Vector(vector));
                vector.clear();
                continue;
            }
            catch (Exception exception) {
                if (this.m_listener != null) {
                    this.m_listener.errorProcessActivity(i, abstractActivity.getName());
                }
                exception.printStackTrace();
            }
        }
        if (bl) {
            return null;
        }
        return this.addPackage(codeGenContext);
    }

    public HashMap getExceptions() {
        return this.m_exceptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        try {
            try {
                Serializable serializable2222;
                char[] cArray = new char[]{'d', 'm', 'u', 's', 'e', 'r'};
                DM4JConnectionManager.initialize("stacw24", "1521", "jw102", false, "dmuser", cArray, Locale.US);
                ArrayList<ActivityDetail> arrayList = new ArrayList<ActivityDetail>();
                ActivityDetail activityDetail = null;
                activityDetail = new ActivityDetail("svmc_COUNTRIES_BA_76", "SVMC_BUILD", "", "", "", "build", true, null, null);
                arrayList.add(activityDetail);
                CodeGenInput codeGenInput = new CodeGenInput("apply_package", "This package is generated by ODMr", arrayList, true, true, true, true);
                CodeGen codeGen = new CodeGen(codeGenInput);
                CodeGenResult codeGenResult = codeGen.generateCode();
                for (Serializable serializable2222 : codeGenResult.getValidations().values()) {
                    System.out.println(((StateValidation)serializable2222).getDescription() + "\n");
                }
                serializable2222 = codeGenResult.getTypeObjects();
                if (serializable2222 != null && ((ArrayList)serializable2222).size() > 0) {
                    System.out.println("Generated Object Record Type: \n\n" + ((ArrayList)serializable2222).get(0).toString() + "\n\n");
                    System.out.println("Generated Object Table Type: \n\n" + ((ArrayList)serializable2222).get(1).toString() + "\n\n");
                }
                String string = codeGenResult.getPackageHdr();
                System.out.println("Generated Package Header: \n\n" + string + "\n\n");
                String string2 = codeGenResult.getPackageBody();
                System.out.println("Generated Package Body: \n\n" + string2 + "\n\n");
                System.out.println("Code Generation Done!");
            }
            catch (Exception exception) {
                Object var12_13 = null;
                DM4JConnectionManager.close();
                return;
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            DM4JConnectionManager.close();
            throw throwable;
        }
        DM4JConnectionManager.close();
    }
}

