/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.worker;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.datamining.association.AssociationModel;
import javax.datamining.association.RuleProperty;
import javax.datamining.attributeimportance.AttributeImportanceModel;
import javax.datamining.base.Model;
import javax.datamining.clustering.ClusteringModel;
import javax.datamining.modeldetail.tree.TreeNode;
import javax.datamining.supervised.classification.ClassificationModel;
import javax.datamining.supervised.regression.RegressionModel;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import oracle.dmt.dm4j.browser.tree.FindSchemaNodeWorker;
import oracle.dmt.dm4j.browser.tree.FindTreeNodeWorker;
import oracle.dmt.dm4j.browser.viewer.classification.LoadABNDetailRulesWorker;
import oracle.dmt.dm4j.browser.viewer.classification.LoadABNRulesWorker;
import oracle.dmt.dm4j.browser.viewer.classification.LoadGLMCoefficientWorker;
import oracle.dmt.dm4j.browser.viewer.classification.LoadNBPairProbabilitiesWorker;
import oracle.dmt.dm4j.browser.viewer.classification.LoadSVMCoefficientWorker;
import oracle.dmt.dm4j.browser.viewer.classification.LoadTreeNodesWorker;
import oracle.dmt.dm4j.browser.viewer.clustering.ClusteringModelViewer;
import oracle.dmt.dm4j.browser.viewer.clustering.LoadClusteringRulesWorker;
import oracle.dmt.dm4j.browser.viewer.clustering.LoadClustersWorker;
import oracle.dmt.dm4j.browser.viewer.featureExtraction.LoadNMFFeaturesWorker;
import oracle.dmt.dm4j.browser.viewer.regression.LoadSVMRegCoefficientWorker;
import oracle.dmt.dm4j.browser.viewer.task.LoadTaskDetailWorker;
import oracle.dmt.dm4j.browser.viewer.task.LoadTasksWorker;
import oracle.dmt.dm4j.browser.worker.LoadAIAttributesWorker;
import oracle.dmt.dm4j.browser.worker.LoadActivityDetailWorker;
import oracle.dmt.dm4j.browser.worker.LoadActivityFolderWorker;
import oracle.dmt.dm4j.browser.worker.LoadApplyOutputWorker;
import oracle.dmt.dm4j.browser.worker.LoadAssocRulesWorker;
import oracle.dmt.dm4j.browser.worker.LoadAttributesWorker;
import oracle.dmt.dm4j.browser.worker.LoadDiscoObjectsFolderWorker;
import oracle.dmt.dm4j.browser.worker.LoadExplainOutputWorker;
import oracle.dmt.dm4j.browser.worker.LoadModelFolderWorker;
import oracle.dmt.dm4j.browser.worker.LoadObjectDetailWorker;
import oracle.dmt.dm4j.browser.worker.LoadObjectsWorker;
import oracle.dmt.dm4j.browser.worker.LoadPredictOutputWorker;
import oracle.dmt.dm4j.browser.worker.LoadResidualPlotWorker;
import oracle.dmt.dm4j.browser.worker.LoadResultFolderWorker;
import oracle.dmt.dm4j.browser.worker.LoadSchemaObjectDetailWorker;
import oracle.dmt.dm4j.browser.worker.LoadStaticFolderWorker;
import oracle.dmt.dm4j.browser.worker.LoadTablesFolderWorker;
import oracle.dmt.dm4j.browser.worker.RefreshObjectsWorker;
import oracle.dmt.dm4j.browser.worker.RemoveObjectsWorker;
import oracle.dmt.dm4j.browser.worker.SortAssocRulesWorker;
import oracle.dmt.dm4j.browser.worker.SwingWorker;
import oracle.dmt.dm4j.browser.worker.ThreadState;
import oracle.dmt.dm4j.browser.worker.listener.WorkerThreadListener;
import oracle.dmt.dm4j.lineage.LineageTreeNode;
import oracle.dmt.dm4j.lineage.LoadDependentViewsWorker;
import oracle.dmt.dm4j.lineage.LoadViewDetailWorker;
import oracle.dmt.jdm.featureextraction.OraFeatureExtractionModel;
import oracle.dmt.jdm.jdmresult.OraMiningApplyResult;
import oracle.dmt.jdm.jdmresult.OraMiningExplainResult;
import oracle.dmt.jdm.jdmresult.OraMiningPredictResult;
import oracle.dss.graph.Graph;

public class WorkerThreadManager
implements ThreadState {
    private static WorkerThreadManager s_mgr = null;
    private EventListenerList m_listenerList = new EventListenerList();
    private static int s_thread = 0;
    private static int s_state = 1;

    private WorkerThreadManager() {
    }

    private void fireThreadCountChanged() {
        Object[] objectArray = this.m_listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != WorkerThreadListener.class) continue;
            ((WorkerThreadListener)objectArray[i + 1]).threadCountChanged(new EventObject(new Integer(s_thread)));
        }
    }

    void addThreadCnt() {
        ++s_thread;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                WorkerThreadManager.this.fireThreadCountChanged();
            }
        });
    }

    void removeThreadCnt() {
        --s_thread;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                WorkerThreadManager.this.fireThreadCountChanged();
            }
        });
    }

    private void fireThreadStateChanged() {
        Object[] objectArray = this.m_listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != WorkerThreadListener.class) continue;
            ((WorkerThreadListener)objectArray[i + 1]).threadStateChanged(new EventObject(new Integer(s_state)));
        }
    }

    public void setRunningState(int n) {
        s_state |= n;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                WorkerThreadManager.this.fireThreadStateChanged();
            }
        });
    }

    public void removeRunningState(int n) {
        s_state &= ~n;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                WorkerThreadManager.this.fireThreadStateChanged();
            }
        });
    }

    public static WorkerThreadManager getInstance() {
        if (s_mgr == null) {
            s_mgr = new WorkerThreadManager();
        }
        return s_mgr;
    }

    public void addWorkerThreadListener(WorkerThreadListener workerThreadListener) {
        this.m_listenerList.add(WorkerThreadListener.class, workerThreadListener);
    }

    public void removeWorkerThreadListener(WorkerThreadListener workerThreadListener) {
        this.m_listenerList.remove(WorkerThreadListener.class, workerThreadListener);
    }

    public int getState() {
        return s_state;
    }

    public SwingWorker getLoadViewDetailWorker(LineageTreeNode lineageTreeNode) {
        return new LoadViewDetailWorker(this, lineageTreeNode);
    }

    public SwingWorker getLoadDependentViewsWorker(LineageTreeNode lineageTreeNode) {
        return new LoadDependentViewsWorker(this, lineageTreeNode);
    }

    public SwingWorker getLoadObjectsWorker(DefaultMutableTreeNode defaultMutableTreeNode) {
        return new LoadObjectsWorker(this, defaultMutableTreeNode);
    }

    public SwingWorker getLoadTasksWorker() {
        return new LoadTasksWorker(this);
    }

    public SwingWorker getLoadTaskDetailWorker(String string, String string2) {
        return new LoadTaskDetailWorker(this, string, string2);
    }

    public SwingWorker getLoadStaticFolderWorker(DefaultMutableTreeNode defaultMutableTreeNode) {
        return new LoadStaticFolderWorker(this, defaultMutableTreeNode);
    }

    public SwingWorker getModelFolderWorker(DefaultMutableTreeNode defaultMutableTreeNode) {
        return new LoadModelFolderWorker(this, defaultMutableTreeNode);
    }

    public SwingWorker getTablesFolderWorker(DefaultMutableTreeNode defaultMutableTreeNode) {
        return new LoadTablesFolderWorker(this, defaultMutableTreeNode);
    }

    public SwingWorker getDiscoObjectsFolderWorker(DefaultMutableTreeNode defaultMutableTreeNode) {
        return new LoadDiscoObjectsFolderWorker(this, defaultMutableTreeNode);
    }

    public SwingWorker getResultFolderWorker(DefaultMutableTreeNode defaultMutableTreeNode) {
        return new LoadResultFolderWorker(this, defaultMutableTreeNode);
    }

    public SwingWorker getLoadActivityFolderWorker(DefaultMutableTreeNode defaultMutableTreeNode) {
        return new LoadActivityFolderWorker(this, defaultMutableTreeNode);
    }

    public SwingWorker getLoadAttributesWorker(Model model) {
        return new LoadAttributesWorker(this, model);
    }

    public SwingWorker getLoadApplyOutputWorker(OraMiningApplyResult oraMiningApplyResult, int n, String[] stringArray, String string, boolean bl) {
        return new LoadApplyOutputWorker(this, oraMiningApplyResult, n, stringArray, string, bl);
    }

    public SwingWorker getLoadResidualPlotWorker(OraMiningApplyResult oraMiningApplyResult, int n, String[] stringArray, String string, boolean bl, Graph graph, Hashtable hashtable, String string2, boolean bl2, JLabel jLabel) {
        return new LoadResidualPlotWorker(this, oraMiningApplyResult, n, stringArray, string, bl, graph, hashtable, string2, bl2, jLabel);
    }

    public SwingWorker getLoadPredictOutputWorker(OraMiningPredictResult oraMiningPredictResult, int n, String[] stringArray, String string, boolean bl) {
        return new LoadPredictOutputWorker(this, oraMiningPredictResult, n, stringArray, string, bl);
    }

    public SwingWorker getLoadExplainOutputWorker(OraMiningExplainResult oraMiningExplainResult, String string, boolean bl, Graph graph) {
        return new LoadExplainOutputWorker(this, oraMiningExplainResult, string, bl, graph);
    }

    public SwingWorker getLoadObjectDetailWorker(DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        return new LoadObjectDetailWorker(this, defaultMutableTreeNode, n);
    }

    public SwingWorker getLoadSchemaObjectDetailWorker(DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        return new LoadSchemaObjectDetailWorker(this, defaultMutableTreeNode, n);
    }

    public SwingWorker getActivityDetailWorker(DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        return new LoadActivityDetailWorker(this, defaultMutableTreeNode, n);
    }

    public SwingWorker getRemoveObjectsWorker(Vector vector, boolean bl, boolean bl2) {
        return new RemoveObjectsWorker(this, vector, bl, bl2);
    }

    public SwingWorker getRefreshObjectsWorker(DefaultTreeModel defaultTreeModel) {
        return new RefreshObjectsWorker(this, defaultTreeModel);
    }

    public SwingWorker getFindTreeNodeWorker(DefaultTreeModel defaultTreeModel, String string, String string2, boolean bl) {
        return new FindTreeNodeWorker(this, defaultTreeModel, string, string2, bl);
    }

    public SwingWorker getFindSchemaNodeWorker(DefaultTreeModel defaultTreeModel, String string, String string2, String string3, boolean bl) {
        return new FindSchemaNodeWorker(this, defaultTreeModel, string, string2, string3, bl);
    }

    public SwingWorker getLoadAssocRulesWorker(AssociationModel associationModel, int n, Double d, Double d2, String[] stringArray, String[] stringArray2, int n2, boolean bl, String string) {
        return new LoadAssocRulesWorker(this, associationModel, n, d, d2, stringArray, stringArray2, n2, bl, string);
    }

    public SwingWorker getSortAssocRulesWorker(AssociationModel associationModel, int n, Double d, Double d2, String[] stringArray, String[] stringArray2, RuleProperty[] rulePropertyArray, Boolean[] booleanArray, String string) {
        return new SortAssocRulesWorker(this, associationModel, n, d, d2, stringArray, stringArray2, rulePropertyArray, booleanArray, string);
    }

    public SwingWorker getLoadABNRulesWorker(ClassificationModel classificationModel) {
        return new LoadABNRulesWorker(this, classificationModel);
    }

    public SwingWorker getLoadClustersWorker(ClusteringModelViewer clusteringModelViewer, JLabel jLabel, int n, boolean bl) {
        return new LoadClustersWorker(this, clusteringModelViewer, jLabel, n, bl);
    }

    public SwingWorker getLoadTreeNodesWorker(TreeNode treeNode, ClassificationModel classificationModel, boolean bl) {
        return new LoadTreeNodesWorker(this, treeNode, classificationModel, bl);
    }

    public SwingWorker getLoadClusteringRulesWorker(ClusteringModel clusteringModel, boolean bl, boolean bl2, int n) {
        return new LoadClusteringRulesWorker(this, clusteringModel, bl, bl2, n);
    }

    public SwingWorker getLoadAIAttributesWorker(AttributeImportanceModel attributeImportanceModel, String string, boolean bl, Graph graph, int n) {
        return new LoadAIAttributesWorker(this, attributeImportanceModel, string, bl, graph, n);
    }

    public SwingWorker getLoadABNDetailRulesWorker(ClassificationModel classificationModel, int n) {
        return new LoadABNDetailRulesWorker(this, classificationModel, n);
    }

    public SwingWorker getLoadSVMCoefficientWorker(ClassificationModel classificationModel, Object object, HashMap hashMap) {
        return new LoadSVMCoefficientWorker(this, classificationModel, object, hashMap);
    }

    public SwingWorker getLoadGLMCoefficientWorker(Model model, Object object, HashMap hashMap) {
        return new LoadGLMCoefficientWorker(this, model, object, hashMap);
    }

    public SwingWorker getLoadSVMRegCoefficientWorker(RegressionModel regressionModel, HashMap hashMap) {
        return new LoadSVMRegCoefficientWorker(this, regressionModel, hashMap);
    }

    public SwingWorker getLoadNMFFeaturesWorker(OraFeatureExtractionModel oraFeatureExtractionModel, Integer n, HashMap hashMap) {
        return new LoadNMFFeaturesWorker(this, oraFeatureExtractionModel, n, hashMap);
    }

    public SwingWorker getLoadNBPairProbabilitiesWorker(ClassificationModel classificationModel, Object object, HashMap hashMap) {
        return new LoadNBPairProbabilitiesWorker(this, classificationModel, object, hashMap);
    }
}

