/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.worker;

import java.util.EventObject;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.worker.SwingWorker;
import oracle.dmt.dm4j.browser.worker.ThreadState;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;
import oracle.dmt.dm4j.browser.worker.listener.ObjectsRemovedListener;

public class RemoveObjectsWorker
extends SwingWorker
implements ThreadState {
    private static int s_thread = 0;
    private EventListenerList listenerList = new EventListenerList();
    private Vector m_nodes;
    private boolean m_cascadeDelete;
    private boolean m_deleteOutput;

    public RemoveObjectsWorker(WorkerThreadManager workerThreadManager, Vector vector, boolean bl, boolean bl2) {
        super(workerThreadManager);
        this.m_nodes = vector;
        this.m_cascadeDelete = bl;
        this.m_deleteOutput = bl2;
    }

    public void addRemovedListener(ObjectsRemovedListener objectsRemovedListener) {
        this.listenerList.add(ObjectsRemovedListener.class, objectsRemovedListener);
    }

    public void removeRemovedListener(ObjectsRemovedListener objectsRemovedListener) {
        this.listenerList.remove(ObjectsRemovedListener.class, objectsRemovedListener);
    }

    public Object construct() {
        Vector vector = null;
        try {
            if (s_thread == 0) {
                this.m_threadManager.setRunningState(8);
            }
            ++s_thread;
            LeafNodeData leafNodeData = (LeafNodeData)((DefaultMutableTreeNode)this.m_nodes.get(0)).getUserObject();
            if (leafNodeData.isMiningObject()) {
                vector = LeafNodeData.removeOdmObjectsFromDMS(this.m_nodes, this.m_cascadeDelete, this.m_deleteOutput);
            } else if (leafNodeData.isSchemaObject()) {
                vector = LeafNodeData.dropSchemaObjects(this.m_nodes);
            } else if (leafNodeData.isActivityObject()) {
                vector = LeafNodeData.dropActivityObjects(this.m_nodes, this.m_deleteOutput);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vector;
    }

    public void finished() {
        if (--s_thread == 0) {
            this.m_threadManager.removeRunningState(8);
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ObjectsRemovedListener.class) continue;
            ((ObjectsRemovedListener)objectArray[i + 1]).objectsRemoved(new EventObject(this.getValue()));
        }
    }
}

