/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.worker;

import java.util.EventObject;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultTreeModel;
import oracle.dmt.dm4j.browser.tree.node.FolderNodeData;
import oracle.dmt.dm4j.browser.worker.SwingWorker;
import oracle.dmt.dm4j.browser.worker.ThreadState;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;
import oracle.dmt.dm4j.browser.worker.listener.ObjectsRefreshedListener;

public class RefreshObjectsWorker
extends SwingWorker
implements ThreadState {
    private static int s_thread = 0;
    private EventListenerList listenerList = new EventListenerList();
    private DefaultTreeModel m_model;

    public RefreshObjectsWorker(WorkerThreadManager workerThreadManager, DefaultTreeModel defaultTreeModel) {
        super(workerThreadManager);
        this.m_model = defaultTreeModel;
    }

    public void addRefreshedListener(ObjectsRefreshedListener objectsRefreshedListener) {
        this.listenerList.add(ObjectsRefreshedListener.class, objectsRefreshedListener);
    }

    public void removeRefreshedListener(ObjectsRefreshedListener objectsRefreshedListener) {
        this.listenerList.remove(ObjectsRefreshedListener.class, objectsRefreshedListener);
    }

    public Object construct() {
        try {
            if (s_thread == 0) {
                this.m_threadManager.setRunningState(16);
            }
            ++s_thread;
            FolderNodeData.refresh(this.m_model);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.m_model;
    }

    public void finished() {
        if (--s_thread == 0) {
            this.m_threadManager.removeRunningState(16);
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ObjectsRefreshedListener.class) continue;
            ((ObjectsRefreshedListener)objectArray[i + 1]).objectsRefreshed(new EventObject(this.getValue()));
        }
    }
}

