/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.worker;

import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dmt.dm4j.browser.tree.node.FolderNodeData;
import oracle.dmt.dm4j.browser.tree.node.NodeData;
import oracle.dmt.dm4j.browser.viewer.folder.StaticFolderViewer;
import oracle.dmt.dm4j.browser.worker.SwingWorker;
import oracle.dmt.dm4j.browser.worker.ThreadState;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;
import oracle.dmt.dm4j.browser.worker.listener.FolderLoadedListener;

public class LoadStaticFolderWorker
extends SwingWorker
implements ThreadState {
    private static int s_thread = 0;
    private EventListenerList listenerList = new EventListenerList();
    private DefaultMutableTreeNode m_treeNode;

    public LoadStaticFolderWorker(WorkerThreadManager workerThreadManager, DefaultMutableTreeNode defaultMutableTreeNode) {
        super(workerThreadManager);
        this.m_treeNode = defaultMutableTreeNode;
    }

    public Object construct() {
        Object object;
        StaticFolderViewer staticFolderViewer = null;
        try {
            if (s_thread == 0) {
                this.m_threadManager.setRunningState(4);
            }
            ++s_thread;
            object = (FolderNodeData)this.m_treeNode.getUserObject();
            if ("SCHEMA".equals(((NodeData)object).getNodeType())) {
                ((NodeData)object).setSchemaName(((NodeData)object).getName());
            }
            staticFolderViewer = new StaticFolderViewer((FolderNodeData)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object = new ArrayList<DefaultMutableTreeNode>();
        ((ArrayList)object).add(this.m_treeNode);
        ((ArrayList)object).add(staticFolderViewer);
        return object;
    }

    public void finished() {
        if (--s_thread == 0) {
            this.m_threadManager.removeRunningState(4);
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != FolderLoadedListener.class) continue;
            ((FolderLoadedListener)objectArray[i + 1]).folderLoaded(new EventObject(this.getValue()));
        }
    }

    public void addStaticFolderLoadedListener(FolderLoadedListener folderLoadedListener) {
        this.listenerList.add(FolderLoadedListener.class, folderLoadedListener);
    }

    public void removeStaticFolderLoadedListener(FolderLoadedListener folderLoadedListener) {
        this.listenerList.remove(FolderLoadedListener.class, folderLoadedListener);
    }
}

