/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.worker;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.viewer.table.TableViewer;
import oracle.dmt.dm4j.browser.worker.SwingWorker;
import oracle.dmt.dm4j.browser.worker.ThreadState;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;
import oracle.dmt.dm4j.browser.worker.listener.SchemaObjectDetailLoadedListener;

public class LoadSchemaObjectDetailWorker
extends SwingWorker
implements ThreadState {
    private static int s_thread = 0;
    private EventListenerList listenerList = new EventListenerList();
    private DefaultMutableTreeNode m_treeNode;
    private int m_tabIndex = 0;

    public LoadSchemaObjectDetailWorker(WorkerThreadManager workerThreadManager, DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        super(workerThreadManager);
        this.m_treeNode = defaultMutableTreeNode;
        this.m_tabIndex = n;
    }

    public void addSchemaObjectDetailLoadedListener(SchemaObjectDetailLoadedListener schemaObjectDetailLoadedListener) {
        this.listenerList.add(SchemaObjectDetailLoadedListener.class, schemaObjectDetailLoadedListener);
    }

    public void removeObjectDetailLoadedListener(SchemaObjectDetailLoadedListener schemaObjectDetailLoadedListener) {
        this.listenerList.remove(SchemaObjectDetailLoadedListener.class, schemaObjectDetailLoadedListener);
    }

    public Object construct() {
        TableViewer tableViewer = null;
        try {
            if (s_thread == 0) {
                this.m_threadManager.setRunningState(4);
            }
            ++s_thread;
            tableViewer = LeafNodeData.loadSchemaObject(this.m_treeNode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        arrayList.add(this.m_treeNode);
        arrayList.add(tableViewer);
        arrayList.add(new Integer(this.m_tabIndex));
        return arrayList;
    }

    public void finished() {
        if (--s_thread == 0) {
            this.m_threadManager.removeRunningState(4);
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != SchemaObjectDetailLoadedListener.class) continue;
            ((SchemaObjectDetailLoadedListener)objectArray[i + 1]).schemaObjectDetailLoaded(new EventObject(this.getValue()));
        }
    }
}

