/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.worker;

import java.util.EventObject;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.event.EventListenerList;
import oracle.dmt.dm4j.browser.viewer.results.apply.ResidualPlotTableModel;
import oracle.dmt.dm4j.browser.worker.SwingWorker;
import oracle.dmt.dm4j.browser.worker.ThreadState;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;
import oracle.dmt.dm4j.browser.worker.listener.ResidualPlotLoadedListener;
import oracle.dmt.jdm.jdmresult.OraMiningApplyResult;
import oracle.dss.graph.Graph;

public class LoadResidualPlotWorker
extends SwingWorker
implements ThreadState {
    private static int s_thread = 0;
    private EventListenerList listenerList = new EventListenerList();
    private OraMiningApplyResult m_mar;
    private int m_rows;
    private String[] m_columns;
    private String m_sortColumn;
    private boolean m_ascending;
    private ResidualPlotTableModel m_tableModel = null;
    private Graph m_residualPlotChart = null;
    private Hashtable m_xformTables = null;
    private String m_targetColumn = null;
    private boolean m_isActualX = false;
    private JLabel m_status = null;

    LoadResidualPlotWorker(WorkerThreadManager workerThreadManager, OraMiningApplyResult oraMiningApplyResult, int n, String[] stringArray, String string, boolean bl, Graph graph, Hashtable hashtable, String string2, boolean bl2, JLabel jLabel) {
        super(workerThreadManager);
        this.m_mar = oraMiningApplyResult;
        this.m_rows = n;
        this.m_columns = stringArray;
        this.m_sortColumn = string;
        this.m_ascending = bl;
        this.m_residualPlotChart = graph;
        this.m_xformTables = hashtable;
        this.m_targetColumn = string2;
        this.m_isActualX = bl2;
        this.m_status = jLabel;
    }

    public void addResidualPlotLoadedListener(ResidualPlotLoadedListener residualPlotLoadedListener) {
        this.listenerList.add(ResidualPlotLoadedListener.class, residualPlotLoadedListener);
    }

    public void removeResidualPlotLoadedListener(ResidualPlotLoadedListener residualPlotLoadedListener) {
        this.listenerList.remove(ResidualPlotLoadedListener.class, residualPlotLoadedListener);
    }

    public Object construct() {
        try {
            if (s_thread == 0) {
                this.m_threadManager.setRunningState(2);
            }
            ++s_thread;
            this.m_tableModel = new ResidualPlotTableModel();
            this.m_tableModel.load(this.m_mar, this.m_rows, this.m_columns, this.m_sortColumn, this.m_ascending, this.m_residualPlotChart, this.m_xformTables, this.m_targetColumn, this.m_isActualX, this.m_status);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.m_tableModel;
    }

    public void finished() {
        if (--s_thread == 0) {
            this.m_threadManager.removeRunningState(2);
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ResidualPlotLoadedListener.class) continue;
            ((ResidualPlotLoadedListener)objectArray[i + 1]).tableLoaded(new EventObject(this.getValue()));
        }
    }
}

