/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.worker;

import java.util.EventObject;
import javax.swing.event.EventListenerList;
import oracle.dmt.dm4j.browser.viewer.results.apply.PredictOutputTableModel;
import oracle.dmt.dm4j.browser.worker.SwingWorker;
import oracle.dmt.dm4j.browser.worker.ThreadState;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;
import oracle.dmt.dm4j.browser.worker.listener.PredictOutputLoadedListener;
import oracle.dmt.jdm.jdmresult.OraMiningPredictResult;

public class LoadPredictOutputWorker
extends SwingWorker
implements ThreadState {
    private static int s_thread = 0;
    private EventListenerList listenerList = new EventListenerList();
    private OraMiningPredictResult m_mar;
    private int m_rows;
    private String[] m_columns;
    private String m_sortColumn;
    private boolean m_ascending;
    private PredictOutputTableModel m_tableModel = null;

    LoadPredictOutputWorker(WorkerThreadManager workerThreadManager, OraMiningPredictResult oraMiningPredictResult, int n, String[] stringArray, String string, boolean bl) {
        super(workerThreadManager);
        this.m_mar = oraMiningPredictResult;
        this.m_rows = n;
        this.m_columns = stringArray;
        this.m_sortColumn = string;
        this.m_ascending = bl;
    }

    public void addPredictOutputLoadedListener(PredictOutputLoadedListener predictOutputLoadedListener) {
        this.listenerList.add(PredictOutputLoadedListener.class, predictOutputLoadedListener);
    }

    public void removePredictOutputLoadedListener(PredictOutputLoadedListener predictOutputLoadedListener) {
        this.listenerList.remove(PredictOutputLoadedListener.class, predictOutputLoadedListener);
    }

    public Object construct() {
        try {
            if (s_thread == 0) {
                this.m_threadManager.setRunningState(2);
            }
            ++s_thread;
            this.m_tableModel = new PredictOutputTableModel();
            this.m_tableModel.load(this.m_mar, this.m_rows, this.m_columns, this.m_sortColumn, this.m_ascending);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.m_tableModel;
    }

    public void finished() {
        if (--s_thread == 0) {
            this.m_threadManager.removeRunningState(2);
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != PredictOutputLoadedListener.class) continue;
            ((PredictOutputLoadedListener)objectArray[i + 1]).tableLoaded(new EventObject(this.getValue()));
        }
    }
}

