/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.worker;

import java.util.EventObject;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dmt.dm4j.browser.tree.node.FolderNodeData;
import oracle.dmt.dm4j.browser.worker.SwingWorker;
import oracle.dmt.dm4j.browser.worker.ThreadState;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;
import oracle.dmt.dm4j.browser.worker.listener.ObjectsLoadedListener;

public class LoadObjectsWorker
extends SwingWorker
implements ThreadState {
    private static int s_thread = 0;
    private EventListenerList listenerList = new EventListenerList();
    private DefaultMutableTreeNode m_parent;
    private String m_modelName = null;

    LoadObjectsWorker(WorkerThreadManager workerThreadManager, DefaultMutableTreeNode defaultMutableTreeNode) {
        super(workerThreadManager);
        this.m_parent = defaultMutableTreeNode;
    }

    public void setModelName(String string) {
        this.m_modelName = string;
    }

    public void addObjectsLoadedListener(ObjectsLoadedListener objectsLoadedListener) {
        this.listenerList.add(ObjectsLoadedListener.class, objectsLoadedListener);
    }

    public void removeObjectsLoadedListener(ObjectsLoadedListener objectsLoadedListener) {
        this.listenerList.remove(ObjectsLoadedListener.class, objectsLoadedListener);
    }

    public Object construct() {
        try {
            if (s_thread == 0) {
                this.m_threadManager.setRunningState(2);
            }
            ++s_thread;
            FolderNodeData.expandNode(this.m_parent, this.m_modelName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.m_parent;
    }

    public void finished() {
        if (--s_thread == 0) {
            this.m_threadManager.removeRunningState(2);
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ObjectsLoadedListener.class) continue;
            ((ObjectsLoadedListener)objectArray[i + 1]).objectsLoaded(new EventObject(this.getValue()));
        }
    }
}

