/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.worker;

import java.util.EventObject;
import javax.datamining.base.BuildSettings;
import javax.datamining.base.Model;
import javax.swing.event.EventListenerList;
import oracle.dmt.dm4j.browser.table.AttributeTableModel;
import oracle.dmt.dm4j.browser.worker.SwingWorker;
import oracle.dmt.dm4j.browser.worker.ThreadState;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;
import oracle.dmt.dm4j.browser.worker.listener.AttributesLoadedListener;
import oracle.dmt.dm4j.browser.worker.listener.ObjectsLoadedListener;

public class LoadAttributesWorker
extends SwingWorker
implements ThreadState {
    private static int s_thread = 0;
    private EventListenerList listenerList = new EventListenerList();
    private BuildSettings m_mfs;
    private Model m_model;
    private AttributeTableModel m_tableModel = null;

    LoadAttributesWorker(WorkerThreadManager workerThreadManager, Model model) {
        super(workerThreadManager);
        this.m_model = model;
        this.m_mfs = model.getBuildSettings();
    }

    public void addAttributesLoadedListener(AttributesLoadedListener attributesLoadedListener) {
        this.listenerList.add(AttributesLoadedListener.class, attributesLoadedListener);
    }

    public void removeAttributesLoadedListener(ObjectsLoadedListener objectsLoadedListener) {
        this.listenerList.remove(ObjectsLoadedListener.class, objectsLoadedListener);
    }

    public Object construct() {
        try {
            if (s_thread == 0) {
                this.m_threadManager.setRunningState(2);
            }
            ++s_thread;
            this.m_tableModel = new AttributeTableModel();
            this.m_tableModel.load(this.m_model);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.m_tableModel;
    }

    public void finished() {
        if (--s_thread == 0) {
            this.m_threadManager.removeRunningState(2);
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != AttributesLoadedListener.class) continue;
            ((AttributesLoadedListener)objectArray[i + 1]).tableLoaded(new EventObject(this.getValue()));
        }
    }
}

