/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.worker;

import java.util.EventObject;
import javax.datamining.attributeimportance.AttributeImportanceModel;
import javax.swing.event.EventListenerList;
import oracle.dmt.dm4j.browser.viewer.attributeImportance.RankTableModel;
import oracle.dmt.dm4j.browser.worker.SwingWorker;
import oracle.dmt.dm4j.browser.worker.ThreadState;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;
import oracle.dmt.dm4j.browser.worker.listener.AIAttributesLoadedListener;
import oracle.dss.graph.Graph;

public class LoadAIAttributesWorker
extends SwingWorker
implements ThreadState {
    private static int s_thread = 0;
    private EventListenerList listenerList = new EventListenerList();
    private AttributeImportanceModel m_aim;
    private String m_sortColumn;
    private boolean m_ascending;
    private RankTableModel m_tableModel = null;
    private Graph m_histogram = null;
    private int m_attrCount = 100;

    LoadAIAttributesWorker(WorkerThreadManager workerThreadManager, AttributeImportanceModel attributeImportanceModel, String string, boolean bl, Graph graph, int n) {
        super(workerThreadManager);
        this.m_aim = attributeImportanceModel;
        this.m_sortColumn = string;
        this.m_ascending = bl;
        this.m_histogram = graph;
        this.m_attrCount = n;
    }

    public void addAIAttributesLoadedListener(AIAttributesLoadedListener aIAttributesLoadedListener) {
        this.listenerList.add(AIAttributesLoadedListener.class, aIAttributesLoadedListener);
    }

    public void removeAIAttributesLoadedListener(AIAttributesLoadedListener aIAttributesLoadedListener) {
        this.listenerList.remove(AIAttributesLoadedListener.class, aIAttributesLoadedListener);
    }

    public Object construct() {
        try {
            if (s_thread == 0) {
                this.m_threadManager.setRunningState(2);
            }
            ++s_thread;
            this.m_tableModel = new RankTableModel();
            this.m_tableModel.load(this.m_aim, this.m_sortColumn, this.m_ascending, this.m_histogram, this.m_attrCount);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.m_tableModel;
    }

    public void finished() {
        if (--s_thread == 0) {
            this.m_threadManager.removeRunningState(2);
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != AIAttributesLoadedListener.class) continue;
            ((AIAttributesLoadedListener)objectArray[i + 1]).attributesLoaded(new EventObject(this.getValue()));
        }
    }
}

