/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.testMetrics;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.datamining.NamedObject;
import javax.datamining.data.CategoryMatrix;
import javax.datamining.resource.Connection;
import javax.datamining.supervised.classification.ClassificationTestMetricOption;
import javax.datamining.supervised.classification.ClassificationTestMetrics;
import javax.datamining.supervised.classification.ClassificationTestTask;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JSimpleDialog;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.viewer.classification.CostMatrixPanel;
import oracle.dmt.dm4j.browser.viewer.testMetrics.ClassificationTestMetricsViewer;
import oracle.dmt.dm4j.datasources.DMEMetadata;

public class SettingsPanel
extends GriddedPanel {
    JLabel m_name = new JLabel();
    JLabel m_hasConfusionMatrix = new JLabel();
    JLabel m_hasROC = new JLabel();
    JLabel m_hasLift = new JLabel();
    JLabel m_quantiles = new JLabel();
    JLabel m_target = new JLabel();
    JButton m_costMatrixBtn = new JButton();
    CategoryMatrix m_costMatrix = null;
    String m_costMatrixTable = null;
    ClassificationTestMetricsViewer m_parent = null;

    public SettingsPanel(ClassificationTestMetricsViewer classificationTestMetricsViewer) {
        try {
            this.m_parent = classificationTestMetricsViewer;
            this.jbInit();
            this.runTimePanelLoad();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getHelpId() {
        return "CLASS_TESTMETRICS_TS";
    }

    private void jbInit() throws Exception {
        int n = 1;
        JLabel jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_NAME"));
        this.addComponent(jLabel, TOPLABELITEMINSETS, n, 1);
        this.addComponent(this.m_name, TOPVALUEITEMINSETS, n++, 2);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_CONFUSION_MATRIX"));
        this.addComponent(jLabel, TOPLABELITEMINSETS, n, 1);
        this.addComponent(this.m_hasConfusionMatrix, TOPVALUEITEMINSETS, n++, 2);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_ROC"));
        this.addComponent(jLabel, TOPLABELITEMINSETS, n, 1);
        this.addComponent(this.m_hasROC, TOPVALUEITEMINSETS, n++, 2);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_LIFT"));
        this.addComponent(jLabel, TOPLABELITEMINSETS, n, 1);
        this.addComponent(this.m_hasLift, TOPVALUEITEMINSETS, n++, 2);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_LIFT_QUANTILES"));
        this.addComponent(jLabel, MIDINDENTEDLABELITEMINSETS, n, 1);
        this.addComponent(this.m_quantiles, MIDVALUEITEMINSETS, n++, 2);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_ROC_LIFT_SETTINGS"));
        this.addComponent(jLabel, TOPLABELITEMINSETS, n++, 1);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_TARGET"));
        this.addComponent(jLabel, MIDINDENTEDLABELITEMINSETS, n, 1);
        this.addComponent(this.m_target, MIDVALUEITEMINSETS, n++, 2);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_COST_MATRIX"));
        this.addComponent(jLabel, MIDINDENTEDLABELITEMINSETS, n, 1);
        this.addComponent(this.m_costMatrixBtn, MIDVALUEITEMINSETS, n++, 2);
        this.m_costMatrixBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.cmButton_actionPerformed(actionEvent);
            }
        });
        this.addFilledComponent(new JLabel(" "), TOPLABELITEMINSETS, n, 1, 4, 2, 1);
    }

    private void runTimePanelLoad() throws Exception {
        ClassificationTestMetrics classificationTestMetrics = this.m_parent.getClassificationTestMetrics();
        String string = this.m_parent.getName();
        this.m_name.setText(string);
        this.loadTaskInfo();
    }

    private void cmButton_actionPerformed(ActionEvent actionEvent) {
        try {
            DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
            CostMatrixPanel costMatrixPanel = new CostMatrixPanel("", this.m_costMatrixTable);
            DM4JSimpleDialog dM4JSimpleDialog = new DM4JSimpleDialog((Frame)BrowserUtils.getParentFrame(this), (JPanel)costMatrixPanel, DM4JResourceUtilities.getUIString("CLASS_COST_MATRIX"), null);
            dM4JSimpleDialog.setCloseDialog();
            dM4JSimpleDialog.setNoHelp();
            dM4JSimpleDialog.setSize(new Dimension(500, 300));
            dM4JSimpleDialog.setVisible(true);
            if (!dM4JSimpleDialog.isOk()) {
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadTaskInfo() throws Exception {
        Connection connection = DM4JConnectionManager.getConnection();
        try {
            try {
                block20: {
                    this.m_hasConfusionMatrix.setText(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_NO"));
                    this.m_hasROC.setText(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_NO"));
                    this.m_hasLift.setText(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_NO"));
                    this.m_costMatrixBtn.setText(DM4JResourceUtilities.getUIString("COMMON_VIEW"));
                    this.m_costMatrixBtn.setEnabled(false);
                    String string = this.m_parent.getTaskName();
                    ClassificationTestTask classificationTestTask = null;
                    if (string != null && (classificationTestTask = (ClassificationTestTask)connection.retrieveObject(DMEMetadata.fixObjectNameWhenLoad(string), NamedObject.task)) != null) {
                        boolean bl = classificationTestTask.computeMetric(ClassificationTestMetricOption.confusionMatrix);
                        if (bl) {
                            this.m_hasConfusionMatrix.setText(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_YES"));
                        } else {
                            this.m_hasConfusionMatrix.setText(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_NO"));
                        }
                        boolean bl2 = classificationTestTask.computeMetric(ClassificationTestMetricOption.receiverOperatingCharacteristics);
                        if (bl2) {
                            this.m_hasROC.setText(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_YES"));
                        } else {
                            this.m_hasROC.setText(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_NO"));
                        }
                        boolean bl3 = classificationTestTask.computeMetric(ClassificationTestMetricOption.lift);
                        if (bl3) {
                            this.m_hasLift.setText(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_YES"));
                            this.m_quantiles.setText(classificationTestTask.getNumberOfLiftQuantiles() + "");
                        } else {
                            this.m_hasLift.setText(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_NO"));
                            this.m_quantiles.setText(DM4JResourceUtilities.getUIString("COMMON_NOT_AVAILABLE"));
                        }
                        if (bl2 || bl3) {
                            this.m_target.setText(classificationTestTask.getPositiveTargetValue().toString());
                        } else {
                            this.m_target.setText(DM4JResourceUtilities.getUIString("COMMON_NOT_AVAILABLE"));
                        }
                        String string2 = classificationTestTask.getCostMatrixName();
                        if (string2 != null) {
                            this.m_costMatrixBtn.setEnabled(true);
                            try {
                                block19: {
                                    try {
                                        if (this.m_costMatrix != null) break block19;
                                        this.m_costMatrixTable = DMEMetadata.fixObjectNameWhenLoad(string2);
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                        Object var10_10 = null;
                                        break block20;
                                    }
                                }
                                Object var10_9 = null;
                            }
                            catch (Throwable throwable) {
                                Object var10_11 = null;
                                throw throwable;
                            }
                        }
                    }
                }
                Object var12_14 = null;
                if (connection == null) return;
            }
            catch (Exception exception) {
                Object var12_15 = null;
                if (connection == null) return;
                connection.close();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            if (connection == null) throw throwable;
            connection.close();
            throw throwable;
        }
        connection.close();
    }
}

