/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.testMetrics;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.datamining.ExecutionHandle;
import javax.datamining.JDMException;
import javax.datamining.NamedObject;
import javax.datamining.resource.Connection;
import javax.datamining.supervised.TestTask;
import javax.datamining.supervised.regression.RegressionTestMetrics;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.HyperlinkButtonDataSource;
import oracle.dmt.dm4j.browser.HyperlinkButtonMiningResult;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.viewer.LoadingStatusPanel;
import oracle.dmt.dm4j.browser.viewer.activity.MiningResultViewerFrame;
import oracle.dmt.dm4j.browser.viewer.activity.OutputDataViewerFrame;
import oracle.dmt.dm4j.browser.viewer.testMetrics.CPredictiveConfidencePanel;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.jdm.supervised.OraTestTask;
import oracle.dmt.jdm.supervised.regression.OraRegressionTestMetrics;

public class RegressionTestMetricsViewer
extends JTabbedPane {
    protected RegressionTestMetrics m_testMetrics;
    protected CPredictiveConfidencePanel m_predConfPanel;
    protected RegressionTestDetailsPanel m_testPanel = null;
    protected RegressionTestTaskPanel m_taskPanel = null;
    protected LeafNodeData m_nd = null;
    protected int[] m_tabIndex;
    static int PC_TAB = 0;
    static int TEST_TAB = 1;
    static int TASK_TAB = 2;
    static int NUM_TAB = 3;
    protected String m_testMetricsName = null;
    protected String m_taskName = null;
    protected Timestamp m_startingTimestamp;
    protected Timestamp m_completionTimestamp;
    protected String m_creatorInfo = "";
    protected String m_inputTableName;
    protected String m_inputSchemaNamea;
    protected String m_testOutputResultName;
    protected Double m_shift = new Double(0.0);
    protected Double m_scale = new Double(1.0);
    private static final String SQL_MINING_TEST = "SELECT * FROM  DM4J$RESULTS_STATE_V WHERE TYPE='TEST' AND UPPER(NAME) = ?";
    private static final String CREATION_DATE = "CREATION_DATE";
    private static final String TASK = "TASK_NAME";
    private boolean m_showPredictiveConfTab = true;

    public RegressionTestMetrics getRegressionTestMetrics() {
        return this.m_testMetrics;
    }

    public String getTaskName() {
        return this.m_taskName;
    }

    protected void setCreatorInfo(String string) throws JDMException {
        this.m_creatorInfo = string;
    }

    public String getCreatorInfo() {
        return this.m_creatorInfo;
    }

    protected void setCreationDate(Date date) throws JDMException {
        this.m_startingTimestamp = new Timestamp(date.getTime());
    }

    public Date getCreationDate() {
        return new Date(this.m_startingTimestamp.getTime());
    }

    protected void setCompletionTimestamp(Date date) {
        this.m_completionTimestamp = new Timestamp(date.getTime());
    }

    public Timestamp getCompletionTimestamp() {
        return this.m_completionTimestamp;
    }

    protected void setInputTableName(String string) {
        this.m_inputTableName = string;
    }

    public String getInputTableName() {
        return this.m_inputTableName;
    }

    protected void setInputSchemaName(String string) {
        this.m_inputSchemaNamea = string;
    }

    public String getSchemaName() {
        return this.m_inputSchemaNamea;
    }

    protected void setTestOutputResultName(String string) {
        this.m_testOutputResultName = string;
    }

    public String getTestOutputResultName() {
        return this.m_testOutputResultName;
    }

    public RegressionTestMetricsViewer(LeafNodeData leafNodeData, Double d, Double d2) {
        try {
            this.m_shift = d;
            this.m_scale = d2;
            this.m_nd = leafNodeData;
            OraRegressionTestMetrics oraRegressionTestMetrics = (OraRegressionTestMetrics)this.m_nd.getOdmObject();
            oraRegressionTestMetrics.setTargetNormalizationDetails(d, d2);
            String string = oraRegressionTestMetrics.getModelName();
            if (string == null) {
                this.m_showPredictiveConfTab = false;
                TEST_TAB = 0;
                TASK_TAB = 1;
                this.loadViewer(TEST_TAB);
            } else {
                this.m_showPredictiveConfTab = true;
                PC_TAB = 0;
                TEST_TAB = 1;
                TASK_TAB = 2;
                this.loadViewer(PC_TAB);
            }
            this.setMinimumSize(BrowserFrame.m_prefRightPaneSize);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public RegressionTestMetricsViewer(LeafNodeData leafNodeData) {
        this(leafNodeData, null, null);
    }

    protected void loadViewer(int n) throws Exception {
        int n2 = 0;
        this.m_tabIndex = new int[NUM_TAB];
        if (this.m_showPredictiveConfTab) {
            this.addTab(DM4JResourceUtilities.getUIString("TESTMETRICS_PC_TAB"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("TESTMETRICS_PC_TAB"));
            this.m_tabIndex[n2++] = PC_TAB;
        }
        this.addTab(DM4JResourceUtilities.getUIString("RESULT_TEST_METRICS_TAB"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("RESULT_TEST_METRICS_TAB"));
        this.m_tabIndex[n2++] = TEST_TAB;
        this.addTab(DM4JResourceUtilities.getUIString("RESULT_TASK_TAB"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("RESULT_TASK_TAB"));
        this.m_tabIndex[n2++] = TASK_TAB;
        this.showTab(n);
        this.setSelectedIndex(n);
        this.addChangeListener(new tabChangeListener());
    }

    protected void showTab(int n) {
        Thread thread = new Thread(new LoadTab(n, this));
        thread.setPriority(5);
        thread.start();
    }

    public String getHelpId() {
        int n = this.getSelectedIndex();
        if (n == 0) {
            return "REGRESS_TESTMETRICS_PC";
        }
        if (n == 1) {
            return "REGRESS_TESTMETRICS";
        }
        if (n == 2) {
            return "REGRESS_TESTMETRICS_TASK";
        }
        return "REGRESS_TESTMETRICS_PC";
    }

    class tabChangeListener
    implements ChangeListener {
        tabChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            RegressionTestMetricsViewer.this.showTab(((JTabbedPane)changeEvent.getSource()).getSelectedIndex());
        }
    }

    class LoadTab
    implements Runnable {
        int tabIndex;
        GriddedPanel panel;
        RegressionTestMetricsViewer viewer;
        Exception exception = null;

        public LoadTab(int n, RegressionTestMetricsViewer regressionTestMetricsViewer2) {
            this.tabIndex = n;
            this.viewer = regressionTestMetricsViewer2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void loadTaskInfo() throws Exception {
            Connection connection2;
            block12: {
                connection2 = DM4JConnectionManager.getConnection();
                java.sql.Connection connection = DM4JConnectionManager.getDbConnection();
                try {
                    block11: {
                        try {
                            String string;
                            RegressionTestMetricsViewer.this.m_testMetrics = (RegressionTestMetrics)RegressionTestMetricsViewer.this.m_nd.getOdmObject();
                            RegressionTestMetricsViewer.this.m_testMetricsName = RegressionTestMetricsViewer.this.m_nd.getName();
                            DMEMetadata dMEMetadata = DMEMetadata.getInstance();
                            String string2 = dMEMetadata.getTaskNameForMiningObject(connection, "TEST", RegressionTestMetricsViewer.this.m_testMetricsName);
                            if (string2 == null) break block11;
                            RegressionTestMetricsViewer.this.m_taskName = string2;
                            TestTask testTask = (TestTask)connection2.retrieveObject(DMEMetadata.fixObjectNameWhenLoad(string2), NamedObject.task);
                            if (testTask == null) break block11;
                            OraTestTask oraTestTask = (OraTestTask)testTask;
                            String string3 = oraTestTask.getTestData().getURI();
                            StringTokenizer stringTokenizer = new StringTokenizer(string3, ".", false);
                            int n = stringTokenizer.countTokens();
                            if (n == 2) {
                                RegressionTestMetricsViewer.this.setInputTableName(stringTokenizer.nextToken());
                                string = stringTokenizer.nextToken();
                            } else {
                                RegressionTestMetricsViewer.this.setInputTableName(string3);
                                string = null;
                            }
                            if (string == null) {
                                string = connection.getMetaData().getUserName();
                            }
                            RegressionTestMetricsViewer.this.setInputSchemaName(string);
                            String string4 = testTask.getTestMetricsName();
                            RegressionTestMetricsViewer.this.setTestOutputResultName(string4);
                            ExecutionHandle executionHandle = testTask.getExecutionHandle();
                            Date date = executionHandle.getStartTime();
                            if (date == null) break block11;
                            RegressionTestMetricsViewer.this.setCreationDate(date);
                            Integer n2 = executionHandle.getDurationInSeconds();
                            if (n2 != null) {
                                Date date2 = new Date(date.getTime() + (long)(n2 * 1000));
                                RegressionTestMetricsViewer.this.setCompletionTimestamp(date2);
                            }
                        }
                        catch (Exception exception) {
                            Object var17_18 = null;
                            if (connection != null) {
                                connection.close();
                            }
                            if (connection2 == null) return;
                            connection2.close();
                            return;
                        }
                    }
                    Object var17_17 = null;
                    if (connection == null) break block12;
                }
                catch (Throwable throwable) {
                    Object var17_19 = null;
                    if (connection != null) {
                        connection.close();
                    }
                    if (connection2 == null) throw throwable;
                    connection2.close();
                    throw throwable;
                }
                connection.close();
            }
            if (connection2 == null) return;
            connection2.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object var1_1 = null;
            try {
                try {
                    this.loadTaskInfo();
                    this.panel = null;
                    if (this.viewer.m_showPredictiveConfTab && RegressionTestMetricsViewer.this.m_tabIndex[this.tabIndex] == PC_TAB) {
                        if (RegressionTestMetricsViewer.this.m_predConfPanel == null) {
                            RegressionTestMetricsViewer.this.m_predConfPanel = new CPredictiveConfidencePanel(this.viewer);
                        }
                        this.panel = RegressionTestMetricsViewer.this.m_predConfPanel;
                    } else if (RegressionTestMetricsViewer.this.m_tabIndex[this.tabIndex] == TEST_TAB) {
                        if (RegressionTestMetricsViewer.this.m_testPanel == null) {
                            RegressionTestMetricsViewer.this.m_testPanel = new RegressionTestDetailsPanel(this.viewer.m_nd);
                        }
                        this.panel = RegressionTestMetricsViewer.this.m_testPanel;
                    } else if (RegressionTestMetricsViewer.this.m_tabIndex[this.tabIndex] == TASK_TAB) {
                        if (RegressionTestMetricsViewer.this.m_taskPanel == null) {
                            RegressionTestMetricsViewer.this.m_taskPanel = new RegressionTestTaskPanel();
                        }
                        this.panel = RegressionTestMetricsViewer.this.m_taskPanel;
                    }
                    Runnable runnable = new Runnable(){

                        public void run() {
                            RegressionTestMetricsViewer.this.setComponentAt(LoadTab.this.tabIndex, LoadTab.this.panel);
                        }
                    };
                    EventQueue.invokeLater(runnable);
                }
                catch (Exception exception) {
                    this.exception = exception;
                    exception.printStackTrace();
                    Object var4_5 = null;
                }
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                throw throwable;
            }
        }
    }

    class RegressionTestDetailsPanel
    extends GriddedPanel {
        LeafNodeData nd;
        protected JLabel m_meanAbsoluteError = new JLabel();
        protected JLabel m_meanActualValue = new JLabel();
        protected JLabel m_meanPredictedValue = new JLabel();
        protected JLabel m_RMSError = new JLabel();
        protected JLabel m_filler = new JLabel();

        public RegressionTestDetailsPanel(LeafNodeData leafNodeData) {
            this.nd = leafNodeData;
            int n = 1;
            JLabel jLabel = new JLabel(DM4JResourceUtilities.getUIString("REGRESS_TESTMETRICS_MAE"));
            this.addComponent(jLabel, TOPLABELITEMINSETS, n, 1);
            this.addComponent(this.m_meanAbsoluteError, TOPVALUEITEMINSETS, n++, 2);
            jLabel = new JLabel(DM4JResourceUtilities.getUIString("REGRESS_TESTMETRICS_MAV"));
            this.addComponent(jLabel, MIDLABELITEMINSETS, n, 1);
            this.addComponent(this.m_meanActualValue, MIDVALUEITEMINSETS, n++, 2);
            jLabel = new JLabel(DM4JResourceUtilities.getUIString("REGRESS_TESTMETRICS_MPV"));
            this.addComponent(jLabel, MIDLABELITEMINSETS, n, 1);
            this.addComponent(this.m_meanPredictedValue, MIDVALUEITEMINSETS, n++, 2);
            jLabel = new JLabel(DM4JResourceUtilities.getUIString("REGRESS_TESTMETRICS_RMSE"));
            this.addComponent(jLabel, MIDLABELITEMINSETS, n, 1);
            this.addComponent(this.m_RMSError, MIDVALUEITEMINSETS, n++, 2);
            this.addFilledComponent(this.m_filler, TOPLABELITEMINSETS, n, 1, 2, 2, 1);
            this.runTimePanelLoad();
        }

        public void runTimePanelLoad() {
            Double d = RegressionTestMetricsViewer.this.m_testMetrics.getMeanAbsoluteError();
            this.m_meanAbsoluteError.setText(DM4JNumericFormat.format(d, false, 10));
            Double d2 = RegressionTestMetricsViewer.this.m_testMetrics.getMeanActualValue();
            this.m_meanActualValue.setText(DM4JNumericFormat.format(d2, false, 10));
            Double d3 = RegressionTestMetricsViewer.this.m_testMetrics.getMeanPredictedValue();
            this.m_meanPredictedValue.setText(DM4JNumericFormat.format(d3, false, 10));
            Double d4 = RegressionTestMetricsViewer.this.m_testMetrics.getRMSError();
            this.m_RMSError.setText(DM4JNumericFormat.format(d4, false, 10));
        }
    }

    class RegressionTestTaskPanel
    extends GriddedPanel {
        protected JLabel m_name = new JLabel();
        protected JLabel m_target = new JLabel();
        protected JLabel m_type = new JLabel();
        protected HyperlinkButtonMiningResult m_modelNameBtn = new HyperlinkButtonMiningResult();
        protected JLabel m_inSchema = new JLabel();
        protected HyperlinkButtonDataSource m_inTable = new HyperlinkButtonDataSource();
        protected JLabel m_startDate = new JLabel();
        protected JLabel m_startTime = new JLabel();
        protected JLabel m_endDate = new JLabel();
        protected JLabel m_endTime = new JLabel();
        protected JLabel m_outSchema = new JLabel();
        protected HyperlinkButtonDataSource m_outTable = new HyperlinkButtonDataSource();
        protected JLabel m_filler = new JLabel();

        public RegressionTestTaskPanel() {
            int n = 1;
            JLabel jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_NAME"));
            this.addComponent(jLabel, TOPLABELITEMINSETS, n, 1);
            this.addComponent(this.m_name, TOPVALUEITEMINSETS, n++, 2);
            jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_TYPE"));
            this.addComponent(jLabel, MIDLABELITEMINSETS, n, 1);
            this.m_type = new JLabel(DM4JResourceUtilities.getUIString("TEST_RESULT_REGRESSION_MODEL_TEST"));
            this.addComponent(this.m_type, MIDVALUEITEMINSETS, n++, 2);
            jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_START_DATE"));
            this.addComponent(jLabel, MIDLABELITEMINSETS, n, 1);
            this.addComponent(this.m_startDate, MIDVALUEITEMINSETS, n++, 2);
            jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_START_TIME"));
            this.addComponent(jLabel, MIDLABELITEMINSETS, n, 1);
            this.addComponent(this.m_startTime, MIDVALUEITEMINSETS, n++, 2);
            jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_END_DATE"));
            this.addComponent(jLabel, MIDLABELITEMINSETS, n, 1);
            this.addComponent(this.m_endDate, MIDVALUEITEMINSETS, n++, 2);
            jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_END_TIME"));
            this.addComponent(jLabel, MIDLABELITEMINSETS, n, 1);
            this.addComponent(this.m_endTime, MIDVALUEITEMINSETS, n++, 2);
            jLabel = new JLabel(DM4JResourceUtilities.getUIString("TEST_RESULT_MODEL_NAME"));
            jLabel.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("TEST_RESULT_MODEL_NAME"));
            this.addComponent(jLabel, TOPLABELITEMINSETS, n, 1, 1, 1, 17, 0);
            this.addComponent(this.m_modelNameBtn, TOPVALUEITEMINSETS, n++, 2, 1, 1, 16, 0);
            jLabel.setLabelFor(this.m_modelNameBtn);
            jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_INPUT_DATA"));
            this.addComponent(jLabel, TOPLABELITEMINSETS, n++, 1);
            jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_SCHEMA"));
            this.addComponent(jLabel, MIDINDENTEDLABELITEMINSETS, n, 1);
            this.addComponent(this.m_inSchema, MIDVALUEITEMINSETS, n++, 2);
            jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_TABLE_OR_VIEW"));
            this.addComponent(jLabel, MIDINDENTEDLABELITEMINSETS, n, 1);
            this.addComponent(this.m_inTable, MIDVALUEITEMINSETS, n++, 2);
            jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_OUTPUT_DATA"));
            this.addComponent(jLabel, TOPLABELITEMINSETS, n++, 1);
            jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_SCHEMA"));
            this.addComponent(jLabel, MIDINDENTEDLABELITEMINSETS, n, 1);
            this.addComponent(this.m_outSchema, MIDVALUEITEMINSETS, n++, 2);
            jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_TABLE_OR_VIEW"));
            this.addComponent(jLabel, MIDINDENTEDLABELITEMINSETS, n, 1);
            this.addComponent(this.m_outTable, MIDVALUEITEMINSETS, n++, 2);
            this.addFilledComponent(new JLabel(" "), TOPLABELITEMINSETS, n, 1, 4, 2, 1);
            this.runTimePanelLoad();
        }

        public void runTimePanelLoad() {
            try {
                Object object;
                String string;
                String string2 = RegressionTestMetricsViewer.this.getTaskName();
                this.m_name.setText(string2);
                Date date = RegressionTestMetricsViewer.this.getCreationDate();
                Timestamp timestamp = RegressionTestMetricsViewer.this.getCompletionTimestamp();
                DateFormat dateFormat = DateFormat.getDateInstance(3, Locale.getDefault());
                String string3 = null;
                if (date != null) {
                    string3 = dateFormat.format(date);
                }
                this.m_startDate.setText(string3);
                dateFormat = DateFormat.getTimeInstance(3, Locale.getDefault());
                String string4 = null;
                if (date != null) {
                    string4 = dateFormat.format(date);
                }
                this.m_startTime.setText(string4);
                dateFormat = DateFormat.getDateInstance(3, Locale.getDefault());
                String string5 = dateFormat.format(timestamp);
                this.m_endDate.setText(string5);
                dateFormat = DateFormat.getTimeInstance(3, Locale.getDefault());
                String string6 = dateFormat.format(timestamp);
                this.m_endTime.setText(string6);
                String string7 = RegressionTestMetricsViewer.this.m_testMetrics.getModelName();
                if (string7 != null) {
                    string = string7.toUpperCase();
                    this.m_modelNameBtn.setText(string);
                    object = new LeafNodeData(string, "SVM_REGRESSION_MODEL");
                    this.m_modelNameBtn.setLeafNodeData((LeafNodeData)object);
                    this.m_modelNameBtn.addActionListener(new ActionListener(){

                        public final void actionPerformed(ActionEvent actionEvent) {
                            HyperlinkButtonMiningResult hyperlinkButtonMiningResult = (HyperlinkButtonMiningResult)actionEvent.getSource();
                            if (!hyperlinkButtonMiningResult.isActive()) {
                                return;
                            }
                            Object var3_3 = null;
                            try {
                                MiningResultViewerFrame miningResultViewerFrame = new MiningResultViewerFrame(hyperlinkButtonMiningResult);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                return;
                            }
                        }
                    });
                } else {
                    this.m_modelNameBtn.setText(DM4JResourceUtilities.getUIString("COMMON_NOT_AVAILABLE"));
                }
                string = RegressionTestMetricsViewer.this.getSchemaName();
                this.m_inSchema.setText(string);
                object = RegressionTestMetricsViewer.this.getInputTableName();
                this.m_inTable.setText((String)object);
                this.m_inTable.setSchemaName(DM4JStringUtils.trimDoubleQuotes(string));
                this.m_inTable.setTableName(DM4JStringUtils.trimDoubleQuotes((String)object));
                this.m_inTable.setActive(true);
                this.m_inTable.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        RegressionTestTaskPanel.this.selectOutputData_actionPerformed(actionEvent);
                    }
                });
                String string8 = RegressionTestMetricsViewer.this.getSchemaName();
                this.m_outSchema.setText(string8);
                String string9 = RegressionTestMetricsViewer.this.getTestOutputResultName();
                this.m_outTable.setText(string9);
                this.m_outTable.setSchemaName(DM4JStringUtils.trimDoubleQuotes(string8));
                this.m_outTable.setTableName(DM4JStringUtils.trimDoubleQuotes(string9));
                this.m_outTable.setActive(true);
                this.m_outTable.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        RegressionTestTaskPanel.this.selectOutputData_actionPerformed(actionEvent);
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private void selectOutputData_actionPerformed(ActionEvent actionEvent) {
            try {
                final HyperlinkButtonDataSource hyperlinkButtonDataSource = (HyperlinkButtonDataSource)actionEvent.getSource();
                Runnable runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Loose catch block
                     */
                    public void run() {
                        block10: {
                            java.sql.Connection connection = null;
                            connection = DM4JConnectionManager.getDbConnection();
                            if (DatabaseMetadata.isTable(connection, hyperlinkButtonDataSource.getSchemaName(), hyperlinkButtonDataSource.getTableName())) {
                                hyperlinkButtonDataSource.setIsView(false);
                            } else {
                                hyperlinkButtonDataSource.setIsView(true);
                            }
                            OutputDataViewerFrame outputDataViewerFrame = new OutputDataViewerFrame(hyperlinkButtonDataSource);
                            Object var4_4 = null;
                            try {
                                connection.close();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            break block10;
                            {
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                    Object var4_5 = null;
                                    try {
                                        connection.close();
                                    }
                                    catch (Exception exception2) {
                                        exception2.printStackTrace();
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                Object var4_6 = null;
                                try {
                                    connection.close();
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                                throw throwable;
                            }
                        }
                    }
                };
                Thread thread = new Thread(runnable);
                thread.setPriority(5);
                thread.start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

