/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.testMetrics;

import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.share.sort.NumberComparator;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JTruncatingNumberFormatPainter;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTable;
import oracle.dmt.dm4j.browser.viewer.testMetrics.ROCData;

public class ROCResultTable
extends Dm4jSpreadTable {
    private int[] m_colSortOrders = null;
    private int m_curSortOrder = 1;
    private ArrayList m_sortRowIndex;
    private String[] m_colNames = new String[]{"Index", DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_TABLE_PROB_THRESHOLD"), DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_TABLE_FALSE_POSITIVE"), DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_TABLE_FALSE_NEGATIVE"), DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_TABLE_TRUE_POSITIVE"), DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_TABLE_TRUE_NEGATIVE"), DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_TABLE_ACCURACY"), DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_TABLE_AVG_ACCURACY"), DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_TABLE_COST")};
    private int[] m_colWidths = new int[]{0, 13, 12, 12, 12, 12, 13, 13, 13};
    private SortableTwoDModel ROCResultTableModel = new SortableTwoDModel();

    public ROCResultTable() {
        super(null);
        this.setColumnNames(this.m_colNames);
        Grid grid = this.getGrid();
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 0, 0);
        grid.setGridSelectionManager(generalGridSelectionManager);
        try {
            this.displayLoadingStatus();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initSortIndex() {
        int n = this.ROCResultTableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            int n2 = (Integer)this.ROCResultTableModel.getData(0, i);
            this.m_sortRowIndex.add(i, new Integer(n2));
        }
    }

    private void updateSortIndex() {
        int n = this.ROCResultTableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            int n2 = (Integer)this.ROCResultTableModel.getData(0, i);
            this.m_sortRowIndex.set(n2, new Integer(i));
        }
    }

    public int getSortIndex(int n) {
        Integer n2 = null;
        n2 = (Integer)this.m_sortRowIndex.get(n);
        return n2 != null ? n2 : -1;
    }

    public int getOrgIndex(int n) {
        int n2 = (Integer)this.ROCResultTableModel.getData(0, n);
        return n2;
    }

    protected int getRowByOrgIndex(int n) {
        int n2 = this.ROCResultTableModel.getRowCount();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = (Integer)this.ROCResultTableModel.getData(0, i);
            if (n4 != n) continue;
            n3 = i;
            i = n2;
        }
        return n3;
    }

    public void refreshCost(Object object) {
        ArrayList arrayList = (ArrayList)object;
        int n = arrayList.size();
        int n2 = 8;
        for (int i = 0; i < n; ++i) {
            ROCData rOCData = (ROCData)arrayList.get(i);
            int n3 = this.getSortIndex(i);
            double d = rOCData.getCost();
            this.ROCResultTableModel.setData(n2, n3, new Double(d));
        }
        this.setModels((TwoDModel)this.ROCResultTableModel, this.getColModel(), null);
    }

    private void load(Object object) {
        this.setDataItem(object);
        ArrayList arrayList = (ArrayList)object;
        int n = arrayList.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            ROCData rOCData = (ROCData)arrayList.get(i);
            this.ROCResultTableModel.setData(n2++, i, new Integer(i));
            double d = rOCData.getProb();
            this.ROCResultTableModel.setData(n2++, i, new Double(d));
            double d2 = rOCData.getFalsePositives();
            this.ROCResultTableModel.setData(n2++, i, new Double(d2));
            double d3 = rOCData.getFalseNegatives();
            this.ROCResultTableModel.setData(n2++, i, new Double(d3));
            double d4 = rOCData.getTruePositives();
            this.ROCResultTableModel.setData(n2++, i, new Double(d4));
            double d5 = rOCData.getTrueNegatives();
            this.ROCResultTableModel.setData(n2++, i, new Double(d5));
            double d6 = rOCData.getAccuracy();
            this.ROCResultTableModel.setData(n2++, i, new Double(d6));
            double d7 = rOCData.getAvgAccuracy();
            this.ROCResultTableModel.setData(n2++, i, new Double(d7));
            double d8 = rOCData.getCost();
            this.ROCResultTableModel.setData(n2++, i, new Double(d8));
            n2 = 0;
        }
        this.setModels((TwoDModel)this.ROCResultTableModel, this.getColModel(), null);
    }

    public void init(Object object) throws Exception {
        this.setDataItem(object);
        ArrayList arrayList = (ArrayList)this.getDataItem();
        if (null == arrayList) {
            throw new Exception("Cannot load data.");
        }
        this.setVerticalSeparatorsVisible(true);
        ArrayList arrayList2 = arrayList;
        int n = arrayList2.size();
        this.ROCResultTableModel.addRows(0, n);
        this.ROCResultTableModel.addColumns(0, this.m_colNames.length);
        this.ROCResultTableModel.setDefaultComparator(NumberComparator.getComparator());
        this.load(arrayList);
        this.m_sortRowIndex = new ArrayList(n);
        this.initSortIndex();
        NumberFormat numberFormat = DM4JNumericFormat.getInstance(true, 0);
        NumberFormat numberFormat2 = DM4JNumericFormat.getInstance(true, 10, 10);
        NumberFormat numberFormat3 = DM4JNumericFormat.getInstance(true, 2, 2);
        DM4JTruncatingNumberFormatPainter dM4JTruncatingNumberFormatPainter = new DM4JTruncatingNumberFormatPainter(numberFormat);
        DM4JTruncatingNumberFormatPainter dM4JTruncatingNumberFormatPainter2 = new DM4JTruncatingNumberFormatPainter(numberFormat2);
        DM4JTruncatingNumberFormatPainter dM4JTruncatingNumberFormatPainter3 = new DM4JTruncatingNumberFormatPainter(numberFormat3);
        this.getGrid().setColumnPainter(1, dM4JTruncatingNumberFormatPainter2);
        this.getGrid().setColumnPainter(6, dM4JTruncatingNumberFormatPainter2);
        this.getGrid().setColumnPainter(7, dM4JTruncatingNumberFormatPainter2);
        this.getGrid().setColumnPainter(8, dM4JTruncatingNumberFormatPainter3);
        this.getGrid().setColumnPainter(2, dM4JTruncatingNumberFormatPainter);
        this.getGrid().setColumnPainter(3, dM4JTruncatingNumberFormatPainter);
        this.getGrid().setColumnPainter(4, dM4JTruncatingNumberFormatPainter);
        this.getGrid().setColumnPainter(5, dM4JTruncatingNumberFormatPainter);
        Header header = this.getColumnHeader();
        header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        header.setItemInputHandler(new SortHandler(this));
        header.setCanMoveItems(false);
        this.setColumnVisible(0, false);
        this.setColumnWidths(this.m_colWidths, true);
        n = this.m_colNames.length;
        this.m_colSortOrders = new int[n];
        for (int i = 0; i < n; ++i) {
            this.m_colSortOrders[i] = 0;
        }
    }

    private class SortHandler
    implements HeaderItemInputHandler {
        private ROCResultTable m_table;

        public SortHandler(ROCResultTable rOCResultTable2) {
            this.m_table = rOCResultTable2;
        }

        public void mousePressed(MouseEvent mouseEvent, Header header, int n) {
            try {
                int n2 = this.m_table.getGrid().getSelection().getSingleRow();
                int n3 = (Integer)ROCResultTable.this.ROCResultTableModel.getData(0, n2);
                int n4 = ROCResultTable.this.m_colSortOrders[n];
                if (n4 == -1) {
                    return;
                }
                if (n4 == 0) {
                    n4 = ROCResultTable.this.m_curSortOrder;
                } else if (n4 == 1) {
                    n4 = 2;
                } else if (n4 == 2) {
                    n4 = 1;
                }
                ((ROCResultTable)ROCResultTable.this).m_colSortOrders[n] = n4;
                ROCResultTable.this.m_curSortOrder = n4;
                ROCResultTable.this.ROCResultTableModel.sort(n, n4 == 1);
                this.m_table.updateSortIndex();
                this.m_table.setSelection(new TwoDSelection(ROCResultTable.this.getRowByOrgIndex(n3), true));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void mouseClicked(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseDragged(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseEntered(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseExited(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseMoved(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseReleased(MouseEvent mouseEvent, Header header, int n) {
        }
    }
}

