/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.testMetrics;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import javax.datamining.NamedObject;
import javax.datamining.data.CategorySet;
import javax.datamining.resource.Connection;
import javax.datamining.supervised.classification.ClassificationModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.grid.ComplexAppearanceManager;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderDataToolTipManager;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.util.ImmInsets;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JNumberTextField;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JTruncatingNumberFormatPainter;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTable;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTableExcelAdapter;
import oracle.dmt.dm4j.browser.viewer.activity.ROCThresholdSelectionPanel;
import oracle.dmt.dm4j.browser.viewer.export.ExportChartDialog;
import oracle.dmt.dm4j.browser.viewer.export.ExportDialog;
import oracle.dmt.dm4j.browser.viewer.testMetrics.ClassificationTestMetricsViewer;
import oracle.dmt.dm4j.browser.viewer.testMetrics.ROCData;
import oracle.dmt.dm4j.browser.viewer.testMetrics.ROCResultTable;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.dataView.GroupComponentHandle;
import oracle.dss.dataView.SeriesComponentHandle;
import oracle.dss.graph.Graph;
import oracle.dss.graph.ImagemapComponent;
import oracle.dss.util.DefaultErrorHandler;

public class ROCPanel
extends GriddedPanel {
    JScrollPane cmPanel = new JScrollPane();
    JScrollPane costmPanel = new JScrollPane();
    private JLabel m_name = new JLabel();
    private JLabel lblROCChart = new JLabel();
    private JLabel lblAreaUnderCurve = new JLabel();
    private JLabel lblConfusionMatrix = new JLabel();
    private JLabel lblMatrixHint = new JLabel();
    private JLabel lblHitRate = new JLabel();
    private JLabel lblFalseAlarmRate = new JLabel();
    private JLabel lblAvgAccuracy = new JLabel();
    private JLabel lblAccuracy = new JLabel();
    private JLabel lblCost = new JLabel();
    private JLabel lblThreshold = new JLabel();
    private JLabel lblFPCost = new JLabel();
    private JLabel lblFNCost = new JLabel();
    private JLabel lblROCTable = new JLabel();
    private DM4JNumberTextField areaUnderCurveValue = new DM4JNumberTextField();
    private DM4JNumberTextField hitRateValue = new DM4JNumberTextField();
    private DM4JNumberTextField falseAlarmRateValue = new DM4JNumberTextField();
    private DM4JNumberTextField avgAccuracyValue = new DM4JNumberTextField();
    private DM4JNumberTextField accuracyValue = new DM4JNumberTextField();
    private DM4JNumberTextField costValue = new DM4JNumberTextField();
    private DM4JNumberTextField thresholdValue = new DM4JNumberTextField();
    private JLabel lblCostMatrix = new JLabel();
    private JLabel lblCostMatrixHint = new JLabel();
    private DM4JNumberTextField txtFPCost = new DM4JNumberTextField();
    private DM4JNumberTextField txtFNCost = new DM4JNumberTextField();
    private JButton butCompute = new JButton();
    private JLabel filler = new JLabel();
    private ROCGraph m_chart;
    private JButton m_thresholdLeft;
    private JButton m_thresholdRight;
    private ArrayList ROCdata = new ArrayList();
    private int m_ROCdataSel = 0;
    private ROCResultTable m_ROCTable;
    private boolean m_bROCTableSelecting = false;
    private boolean m_bROCChartSelecting = false;
    private ConfusionMatrixTable m_cmTable;
    private CostMatrixTable m_costMatrixTable;
    private double m_FPCost;
    private double m_FNCost;
    private ClassificationTestMetricsViewer m_parent;
    private ROCThresholdSelectionPanel m_rocThresholdSelectionPanel = null;
    private CategorySet m_targetValues = null;
    private static int MAX_SAMPLE_SIZE = 1000;

    public ROCPanel(ClassificationTestMetricsViewer classificationTestMetricsViewer) {
        try {
            this.m_parent = classificationTestMetricsViewer;
            this.jbInit();
            this.runTimePanelLoad();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setThresholdSelectionPanel(ROCThresholdSelectionPanel rOCThresholdSelectionPanel) {
        this.m_rocThresholdSelectionPanel = rOCThresholdSelectionPanel;
    }

    public String getHelpId() {
        return "CLASS_TESTMETRICS_ROC";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSelectedThresholdValue(Double d) {
        this.thresholdValue.setNumber(d);
        if (d != null) {
            int n = 0;
            try {
                try {
                    for (int i = 0; i < this.ROCdata.size(); ++i) {
                        String string;
                        ROCData rOCData = (ROCData)this.ROCdata.get(i);
                        double d2 = rOCData.getProb();
                        String string2 = DM4JNumericFormat.format(d2, true, 10);
                        if (!string2.endsWith(string = DM4JNumericFormat.format(d, true, 10))) continue;
                        n = i;
                    }
                    Object var10_9 = null;
                }
                catch (Exception exception) {
                    Object var10_10 = null;
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                throw throwable;
            }
            this.m_chart.updateSelection(n);
            this.updateROCDataSelection(n);
        }
    }

    protected Double getSelectedThresholdValue() {
        return (Double)this.thresholdValue.getNumber();
    }

    protected SortableTwoDModel getCostMatrixTableModel() {
        if (this.m_costMatrixTable != null && this.getSelectedThresholdValue() != null) {
            return this.m_costMatrixTable.getCostMatrixHiddenTableModel();
        }
        return null;
    }

    protected ArrayOneDModel getColModel() {
        if (this.m_costMatrixTable != null && this.getSelectedThresholdValue() != null) {
            return this.m_costMatrixTable.getCostMatrixHiddenColumnNames();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void runTimePanelLoad() throws Exception {
        Object object;
        int n;
        block17: {
            String string = this.m_parent.getROCName();
            this.m_name.setText(string);
            this.m_FPCost = 1.0;
            this.m_FNCost = 1.0;
            this.txtFPCost.setNumber(new Double(this.m_FPCost));
            this.txtFNCost.setNumber(new Double(this.m_FNCost));
            int n2 = this.setData(this.m_chart);
            n = this.findLowestCostIndex();
            this.m_chart.updateROCDataPoints();
            double d = this.m_parent.getClassificationTestMetrics().getROC().getAreaUnderCurve();
            this.areaUnderCurveValue.setNumber(new Double(d));
            this.lblAreaUnderCurve.setText(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_CHART_AREA_UNDER_CURVE") + this.areaUnderCurveValue.getText());
            this.lblAreaUnderCurve.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("CLASS_TESTMETRICS_CHART_AREA_UNDER_CURVE"));
            this.m_cmTable.init(this.ROCdata.get(n));
            java.sql.Connection connection = null;
            Connection connection2 = null;
            ClassificationModel classificationModel = null;
            connection = DM4JConnectionManager.getDbConnection();
            connection2 = DM4JConnectionManager.getConnection();
            object = DMEMetadata.getInstance();
            String string2 = ((DMEMetadata)object).getModelNameForResult(connection, "TEST", this.m_parent.getName());
            if (string2 != null) {
                try {
                    classificationModel = (ClassificationModel)connection2.retrieveObject(string2.toUpperCase(), NamedObject.model);
                    this.m_targetValues = classificationModel.getTargetCategorySet();
                }
                catch (Exception exception) {
                }
            }
            Object var13_14 = null;
            try {
                if (connection != null) {
                    connection.close();
                }
                if (connection2 != null) {
                    connection2.close();
                }
                break block17;
            }
            catch (Exception exception) {}
            break block17;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var13_15 = null;
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                        if (connection2 != null) {
                            connection2.close();
                        }
                        break block17;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                try {
                    if (connection != null) {
                        connection.close();
                    }
                    if (connection2 != null) {
                        connection2.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        this.m_costMatrixTable.init(this.ROCdata.get(n));
        object = (ROCData)this.ROCdata.get(n);
        this.hitRateValue.setNumber(new Double(((ROCData)object).getTruePositivesFraction()));
        this.falseAlarmRateValue.setNumber(new Double(((ROCData)object).getFalsePositivesFraction()));
        this.avgAccuracyValue.setNumber(new Double(((ROCData)object).getAvgAccuracy()));
        this.accuracyValue.setNumber(new Double(((ROCData)object).getAccuracy()));
        this.costValue.setNumber(new Double(((ROCData)object).getCost()));
        this.thresholdValue.setNumber(new Double(((ROCData)object).getProb()));
        this.m_ROCTable.init(this.ROCdata);
        int n3 = this.m_ROCTable.getSortIndex(n);
        this.m_ROCTable.setSelection(new TwoDSelection(n3, true));
        this.m_ROCTable.setFirstRowOnScreen(n3);
        int n4 = this.m_cmTable.getDefaultColumnWidth();
        int n5 = this.m_cmTable.getDefaultRowHeight();
        this.cmPanel.setAutoscrolls(false);
        this.cmPanel.setMinimumSize(new Dimension(n4, n5 * 3 + n5 / 4));
        n4 = this.m_costMatrixTable.getDefaultColumnWidth();
        n5 = this.m_costMatrixTable.getDefaultRowHeight();
        this.costmPanel.setAutoscrolls(false);
        this.costmPanel.setMinimumSize(new Dimension(n4, n5 * 3 + n5 / 4));
    }

    private void jbInit() throws Exception {
        GriddedPanel griddedPanel = new GriddedPanel();
        int n = 1;
        JLabel jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_NAME"));
        griddedPanel.addComponent(jLabel, TOPLABELITEMINSETS, n, 1);
        griddedPanel.addComponent(this.m_name, TOPVALUEITEMINSETS, n++, 2);
        DefaultErrorHandler defaultErrorHandler = new DefaultErrorHandler();
        defaultErrorHandler.setDebugMode(255);
        this.m_chart = new ROCGraph(defaultErrorHandler);
        this.m_cmTable = new ConfusionMatrixTable();
        this.m_costMatrixTable = new CostMatrixTable();
        this.m_ROCTable = new ROCResultTable();
        Dimension dimension = new Dimension(60, 20);
        JPanel jPanel = new JPanel(new BorderLayout());
        this.lblROCChart.setLabelFor(this.m_chart);
        this.lblROCChart.setText(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_LIFT_CHART"));
        this.lblROCChart.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("CLASS_TESTMETRICS_LIFT_CHART"));
        JButton jButton = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/save.gif"));
        jButton.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_EXPORT"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
                    ExportChartDialog exportChartDialog = new ExportChartDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("COMMON_SAVE_FILE_AS"));
                    if (!exportChartDialog.isCancelled()) {
                        exportChartDialog.export(ROCPanel.this.m_chart);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel2.add((Component)griddedPanel, "West");
        jPanel3.add((Component)jPanel2, "North");
        jPanel3.add((Component)this.lblROCChart, "West");
        jPanel3.add((Component)jButton, "East");
        jPanel.add((Component)jPanel3, "North");
        this.m_chart.setGraphType(61);
        this.m_chart.setEnabled(false);
        this.m_chart.setLocale(Locale.getDefault());
        this.m_chart.setAutoLayout(2);
        this.m_chart.getX1Title().setText(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_CHART_X_FALSE_POSITIVE"));
        this.m_chart.getY1Title().setText(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_CHART_Y_TRUE_POSITIVE"));
        this.m_chart.getX1Axis().setAxisMaxAutoScaled(false);
        this.m_chart.getX1Axis().setAxisMaxValue(1.0);
        this.m_chart.getY1Axis().setAxisMaxAutoScaled(false);
        this.m_chart.getY1Axis().setAxisMaxValue(1.0);
        this.m_chart.getSeries().setDefaultMarkerShape(0);
        this.m_chart.setScatterDataLineDisplayed(true);
        jPanel.add((Component)this.m_chart, "Center");
        this.areaUnderCurveValue.setLocale(Locale.getDefault());
        this.areaUnderCurveValue.setDecimal(true, 10);
        this.areaUnderCurveValue.setDataType(Double.class);
        this.areaUnderCurveValue.setSigned(false);
        this.areaUnderCurveValue.setPreferredSize(dimension);
        this.areaUnderCurveValue.setMinimumSize(dimension);
        this.m_thresholdRight = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/right_e.gif"));
        this.m_thresholdRight.setToolTipText(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_CHART_RIGHT_ARROW"));
        this.m_thresholdRight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KeyEvent keyEvent = new KeyEvent(ROCPanel.this.m_chart, 0, 0L, 0, 39, 'R');
                ROCPanel.this.m_chart.keyPressed(keyEvent);
                ROCPanel.this.m_thresholdRight.setEnabled(ROCPanel.this.m_ROCdataSel != ROCPanel.this.ROCdata.size() - 1);
                ROCPanel.this.m_thresholdLeft.setEnabled(ROCPanel.this.m_ROCdataSel != 0);
            }
        });
        this.m_thresholdLeft = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/left_e.gif"));
        this.m_thresholdLeft.setToolTipText(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_CHART_LEFT_ARROW"));
        this.m_thresholdLeft.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KeyEvent keyEvent = new KeyEvent(ROCPanel.this.m_chart, 0, 0L, 0, 37, 'L');
                ROCPanel.this.m_chart.keyPressed(keyEvent);
                ROCPanel.this.m_thresholdRight.setEnabled(ROCPanel.this.m_ROCdataSel != ROCPanel.this.ROCdata.size() - 1);
                ROCPanel.this.m_thresholdLeft.setEnabled(ROCPanel.this.m_ROCdataSel != 0);
            }
        });
        JPanel jPanel4 = new JPanel(new GridLayout(0, 3));
        jPanel4.add(new JLabel());
        jPanel4.add(this.lblAreaUnderCurve);
        JPanel jPanel5 = new JPanel(new FlowLayout(4, 5, 0));
        jPanel5.add(this.m_thresholdLeft);
        jPanel5.add(this.m_thresholdRight);
        jPanel4.add(jPanel5);
        jPanel.add((Component)jPanel4, "South");
        JPanel jPanel6 = new JPanel(new GridBagLayout());
        int n2 = 0;
        int n3 = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = TOPLABELITEMINSETS;
        gridBagConstraints.gridx = n3;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.lblConfusionMatrix.setText(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_CHART_CONFUSION_MATRIX"));
        this.lblConfusionMatrix.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("CLASS_TESTMETRICS_CHART_CONFUSION_MATRIX"));
        this.lblConfusionMatrix.setLabelFor(this.m_cmTable);
        jPanel6.add((Component)this.lblConfusionMatrix, gridBagConstraints);
        n2 += gridBagConstraints.gridheight;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = MIDLABELITEMINSETS;
        gridBagConstraints.gridx = n3;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.cmPanel.getViewport().add(this.m_cmTable);
        jPanel6.add((Component)this.cmPanel, gridBagConstraints);
        n2 += gridBagConstraints.gridheight;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = MIDLABELITEMINSETS;
        gridBagConstraints.gridx = n3;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.lblMatrixHint.setText(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_CHART_CONFUSION_MATRIX_HINT"));
        jPanel6.add((Component)this.lblMatrixHint, gridBagConstraints);
        n2 += gridBagConstraints.gridheight;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = TOPLABELITEMINSETS;
        gridBagConstraints.gridx = n3;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.lblHitRate.setText(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_CHART_TRUE_POSITIVE"));
        this.lblHitRate.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("CLASS_TESTMETRICS_CHART_TRUE_POSITIVE"));
        this.lblHitRate.setLabelFor(this.hitRateValue);
        jPanel6.add((Component)this.lblHitRate, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = TOPVALUEITEMINSETS;
        gridBagConstraints.gridx = n3 += gridBagConstraints.gridwidth;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.hitRateValue.setLocale(Locale.getDefault());
        this.hitRateValue.setDecimal(true, 10);
        this.hitRateValue.setDataType(Double.class);
        this.hitRateValue.setSigned(false);
        this.hitRateValue.setPreferredSize(dimension);
        this.hitRateValue.setMinimumSize(dimension);
        jPanel6.add((Component)this.hitRateValue, gridBagConstraints);
        this.hitRateValue.setEditable(false);
        n3 = 0;
        n2 += gridBagConstraints.gridheight;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = MIDLABELITEMINSETS;
        gridBagConstraints.gridx = n3;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.lblFalseAlarmRate.setText(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_CHART_FALSE_POSITIVE"));
        this.lblFalseAlarmRate.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("CLASS_TESTMETRICS_CHART_FALSE_POSITIVE"));
        this.lblFalseAlarmRate.setLabelFor(this.falseAlarmRateValue);
        jPanel6.add((Component)this.lblFalseAlarmRate, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = MIDVALUEITEMINSETS;
        gridBagConstraints.gridx = n3 += gridBagConstraints.gridwidth;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.falseAlarmRateValue.setLocale(Locale.getDefault());
        this.falseAlarmRateValue.setDecimal(true, 10);
        this.falseAlarmRateValue.setDataType(Double.class);
        this.falseAlarmRateValue.setSigned(false);
        this.falseAlarmRateValue.setPreferredSize(dimension);
        this.falseAlarmRateValue.setMinimumSize(dimension);
        jPanel6.add((Component)this.falseAlarmRateValue, gridBagConstraints);
        this.falseAlarmRateValue.setEditable(false);
        n3 = 0;
        n2 += gridBagConstraints.gridheight;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = MIDLABELITEMINSETS;
        gridBagConstraints.gridx = n3;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.lblAvgAccuracy.setText(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_CHART_AVG_ACCURACY"));
        this.lblAvgAccuracy.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("CLASS_TESTMETRICS_CHART_AVG_ACCURACY"));
        this.lblAvgAccuracy.setLabelFor(this.avgAccuracyValue);
        jPanel6.add((Component)this.lblAvgAccuracy, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = MIDVALUEITEMINSETS;
        gridBagConstraints.gridx = n3 += gridBagConstraints.gridwidth;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.avgAccuracyValue.setLocale(Locale.getDefault());
        this.avgAccuracyValue.setDecimal(true, 10);
        this.avgAccuracyValue.setDataType(Double.class);
        this.avgAccuracyValue.setSigned(false);
        this.avgAccuracyValue.setPreferredSize(dimension);
        this.avgAccuracyValue.setMinimumSize(dimension);
        jPanel6.add((Component)this.avgAccuracyValue, gridBagConstraints);
        this.avgAccuracyValue.setEditable(false);
        n3 = 0;
        n2 += gridBagConstraints.gridheight;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = MIDLABELITEMINSETS;
        gridBagConstraints.gridx = n3;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.lblAccuracy.setText(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_CHART_ACCURACY"));
        this.lblAccuracy.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("CLASS_TESTMETRICS_CHART_ACCURACY"));
        this.lblAccuracy.setLabelFor(this.accuracyValue);
        jPanel6.add((Component)this.lblAccuracy, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = MIDVALUEITEMINSETS;
        gridBagConstraints.gridx = n3 += gridBagConstraints.gridwidth;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.accuracyValue.setLocale(Locale.getDefault());
        this.accuracyValue.setDecimal(true, 10);
        this.accuracyValue.setDataType(Double.class);
        this.accuracyValue.setSigned(false);
        this.accuracyValue.setPreferredSize(dimension);
        this.accuracyValue.setMinimumSize(dimension);
        jPanel6.add((Component)this.accuracyValue, gridBagConstraints);
        this.accuracyValue.setEditable(false);
        n3 = 0;
        n2 += gridBagConstraints.gridheight;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = MIDLABELITEMINSETS;
        gridBagConstraints.gridx = n3;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.lblCost.setText(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_CHART_COST"));
        this.lblCost.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("CLASS_TESTMETRICS_CHART_COST"));
        this.lblCost.setLabelFor(this.costValue);
        jPanel6.add((Component)this.lblCost, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = MIDVALUEITEMINSETS;
        gridBagConstraints.gridx = n3 += gridBagConstraints.gridwidth;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.costValue.setLocale(Locale.getDefault());
        this.costValue.setDecimal(true, 2);
        this.costValue.setDataType(Double.class);
        this.costValue.setPreferredSize(dimension);
        this.costValue.setMinimumSize(dimension);
        jPanel6.add((Component)this.costValue, gridBagConstraints);
        this.costValue.setEditable(false);
        n3 = 0;
        n2 += gridBagConstraints.gridheight;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = MIDLABELITEMINSETS;
        gridBagConstraints.gridx = n3;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.lblThreshold.setText(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_CHART_PROB_THRESHOLD"));
        this.lblThreshold.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("CLASS_TESTMETRICS_CHART_PROB_THRESHOLD"));
        this.lblThreshold.setLabelFor(this.thresholdValue);
        jPanel6.add((Component)this.lblThreshold, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = MIDVALUEITEMINSETS;
        gridBagConstraints.gridx = n3 += gridBagConstraints.gridwidth;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.thresholdValue.setLocale(Locale.getDefault());
        this.thresholdValue.setDecimal(true, 10);
        this.thresholdValue.setDataType(Double.class);
        this.thresholdValue.setSigned(false);
        this.thresholdValue.setPreferredSize(dimension);
        this.thresholdValue.setMinimumSize(dimension);
        jPanel6.add((Component)this.thresholdValue, gridBagConstraints);
        this.thresholdValue.setEditable(false);
        n3 = 0;
        n2 += gridBagConstraints.gridheight;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = TOPLABELITEMINSETS;
        gridBagConstraints.gridx = n3;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.lblCostMatrix.setText(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_CHART_COST_MATRIX"));
        this.lblCostMatrix.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("CLASS_TESTMETRICS_CHART_COST_MATRIX"));
        this.lblCostMatrix.setLabelFor(this.m_costMatrixTable);
        jPanel6.add((Component)this.lblCostMatrix, gridBagConstraints);
        n2 += gridBagConstraints.gridheight;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = MIDLABELITEMINSETS;
        gridBagConstraints.gridx = n3;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.costmPanel.getViewport().add(this.m_costMatrixTable);
        jPanel6.add((Component)this.costmPanel, gridBagConstraints);
        n2 += gridBagConstraints.gridheight;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = MIDLABELITEMINSETS;
        gridBagConstraints.gridx = n3;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.lblCostMatrixHint.setText(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_CHART_CONFUSION_MATRIX_HINT"));
        jPanel6.add((Component)this.lblCostMatrixHint, gridBagConstraints);
        n2 += gridBagConstraints.gridheight;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = MIDLABELITEMINSETS;
        gridBagConstraints.gridx = n3;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        jPanel6.add((Component)this.filler, gridBagConstraints);
        JPanel jPanel7 = new JPanel(new GridBagLayout());
        n2 = 0;
        n3 = 0;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = n3;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.lblROCTable.setText(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_TABLE_DATA_DETAIL"));
        this.lblROCTable.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("CLASS_TESTMETRICS_TABLE_DATA_DETAIL"));
        this.lblROCTable.setLabelFor(this.m_ROCTable);
        jPanel7.add((Component)this.lblROCTable, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = MIDLABELITEMINSETS;
        gridBagConstraints.gridx = n3 += gridBagConstraints.gridwidth;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.butCompute.setText(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_TABLE_COMPUTE_COST"));
        this.butCompute.setMnemonic(DM4JResourceUtilities.getUIMnemonic("CLASS_TESTMETRICS_TABLE_COMPUTE_COST"));
        this.butCompute.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ROCPanel.this.butCompute_actionPerformed(actionEvent);
            }
        });
        n2 += gridBagConstraints.gridheight;
        jButton = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/save.gif"));
        jButton.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_EXPORT"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
                    ExportDialog exportDialog = new ExportDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("COMMON_SAVE_FILE_AS"));
                    if (!exportDialog.isCancelled()) {
                        exportDialog.export(ROCPanel.this.m_ROCTable);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new FlowLayout(2, 5, 0));
        this.lblFPCost.setText(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_TABLE_FALSE_POSITIVE_COST"));
        this.lblFPCost.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("CLASS_TESTMETRICS_TABLE_FALSE_POSITIVE_COST"));
        jPanel8.add(this.lblFPCost);
        this.lblFPCost.setLabelFor(this.txtFPCost);
        this.txtFPCost.setLocale(Locale.getDefault());
        this.txtFPCost.setDecimal(true, 10);
        this.txtFPCost.setDataType(Double.class);
        jPanel8.add(this.txtFPCost);
        this.lblFNCost.setText(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_TABLE_FALSE_NEGATIVE_COST"));
        this.lblFNCost.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("CLASS_TESTMETRICS_TABLE_FALSE_NEGATIVE_COST"));
        jPanel8.add(this.lblFNCost);
        this.lblFNCost.setLabelFor(this.txtFNCost);
        this.txtFNCost.setLocale(Locale.getDefault());
        this.txtFNCost.setDecimal(true, 10);
        this.txtFNCost.setDataType(Double.class);
        jPanel8.add(this.txtFNCost);
        jPanel8.add(this.butCompute);
        jPanel8.add(jButton);
        this.txtFPCost.setPreferredSize(dimension);
        this.txtFPCost.setMinimumSize(dimension);
        this.txtFNCost.setPreferredSize(dimension);
        this.txtFNCost.setMinimumSize(dimension);
        jPanel7.add((Component)jPanel8, gridBagConstraints);
        n3 = 0;
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 1, 0);
        this.m_ROCTable.getGrid().setGridSelectionManager(generalGridSelectionManager);
        generalGridSelectionManager.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ROCPanel.this.m_bROCTableSelecting = true;
                TwoDSelection twoDSelection = (TwoDSelection)propertyChangeEvent.getNewValue();
                int n = twoDSelection.getRowSelection().getSingleItem();
                n = ROCPanel.this.m_ROCTable.getOrgIndex(n);
                if (!ROCPanel.this.m_bROCChartSelecting) {
                    ROCPanel.this.m_chart.updateSelection(n);
                    ROCPanel.this.updateROCDataSelection(n);
                }
                ROCPanel.this.m_bROCTableSelecting = false;
            }
        });
        Dm4jSpreadTableExcelAdapter dm4jSpreadTableExcelAdapter = new Dm4jSpreadTableExcelAdapter(this.m_ROCTable);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.m_ROCTable);
        jScrollPane.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = n3;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel7.add((Component)jScrollPane, gridBagConstraints);
        JSplitPane jSplitPane = new JSplitPane(1, jPanel, jPanel6);
        jSplitPane.setResizeWeight(0.8);
        JSplitPane jSplitPane2 = new JSplitPane(0, jSplitPane, jPanel7);
        jSplitPane2.setResizeWeight(0.8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.gridheight = 8;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jSplitPane2, gridBagConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateROCDataSelection(int n) {
        try {
            block5: {
                try {
                    int n2;
                    this.m_ROCdataSel = n;
                    this.m_bROCChartSelecting = true;
                    int n3 = this.m_ROCdataSel;
                    ROCData rOCData = (ROCData)this.ROCdata.get(n3);
                    this.hitRateValue.setNumber(new Double(rOCData.getTruePositivesFraction()));
                    this.falseAlarmRateValue.setNumber(new Double(rOCData.getFalsePositivesFraction()));
                    this.avgAccuracyValue.setNumber(new Double(rOCData.getAvgAccuracy()));
                    this.accuracyValue.setNumber(new Double(rOCData.getAccuracy()));
                    this.costValue.setNumber(new Double(rOCData.getCost()));
                    this.thresholdValue.setNumber(new Double(rOCData.getProb()));
                    this.m_cmTable.load(rOCData);
                    this.m_costMatrixTable.load(rOCData);
                    if (!this.m_bROCTableSelecting && (n2 = this.m_ROCTable.getSortIndex(n3)) >= 0) {
                        this.m_ROCTable.setSelection(new TwoDSelection(n2, true));
                        this.m_ROCTable.setFirstRowOnScreen(n2);
                        this.m_ROCTable.updateUI();
                    }
                    this.m_bROCChartSelecting = false;
                    if (this.m_rocThresholdSelectionPanel == null) break block5;
                    this.m_rocThresholdSelectionPanel.updateSelectedThresholdValue(this.getSelectedThresholdValue());
                }
                catch (Exception exception) {
                    Object var6_7 = null;
                }
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findLowestCostIndex() {
        double d = Double.MAX_VALUE;
        int n = 0;
        try {
            try {
                for (int i = 0; i < this.ROCdata.size(); ++i) {
                    ROCData rOCData = (ROCData)this.ROCdata.get(i);
                    double d2 = rOCData.getCost();
                    if (!(d2 < d)) continue;
                    d = d2;
                    n = i;
                }
                Object var9_7 = null;
            }
            catch (Exception exception) {
                Object var9_8 = null;
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            throw throwable;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void butCompute_actionPerformed(ActionEvent actionEvent) {
        try {
            try {
                int n;
                double d = Double.parseDouble(this.txtFPCost.getText());
                double d2 = Double.parseDouble(this.txtFNCost.getText());
                double d3 = Double.MAX_VALUE;
                int n2 = 0;
                for (n = 0; n < this.ROCdata.size(); ++n) {
                    ROCData rOCData = (ROCData)this.ROCdata.get(n);
                    rOCData.computeCost(d, d2);
                    double d4 = rOCData.getCost();
                    if (!(d4 < d3)) continue;
                    d3 = d4;
                    n2 = n;
                }
                this.m_ROCTable.refreshCost(this.ROCdata);
                n = this.m_ROCTable.getSortIndex(n2);
                this.m_ROCTable.setSelection(new TwoDSelection(n, true));
                this.m_ROCTable.setFirstRowOnScreen(n);
            }
            catch (Exception exception) {
                Object var14_11 = null;
            }
            Object var14_10 = null;
        }
        catch (Throwable throwable) {
            Object var14_12 = null;
            throw throwable;
        }
    }

    private int setData(ROCGraph rOCGraph) {
        try {
            rOCGraph.setDataRowShownAsASeries(false);
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
            int n = 0;
            double d = Double.MAX_VALUE;
            double d2 = 0.0;
            java.sql.Connection connection = DM4JConnectionManager.getDbConnection();
            String string = this.m_parent.getROCName();
            if (connection != null) {
                String string2 = "SELECT TRUNC(PROBABILITY,25) PROBABILITY, TRUNC(TRUE_POSITIVE_FRACTION,10) TRUE_POSITIVE_FRACTION, TRUNC(FALSE_POSITIVE_FRACTION,10) FALSE_POSITIVE_FRACTION, TRUE_POSITIVES, FALSE_NEGATIVES, FALSE_POSITIVES, TRUE_NEGATIVES FROM (SELECT t.*, ROWNUM RNUM FROM " + string + " t) " + "WHERE ORA_HASH(RNUM,((SELECT COUNT(*) FROM " + string + ")-1),12345) < " + MAX_SAMPLE_SIZE + " " + "ORDER BY FALSE_POSITIVE_FRACTION DESC, TRUE_POSITIVE_FRACTION DESC";
                Statement statement = connection.createStatement();
                if (statement != null) {
                    ResultSet resultSet = statement.executeQuery(string2);
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            double d3 = resultSet.getDouble("TRUE_POSITIVES");
                            double d4 = resultSet.getDouble("FALSE_NEGATIVES");
                            double d5 = resultSet.getDouble("FALSE_POSITIVES");
                            double d6 = resultSet.getDouble("TRUE_NEGATIVES");
                            double d7 = resultSet.getDouble("TRUE_POSITIVE_FRACTION");
                            double d8 = resultSet.getDouble("FALSE_POSITIVE_FRACTION");
                            double d9 = resultSet.getDouble("PROBABILITY");
                            ++n;
                            for (int i = 0; i < 2; ++i) {
                                Object[] objectArray = new Object[]{"ROC Curve", i == 0 ? "False_Positive_" + n : "True_Positive_" + n, i == 0 ? new Double(d8) : new Double(d7)};
                                arrayList.add(objectArray);
                            }
                            ROCData rOCData = new ROCData(d9, d3, d4, d5, d6, d7, d8);
                            rOCData.computeCost(this.m_FPCost, this.m_FNCost);
                            double d10 = rOCData.getCost();
                            if (d10 < d) {
                                d = d10;
                                d2 = d8;
                            }
                            this.ROCdata.add(0, rOCData);
                        }
                    } else {
                        System.out.println("ResultSet is null");
                    }
                    statement.close();
                } else {
                    System.out.println("Statement is null");
                }
                connection.close();
            }
            rOCGraph.setData(arrayList, d2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.ROCdata.size();
    }

    private class CostMatrixTable
    extends Dm4jSpreadTable {
        private boolean m_bShowFloats;
        private SortableTwoDModel costMatrixTableModel;
        private static final double THRESHOLD_ADJUSTMENT = (double)1.0E-6f;
        private ArrayOneDModel costMatrixHiddenColumnNames;
        private SortableTwoDModel costMatrixHiddenTableModel;

        public CostMatrixTable() {
            super(null);
            this.m_bShowFloats = false;
            this.costMatrixTableModel = new SortableTwoDModel();
            this.costMatrixHiddenColumnNames = null;
            this.costMatrixHiddenTableModel = null;
            String[] stringArray = new String[]{"Others", ROCPanel.this.m_parent.getTargetValue()};
            this.setColumnNames(stringArray);
            Grid grid = this.getGrid();
            GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 0, 0);
            grid.setGridSelectionManager(generalGridSelectionManager);
            try {
                this.displayLoadingStatus();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public SortableTwoDModel getCostMatrixHiddenTableModel() {
            return this.costMatrixHiddenTableModel;
        }

        public ArrayOneDModel getCostMatrixHiddenColumnNames() {
            return this.costMatrixHiddenColumnNames;
        }

        public void load(Object object) {
            this.setDataItem(object);
            ROCData rOCData = (ROCData)object;
            double d = rOCData.getProb() - (double)1.0E-6f;
            if (d < 0.0) {
                d = rOCData.getProb();
            }
            double d2 = (1.0 - d) / d;
            this.costMatrixTableModel.setData(0, 0, new Double(0.0));
            this.costMatrixTableModel.setData(1, 0, new Double(1.0));
            this.costMatrixTableModel.setData(0, 1, new Double(d2));
            this.costMatrixTableModel.setData(1, 1, new Double(0.0));
            this.setModels((TwoDModel)this.costMatrixTableModel, this.getColModel(), this.getColModel());
            if (ROCPanel.this.m_targetValues != null) {
                this.costMatrixHiddenColumnNames = new ArrayOneDModel(ROCPanel.this.m_targetValues.getValues());
                this.costMatrixHiddenTableModel = new SortableTwoDModel();
                int n = this.costMatrixHiddenColumnNames.getItemCount();
                this.costMatrixHiddenTableModel.addRows(0, n);
                this.costMatrixHiddenTableModel.addColumns(0, n);
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n; ++j) {
                        if (i == j) {
                            this.costMatrixHiddenTableModel.setData(j, i, new Double(0.0));
                            continue;
                        }
                        if (j == 0 && i > j) {
                            this.costMatrixHiddenTableModel.setData(j, i, new Double(d2));
                            continue;
                        }
                        this.costMatrixHiddenTableModel.setData(j, i, new Double(1.0));
                    }
                }
            }
        }

        public void init(Object object) throws Exception {
            this.setDataItem(object);
            ROCData rOCData = (ROCData)this.getDataItem();
            if (null == rOCData) {
                throw new Exception("Cannot load data. Data is not supplied");
            }
            this.setVerticalSeparatorsVisible(true);
            this.costMatrixTableModel.addRows(0, 2);
            this.costMatrixTableModel.addColumns(0, 2);
            this.load(rOCData);
            NumberFormat numberFormat = DM4JNumericFormat.getInstance(true, 9);
            DM4JTruncatingNumberFormatPainter dM4JTruncatingNumberFormatPainter = new DM4JTruncatingNumberFormatPainter(numberFormat);
            this.getGrid().setColumnPainter(0, dM4JTruncatingNumberFormatPainter);
            this.getGrid().setColumnPainter(1, dM4JTruncatingNumberFormatPainter);
            Header header = this.getColumnHeader();
            header.setToolTipManager(new ToolTipHeader(this.getColModel()));
            header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
            header.setCanMoveItems(false);
            this.setColumnWidths(null, false);
            Header header2 = this.getRowHeader();
            header2.setToolTipManager(new ToolTipHeader(this.getColModel()));
            int n = 0;
            Dimension dimension = null;
            Painter painter = this.getRowHeader().getDefaultPainter();
            int n2 = this.getRowHeader().getItemCount();
            for (int i = 0; i < n2; ++i) {
                int n3 = 0;
                PaintContext paintContext = this.getRowHeader().getItemPaintContext(i);
                dimension = painter.getPreferredSize(paintContext);
                Appearance appearance = this.getRowHeader().getItemAppearance(i);
                ImmInsets immInsets = appearance.getInsets();
                dimension.width += (n3 += 2 * (immInsets.left + immInsets.right));
                if (dimension.width <= n) continue;
                n = dimension.width;
            }
            this.setRowHeaderWidth(n);
            this.showColorDiagonal();
        }

        public void showColorDiagonal() throws Exception {
            int n;
            Grid grid = this.getGrid();
            SortableTwoDModel sortableTwoDModel = (SortableTwoDModel)grid.getModel();
            int n2 = sortableTwoDModel.getRowCount();
            if (n2 != (n = sortableTwoDModel.getColumnCount())) {
                throw new Exception("Table is not symmetrical.  Diagonal cannot be displayed");
            }
            ComplexAppearanceManager complexAppearanceManager = new ComplexAppearanceManager();
            grid.setAppearanceManager(complexAppearanceManager);
            for (int i = 0; i < n; ++i) {
                Appearance appearance = complexAppearanceManager.getCellAppearance(i, i);
                appearance.setBackground(new Color(173, 178, 206));
                appearance.setForeground(Color.black);
                complexAppearanceManager.setCellAppearance(i, i, appearance);
            }
        }

        class ToolTipHeader
        extends HeaderDataToolTipManager {
            ArrayOneDModel m_tips;

            ToolTipHeader(ArrayOneDModel arrayOneDModel) {
                this.m_tips = arrayOneDModel;
            }

            public String getItemToolTipValue(Header header, int n) {
                return (String)this.m_tips.getData(n);
            }
        }
    }

    private class ConfusionMatrixTable
    extends Dm4jSpreadTable {
        private boolean m_bShowFloats;
        private SortableTwoDModel confusionMatrixTableModel;

        public ConfusionMatrixTable() {
            super(null);
            this.m_bShowFloats = false;
            this.confusionMatrixTableModel = new SortableTwoDModel();
            String[] stringArray = new String[]{"Others", ROCPanel.this.m_parent.getTargetValue()};
            this.setColumnNames(stringArray);
            Grid grid = this.getGrid();
            GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 0, 0);
            grid.setGridSelectionManager(generalGridSelectionManager);
            try {
                this.displayLoadingStatus();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void load(Object object) {
            this.setDataItem(object);
            ROCData rOCData = (ROCData)object;
            this.confusionMatrixTableModel.setData(0, 0, new Double(rOCData.getTrueNegatives()));
            this.confusionMatrixTableModel.setData(1, 0, new Double(rOCData.getFalsePositives()));
            this.confusionMatrixTableModel.setData(0, 1, new Double(rOCData.getFalseNegatives()));
            this.confusionMatrixTableModel.setData(1, 1, new Double(rOCData.getTruePositives()));
            this.setModels((TwoDModel)this.confusionMatrixTableModel, this.getColModel(), this.getColModel());
        }

        public void init(Object object) throws Exception {
            this.setDataItem(object);
            ROCData rOCData = (ROCData)this.getDataItem();
            if (null == rOCData) {
                throw new Exception("Cannot load data. Data is not supplied");
            }
            this.setVerticalSeparatorsVisible(true);
            this.confusionMatrixTableModel.addRows(0, 2);
            this.confusionMatrixTableModel.addColumns(0, 2);
            this.load(rOCData);
            NumberFormat numberFormat = DM4JNumericFormat.getInstance(true, 0);
            DM4JTruncatingNumberFormatPainter dM4JTruncatingNumberFormatPainter = new DM4JTruncatingNumberFormatPainter(numberFormat);
            this.getGrid().setColumnPainter(0, dM4JTruncatingNumberFormatPainter);
            this.getGrid().setColumnPainter(1, dM4JTruncatingNumberFormatPainter);
            Header header = this.getColumnHeader();
            header.setToolTipManager(new ToolTipHeader(this.getColModel()));
            header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
            header.setCanMoveItems(false);
            this.setColumnWidths(null, false);
            Header header2 = this.getRowHeader();
            header2.setToolTipManager(new ToolTipHeader(this.getColModel()));
            int n = 0;
            Dimension dimension = null;
            Painter painter = this.getRowHeader().getDefaultPainter();
            int n2 = this.getRowHeader().getItemCount();
            for (int i = 0; i < n2; ++i) {
                int n3 = 0;
                PaintContext paintContext = this.getRowHeader().getItemPaintContext(i);
                dimension = painter.getPreferredSize(paintContext);
                Appearance appearance = this.getRowHeader().getItemAppearance(i);
                ImmInsets immInsets = appearance.getInsets();
                dimension.width += (n3 += 2 * (immInsets.left + immInsets.right));
                if (dimension.width <= n) continue;
                n = dimension.width;
            }
            this.setRowHeaderWidth(n);
            this.showColorDiagonal();
        }

        public void showColorDiagonal() throws Exception {
            int n;
            Grid grid = this.getGrid();
            SortableTwoDModel sortableTwoDModel = (SortableTwoDModel)grid.getModel();
            int n2 = sortableTwoDModel.getRowCount();
            if (n2 != (n = sortableTwoDModel.getColumnCount())) {
                throw new Exception("Table is not symmetrical.  Diagonal cannot be displayed");
            }
            ComplexAppearanceManager complexAppearanceManager = new ComplexAppearanceManager();
            grid.setAppearanceManager(complexAppearanceManager);
            for (int i = 0; i < n; ++i) {
                Appearance appearance = complexAppearanceManager.getCellAppearance(i, i);
                appearance.setBackground(new Color(173, 178, 206));
                appearance.setForeground(Color.black);
                complexAppearanceManager.setCellAppearance(i, i, appearance);
            }
        }

        class ToolTipHeader
        extends HeaderDataToolTipManager {
            ArrayOneDModel m_tips;

            ToolTipHeader(ArrayOneDModel arrayOneDModel) {
                this.m_tips = arrayOneDModel;
            }

            public String getItemToolTipValue(Header header, int n) {
                return (String)this.m_tips.getData(n);
            }
        }
    }

    private class ROCGraph
    extends Graph
    implements KeyListener,
    MouseListener,
    MouseMotionListener,
    ComponentListener {
        private int slider_x1;
        private int slider_x2;
        private int slider_y1;
        private int slider_y2;
        private int slider_ox1;
        private int slider_ox2;
        private int slider_oy1;
        private int slider_oy2;
        private boolean m_mousePressed;
        private ArrayList m_data;
        private int m_numROCPts;
        private int THRESHOLD_SERIES;
        private int DIAGONAL_SERIES;
        private int ROC_SERIES;

        public ROCGraph(DefaultErrorHandler defaultErrorHandler) {
            super(defaultErrorHandler);
            this.slider_x1 = 0;
            this.slider_x2 = 0;
            this.slider_y1 = 0;
            this.slider_y2 = 0;
            this.slider_ox1 = 0;
            this.slider_ox2 = 0;
            this.slider_oy1 = 0;
            this.slider_oy2 = 0;
            this.m_mousePressed = false;
            this.m_numROCPts = 0;
            this.THRESHOLD_SERIES = 0;
            this.DIAGONAL_SERIES = 1;
            this.ROC_SERIES = 2;
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addComponentListener(this);
            this.addKeyListener(this);
        }

        private void updateThresholdDataPoints(double d) {
            Double d2 = new Double(0.0);
            Double d3 = new Double(1.0);
            Double d4 = new Double(d);
            Object[] objectArray = null;
            int n = 0;
            objectArray = new Object[]{"Threshold", "False_Positive_1", d4};
            this.m_data.set(n++, objectArray);
            objectArray = new Object[]{"Threshold", "True_Positive_1", d3};
            this.m_data.set(n++, objectArray);
            for (int i = 2; i < this.m_numROCPts; ++i) {
                for (int j = 0; j < 2; ++j) {
                    objectArray = new Object[]{"Threshold", j == 0 ? "False_Positive_" + i : "True_Positive_" + i, j == 0 ? d4 : new Double((double)(this.m_numROCPts - i) / (double)this.m_numROCPts)};
                    this.m_data.set(n++, objectArray);
                }
            }
            objectArray = new Object[]{"Threshold", "False_Positive_" + this.m_numROCPts, d4};
            this.m_data.set(n++, objectArray);
            objectArray = new Object[]{"Threshold", "True_Positive_" + this.m_numROCPts, d2};
            this.m_data.set(n++, objectArray);
        }

        public void setData(ArrayList arrayList, double d) {
            int n;
            int n2;
            this.m_data = new ArrayList(arrayList);
            this.m_numROCPts = n2 = arrayList.size() / 2;
            Double d2 = new Double(0.0);
            Double d3 = new Double(1.0);
            Object[] objectArray = new Object[]{"Diagonal", "False_Positive_1", d3};
            this.m_data.add(0, objectArray);
            objectArray = new Object[]{"Diagonal", "True_Positive_1", d3};
            this.m_data.add(0, objectArray);
            for (int i = 2; i < n2; ++i) {
                for (n = 0; n < 2; ++n) {
                    objectArray = new Object[]{"Diagonal", n == 0 ? "False_Positive_" + i : "True_Positive_" + i, d2};
                    this.m_data.add(0, objectArray);
                }
            }
            objectArray = new Object[]{"Diagonal", "False_Positive_" + this.m_numROCPts, d2};
            this.m_data.add(0, objectArray);
            objectArray = new Object[]{"Diagonal", "True_Positive_" + this.m_numROCPts, d2};
            this.m_data.add(0, objectArray);
            Double d4 = new Double(d);
            objectArray = new Object[]{"Threshold", "False_Positive_1", d4};
            this.m_data.add(0, objectArray);
            objectArray = new Object[]{"Threshold", "True_Positive_1", d3};
            this.m_data.add(0, objectArray);
            for (n = 2; n < this.m_numROCPts; ++n) {
                for (int i = 0; i < 2; ++i) {
                    objectArray = new Object[]{"Threshold", i == 0 ? "False_Positive_" + n : "True_Positive_" + n, i == 0 ? d4 : new Double((double)(this.m_numROCPts - n) / (double)this.m_numROCPts)};
                    this.m_data.add(0, objectArray);
                }
            }
            objectArray = new Object[]{"Threshold", "False_Positive_" + this.m_numROCPts, d4};
            this.m_data.add(0, objectArray);
            objectArray = new Object[]{"Threshold", "True_Positive_" + this.m_numROCPts, d2};
            this.m_data.add(0, objectArray);
            this.setTabularData(this.m_data);
            try {
                this.getSeries().setColor(Color.blue, this.ROC_SERIES);
                this.getSeries().setColor(Color.black, this.DIAGONAL_SERIES);
                this.getSeries().setColor(Color.red, this.THRESHOLD_SERIES);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void updateROCDataPoints() {
            int n = this.getPresentationWidth();
            int n2 = this.getPresentationHeight();
            this.setImageSize(new Dimension(n, n2));
            int n3 = ROCPanel.this.ROCdata.size();
            this.getSeries().setDefaultMarkerShape(2);
            Enumeration enumeration = this.getImagemapEnumeration(1);
            int n4 = 0;
            while (enumeration.hasMoreElements()) {
                ImagemapComponent imagemapComponent = (ImagemapComponent)enumeration.nextElement();
                ComponentHandle componentHandle = imagemapComponent.getComponentHandle();
                int n5 = -1;
                int n6 = -1;
                if (componentHandle instanceof DataComponentHandle) {
                    n6 = ((DataComponentHandle)componentHandle).getGroup();
                    n5 = ((DataComponentHandle)componentHandle).getSeries();
                } else if (componentHandle instanceof SeriesComponentHandle) {
                    n5 = ((SeriesComponentHandle)componentHandle).getSeries();
                } else if (componentHandle instanceof GroupComponentHandle) {
                    n6 = ((GroupComponentHandle)componentHandle).getGroup();
                }
                if (n5 != this.ROC_SERIES) continue;
                int n7 = 0;
                int n8 = 0;
                Polygon polygon = imagemapComponent.getPlacement();
                if (polygon != null) {
                    n7 = (int)polygon.getBounds().getCenterX();
                    n8 = (int)polygon.getBounds().getCenterY();
                }
                ROCData rOCData = (ROCData)ROCPanel.this.ROCdata.get(n4);
                rOCData.setPoint(n7, n8);
                if (n4 == 0) {
                    this.slider_y1 = (int)imagemapComponent.getPlacement().getBounds().getCenterY();
                }
                if (n4 == n3 - 1) {
                    this.slider_y2 = (int)imagemapComponent.getPlacement().getBounds().getCenterY();
                }
                ++n4;
            }
            this.getSeries().setDefaultMarkerShape(0);
        }

        private void setLocation(int n) {
            this.slider_x1 = this.slider_x2 = n;
        }

        private int mapScreenPtToDataPt(int n) {
            int n2 = 0;
            int n3 = ROCPanel.this.ROCdata.size();
            int n4 = (int)((ROCData)ROCPanel.this.ROCdata.get(0)).getPoint().getX();
            int n5 = (int)((ROCData)ROCPanel.this.ROCdata.get(n3 - 1)).getPoint().getX();
            if (n <= n4) {
                this.slider_x1 = this.slider_x2 = n4;
                n2 = 0;
            } else if (n >= n5) {
                this.slider_x1 = this.slider_x2 = n5;
                n2 = n3 - 1;
            } else {
                for (int i = 0; i < n3 - 1; ++i) {
                    n4 = (int)((ROCData)ROCPanel.this.ROCdata.get(i)).getPoint().getX();
                    n5 = (int)((ROCData)ROCPanel.this.ROCdata.get(i + 1)).getPoint().getX();
                    if (n < n4 || n >= n5) continue;
                    int n6 = n - n4;
                    int n7 = n5 - n;
                    if (n6 <= n7) {
                        this.slider_x1 = this.slider_x2 = n4;
                        n2 = i;
                        break;
                    }
                    this.slider_x1 = this.slider_x2 = n5;
                    n2 = i + 1;
                    break;
                }
            }
            return n2;
        }

        private void updateSelection(int n) {
            ROCData rOCData = (ROCData)ROCPanel.this.ROCdata.get(n);
            this.updateThresholdDataPoints(rOCData.getFalsePositivesFraction());
            this.setTabularData(this.m_data);
            Point point = rOCData.getPoint();
            if (point != null) {
                this.setLocation(point.x);
            }
            this.repaint();
        }

        public void updateLocation(int n) {
            int n2 = this.mapScreenPtToDataPt(n);
            this.updateSelection(n2);
            ROCPanel.this.updateROCDataSelection(n2);
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this.m_mousePressed) {
                this.update(graphics);
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = ROCPanel.this.m_ROCdataSel;
            int n2 = ROCPanel.this.ROCdata.size();
            if (keyEvent.getKeyCode() == 39) {
                ++n;
            } else if (keyEvent.getKeyCode() == 37) {
                --n;
            }
            n = Math.max(0, Math.min(n, n2 - 1));
            this.updateSelection(n);
            ROCPanel.this.updateROCDataSelection(n);
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.updateROCDataPoints();
            int n = ROCPanel.this.m_ROCdataSel;
            Point point = ((ROCData)ROCPanel.this.ROCdata.get(n)).getPoint();
            if (point != null) {
                this.slider_x1 = this.slider_x2 = point.x;
            }
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        public void update(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = graphics2D.getColor();
            Stroke stroke = graphics2D.getStroke();
            if (this.slider_ox1 != this.slider_x1) {
                graphics2D.setColor(Color.white);
                graphics2D.drawLine(this.slider_ox1, this.slider_oy1, this.slider_ox2, this.slider_oy2);
            }
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.setColor(Color.red);
            graphics2D.drawLine(this.slider_x1, this.slider_y1, this.slider_x2, this.slider_y2);
            this.slider_ox1 = this.slider_x1;
            this.slider_ox2 = this.slider_x2;
            this.slider_oy1 = this.slider_y1;
            this.slider_oy2 = this.slider_y2;
            graphics2D.setColor(color);
            graphics2D.setStroke(stroke);
        }
    }
}

