/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.testMetrics;

import java.awt.Point;

class ROCData {
    private double m_prob;
    private double m_tp;
    private double m_fn;
    private double m_tn;
    private double m_fp;
    private double m_tpf;
    private double m_fpf;
    private double m_accuracy;
    private double m_avgAccuracy;
    private double m_cost;
    private Point m_pt;

    public ROCData(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.m_prob = d;
        this.m_tp = d2;
        this.m_fn = d3;
        this.m_tn = d5;
        this.m_fp = d4;
        this.m_tpf = d6;
        this.m_fpf = d7;
        this.m_accuracy = (this.m_tp + this.m_tn) / (this.m_tp + this.m_fp + this.m_tn + this.m_fn);
        this.m_avgAccuracy = (this.m_tp / (this.m_tp + this.m_fn) + this.m_tn / (this.m_tn + this.m_fp)) / 2.0;
        this.m_cost = 0.0;
    }

    public void computeCost(double d, double d2) {
        this.m_cost = d * this.m_fp + d2 * this.m_fn;
    }

    public double getProb() {
        return this.m_prob;
    }

    public double getTruePositives() {
        return this.m_tp;
    }

    public double getFalseNegatives() {
        return this.m_fn;
    }

    public double getFalsePositives() {
        return this.m_fp;
    }

    public double getTrueNegatives() {
        return this.m_tn;
    }

    public double getTruePositivesFraction() {
        return this.m_tpf;
    }

    public double getFalsePositivesFraction() {
        return this.m_fpf;
    }

    public double getAccuracy() {
        return this.m_accuracy;
    }

    public double getAvgAccuracy() {
        return this.m_avgAccuracy;
    }

    public double getCost() {
        return this.m_cost;
    }

    public void setPoint(int n, int n2) {
        this.m_pt = new Point(n, n2);
    }

    public Point getPoint() {
        return this.m_pt;
    }
}

