/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.testMetrics;

import java.awt.Color;
import java.awt.Dimension;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.grid.ComplexAppearanceManager;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderDataToolTipManager;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.ImmInsets;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTable;
import oracle.dmt.dm4j.browser.viewer.testMetrics.ClassificationTestMetricsViewer;
import oracle.dmt.dm4j.browser.viewer.testMetrics.ConfusionMatrixPanel;
import oracle.dmt.dm4j.browser.viewer.testMetrics.ConfusionMatrixTableModel;
import oracle.dmt.dm4j.browser.viewer.testMetrics.SummarizedConfusionMatrixTableModel;

public final class ConfusionMatrixTable
extends Dm4jSpreadTable {
    private boolean m_bShowCost = false;
    private boolean m_bShowFloats = true;
    private ClassificationTestMetricsViewer m_parent;
    private SummarizedConfusionMatrixTableModel m_scmModel;
    private ConfusionMatrixTableModel m_cmTableModel;

    public ConfusionMatrixTable(ClassificationTestMetricsViewer classificationTestMetricsViewer, SummarizedConfusionMatrixTableModel summarizedConfusionMatrixTableModel) {
        super(null);
        this.m_parent = classificationTestMetricsViewer;
        this.m_scmModel = summarizedConfusionMatrixTableModel;
        Grid grid = this.getGrid();
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 0, 0);
        grid.setGridSelectionManager(generalGridSelectionManager);
    }

    public void load(boolean bl) throws Exception {
        this.m_bShowCost = bl;
        this.setVerticalSeparatorsVisible(true);
        this.m_cmTableModel = new ConfusionMatrixTableModel(this.m_parent, this.m_scmModel);
        this.m_cmTableModel.setShowFloats(this.m_bShowFloats);
        this.m_cmTableModel.load(this);
        Header header = this.getColumnHeader();
        header.setToolTipManager(new ToolTipHeader(this.getColModel()));
        header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        header.setCanMoveItems(false);
        Header header2 = this.getRowHeader();
        header2.setToolTipManager(new ToolTipHeader(this.getColModel()));
        int n = 0;
        Dimension dimension = null;
        Painter painter = this.getRowHeader().getDefaultPainter();
        for (int i = 0; i < this.getRowHeader().getItemCount(); ++i) {
            int n2 = 0;
            PaintContext paintContext = this.getRowHeader().getItemPaintContext(i);
            dimension = painter.getPreferredSize(paintContext);
            Appearance appearance = this.getRowHeader().getItemAppearance(i);
            ImmInsets immInsets = appearance.getInsets();
            dimension.width += (n2 += 2 * (immInsets.left + immInsets.right));
            if (dimension.width <= n) continue;
            n = dimension.width;
        }
        this.setRowHeaderWidth(n);
        this.showCost(this.m_bShowCost);
    }

    public void showColorDiagonal() throws Exception {
        Appearance appearance;
        int n;
        int n2;
        Object object;
        int n3;
        Grid grid = this.getGrid();
        int n4 = this.m_cmTableModel.getRowCount();
        if (n4 != (n3 = this.m_cmTableModel.getColumnCount())) {
            throw new Exception("Table is not symmetrical.  Diagonal cannot be displayed");
        }
        ComplexAppearanceManager complexAppearanceManager = new ComplexAppearanceManager();
        grid.setAppearanceManager(complexAppearanceManager);
        for (int i = 0; i < n3 - 3; ++i) {
            object = complexAppearanceManager.getCellAppearance(i, i);
            ((Appearance)object).setBackground(new Color(173, 178, 206));
            ((Appearance)object).setForeground(Color.black);
            complexAppearanceManager.setCellAppearance(i, i, (Appearance)object);
        }
        ConfusionMatrixPanel confusionMatrixPanel = (ConfusionMatrixPanel)this.m_parent.getComponentAt(1);
        object = confusionMatrixPanel.getBackground();
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = n3 - 3; n < n3; ++n) {
                appearance = complexAppearanceManager.getCellAppearance(n, n2);
                appearance.setBackground((Color)object);
                complexAppearanceManager.setCellAppearance(n, n2, appearance);
            }
        }
        for (n2 = n3 - 3; n2 < n3; ++n2) {
            for (n = 0; n < n3 - 3; ++n) {
                appearance = complexAppearanceManager.getCellAppearance(n, n2);
                appearance.setBackground((Color)object);
                complexAppearanceManager.setCellAppearance(n, n2, appearance);
            }
        }
    }

    public void showCost(boolean bl) {
        try {
            this.setColumnVisible(this.m_cmTableModel.getRecallTotalColIdx(), bl);
            this.setColumnVisible(this.m_cmTableModel.getRecallColIdx(), bl);
            this.setColumnVisible(this.m_cmTableModel.getRecallCostColIdx(), bl);
            this.setRowVisible(this.m_cmTableModel.getPrecisionTotalRowIdx(), bl);
            this.setRowVisible(this.m_cmTableModel.getPrecisionRowIdx(), bl);
            this.setRowVisible(this.m_cmTableModel.getPrecisionCostRowIdx(), bl);
            this.m_bShowCost = bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setShowFloats(boolean bl) {
        this.m_bShowFloats = bl;
    }

    class ToolTipHeader
    extends HeaderDataToolTipManager {
        ArrayOneDModel m_tips;

        ToolTipHeader(ArrayOneDModel arrayOneDModel) {
            this.m_tips = arrayOneDModel;
        }

        public String getItemToolTipValue(Header header, int n) {
            return (String)this.m_tips.getData(n);
        }
    }
}

