/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.testMetrics;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Date;
import javax.datamining.JDMException;
import javax.datamining.resource.Connection;
import javax.datamining.supervised.classification.ClassificationTestMetrics;
import javax.datamining.supervised.classification.ConfusionMatrix;
import javax.datamining.supervised.classification.Lift;
import javax.datamining.supervised.classification.ReceiverOperatingCharacterics;
import javax.swing.AbstractAction;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.viewer.LoadingStatusPanel;
import oracle.dmt.dm4j.browser.viewer.testMetrics.CPredictiveConfidencePanel;
import oracle.dmt.dm4j.browser.viewer.testMetrics.ConfusionMatrixPanel;
import oracle.dmt.dm4j.browser.viewer.testMetrics.LiftPanel;
import oracle.dmt.dm4j.browser.viewer.testMetrics.ROCPanel;
import oracle.dmt.dm4j.browser.viewer.testMetrics.SettingsPanel;
import oracle.dmt.dm4j.browser.viewer.testMetrics.TaskPanel;
import oracle.dmt.dm4j.datasources.DMEMetadata;

public class ClassificationTestMetricsViewer
extends JTabbedPane {
    static int PC_TAB = 0;
    static int CM_TAB = 1;
    static int ROC_TAB = 2;
    static int LIFT_TAB = 3;
    static int SETTINGS_TAB = 4;
    static int TASK_TAB = 5;
    static int NUM_TAB = 6;
    int[] m_tabIndex;
    CPredictiveConfidencePanel m_predConfPanel;
    TaskPanel m_taskPanel;
    SettingsPanel m_settingsPanel;
    ConfusionMatrixPanel m_confusionMatrixPanel;
    ROCPanel m_ROCPanel;
    LiftPanel m_LiftPanel;
    protected LeafNodeData m_node;
    protected Connection m_dmeConn = null;
    protected String m_confusionMatrixName = null;
    protected String m_ROCName = null;
    protected String m_liftName = null;
    protected String m_targetValue = null;
    protected ClassificationTestMetrics m_testMetrics = null;
    protected ReceiverOperatingCharacterics m_roc = null;
    protected ConfusionMatrix m_confusionMatrix = null;
    protected Lift m_lift = null;
    protected String m_taskName = null;
    protected String m_name = null;
    protected Timestamp m_startingTimestamp;
    protected Timestamp m_completionTimestamp;
    protected String m_creatorInfo = "";
    protected String m_inputTableName;
    protected String m_inputSchemaNamea;
    protected String m_testOutputResultName;

    public ClassificationTestMetrics getClassificationTestMetrics() {
        return this.m_testMetrics;
    }

    public String getName() {
        return this.m_name;
    }

    public String getTaskName() {
        return this.m_taskName;
    }

    public String getConfusionMatrixName() {
        return this.m_confusionMatrixName;
    }

    public String getROCName() {
        return this.m_ROCName;
    }

    public String getLiftName() {
        return this.m_liftName;
    }

    public String getTargetValue() {
        return this.m_targetValue;
    }

    protected void setCreatorInfo(String string) throws JDMException {
        this.m_creatorInfo = string;
    }

    public String getCreatorInfo() {
        return this.m_creatorInfo;
    }

    protected void setCreationDate(Date date) throws JDMException {
        this.m_startingTimestamp = new Timestamp(date.getTime());
    }

    public Date getCreationDate() {
        if (this.m_startingTimestamp == null) {
            return null;
        }
        return new Date(this.m_startingTimestamp.getTime());
    }

    protected void setCompletionTimestamp(Date date) {
        this.m_completionTimestamp = new Timestamp(date.getTime());
    }

    public Timestamp getCompletionTimestamp() {
        return this.m_completionTimestamp;
    }

    protected void setInputTableName(String string) {
        this.m_inputTableName = string;
    }

    public String getInputTableName() {
        return this.m_inputTableName;
    }

    protected void setInputSchemaName(String string) {
        this.m_inputSchemaNamea = string;
    }

    public String getSchemaName() {
        return this.m_inputSchemaNamea;
    }

    protected void setTestOutputResultName(String string) {
        this.m_testOutputResultName = string;
    }

    public String getTestOutputResultName() {
        return this.m_testOutputResultName;
    }

    public ClassificationTestMetricsViewer(LeafNodeData leafNodeData, Connection connection, int n) throws Exception {
        Thread thread = new Thread(new LoadViewer(leafNodeData, connection, n, this));
        thread.setPriority(5);
        thread.start();
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = ClassificationTestMetricsViewer.this.getHelpId();
                if (string != null) {
                    BrowserFrame.getCSHManager().showTopic(string);
                }
            }
        };
        this.addTab(DM4JResourceUtilities.getUIString("COMMON_LOADING"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("COMMON_LOADING"));
        this.setMinimumSize(BrowserFrame.m_prefRightPaneSize);
    }

    public Connection getConnection() {
        return this.m_dmeConn;
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.m_dmeConn != null) {
            try {
                this.m_dmeConn.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public String getHelpId() {
        int n = this.getSelectedIndex();
        GriddedPanel griddedPanel = (GriddedPanel)this.getComponentAt(n);
        return griddedPanel.getHelpId();
    }

    protected void loadViewer(LeafNodeData leafNodeData, int n) throws Exception {
        ClassificationTestMetrics classificationTestMetrics = this.getClassificationTestMetrics();
        int n2 = 0;
        this.m_tabIndex = new int[NUM_TAB];
        if (this.m_confusionMatrix != null) {
            this.addTab(DM4JResourceUtilities.getUIString("TESTMETRICS_PC_TAB"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("TESTMETRICS_PC_TAB"));
            this.m_tabIndex[n2++] = PC_TAB;
        }
        if (this.m_confusionMatrix != null) {
            this.addTab(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_CM_TAB"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_CM_TAB"));
            this.m_tabIndex[n2++] = CM_TAB;
        }
        if (this.m_ROCName != null) {
            this.addTab(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_ROC_TAB"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_ROC_TAB"));
            this.m_tabIndex[n2++] = ROC_TAB;
        }
        if (this.m_lift != null) {
            this.addTab(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_LIFT_TAB"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_LIFT_TAB"));
            this.m_tabIndex[n2++] = LIFT_TAB;
        }
        if (classificationTestMetrics != null) {
            this.addTab(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_SETTINGS_TAB"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_SETTINGS_TAB"));
            this.m_tabIndex[n2++] = SETTINGS_TAB;
        }
        if (classificationTestMetrics != null) {
            this.addTab(DM4JResourceUtilities.getUIString("RESULT_TASK_TAB"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("RESULT_TASK_TAB"));
            this.m_tabIndex[n2++] = TASK_TAB;
        }
        this.showTab(n);
        this.setSelectedIndex(n);
    }

    protected void showTab(int n) {
        Thread thread = new Thread(new LoadTab(n, this));
        thread.setPriority(5);
        thread.start();
    }

    class LoadViewer
    implements Runnable {
        LeafNodeData nd;
        Connection dmeConn;
        int tabIndex;
        ClassificationTestMetricsViewer parent;

        public LoadViewer(LeafNodeData leafNodeData, Connection connection, int n, ClassificationTestMetricsViewer classificationTestMetricsViewer2) {
            this.nd = leafNodeData;
            this.dmeConn = connection;
            this.tabIndex = n;
            this.parent = classificationTestMetricsViewer2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block27: {
                Object object;
                String string;
                Object object2;
                String string2 = "SELECT METRIC_NAME, METRIC_VARCHAR_VALUE, METRIC_NUM_VALUE FROM " + (DM4JStringUtils.isDoubleQuotedString(this.nd.getName()) ? this.nd.getName() : DM4JStringUtils.addDoubleQuotes(this.nd.getName()));
                PreparedStatement preparedStatement = null;
                ResultSet resultSet = null;
                ClassificationTestMetricsViewer.this.m_node = this.nd;
                ClassificationTestMetricsViewer.this.m_dmeConn = this.dmeConn;
                java.sql.Connection connection = null;
                connection = DM4JConnectionManager.getDbConnection();
                preparedStatement = connection.prepareStatement(string2);
                resultSet = preparedStatement.executeQuery();
                ClassificationTestMetricsViewer.this.m_name = ClassificationTestMetricsViewer.this.m_node.getName();
                while (resultSet.next()) {
                    object2 = resultSet.getString("METRIC_NAME");
                    string = resultSet.getString("METRIC_VARCHAR_VALUE");
                    object = resultSet.getString("METRIC_NUM_VALUE");
                    if (((String)object2).equals("CONFUSION_MATRIX_TABLE")) {
                        ClassificationTestMetricsViewer.this.m_confusionMatrixName = string;
                        continue;
                    }
                    if (((String)object2).equals("ROC_TABLE")) {
                        ClassificationTestMetricsViewer.this.m_ROCName = string;
                        continue;
                    }
                    if (((String)object2).equals("LIFT_TABLE")) {
                        ClassificationTestMetricsViewer.this.m_liftName = string;
                        continue;
                    }
                    if (!((String)object2).equals("POSITIVE_TARGET_VALUE")) continue;
                    if (string != null) {
                        ClassificationTestMetricsViewer.this.m_targetValue = string;
                        continue;
                    }
                    ClassificationTestMetricsViewer.this.m_targetValue = object;
                }
                ClassificationTestMetricsViewer.this.m_testMetrics = (ClassificationTestMetrics)this.nd.getOdmObject();
                try {
                    ClassificationTestMetricsViewer.this.m_confusionMatrix = ClassificationTestMetricsViewer.this.m_testMetrics.getConfusionMatrix();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    ClassificationTestMetricsViewer.this.m_lift = ClassificationTestMetricsViewer.this.m_testMetrics.getLift();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                object2 = DMEMetadata.getInstance();
                string = ((DMEMetadata)object2).getTaskNameForMiningObject(connection, "TEST", ClassificationTestMetricsViewer.this.m_name);
                if (string != null) {
                    ClassificationTestMetricsViewer.this.m_taskName = string;
                }
                object = new Runnable(){

                    public void run() {
                        try {
                            if (LoadViewer.this.tabIndex >= 0) {
                                LoadViewer.this.parent.removeTabAt(LoadViewer.this.tabIndex);
                            }
                            ClassificationTestMetricsViewer.this.loadViewer(LoadViewer.this.nd, LoadViewer.this.tabIndex);
                            LoadViewer.this.parent.addChangeListener(new tabChangeListener());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                };
                EventQueue.invokeLater((Runnable)object);
                Object var9_11 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                    break block27;
                }
                catch (Exception exception) {}
                break block27;
                {
                    catch (Exception exception) {
                        exception.printStackTrace();
                        Object var9_12 = null;
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                            if (preparedStatement != null) {
                                preparedStatement.close();
                            }
                            if (connection != null) {
                                connection.close();
                            }
                            break block27;
                        }
                        catch (Exception exception2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }

    class LoadTab
    implements Runnable {
        int tabIndex;
        GriddedPanel panel;
        ClassificationTestMetricsViewer viewer;

        public LoadTab(int n, ClassificationTestMetricsViewer classificationTestMetricsViewer2) {
            this.viewer = classificationTestMetricsViewer2;
            this.tabIndex = n;
        }

        public void run() {
            try {
                ClassificationTestMetrics classificationTestMetrics = (ClassificationTestMetrics)ClassificationTestMetricsViewer.this.m_node.getOdmObject();
                Object var2_3 = null;
                ConfusionMatrix confusionMatrix = null;
                Lift lift = null;
                this.panel = null;
                try {
                    confusionMatrix = classificationTestMetrics.getConfusionMatrix();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    lift = classificationTestMetrics.getLift();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.tabIndex >= 0) {
                    if (ClassificationTestMetricsViewer.this.m_tabIndex[this.tabIndex] == PC_TAB && classificationTestMetrics != null) {
                        if (ClassificationTestMetricsViewer.this.m_predConfPanel == null) {
                            ClassificationTestMetricsViewer.this.m_predConfPanel = new CPredictiveConfidencePanel(this.viewer);
                        }
                        this.panel = ClassificationTestMetricsViewer.this.m_predConfPanel;
                    } else if (ClassificationTestMetricsViewer.this.m_tabIndex[this.tabIndex] == TASK_TAB && classificationTestMetrics != null) {
                        if (ClassificationTestMetricsViewer.this.m_taskPanel == null) {
                            ClassificationTestMetricsViewer.this.m_taskPanel = new TaskPanel(this.viewer);
                        }
                        this.panel = ClassificationTestMetricsViewer.this.m_taskPanel;
                    } else if (ClassificationTestMetricsViewer.this.m_tabIndex[this.tabIndex] == SETTINGS_TAB && classificationTestMetrics != null) {
                        if (ClassificationTestMetricsViewer.this.m_settingsPanel == null) {
                            ClassificationTestMetricsViewer.this.m_settingsPanel = new SettingsPanel(this.viewer);
                        }
                        this.panel = ClassificationTestMetricsViewer.this.m_settingsPanel;
                    } else if (ClassificationTestMetricsViewer.this.m_tabIndex[this.tabIndex] == CM_TAB && confusionMatrix != null) {
                        if (ClassificationTestMetricsViewer.this.m_confusionMatrixPanel == null) {
                            ClassificationTestMetricsViewer.this.m_confusionMatrixPanel = new ConfusionMatrixPanel(this.viewer);
                        }
                        this.panel = ClassificationTestMetricsViewer.this.m_confusionMatrixPanel;
                    } else if (ClassificationTestMetricsViewer.this.m_tabIndex[this.tabIndex] == ROC_TAB && ClassificationTestMetricsViewer.this.m_ROCName != null) {
                        if (ClassificationTestMetricsViewer.this.m_ROCPanel == null) {
                            ClassificationTestMetricsViewer.this.m_ROCPanel = new ROCPanel(this.viewer);
                        }
                        this.panel = ClassificationTestMetricsViewer.this.m_ROCPanel;
                    } else if (ClassificationTestMetricsViewer.this.m_tabIndex[this.tabIndex] == LIFT_TAB && lift != null) {
                        if (ClassificationTestMetricsViewer.this.m_LiftPanel == null) {
                            ClassificationTestMetricsViewer.this.m_LiftPanel = new LiftPanel(this.viewer);
                        }
                        this.panel = ClassificationTestMetricsViewer.this.m_LiftPanel;
                    }
                    Runnable runnable = new Runnable(){

                        public void run() {
                            ClassificationTestMetricsViewer.this.setComponentAt(LoadTab.this.tabIndex, LoadTab.this.panel);
                        }
                    };
                    EventQueue.invokeLater(runnable);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class tabChangeListener
    implements ChangeListener {
        tabChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            ClassificationTestMetricsViewer.this.showTab(((JTabbedPane)changeEvent.getSource()).getSelectedIndex());
        }
    }
}

