/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.testMetrics;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.sql.Connection;
import java.text.NumberFormat;
import javax.datamining.supervised.classification.ClassificationTestMetrics;
import javax.datamining.supervised.regression.RegressionTestMetrics;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.charts.piechart.Gauge;
import oracle.charts.types.ChartException;
import oracle.charts.types.PieSliceDesc;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.viewer.testMetrics.ClassificationTestMetricsViewer;
import oracle.dmt.dm4j.browser.viewer.testMetrics.RegressionTestMetricsViewer;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.wizard.director.minings.ClassificationModelLiftBuilder;
import oracle.dmt.dm4j.wizard.director.minings.RegressionModelTestBuilder;

public class CPredictiveConfidencePanel
extends GriddedPanel {
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JLabel m_name = new JLabel();
    JLabel m_accuracy = new JLabel();
    ClassificationTestMetricsViewer m_classTestMetricsViewer = null;
    RegressionTestMetricsViewer m_regressTestMetricsViewer = null;
    static PieSliceDesc[] GaugeRegions = new PieSliceDesc[]{new PieSliceDesc(DM4JResourceUtilities.getUIString("TESTMETRICS_PC_BEST"), 34.0), new PieSliceDesc(DM4JResourceUtilities.getUIString("TESTMETRICS_PC_GOOD"), 33.0), new PieSliceDesc(DM4JResourceUtilities.getUIString("TESTMETRICS_PC_AVG"), 33.0)};
    static int Display_height = 300;
    static int Display_width = 300;
    static int GaugeSpan = 180;
    Gauge m_gauge = null;

    public CPredictiveConfidencePanel(JTabbedPane jTabbedPane) {
        try {
            if (jTabbedPane instanceof ClassificationTestMetricsViewer) {
                this.m_classTestMetricsViewer = (ClassificationTestMetricsViewer)jTabbedPane;
                this.jbInit();
                this.classRunTimePanelLoad();
            } else if (jTabbedPane instanceof RegressionTestMetricsViewer) {
                this.m_regressTestMetricsViewer = (RegressionTestMetricsViewer)jTabbedPane;
                this.jbInit();
                this.regressRunTimePanelLoad();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getHelpId() {
        return this.m_classTestMetricsViewer != null ? "CLASS_TESTMETRICS_PC" : "REGRESS_TESTMETRICS_PC";
    }

    private Gauge initGaugeControl() throws Exception {
        Gauge gauge = null;
        try {
            GaugeRegions[0].setBackground(Color.green);
            GaugeRegions[1].setBackground(Color.yellow);
            GaugeRegions[2].setBackground(Color.red);
            gauge = new Gauge();
            gauge.setSize(Display_width, Display_height);
            gauge.setBorderLeft(2);
            gauge.setBorderRight(2);
            gauge.setBorderBottom(2);
            gauge.setBackground(this.getBackground());
            gauge.setEdgeColor(this.getBackground());
            gauge.setSeries(GaugeRegions);
            gauge.setGaugeSpan(GaugeSpan);
            gauge.getLegendDesc().setLegendAlignment(4);
            gauge.setGaugeNeedleColor(new Color(100, 100, 100));
        }
        catch (ChartException chartException) {
            chartException.printStackTrace();
            throw chartException;
        }
        return gauge;
    }

    private void jbInit() throws Exception {
        int n = 0;
        int n2 = 0;
        String string = this.m_classTestMetricsViewer != null ? DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_PC_DESCRIPTION") : DM4JResourceUtilities.getUIString("REGRESS_TESTMETRICS_PC_DESCRIPTION");
        this.mlblStepDescription.setText(string);
        this.mlblStepDescription.setPreferredRows(4);
        this.mlblStepDescription.setMinimumRows(4);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.addFilledComponent(this.mlblStepDescription, GriddedPanel.TOPLABELITEMINSETS, n, n2, 6, 4, 2);
        this.addFilledComponent(new JLabel(), GriddedPanel.TOPLABELITEMINSETS, n += 4, n2, 6, 4, 2);
        this.addFilledComponent(new JLabel(), TOPLABELITEMINSETS, n += 4, n2, 2, 2, 1);
        n2 = 2;
        this.m_gauge = this.initGaugeControl();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.m_gauge, "Center");
        jPanel.setPreferredSize(new Dimension(100, 100));
        this.addFilledComponent(jPanel, TOPLABELITEMINSETS, n, n2, 2, 2, 1);
        n2 = 4;
        this.addFilledComponent(new JLabel(), GriddedPanel.TOPLABELITEMINSETS, n, n2, 2, 2, 1);
        n2 = 0;
        this.addFilledComponent(new JLabel(), TOPLABELITEMINSETS, n += 2, n2, 6, 6, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void classRunTimePanelLoad() throws Exception {
        ClassificationTestMetrics classificationTestMetrics = this.m_classTestMetricsViewer.getClassificationTestMetrics();
        Connection connection = null;
        connection = DM4JConnectionManager.getDbConnection();
        DMEMetadata dMEMetadata = DMEMetadata.getInstance();
        String string = classificationTestMetrics.getName();
        Double d = dMEMetadata.getPredictiveConfidence(connection, string);
        if (d == null) {
            d = ClassificationModelLiftBuilder.computePredictiveConfidence(classificationTestMetrics);
        }
        this.m_gauge.setGaugeLevel(d);
        NumberFormat numberFormat = DM4JNumericFormat.getInstance(false, 2);
        this.m_gauge.getFootnote().setText(DM4JResourceUtilities.getUIString("TESTMETRICS_PC_TAB") + ": " + numberFormat.format(d) + "%");
        Object var8_8 = null;
        if (null == connection) return;
        try {
            connection.close();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (Exception exception) {
                exception.printStackTrace();
                Object var8_9 = null;
                if (null == connection) return;
                try {
                    connection.close();
                    return;
                }
                catch (Exception exception2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (null == connection) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void regressRunTimePanelLoad() throws Exception {
        RegressionTestMetrics regressionTestMetrics = this.m_regressTestMetricsViewer.getRegressionTestMetrics();
        Connection connection = null;
        String string = "select TARGET_ATTRIBUTE from DM_USER_MODELS where NAME = ?";
        String string2 = "select SQRT((count(*) / (count(*) - 1)) * variance({0})) from \"{1}\".\"{2}\"";
        connection = DM4JConnectionManager.getDbConnection();
        DMEMetadata dMEMetadata = DMEMetadata.getInstance();
        String string3 = regressionTestMetrics.getName();
        Double d = dMEMetadata.getPredictiveConfidence(connection, string3);
        if (d == null) {
            d = RegressionModelTestBuilder.computePredictiveConfidence(regressionTestMetrics.getModelName(), this.m_regressTestMetricsViewer.getSchemaName(), this.m_regressTestMetricsViewer.getInputTableName(), regressionTestMetrics.getRMSError());
        }
        this.m_gauge.setGaugeLevel(d);
        NumberFormat numberFormat = DM4JNumericFormat.getInstance(false, 2);
        this.m_gauge.getFootnote().setText(DM4JResourceUtilities.getUIString("TESTMETRICS_PC_TAB") + ": " + numberFormat.format(d) + "%");
        Object var10_10 = null;
        if (null == connection) return;
        try {
            connection.close();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (Exception exception) {
                exception.printStackTrace();
                Object var10_11 = null;
                if (null == connection) return;
                try {
                    connection.close();
                    return;
                }
                catch (Exception exception2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (null == connection) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }
}

