/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.task;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Vector;
import javax.datamining.NamedObject;
import javax.datamining.resource.Connection;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.viewer.EmptySelectionPanel;
import oracle.dmt.dm4j.browser.viewer.LoadingStatusPanel;
import oracle.dmt.dm4j.browser.viewer.task.LoadTaskDetailWorker;
import oracle.dmt.dm4j.browser.viewer.task.LoadTasksWorker;
import oracle.dmt.dm4j.browser.viewer.task.TaskDetailLoadedListener;
import oracle.dmt.dm4j.browser.viewer.task.TaskDetailPanel;
import oracle.dmt.dm4j.browser.viewer.task.TaskTable;
import oracle.dmt.dm4j.browser.viewer.task.TaskTableModel;
import oracle.dmt.dm4j.browser.viewer.task.TasksLoadedListener;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;

public class TaskListPanel
extends GriddedPanel
implements VetoableChangeListener,
TasksLoadedListener,
TaskDetailLoadedListener {
    JScrollPane m_tasksScrollPane = new JScrollPane();
    JButton m_refresh = new JButton();
    JButton m_stop = new JButton();
    JButton m_delete = new JButton();
    JSplitPane m_splitPane = null;
    TaskTable m_taskTable = null;
    String m_findTaskName = null;
    int m_sortColumn = 0;
    boolean m_sortAscending = true;

    public TaskListPanel(JSplitPane jSplitPane, String string) {
        try {
            this.m_splitPane = jSplitPane;
            this.m_findTaskName = string;
            this.jbInit();
            this.runTimePanelLoad();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getHelpId() {
        return "TASKS";
    }

    private void jbInit() throws Exception {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        JLabel jLabel = new JLabel(DM4JResourceUtilities.getUIString("TASK_LIST_TASKS_LABEL"));
        jLabel.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "TASK_LIST_TASKS_LABEL"));
        this.addComponent(jLabel, TOPLABELITEMINSETS, 0, 0, 1, 1, 18, 2);
        this.initTaskList();
        jLabel.setLabelFor(this.m_taskTable);
        this.addFilledComponent(this.m_tasksScrollPane, MIDLABELITEMINSETS, 1, 0, 2, 5, 1);
        this.addComponent(this.m_refresh, TOPLABELITEMINSETS, 1, 2, 1, 1, 12, 2);
        this.addComponent(this.m_stop, TOPLABELITEMINSETS, 2, 2, 1, 1, 12, 2);
    }

    private void runTimePanelLoad() throws Exception {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        this.m_refresh.setText(DM4JResourceUtilities.getUIString("TASK_LIST_REFRESH_BUTTON"));
        this.m_refresh.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "TASK_LIST_REFRESH_BUTTON"));
        this.m_refresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TaskListPanel.this.btnRefresh_actionPerformed(actionEvent);
            }
        });
        this.m_stop.setText(DM4JResourceUtilities.getUIString("TASK_LIST_STOP_BUTTON"));
        this.m_stop.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "TASK_LIST_STOP_BUTTON"));
        this.m_stop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TaskListPanel.this.btnStop_actionPerformed(actionEvent);
            }
        });
        this.m_delete.setText(DM4JResourceUtilities.getUIString("TASK_LIST_DELETE_BUTTON"));
        this.m_delete.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "TASK_LIST_DELETE_BUTTON"));
        this.m_delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TaskListPanel.this.btnDelete_actionPerformed(actionEvent);
            }
        });
    }

    public void tasksLoaded(EventObject eventObject) {
        Object object = eventObject.getSource();
        TaskTableModel taskTableModel = null;
        if (!(object instanceof TaskTableModel)) {
            JOptionPane.showMessageDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("ERROR_LIST_TASKS"), DM4JVersion.getFullBrowserName(), 0);
            return;
        }
        taskTableModel = (TaskTableModel)object;
        this.m_taskTable.loadTasks(taskTableModel, this.m_findTaskName, this.m_sortColumn, this.m_sortAscending);
        this.m_refresh.setEnabled(true);
        this.m_delete.setEnabled(true);
        this.m_stop.setEnabled(true);
    }

    private void btnRefresh_actionPerformed(ActionEvent actionEvent) {
        this.initTaskList();
    }

    public String getSelectedTaskName() {
        Grid grid = this.m_taskTable.getGrid();
        GeneralGridSelectionManager generalGridSelectionManager = (GeneralGridSelectionManager)grid.getGridSelectionManager();
        int n = generalGridSelectionManager.getSelection().getSingleRow();
        String string = (String)this.m_taskTable.getTableModel().getData(0, n);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTaskList() {
        this.setCursor(new Cursor(3));
        JButton jButton = this.m_refresh;
        synchronized (jButton) {
            this.m_refresh.setEnabled(false);
            this.m_delete.setEnabled(false);
            this.m_stop.setEnabled(false);
            try {
                GeneralGridSelectionManager generalGridSelectionManager;
                Grid grid;
                boolean bl = true;
                if (this.m_taskTable != null) {
                    this.m_sortColumn = this.m_taskTable.getSortColumn();
                    this.m_sortAscending = this.m_taskTable.getSortOrder();
                    grid = this.m_taskTable.getGrid();
                    generalGridSelectionManager = (GeneralGridSelectionManager)grid.getGridSelectionManager();
                    generalGridSelectionManager.removeVetoableChangeListener(this);
                    this.m_findTaskName = this.getSelectedTaskName();
                    this.m_tasksScrollPane.getViewport().remove(this.m_taskTable);
                    this.m_taskTable = null;
                }
                this.m_taskTable = new TaskTable(null);
                this.m_tasksScrollPane.getViewport().add(this.m_taskTable);
                this.m_taskTable.setDefaultColumnWidths();
                grid = this.m_taskTable.getGrid();
                generalGridSelectionManager = new GeneralGridSelectionManager(0, 2, 0);
                grid.setGridSelectionManager(generalGridSelectionManager);
                generalGridSelectionManager.addVetoableChangeListener(this);
                WorkerThreadManager workerThreadManager = WorkerThreadManager.getInstance();
                LoadTasksWorker loadTasksWorker = (LoadTasksWorker)workerThreadManager.getLoadTasksWorker();
                loadTasksWorker.addTasksLoadedListener(this);
                loadTasksWorker.start();
            }
            catch (Exception exception) {
                this.m_refresh.setEnabled(true);
                this.m_delete.setEnabled(true);
                this.m_stop.setEnabled(true);
                exception.printStackTrace();
                JOptionPane.showMessageDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("ERROR_LIST_TASKS"), DM4JVersion.getFullBrowserName(), 0);
            }
        }
        this.setCursor(new Cursor(0));
    }

    private void btnStop_actionPerformed(ActionEvent actionEvent) {
        Vector vector = this.m_taskTable.getSelectedIndexes(this.m_taskTable.getSelection());
        if (vector.size() == 0) {
            JOptionPane.showOptionDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("TASK_STOP_WARNING"), DM4JResourceUtilities.getUIString("WARNING"), -1, 2, null, null, null);
            this.setCursor(new Cursor(0));
            return;
        }
        int n = JOptionPane.showConfirmDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("TASK_STOP_PROMPT"), DM4JResourceUtilities.getUIString("WARNING"), 0, 2);
        if (1 == n) {
            return;
        }
        BrowserFrame browserFrame = BrowserFrame.getMainFrame();
        Connection connection = null;
        TaskTableModel taskTableModel = this.m_taskTable.getTableModel();
        Enumeration enumeration = vector.elements();
        this.setCursor(new Cursor(3));
        try {
            connection = DM4JConnectionManager.getConnection();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(browserFrame, DM4JResourceUtilities.getUIString("DMS_CONNECTION_NOCREATE"), DM4JResourceUtilities.getUIString("ERROR"), 0);
            return;
        }
        Vector vector2 = new Vector();
        while (enumeration.hasMoreElements()) {
            Integer n2 = (Integer)enumeration.nextElement();
            int n3 = n2;
            String string = (String)taskTableModel.getData(0, n3);
        }
        try {
            connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initTaskList();
        if (0 != vector2.size()) {
            JOptionPane.showOptionDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("TASK_STOP_ERROR"), DM4JResourceUtilities.getUIString("ERROR"), -1, 0, null, null, null);
        }
        this.setCursor(new Cursor(0));
    }

    private void btnDelete_actionPerformed(ActionEvent actionEvent) {
        Vector vector = this.m_taskTable.getSelectedIndexes(this.m_taskTable.getSelection());
        if (vector.size() == 0) {
            JOptionPane.showOptionDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("TASK_DELETE_WARNING"), DM4JResourceUtilities.getUIString("WARNING"), -1, 2, null, null, null);
            this.setCursor(new Cursor(0));
            return;
        }
        int n = JOptionPane.showConfirmDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("TASK_DELETE_PROMPT"), DM4JResourceUtilities.getUIString("WARNING"), 0, 2);
        if (1 == n) {
            return;
        }
        BrowserFrame browserFrame = BrowserFrame.getMainFrame();
        Connection connection = null;
        TaskTableModel taskTableModel = this.m_taskTable.getTableModel();
        Enumeration enumeration = vector.elements();
        this.setCursor(new Cursor(3));
        try {
            connection = DM4JConnectionManager.getConnection();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(browserFrame, DM4JResourceUtilities.getUIString("DMS_CONNECTION_NOCREATE"), DM4JResourceUtilities.getUIString("ERROR"), 0);
            return;
        }
        Vector<Exception> vector2 = new Vector<Exception>();
        while (enumeration.hasMoreElements()) {
            Integer n2 = (Integer)enumeration.nextElement();
            int n3 = n2;
            String string = (String)taskTableModel.getData(0, n3);
            try {
                connection.removeObject(string, NamedObject.task);
            }
            catch (Exception exception) {
                vector2.add(exception);
            }
        }
        try {
            connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initTaskList();
        if (0 != vector2.size()) {
            JOptionPane.showOptionDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("TASK_DELETE_ERROR"), DM4JResourceUtilities.getUIString("ERROR"), -1, 0, null, null, null);
        }
        this.setCursor(new Cursor(0));
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
        TwoDSelection twoDSelection = (TwoDSelection)propertyChangeEvent.getNewValue();
        if (this.m_taskTable.isMultpleSelection(twoDSelection)) {
            this.showMultipleSelectionPane();
            return;
        }
        if (this.m_taskTable.isEmptySelection(twoDSelection)) {
            this.showEmptySelectionPane();
            return;
        }
        int n = twoDSelection.getSingleRow();
        LoadingStatusPanel loadingStatusPanel = new LoadingStatusPanel();
        int n2 = this.m_splitPane.getDividerLocation();
        loadingStatusPanel.setMinimumSize(new Dimension(50, 50));
        this.m_splitPane.add((Component)loadingStatusPanel, "bottom");
        this.m_splitPane.setDividerLocation(n2);
        String string = (String)this.m_taskTable.getTableModel().getData(0, n);
        String string2 = (String)this.m_taskTable.getTableModel().getData(1, n);
        WorkerThreadManager workerThreadManager = WorkerThreadManager.getInstance();
        LoadTaskDetailWorker loadTaskDetailWorker = (LoadTaskDetailWorker)workerThreadManager.getLoadTaskDetailWorker(string, string2);
        loadTaskDetailWorker.addTaskDetailLoadedListener(this);
        loadTaskDetailWorker.start();
    }

    public void taskDetailLoaded(EventObject eventObject) {
        if (null == this.m_taskTable) {
            return;
        }
        TwoDSelection twoDSelection = this.m_taskTable.getSelection();
        if (this.m_taskTable.isMultpleSelection(twoDSelection)) {
            return;
        }
        if (this.m_taskTable.isEmptySelection(twoDSelection)) {
            return;
        }
        TaskTableModel taskTableModel = this.m_taskTable.getTableModel();
        if (null == taskTableModel) {
            return;
        }
        TaskDetailPanel taskDetailPanel = (TaskDetailPanel)eventObject.getSource();
        taskDetailPanel.setMinimumSize(new Dimension(50, 50));
        int n = this.m_splitPane.getDividerLocation();
        TwoDSelection twoDSelection2 = this.m_taskTable.getSelection();
        OneDSelection oneDSelection = twoDSelection2.getRowSelection();
        int n2 = oneDSelection.getSingleItem();
        String string = (String)taskTableModel.getData(0, n2);
        String string2 = taskDetailPanel.getMiningTaskName();
        if (string.equals(DM4JStringUtils.trimDoubleQuotes(string2))) {
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.getViewport().add(taskDetailPanel);
            this.m_splitPane.add((Component)jScrollPane, "bottom");
            this.m_splitPane.setDividerLocation(n);
        }
    }

    private void showMultipleSelectionPane() {
        EmptySelectionPanel emptySelectionPanel = new EmptySelectionPanel(DM4JResourceUtilities.getUIString("COMMON_MULTI_ITEM_SELECTED"));
        int n = this.m_splitPane.getDividerLocation();
        this.m_splitPane.setBottomComponent(emptySelectionPanel);
        this.m_splitPane.setDividerLocation(n);
    }

    private void showEmptySelectionPane() {
        EmptySelectionPanel emptySelectionPanel = new EmptySelectionPanel(DM4JResourceUtilities.getUIString("COMMON_NO_ITEM_SELECTED"));
        int n = this.m_splitPane.getDividerLocation();
        this.m_splitPane.setBottomComponent(emptySelectionPanel);
        this.m_splitPane.setDividerLocation(n);
    }
}

