/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.task;

import java.util.EventObject;
import javax.datamining.JDMException;
import javax.datamining.NamedObject;
import javax.datamining.base.Task;
import javax.datamining.resource.Connection;
import javax.datamining.supervised.TestTask;
import javax.datamining.task.BuildTask;
import javax.datamining.task.apply.ApplyTask;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.viewer.task.ApplyTaskDetailPanel;
import oracle.dmt.dm4j.browser.viewer.task.BuildTaskDetailPanel;
import oracle.dmt.dm4j.browser.viewer.task.ExplainTaskDetailPanel;
import oracle.dmt.dm4j.browser.viewer.task.PredictTaskDetailPanel;
import oracle.dmt.dm4j.browser.viewer.task.TaskDetailLoadedListener;
import oracle.dmt.dm4j.browser.viewer.task.TaskDetailPanel;
import oracle.dmt.dm4j.browser.viewer.task.TestTaskDetailPanel;
import oracle.dmt.dm4j.browser.viewer.task.TransformationTaskDetailPanel;
import oracle.dmt.dm4j.browser.worker.SwingWorker;
import oracle.dmt.dm4j.browser.worker.ThreadState;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.jdm.task.OraExplainTask;
import oracle.dmt.jdm.task.OraPredictTask;
import oracle.dmt.jdm.task.OraTransformationTask;

public class LoadTaskDetailWorker
extends SwingWorker
implements ThreadState {
    private static int s_thread = 0;
    private EventListenerList listenerList = new EventListenerList();
    private String m_taskName;
    private String m_taskType;

    public LoadTaskDetailWorker(WorkerThreadManager workerThreadManager, String string, String string2) {
        super(workerThreadManager);
        this.m_taskName = string;
        this.m_taskType = string2;
    }

    public void addTaskDetailLoadedListener(TaskDetailLoadedListener taskDetailLoadedListener) {
        this.listenerList.add(TaskDetailLoadedListener.class, taskDetailLoadedListener);
    }

    public void removeTaskDetailLoadedListener(TaskDetailLoadedListener taskDetailLoadedListener) {
        this.listenerList.remove(TaskDetailLoadedListener.class, taskDetailLoadedListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object construct() {
        GriddedPanel griddedPanel = null;
        try {
            try {
                if (s_thread == 0) {
                    this.m_threadManager.setRunningState(4);
                }
                ++s_thread;
                griddedPanel = this.createDetailViewer(this.m_taskName, this.m_taskType);
            }
            catch (Exception exception) {
                Object var4_3 = null;
                if (--s_thread == 0) {
                    this.m_threadManager.removeRunningState(4);
                }
            }
            Object var4_2 = null;
            if (--s_thread == 0) {
                this.m_threadManager.removeRunningState(4);
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (--s_thread == 0) {
                this.m_threadManager.removeRunningState(4);
            }
            throw throwable;
        }
        return griddedPanel;
    }

    public void finished() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TaskDetailLoadedListener.class) continue;
            ((TaskDetailLoadedListener)objectArray[i + 1]).taskDetailLoaded(new EventObject(this.getValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private GriddedPanel createDetailViewer(String string, String string2) {
        TaskDetailPanel taskDetailPanel;
        block17: {
            Connection connection;
            DM4JListResourceBundle dM4JListResourceBundle;
            BrowserFrame browserFrame;
            block16: {
                taskDetailPanel = null;
                Task task = null;
                browserFrame = BrowserFrame.getMainFrame();
                dM4JListResourceBundle = BrowserUtils.getBundleInstance();
                connection = null;
                connection = DM4JConnectionManager.getConnection();
                task = this.restoreTask(connection, string, string2);
                if (task instanceof BuildTask) {
                    taskDetailPanel = new BuildTaskDetailPanel(task);
                    break block16;
                }
                if (task instanceof ApplyTask) {
                    taskDetailPanel = new ApplyTaskDetailPanel(task);
                    break block16;
                }
                if (task instanceof TestTask) {
                    taskDetailPanel = new TestTaskDetailPanel(task);
                    break block16;
                }
                if (task instanceof OraPredictTask) {
                    taskDetailPanel = new PredictTaskDetailPanel(task);
                    break block16;
                }
                if (task instanceof OraExplainTask) {
                    taskDetailPanel = new ExplainTaskDetailPanel(task);
                    break block16;
                }
                if (!(task instanceof OraTransformationTask)) break block16;
                taskDetailPanel = new TransformationTaskDetailPanel(task);
            }
            Object var13_8 = null;
            try {
                if (connection != null) {
                    connection.close();
                }
                break block17;
            }
            catch (JDMException jDMException) {}
            break block17;
            {
                catch (Exception exception) {
                    String string3 = dM4JListResourceBundle.getString("COMMON_TASK_NOT_FOUND");
                    String string4 = dM4JListResourceBundle.getString("APPLICATION_TITLE");
                    JOptionPane.showMessageDialog(browserFrame, string3, string4, 0);
                    GriddedPanel griddedPanel = null;
                    Object var13_9 = null;
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (JDMException jDMException) {
                        // empty catch block
                    }
                    return griddedPanel;
                }
            }
            catch (Throwable throwable) {
                Object var13_10 = null;
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (JDMException jDMException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return taskDetailPanel;
    }

    private Task restoreTask(Connection connection, String string, String string2) throws Exception {
        Task task = null;
        if (string2.equalsIgnoreCase("BUILD") || string2.equalsIgnoreCase("TEST") || string2.equalsIgnoreCase("APPLY") || string2.equalsIgnoreCase("PLOT") || string2.equalsIgnoreCase("PRDCT") || string2.equalsIgnoreCase("EXPLN")) {
            task = (Task)connection.retrieveObject(DMEMetadata.fixObjectNameWhenLoad(string), NamedObject.task);
        } else if (string2.equalsIgnoreCase("XTEXT")) {
            task = (Task)connection.retrieveObject(string, NamedObject.task);
        }
        return task;
    }
}

