/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.task;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import javax.datamining.base.Task;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.HyperlinkButton;
import oracle.dmt.dm4j.browser.compatibility.CompatibilityUtils;
import oracle.dmt.dm4j.browser.viewer.task.TaskDetailPanel;

public class ImportTaskDetailPanel
extends TaskDetailPanel {
    private JLabel m_name = new JLabel();
    private JLabel m_type = new JLabel();
    private HyperlinkButton m_modelNameBtn = new HyperlinkButton();
    private HyperlinkButton m_tableBtn = new HyperlinkButton();
    private JLabel m_column = new JLabel();
    private JLabel m_time = new JLabel();
    private JLabel m_duration = new JLabel();
    private JLabel m_status = new JLabel();
    private JTextArea m_message = null;
    private JScrollPane m_messagePanel = new JScrollPane();
    private Task m_task;
    private String m_modelType = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportTaskDetailPanel(Task task) {
        super(task);
        BrowserFrame browserFrame = BrowserFrame.getMainFrame();
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            this.m_task = this.getMiningTask();
            this.jbInit(connection);
            this.runTimePanelLoad(connection);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void jbInit(Connection connection) throws Exception {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        int n = 0;
        JLabel jLabel = new JLabel();
        jLabel.setText(DM4JResourceUtilities.getUIString("COMMON_NAME"));
        this.addComponent(jLabel, TOPLABELITEMINSETS, n, 1);
        this.addFilledComponent(this.m_name, TOPVALUEITEMINSETS, n++, 2, 2);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(DM4JResourceUtilities.getUIString("COMMON_TYPE"));
        this.addComponent(jLabel2, MIDLABELITEMINSETS, n, 1);
        this.addComponent(this.m_type, MIDVALUEITEMINSETS, n++, 2);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(DM4JResourceUtilities.getUIString("COMMON_INPUT_DATA"));
        this.addComponent(jLabel3, TOPLABELITEMINSETS, n++, 1);
        this.addComponent(this.m_tableBtn, MIDINDENTEDLABELITEMINSETS, n++, 1, 3, 1, 16, 2);
        JLabel jLabel4 = new JLabel();
        jLabel4.setText(DM4JResourceUtilities.getUIString("TASK_COLUMN"));
        this.addComponent(jLabel4, MIDINDENTEDLABELITEMINSETS, n, 1);
        this.addComponent(this.m_column, MIDVALUEITEMINSETS, n++, 2);
        JLabel jLabel5 = new JLabel();
        jLabel5.setText(DM4JResourceUtilities.getUIString("COMMON_OUTPUT_DATA"));
        this.addComponent(jLabel5, TOPLABELITEMINSETS, n++, 1);
        this.addComponent(this.m_modelNameBtn, MIDINDENTEDLABELITEMINSETS, n++, 1, 3, 1, 16, 2);
        JLabel jLabel6 = new JLabel();
        jLabel6.setText(DM4JResourceUtilities.getUIString("COMMON_END_TIME"));
        this.addComponent(jLabel6, TOPLABELITEMINSETS, n, 1);
        this.addComponent(this.m_time, TOPVALUEITEMINSETS, n++, 2);
        JLabel jLabel7 = new JLabel();
        jLabel7.setText(DM4JResourceUtilities.getUIString("COMMON_DURATION"));
        this.addComponent(jLabel7, MIDLABELITEMINSETS, n, 1);
        this.addComponent(this.m_duration, MIDVALUEITEMINSETS, n++, 2);
        JLabel jLabel8 = new JLabel();
        jLabel8.setText(DM4JResourceUtilities.getUIString("COMMON_STATUS"));
        this.addComponent(jLabel8, MIDLABELITEMINSETS, n, 1);
        this.addComponent(this.m_status, MIDVALUEITEMINSETS, n++, 2);
        JLabel jLabel9 = new JLabel();
        jLabel9.setText(DM4JResourceUtilities.getUIString("TASK_MESSAGE"));
        jLabel9.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "TASK_MESSAGE"));
        this.addComponent(jLabel9, TOPLABELITEMINSETS, n++, 1);
        this.m_message = new JTextArea(4, 10);
        this.m_message.setEditable(false);
        this.m_message.setLineWrap(true);
        this.m_message.setWrapStyleWord(true);
        jLabel9.setLabelFor(this.m_message);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.m_message);
        this.addFilledComponent(jScrollPane, MIDLABELITEMINSETS, n++, 1, 2, 2, 1);
        this.setPreferredSize(null);
    }

    private void runTimePanelLoad(Connection connection) throws Exception {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        String string = this.m_task.getName();
        this.m_name.setText(string);
        String string2 = null;
        try {
            this.m_modelType = CompatibilityUtils.getModelType(connection, string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_type.setText(DM4JResourceUtilities.getUIString("IMPORT_TASK_TYPE"));
        this.m_modelNameBtn.setText(DM4JResourceUtilities.getUIString("COMMON_MODEL_NAME") + " " + string2);
        this.m_modelNameBtn.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                BrowserFrame browserFrame = BrowserFrame.getMainFrame();
                HyperlinkButton hyperlinkButton = (HyperlinkButton)actionEvent.getSource();
                hyperlinkButton.setCursor(Cursor.getPredefinedCursor(3));
                browserFrame.findComponent(ImportTaskDetailPanel.this.m_modelType, "");
                hyperlinkButton.setCursor(Cursor.getPredefinedCursor(12));
            }
        });
    }
}

