/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.table.db;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dmt.dm4j.browser.viewer.table.ModelUtil;
import oracle.dmt.dm4j.browser.viewer.table.db.Column;
import oracle.dmt.dm4j.browser.viewer.table.db.Constraint;
import oracle.dmt.dm4j.browser.viewer.table.db.SchemaObject;

public class Table
extends SchemaObject {
    private ArrayList m_columns = new ArrayList(10);
    private ArrayList m_constraints = new ArrayList();
    private String m_comment;

    public Table() {
    }

    public Table(String string) {
        this();
        this.setName(string);
    }

    public boolean equals(Object object) {
        return object instanceof Table && this.equalsImpl((Table)object);
    }

    protected boolean equalsImpl(Table table) {
        return super.equalsImpl(table) && ModelUtil.areEqual(this.m_columns, table.m_columns) && ModelUtil.areEqual(this.m_constraints, table.m_constraints) && ModelUtil.areEqual(this.m_comment, table.m_comment);
    }

    public void setColumns(List list) {
        if (ModelUtil.areDifferent(list, this.m_columns)) {
            this.m_columns.clear();
            this.m_columns.addAll(list);
        }
    }

    public List getColumns() {
        return new ArrayList(this.m_columns);
    }

    public void addColumn(Column column) {
        this.m_columns.add(column);
    }

    public Column getColumn(String string) {
        for (Column column : this.m_columns) {
            if (!column.getName().equals(string)) continue;
            return column;
        }
        return null;
    }

    public void removeColumn(Column column) {
        if (this.m_columns.contains(column)) {
            this.m_columns.remove(column);
        }
    }

    public List getConstraints() {
        return new ArrayList(this.m_constraints);
    }

    public void setConstraints(List list) {
        if (ModelUtil.areDifferent(this.m_constraints, list)) {
            this.m_constraints.clear();
            this.m_constraints.addAll(list);
        }
    }

    public void addConstraint(Constraint constraint) {
        this.m_constraints.add(constraint);
    }

    public void removeConstraint(Constraint constraint) {
        if (this.m_constraints.contains(constraint)) {
            this.m_constraints.remove(constraint);
        }
    }

    public String getType() {
        return "TABLE";
    }

    public Iterator getChildren() {
        return this.m_columns.iterator();
    }

    public String getComment() {
        return this.m_comment;
    }

    public void setComment(String string) {
        this.m_comment = string;
    }

    public String[] generateSQL() {
        return new String[0];
    }
}

