/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.table.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.browser.viewer.table.db.Column;
import oracle.dmt.dm4j.browser.viewer.table.db.FKConstraint;
import oracle.dmt.dm4j.browser.viewer.table.db.PKConstraint;
import oracle.dmt.dm4j.browser.viewer.table.db.Table;
import oracle.dmt.dm4j.browser.viewer.table.db.UniqueConstraint;

public class JdbcDatabase {
    static final int DATABASE_TYPE_GENERIC = 0;
    static final int DATABASE_TYPE_ORACLE = 1;
    static final int DATABASE_TYPE_ORACLELITE = 2;
    protected Connection m_conn = null;
    protected String m_connName = null;
    protected List m_databaseObjectTypes = null;
    private int m_databaseType = -1;
    private String m_lastErrorText = null;
    private String m_lastResultString = null;
    private String m_identifierQuoteString = null;
    public static final String SQLSTATE_NOT_IMPLEMENTED = "S1C00";
    private List m_internalSchemaList = null;
    private String m_catalog;

    public JdbcDatabase(String string, Connection connection) {
        this.m_connName = string;
        if (null == connection) {
            try {
                this.m_conn = DM4JConnectionManager.getDbConnection();
            }
            catch (Exception exception) {
                String string2 = "Unable to find connection " + string + "\n" + exception.getMessage();
                throw new RuntimeException(string2);
            }
        } else {
            this.m_conn = connection;
        }
        try {
            this.m_catalog = this.m_conn.getCatalog();
            this.m_internalSchemaList = this.queryDmdSchemas(false);
        }
        catch (Exception exception) {
            this.m_internalSchemaList = new ArrayList(0);
            exception.printStackTrace();
        }
    }

    public JdbcDatabase(Connection connection) {
        this(null, connection);
    }

    public Connection getConnection() {
        return this.m_conn;
    }

    public String getConnectionName() {
        return this.m_connName;
    }

    public int getDatabaseType() {
        if (this.m_databaseType == -1) {
            this.m_databaseType = this.getDatabaseTypeImpl();
        }
        return this.m_databaseType;
    }

    protected int getDatabaseTypeImpl() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean containsNonSchemaTables() {
        boolean bl;
        block9: {
            ResultSet resultSet = null;
            bl = false;
            DatabaseMetaData databaseMetaData = this.m_conn.getMetaData();
            resultSet = databaseMetaData.getTables(this.m_catalog, "", "%", null);
            bl = resultSet.next();
            Object var5_5 = null;
            if (resultSet == null) break block9;
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            resultSet = null;
            {
                break block9;
                catch (Exception exception) {
                    Object var5_6 = null;
                    if (resultSet == null) break block9;
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    resultSet = null;
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    resultSet = null;
                }
                throw throwable;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private List queryDmdSchemas(boolean bl) throws SQLException {
        ArrayList<String> arrayList;
        block15: {
            ResultSet resultSet;
            block14: {
                arrayList = new ArrayList<String>(20);
                resultSet = null;
                DatabaseMetaData databaseMetaData = this.m_conn.getMetaData();
                resultSet = databaseMetaData.getSchemas();
                while (resultSet.next()) {
                    arrayList.add(resultSet.getString(1));
                }
                if (!bl || !this.containsNonSchemaTables()) break block14;
                arrayList.add("");
            }
            Object var8_7 = null;
            if (resultSet == null) break block15;
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            resultSet = null;
            {
                break block15;
                catch (SQLException sQLException) {
                    String string = sQLException.getSQLState();
                    if (string.equals(SQLSTATE_NOT_IMPLEMENTED)) {
                        arrayList.clear();
                        System.out.println(sQLException.toString());
                        ArrayList<String> arrayList2 = arrayList;
                        Object var8_8 = null;
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            resultSet = null;
                        }
                        return arrayList2;
                    }
                    throw sQLException;
                }
                catch (NullPointerException nullPointerException) {
                    nullPointerException.printStackTrace();
                    Object var8_9 = null;
                    if (resultSet == null) break block15;
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    resultSet = null;
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    resultSet = null;
                }
                throw throwable;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private List queryDmdCatalogs() throws SQLException {
        ArrayList<String> arrayList;
        block10: {
            arrayList = new ArrayList<String>(20);
            ResultSet resultSet = null;
            DatabaseMetaData databaseMetaData = this.m_conn.getMetaData();
            resultSet = databaseMetaData.getCatalogs();
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
            Object var5_5 = null;
            if (resultSet == null) break block10;
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            resultSet = null;
            {
                break block10;
                catch (NullPointerException nullPointerException) {
                    Object var5_6 = null;
                    if (resultSet == null) break block10;
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    resultSet = null;
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    resultSet = null;
                }
                throw throwable;
            }
        }
        return arrayList;
    }

    public void close() {
        try {
            if (!this.m_conn.isClosed()) {
                this.m_conn.close();
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    public String getLastErrorText() {
        return this.m_lastErrorText;
    }

    public String getLastResultString() {
        return this.m_lastResultString;
    }

    protected String transformSQLStatement(String string) {
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ResultSet executeQuery(String string) {
        ResultSet resultSet;
        block19: {
            resultSet = null;
            Statement statement = null;
            this.m_lastErrorText = null;
            this.m_lastResultString = "";
            string = string.trim();
            String string2 = string.toUpperCase();
            if (string.endsWith(";") && !string2.endsWith("END;")) {
                string = string.substring(0, string.lastIndexOf(";"));
            }
            string = this.transformSQLStatement(string);
            statement = this.m_conn.createStatement();
            boolean bl = statement.execute(string);
            if (bl) {
                resultSet = statement.getResultSet();
            } else {
                this.m_lastResultString = String.valueOf(statement.getUpdateCount());
            }
            for (SQLWarning sQLWarning = statement.getWarnings(); sQLWarning != null; sQLWarning = sQLWarning.getNextWarning()) {
                System.out.println(sQLWarning.getLocalizedMessage());
            }
            Object var8_11 = null;
            if (resultSet != null) break block19;
            try {
                if (statement != null) {
                    statement.close();
                }
                break block19;
            }
            catch (Exception exception) {}
            break block19;
            {
                catch (SQLException sQLException) {
                    String string3 = sQLException.getLocalizedMessage();
                    this.m_lastResultString = this.m_lastErrorText = string3 != null ? string3.trim() : string3;
                    Object var8_12 = null;
                    if (resultSet != null) break block19;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        break block19;
                    }
                    catch (Exception exception) {}
                    break block19;
                }
                catch (Exception exception) {
                    String string4 = exception.toString();
                    this.m_lastResultString = this.m_lastErrorText = string4 != null ? string4.trim() : string4;
                    Object var8_13 = null;
                    if (resultSet != null) break block19;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        break block19;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_14 = null;
                if (resultSet == null) {
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return resultSet;
    }

    public Table getTable(String string, String string2) {
        Table table = this.createTable(string, string2);
        if (table != null) {
            table.setCatalog(this.m_catalog);
            table.setColumns(this.getColumns(string, string2));
            table.setConstraints(this.getConstraints(string, string2));
            table.setComment(this.getComments(string, string2));
        }
        return table;
    }

    protected Table createTable(String string, String string2) {
        Table table = new Table(string2);
        table.setSchema(string);
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List getColumns(String string, String string2) {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        ResultSet resultSet = null;
        String string3 = this.m_internalSchemaList.size() > 0 ? string : null;
        DatabaseMetaData databaseMetaData = this.m_conn.getMetaData();
        resultSet = databaseMetaData.getColumns(this.m_catalog, string3, string2, "%");
        while (resultSet.next()) {
            String string4;
            String string5 = resultSet.getString(4);
            Column column = new Column(string5);
            column.setTableName(string2);
            column.setCatalog(resultSet.getString(1));
            column.setSchema(resultSet.getString(2));
            column.setDataTypeString(resultSet.getString(6));
            try {
                string4 = resultSet.getString(7);
                if (string4 != null) {
                    column.setPrecision(new Long(string4));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                string4 = resultSet.getString(9);
                if (string4 != null) {
                    column.setScale(new Long(string4));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            column.setComment(resultSet.getString(12));
            string4 = resultSet.getString(18);
            boolean bl = !"YES".equals(string4);
            column.setNotNull(bl);
            arrayList.add(column);
        }
        Object var12_15 = null;
        if (resultSet == null) return arrayList;
        try {
            resultSet.close();
            return arrayList;
        }
        catch (Exception exception) {}
        return arrayList;
        {
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                Object var12_16 = null;
                if (resultSet == null) return arrayList;
                try {
                    resultSet.close();
                    return arrayList;
                }
                catch (Exception exception) {}
                return arrayList;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Object var12_17 = null;
                if (resultSet == null) return arrayList;
                try {
                    resultSet.close();
                    return arrayList;
                }
                catch (Exception exception2) {}
                return arrayList;
            }
        }
        catch (Throwable throwable) {
            Object var12_18 = null;
            if (resultSet == null) throw throwable;
            try {
                resultSet.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List getConstraints(String string, String string2) {
        Object object;
        Object object2;
        Iterator iterator;
        Object object3;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ResultSet resultSet = null;
        DatabaseMetaData databaseMetaData = this.m_conn.getMetaData();
        String string3 = this.m_internalSchemaList.size() > 0 ? string : null;
        resultSet = databaseMetaData.getPrimaryKeys(this.m_catalog, string3, string2);
        if (resultSet.next()) {
            class PKCol
            implements Comparable {
                int _seq;
                String _colName;

                PKCol(int n, String string) {
                    this._seq = n;
                    this._colName = string;
                }

                public int compareTo(Object object) {
                    return this._seq - ((PKCol)object)._seq;
                }
            }
            object3 = new PKConstraint(this.m_catalog, string, string2, resultSet.getString(6));
            iterator = new ArrayList<PKCol>();
            do {
                iterator.add(new PKCol(resultSet.getInt(5), resultSet.getString(4)));
            } while (resultSet.next());
            if (iterator.size() > 0) {
                Collections.sort(iterator);
            }
            object2 = iterator.iterator();
            while (object2.hasNext()) {
                object = (PKCol)object2.next();
                ((UniqueConstraint)object3).addColumn(((PKCol)object)._colName);
            }
            arrayList.add(object3);
        }
        resultSet.close();
        object3 = new HashMap();
        resultSet = databaseMetaData.getImportedKeys(this.m_catalog, string3, string2);
        while (resultSet.next()) {
            Object object4;
            String string4;
            iterator = resultSet.getString(1);
            object2 = resultSet.getString(2);
            object = resultSet.getString(3);
            String string5 = resultSet.getString(13);
            if (this.hasLength(string5)) {
                string4 = string5;
            } else {
                object4 = new StringBuffer();
                if (this.hasLength((String)((Object)iterator))) {
                    ((StringBuffer)object4).append((String)((Object)iterator));
                    ((StringBuffer)object4).append("#");
                }
                if (this.hasLength((String)object2)) {
                    ((StringBuffer)object4).append((String)object2);
                    ((StringBuffer)object4).append("#");
                }
                ((StringBuffer)object4).append((String)object);
                string4 = ((StringBuffer)object4).toString();
            }
            object4 = (FKConstraint)((HashMap)object3).get(string4);
            if (object4 == null) {
                object4 = new FKConstraint(this.m_catalog, string, string2, resultSet.getString(12));
                ((FKConstraint)object4).setReference(new PKConstraint((String)((Object)iterator), (String)object2, (String)object, string5));
                ((HashMap)object3).put(string4, object4);
            }
            ((FKConstraint)object4).addColumn(resultSet.getString(8));
            ((FKConstraint)object4).getReference().addColumn(resultSet.getString(4));
            short s = resultSet.getShort(11);
            int n = s == 0 ? 1 : (s == 2 ? 2 : 0);
            ((FKConstraint)object4).setOnDelete(n);
        }
        iterator = ((HashMap)object3).values().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        Object var17_17 = null;
        if (resultSet == null) return arrayList;
        try {
            resultSet.close();
            return arrayList;
        }
        catch (Exception exception) {}
        return arrayList;
        {
            catch (Exception exception) {
                exception.printStackTrace();
                Object var17_18 = null;
                if (resultSet == null) return arrayList;
                try {
                    resultSet.close();
                    return arrayList;
                }
                catch (Exception exception2) {}
                return arrayList;
            }
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            if (resultSet == null) throw throwable;
            try {
                resultSet.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getComments(String string, String string2) {
        ResultSet resultSet;
        String string3;
        block10: {
            string3 = null;
            resultSet = null;
            PreparedStatement preparedStatement = this.m_conn.prepareStatement("SELECT COMMENTS FROM ALL_TAB_COMMENTS WHERE TABLE_NAME = ?");
            preparedStatement.setString(1, string2);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block10;
            string3 = resultSet.getString(1);
        }
        Object var7_8 = null;
        if (resultSet == null) return string3;
        try {
            resultSet.close();
            return string3;
        }
        catch (Exception exception) {}
        return string3;
        {
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                Object var7_9 = null;
                if (resultSet == null) return string3;
                try {
                    resultSet.close();
                    return string3;
                }
                catch (Exception exception) {}
                return string3;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Object var7_10 = null;
                if (resultSet == null) return string3;
                try {
                    resultSet.close();
                    return string3;
                }
                catch (Exception exception2) {}
                return string3;
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (resultSet == null) throw throwable;
            try {
                resultSet.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private HashMap getTablePrimaryKeys(String string, String string2) {
        HashMap<String, String> hashMap;
        block12: {
            hashMap = new HashMap<String, String>();
            ResultSet resultSet = null;
            DatabaseMetaData databaseMetaData = this.m_conn.getMetaData();
            String string3 = this.m_internalSchemaList.size() > 0 ? string : null;
            resultSet = databaseMetaData.getPrimaryKeys(this.m_catalog, string3, string2);
            while (resultSet.next()) {
                hashMap.put(resultSet.getString(4), "Yes");
            }
            Object var8_9 = null;
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            resultSet = null;
            {
                break block12;
                catch (SQLException sQLException) {
                    System.out.println(sQLException.getLocalizedMessage());
                    Object var8_10 = null;
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    resultSet = null;
                    break block12;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var8_11 = null;
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    resultSet = null;
                }
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                resultSet = null;
                throw throwable;
            }
        }
        return hashMap;
    }

    private Boolean yesNoToBoolean(String string) {
        if (string != null && string.equalsIgnoreCase("Y")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean exists(String string, String string2, String string3) {
        return true;
    }

    public boolean isValidName(String string) {
        return true;
    }

    public boolean isObjectValid(String string, String string2, int n) {
        return true;
    }

    public String getIdentifierQuoteString() {
        if (this.m_identifierQuoteString == null) {
            try {
                Connection connection = this.getConnection();
                if (connection != null) {
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    this.m_identifierQuoteString = databaseMetaData.getIdentifierQuoteString();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.m_identifierQuoteString != null ? this.m_identifierQuoteString : "";
    }

    public boolean hasLength(String string) {
        return string != null && string.length() > 0;
    }
}

