/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.table;

import java.awt.EventQueue;
import java.sql.Connection;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dmt.dm4j.DM4JCommonUIUtils;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.viewer.LoadingStatusPanel;
import oracle.dmt.dm4j.browser.viewer.table.DataPanel;
import oracle.dmt.dm4j.browser.viewer.table.StructurePanel;
import oracle.dmt.dm4j.lineage.LineageViewerSplitPanel;

public class TableViewer
extends JTabbedPane {
    LeafNodeData m_lnd = null;
    DataPanel m_dataPane = null;
    StructurePanel m_structurePane = null;
    LineageViewerSplitPanel m_lineagePane = null;
    Connection m_conn = null;
    private static int DATA_TAB = 1;
    private static int LINEAGE_TAB = 2;

    public TableViewer(LeafNodeData leafNodeData) {
        try {
            this.m_lnd = leafNodeData;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        BrowserFrame browserFrame = BrowserFrame.getMainFrame();
        try {
            this.m_conn = DM4JConnectionManager.getDbConnection();
        }
        catch (Exception exception) {
            DM4JCommonUIUtils.showErrorMessage(browserFrame, DM4JResourceUtilities.getUIString("TBLVIEW_ERROR_DATA"));
        }
        this.m_dataPane = null;
        this.m_structurePane = new StructurePanel(this.m_lnd, this.m_conn);
        this.addTab(DM4JResourceUtilities.getUIString("TBLVIEW_STRUCTURE"), null, this.m_structurePane, DM4JResourceUtilities.getUIString("TBLVIEW_STRUCTURE"));
        this.addTab(DM4JResourceUtilities.getUIString("TBLVIEW_DATA"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("TBLVIEW_DATA"));
        if (this.m_lnd.isObjectType("VIEW")) {
            this.addTab("View Lineage", null, new LoadingStatusPanel(), "View Lineage");
        }
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TableViewer.this.tabChangeListener(changeEvent);
            }
        });
    }

    public void tabChangeListener(ChangeEvent changeEvent) {
        final ChangeEvent changeEvent2 = changeEvent;
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    Runnable runnable;
                    BrowserFrame browserFrame = BrowserFrame.getMainFrame();
                    int n = ((JTabbedPane)changeEvent2.getSource()).getSelectedIndex();
                    if (DATA_TAB == n && TableViewer.this.m_dataPane == null) {
                        TableViewer.this.m_dataPane = new DataPanel(TableViewer.this.m_lnd, TableViewer.this.m_conn);
                        runnable = new Runnable(){

                            public void run() {
                                TableViewer.this.setComponentAt(DATA_TAB, TableViewer.this.m_dataPane);
                            }
                        };
                        EventQueue.invokeLater(runnable);
                    }
                    if (LINEAGE_TAB == n && TableViewer.this.m_lineagePane == null) {
                        TableViewer.this.m_lineagePane = new LineageViewerSplitPanel(TableViewer.this.m_lnd.getSchemaName(), TableViewer.this.m_lnd.getName());
                        runnable = new Runnable(){

                            public void run() {
                                TableViewer.this.setComponentAt(LINEAGE_TAB, TableViewer.this.m_lineagePane);
                            }
                        };
                        EventQueue.invokeLater(runnable);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.setPriority(5);
        thread.start();
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.m_conn != null) {
            try {
                this.m_conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.m_dataPane != null) {
            this.m_dataPane.close();
        }
        this.removeAll();
        this.m_conn = null;
        this.m_dataPane = null;
        this.m_structurePane = null;
    }
}

