/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.viewer.table.LabelTableCellRenderer;
import oracle.dmt.dm4j.browser.viewer.table.TableColumnTableModel;
import oracle.dmt.dm4j.browser.viewer.table.db.Column;
import oracle.dmt.dm4j.browser.viewer.table.db.Constraint;
import oracle.dmt.dm4j.browser.viewer.table.db.JdbcDatabase;
import oracle.dmt.dm4j.browser.viewer.table.db.Table;
import oracle.dmt.dm4j.browser.viewer.table.db.UniqueConstraint;

public class StructurePanel
extends JPanel {
    private BorderLayout m_borderLayout1 = new BorderLayout();
    private JLabel m_lblName = new JLabel();
    private JTextField m_txtName = new JTextField();
    private JLabel m_lblComment = new JLabel();
    private JTextArea m_taComment = new JTextArea(2, 1);
    private JScrollPane m_spCommentsPane = new JScrollPane();
    private JTable m_tblStructure = null;
    private LeafNodeData m_nodeData = null;
    protected TableColumnTableModel m_model = null;
    private GriddedPanel m_pnlComments = new GriddedPanel();
    private JScrollPane m_scrollPane = null;
    private Connection m_conn = null;
    private static String _yes = DM4JResourceUtilities.getUIString("COMMON_YES");
    private static String _no = DM4JResourceUtilities.getUIString("COMMON_NO");
    private static final Icon YES_ICON = IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/yes.gif");
    private static final Icon NO_ICON = IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/no.gif");

    public StructurePanel(LeafNodeData leafNodeData, Connection connection) {
        this.m_conn = connection;
        this.m_nodeData = leafNodeData;
        try {
            this.preInit();
            this.jbInit();
            this.postInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void preInit() {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        this.m_lblName.setText(DM4JResourceUtilities.getUIString("COMMON_NAME"));
        this.m_lblName.setLabelFor(this.m_txtName);
        this.m_txtName.setEditable(false);
        this.m_txtName.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.m_pnlComments.addFilledComponent(this.m_lblName, GriddedPanel.TOPLABELITEMINSETS, 0, 0, 1, 1, 0);
        this.m_pnlComments.addFilledComponent(this.m_txtName, GriddedPanel.TOPVALUEITEMINSETS, 0, 1, 1, 1, 2);
        this.m_taComment.setEditable(false);
        this.m_taComment.setLineWrap(true);
        this.m_taComment.setWrapStyleWord(true);
        this.m_taComment.setBackground(this.getBackground());
        this.m_lblComment.setText(DM4JResourceUtilities.getUIString("TVIEW_COMMENT"));
        this.m_lblComment.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "TVIEW_COMMENT"));
        this.m_lblComment.setLabelFor(this.m_taComment);
        this.m_pnlComments.addFilledComponent(this.m_lblComment, GriddedPanel.TOPLABELITEMINSETS, 2, 0, 1, 1, 0);
        this.m_spCommentsPane.getViewport().add(this.m_taComment);
        this.m_pnlComments.addFilledComponent(this.m_spCommentsPane, GriddedPanel.MIDLABELITEMINSETS, 3, 0, 2, 1, 2);
        JLabel jLabel = new JLabel();
        jLabel.setText(DM4JResourceUtilities.getUIString("COMMON_ATTRIBUTES"));
        jLabel.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "COMMON_ATTRIBUTES"));
        this.m_pnlComments.addFilledComponent(jLabel, GriddedPanel.TOPLABELITEMINSETS, 4, 0, 3, 1, 2);
        this.m_model = new TableColumnTableModel();
        this.m_tblStructure = new JTable(this.m_model);
        this.m_tblStructure.setDefaultRenderer(JLabel.class, new LabelTableCellRenderer());
        this.m_tblStructure.setAutoResizeMode(3);
        this.m_tblStructure.getTableHeader().resizeAndRepaint();
        this.m_tblStructure.setBackground(SystemColor.control);
        this.m_tblStructure.setAutoResizeMode(3);
        this.m_scrollPane = new JScrollPane(this.m_tblStructure);
        jLabel.setLabelFor(this.m_tblStructure);
    }

    private void postInit() {
        this.m_tblStructure.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
            }
        });
    }

    private void jbInit() throws Exception {
        this.setLayout(this.m_borderLayout1);
        this.add((Component)this.m_pnlComments, "North");
        this.add((Component)this.m_scrollPane, "Center");
        this.open();
    }

    protected List createInfoPanel() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            JdbcDatabase jdbcDatabase = new JdbcDatabase(this.m_conn);
            Table table = jdbcDatabase.getTable(this.m_nodeData.getSchemaName(), this.m_nodeData.getName());
            this.m_txtName.setText(table.getName());
            this.m_taComment.setText(table.getComment());
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (Object object : table.getConstraints()) {
                int n = ((Constraint)object).getConstraintType();
                if (n != 0 && n != 2) continue;
                for (Object object2 : ((UniqueConstraint)object).getColumns()) {
                    if (arrayList2.contains(object2)) continue;
                    arrayList2.add((String)object2);
                }
            }
            Iterator iterator = table.getColumns().iterator();
            while (iterator.hasNext()) {
                Object object2;
                Object object;
                object = new ArrayList();
                Column column = (Column)iterator.next();
                String string = column.getName();
                object.add(StructurePanel.getLabel(arrayList2.contains(string)));
                object.add(string);
                object.add(column.getDataTypeString());
                object2 = column.getPrecision();
                object.add(object2 != null ? ((Long)object2).toString() : "0");
                Long l = column.getScale();
                object.add(l != null ? l.toString() : "");
                object.add(StructurePanel.getLabel(!column.isNotNull()));
                arrayList.add(object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public void open() {
        this.m_model.setData(this.createInfoPanel());
        this.m_tblStructure.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
    }

    public void close() {
    }

    public String getTabLabel() {
        return DM4JResourceUtilities.getUIString("TBLVIEW_STRUCTURE");
    }

    public Icon getTabIcon() {
        return null;
    }

    public String getTabDescription() {
        return this.getTabLabel();
    }

    public Component getGUI() {
        return this;
    }

    private static JLabel getLabel(boolean bl) {
        JLabel jLabel = new JLabel(bl ? YES_ICON : NO_ICON);
        AccessibleContext accessibleContext = jLabel.getAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.setAccessibleName(bl ? _yes : _no);
            accessibleContext.setAccessibleDescription(bl ? _yes : _no);
        }
        return jLabel;
    }
}

