/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.viewer.table.ResultSetNavigationBar;
import oracle.dmt.dm4j.browser.viewer.table.ResultSetNavigationEvent;
import oracle.dmt.dm4j.browser.viewer.table.ResultSetNavigationListener;

public class DefaultResultSetNavigationBar
extends JPanel
implements ResultSetNavigationBar,
ResultSetNavigationListener {
    private NumberTextField m_tfSize = new NumberTextField();
    private JLabel m_lblSize = new JLabel();
    private JButton m_btnFetch = new JButton();
    private JButton m_btnRefresh = new JButton();
    private JButton m_btnExport = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/save.gif"));

    public DefaultResultSetNavigationBar() {
        this.m_tfSize.setDataType(Integer.TYPE);
        this.m_tfSize.setNumber(new Integer(100));
        this.m_tfSize.setSigned(false);
        this.m_tfSize.setColumns(5);
        this.m_tfSize.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_TIP_POSITIVE_INTEGER"));
        this.m_lblSize.setText(DM4JResourceUtilities.getUIString("TBLVIEW_DATA_FETCHSIZE"));
        this.m_lblSize.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("TBLVIEW_DATA_FETCHSIZE"));
        this.m_lblSize.setLabelFor(this.m_tfSize);
        this.m_btnFetch.setText(DM4JResourceUtilities.getUIString("TBLVIEW_DATA_FETCHNEXT"));
        this.m_btnFetch.setMnemonic(DM4JResourceUtilities.getUIMnemonic("TBLVIEW_DATA_FETCHNEXT"));
        this.m_btnFetch.setEnabled(true);
        this.m_btnRefresh.setText(DM4JResourceUtilities.getUIString("TBLVIEW_DATA_REFRESH"));
        this.m_btnRefresh.setMnemonic(DM4JResourceUtilities.getUIMnemonic("TBLVIEW_DATA_REFRESH"));
        this.m_btnRefresh.setEnabled(true);
        this.m_btnExport.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_EXPORT"));
        this.m_btnExport.setEnabled(true);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.m_lblSize, gridBagConstraints);
        this.add((Component)this.m_tfSize, gridBagConstraints);
        this.add((Component)this.m_btnFetch, gridBagConstraints);
        this.add((Component)this.m_btnRefresh, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)new JLabel(), gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        this.add((Component)this.m_btnExport, gridBagConstraints);
    }

    public void addFetchActionListener(ActionListener actionListener) {
        this.m_btnFetch.addActionListener(actionListener);
    }

    public void removeFetchActionListener(ActionListener actionListener) {
        this.m_btnFetch.removeActionListener(actionListener);
    }

    public void addRefreshActionListener(ActionListener actionListener) {
        this.m_btnRefresh.addActionListener(actionListener);
    }

    public void removeRefreshActionListener(ActionListener actionListener) {
        this.m_btnRefresh.removeActionListener(actionListener);
    }

    public void addExportActionListener(ActionListener actionListener) {
        this.m_btnExport.addActionListener(actionListener);
    }

    public void removeExportActionListener(ActionListener actionListener) {
        this.m_btnExport.removeActionListener(actionListener);
    }

    public void setFetchEnabled(boolean bl) {
        this.m_btnFetch.setEnabled(bl);
    }

    public void setRefreshEnabled(boolean bl) {
        this.m_btnRefresh.setEnabled(bl);
    }

    public void setExportEnabled(boolean bl) {
        this.m_btnExport.setEnabled(bl);
    }

    public int getFetchSize() {
        int n = 0;
        try {
            n = this.m_tfSize.getNumber().intValue();
        }
        catch (NumberFormatException numberFormatException) {
            n = 100;
        }
        return n;
    }

    public void fetchNextPerformed(ResultSetNavigationEvent resultSetNavigationEvent) {
        this.m_btnFetch.setEnabled(resultSetNavigationEvent.getNumberFetched() == resultSetNavigationEvent.getFetchSize());
    }

    public void refreshPerformed(ResultSetNavigationEvent resultSetNavigationEvent) {
        this.m_btnFetch.setEnabled(true);
    }
}

