/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.sort;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.viewer.sort.AttributeSelectionDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;

public class AttributeSelectionPanel
extends GriddedPanel {
    private static DM4JListResourceBundle res;
    AttributeSelectionDialog m_parentDialog;
    boolean m_isOk = false;
    Object[] m_unSelectedAttributes = null;
    Object[] m_selectedAttributes = null;
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    DefaultListModel availableAttributesModel = new DefaultListModel();
    JList availableList = new JList();
    JScrollPane availableScrollPane = new JScrollPane(this.availableList);
    DefaultListModel selectedAttributesModel = new DefaultListModel();
    JList selectedList = new JList();
    JScrollPane selectedScrollPane = new JScrollPane(this.selectedList);
    JButton addSelected = new JButton();
    JButton removeSelected = new JButton();
    JButton addAll = new JButton();
    JButton removeAll = new JButton();
    JLabel lblFiller = new JLabel();
    private Vector m_allAvailableItems;

    public AttributeSelectionPanel(AttributeSelectionDialog attributeSelectionDialog, Vector vector, Object[] objectArray, Object[] objectArray2) throws Exception {
        this.m_parentDialog = attributeSelectionDialog;
        this.m_unSelectedAttributes = objectArray;
        this.m_selectedAttributes = objectArray2;
        this.m_allAvailableItems = vector;
        this.jbInit();
    }

    private void jbInit() throws Exception {
        res = BrowserUtils.getBundleInstance();
        int n = 0;
        this.mlblStepDescription.setText(DM4JResourceUtilities.getUIString("COMMON_SELECT_ITEMS_DESCRIPTION"));
        this.mlblStepDescription.setPreferredRows(1);
        this.mlblStepDescription.setMinimumRows(1);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.addFilledComponent(this.mlblStepDescription, TOPLABELITEMINSETS, n++, 0, 5, 1, 1);
        this.availableList.setSelectionMode(2);
        this.availableList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int[] nArray = AttributeSelectionPanel.this.availableList.getSelectedIndices();
                if (nArray != null & nArray.length > 0) {
                    // empty if block
                }
            }
        });
        this.m_parentDialog.setInitialFocus(this.availableList);
        GriddedPanel griddedPanel = new GriddedPanel();
        GriddedPanel griddedPanel2 = new GriddedPanel();
        GriddedPanel griddedPanel3 = new GriddedPanel();
        JLabel jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_AVAILABLE_ITEMS"));
        jLabel.setLabelFor(this.availableScrollPane);
        this.availableScrollPane.setToolTipText(jLabel.getText());
        griddedPanel.addFilledComponent(jLabel, GriddedPanel.MIDLABELITEMINSETS, 0, 0, 2);
        griddedPanel.addFilledComponent(this.availableScrollPane, GriddedPanel.MIDLABELITEMINSETS, 1, 0, 2, 9, 1);
        JLabel jLabel2 = new JLabel(DM4JResourceUtilities.getUIString("COMMON_SELECTED_ITEMS"));
        jLabel2.setLabelFor(this.selectedScrollPane);
        this.selectedScrollPane.setToolTipText(jLabel2.getText());
        this.addSelected.setIcon(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/ShuttleRight.gif"));
        this.addSelected.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeSelectionPanel.this.btnAddSelected_actionPerformed();
            }
        });
        this.removeSelected.setIcon(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/ShuttleLeft.gif"));
        this.removeSelected.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeSelectionPanel.this.btnRemoveSelected_actionPerformed();
            }
        });
        this.addAll.setIcon(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/ShuttleRightAll.gif"));
        this.addAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeSelectionPanel.this.btnAddAll_actionPerformed();
            }
        });
        this.removeAll.setIcon(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/ShuttleLeftAll.gif"));
        this.removeAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeSelectionPanel.this.btnRemoveAll_actionPerformed();
            }
        });
        griddedPanel2.addFilledComponent(new JLabel(), new Insets(0, 0, 0, 0), 0, 0, 1, 3, 3);
        griddedPanel2.addComponent(this.addSelected, new Insets(0, 5, 0, 5), 3, 0, 1, 1, 13, 2);
        griddedPanel2.addComponent(this.removeSelected, new Insets(4, 5, 0, 5), 4, 0, 1, 1, 13, 2);
        griddedPanel2.addComponent(this.addAll, new Insets(4, 5, 0, 5), 5, 0, 1, 1, 13, 2);
        griddedPanel2.addComponent(this.removeAll, new Insets(4, 5, 0, 5), 6, 0, 1, 1, 13, 2);
        griddedPanel2.addFilledComponent(new JLabel(), new Insets(0, 0, 0, 0), 7, 0, 1, 2, 3);
        griddedPanel3.addComponent(jLabel2, GriddedPanel.MIDLABELITEMINSETS, 0, 0);
        griddedPanel3.addFilledComponent(this.selectedScrollPane, GriddedPanel.MIDLABELITEMINSETS, 1, 0, 2, 9, 1);
        this.selectedList.setSelectionMode(2);
        this.selectedList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int[] nArray = AttributeSelectionPanel.this.availableList.getSelectedIndices();
                if (nArray != null & nArray.length > 0) {
                    // empty if block
                }
            }
        });
        this.addWeightedComponent(griddedPanel, new Insets(10, 0, 0, 0), n, 0, 2, 3, 18, 1, 0.5, 100.0);
        this.addWeightedComponent(griddedPanel2, new Insets(10, 0, 0, 0), n, 2, 1, 3, 10, 0, 0.0, 0.0);
        this.addWeightedComponent(griddedPanel3, new Insets(10, 0, 0, 0), n, 3, 1, 3, 12, 1, 0.5, 100.0);
        this.addOKHelpCancelListeners();
        this.loadDefaultValues();
    }

    protected void loadDefaultValues() throws Exception {
        int n;
        Object[] objectArray = this.m_unSelectedAttributes;
        if (objectArray != null && objectArray.length > 0) {
            for (n = 0; n < objectArray.length; ++n) {
                this.availableAttributesModel.addElement(objectArray[n].toString());
            }
        }
        this.availableList.setModel(this.availableAttributesModel);
        objectArray = this.m_selectedAttributes;
        if (objectArray != null && objectArray.length > 0) {
            for (n = 0; n < objectArray.length; ++n) {
                this.selectedAttributesModel.addElement(objectArray[n].toString());
            }
        }
        this.selectedList.setModel(this.selectedAttributesModel);
    }

    protected void processUserInput() {
        this.m_unSelectedAttributes = this.availableAttributesModel.toArray();
        this.m_selectedAttributes = this.selectedAttributesModel.toArray();
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeSelectionPanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok" == string) {
            String string2 = this.validateSize();
            DM4JEvent dM4JEvent = (DM4JEvent)actionEvent;
            if (string2 == null) {
                this.processUserInput();
                this.m_isOk = true;
            } else {
                String string3 = DM4JResourceUtilities.getUIString("ERROR_TITLE");
                JOptionPane.showMessageDialog(BrowserFrame.getMainFrame(), string2, string3, 0);
                dM4JEvent.cancel();
            }
        } else if ("cancel" == string) {
            this.m_isOk = false;
        }
    }

    public Object[] getSelectedAttributeList() {
        return this.m_selectedAttributes;
    }

    public Object[] getUnSelectedAttributeList() {
        return this.m_unSelectedAttributes;
    }

    public boolean isOk() {
        return this.m_isOk;
    }

    private void moveSelectedItems(JList jList, DefaultListModel defaultListModel, DefaultListModel defaultListModel2) {
        Object e2;
        int n;
        int[] nArray = jList.getSelectedIndices();
        if (nArray == null || 0 == nArray.length) {
            return;
        }
        TreeSet treeSet = new TreeSet();
        Hashtable hashtable = new Hashtable();
        if (!defaultListModel.isEmpty()) {
            for (n = 0; n < defaultListModel.size(); ++n) {
                e2 = defaultListModel.getElementAt(n);
                treeSet.add(e2);
                hashtable.put(e2, e2);
            }
        }
        for (n = 0; n < nArray.length; ++n) {
            e2 = defaultListModel2.getElementAt(nArray[n]);
            treeSet.add(e2);
            hashtable.put(e2, e2);
        }
        defaultListModel.removeAllElements();
        for (Object e2 : treeSet) {
            defaultListModel.addElement(e2);
        }
        defaultListModel2.removeAllElements();
        if (this.m_allAvailableItems != null) {
            for (int i = 0; i < this.m_allAvailableItems.size(); ++i) {
                Object e3 = this.m_allAvailableItems.elementAt(i);
                if (null != hashtable.get(e3)) continue;
                defaultListModel2.addElement(e3);
            }
        }
        hashtable.clear();
    }

    protected void btnAddSelected_actionPerformed() {
        this.moveSelectedItems(this.availableList, this.selectedAttributesModel, this.availableAttributesModel);
    }

    protected void btnRemoveSelected_actionPerformed() {
        this.moveSelectedItems(this.selectedList, this.availableAttributesModel, this.selectedAttributesModel);
    }

    private void moveAll(DefaultListModel defaultListModel, DefaultListModel defaultListModel2) {
        defaultListModel.removeAllElements();
        defaultListModel2.removeAllElements();
        if (this.m_allAvailableItems == null || this.m_allAvailableItems.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.m_allAvailableItems.size(); ++i) {
            defaultListModel.addElement(this.m_allAvailableItems.elementAt(i));
        }
    }

    protected void btnAddAll_actionPerformed() {
        this.moveAll(this.selectedAttributesModel, this.availableAttributesModel);
    }

    protected void btnRemoveAll_actionPerformed() {
        this.moveAll(this.availableAttributesModel, this.selectedAttributesModel);
    }

    protected String validateSize() {
        if (this.selectedAttributesModel.getSize() > 1000) {
            return DM4JResourceUtilities.getUIString("ERROR_ASSOC_GREATER_1000");
        }
        return null;
    }
}

