/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.sort;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.datamining.association.AssociationModel;
import javax.datamining.association.RuleProperty;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JNumberTextField;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.viewer.sort.AttributeSelectionDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;

public class ARSortPanel
extends GriddedPanel {
    private static final String NONE = "none";
    protected JLabel[] m_lblRules = new JLabel[2];
    DM4JNumberTextField m_ruleFetchSize = new DM4JNumberTextField();
    DM4JNumberTextField m_ruleminConfidence = new DM4JNumberTextField();
    DM4JNumberTextField m_ruleminSupport = new DM4JNumberTextField();
    JCheckBox chkEnabledConfidenceFilter = new JCheckBox();
    JCheckBox chkEnabledSupportFilter = new JCheckBox();
    protected JComboBox[] m_comboRules = new JComboBox[2];
    protected DefaultComboBoxModel[] m_sortRules = new DefaultComboBoxModel[2];
    protected ComboActionListener[] m_actionListeners = new ComboActionListener[2];
    protected JComboBox[] m_comboOrder = new JComboBox[2];
    protected DefaultComboBoxModel[] m_sortOder = new DefaultComboBoxModel[2];
    private int COMBO1 = 0;
    private int COMBO2 = 1;
    private String[] m_attrList = null;
    AssociationModel m_model = null;
    private Vector m_antecedentItems = null;
    private Vector m_consequentItems = null;
    private static String[] m_labels;
    private static int[] m_labelsMnemonics;
    private static Hashtable m_htRuleNames;
    private Vector m_selectedRules = null;
    private Vector m_SelectedRulesSortOrder = null;
    private RuleProperty[] m_oldSortSriteria = null;
    private Boolean[] m_oldSortOrder = null;
    protected DM4JDialog m_parentDialog;
    private static String ASCENDING;
    private static String DESCENDING;
    private static String ANY;
    private static DM4JListResourceBundle res;
    static final int MAXNUMRULE = 100;
    static final double MIN_CONFIDENCE = 10.0;
    static final double MIN_SUPPORT = 1.0;
    private Integer m_fetchSize;
    private Double m_minConfidence;
    private Double m_minSupport;
    private boolean m_bSupport = true;
    private boolean m_bConfidence = true;
    private Object[] m_selectedAttributeBetween;
    private Object[] m_selectedAttributeAnd;
    private String _realAttributeName;
    private Object[] m_ifUnSelectedAttributes = null;
    private Object[] m_ifSelectedAttributes = null;
    private DefaultListModel ifAttributesModel = new DefaultListModel();
    private JList ifList = new JList();
    private JScrollPane ifScrollPane = new JScrollPane(this.ifList);
    private JButton btnIfEdit = new JButton();
    private Object[] m_thenUnSelectedAttributes = null;
    private Object[] m_thenSelectedAttributes = null;
    private DefaultListModel thenAttributesModel = new DefaultListModel();
    private JList thenList = new JList();
    private JScrollPane thenScrollPane = new JScrollPane(this.thenList);
    private JButton btnThenEdit = new JButton();

    public ARSortPanel(DM4JDialog dM4JDialog, AssociationModel associationModel, Integer n, Double d, Double d2, boolean bl, boolean bl2, Object[] objectArray, Object[] objectArray2, int n2, RuleProperty[] rulePropertyArray, Boolean[] booleanArray, Vector vector, Vector vector2, String string) throws Exception {
        this.m_parentDialog = dM4JDialog;
        this.m_oldSortSriteria = rulePropertyArray;
        this.m_oldSortOrder = booleanArray;
        this.m_model = associationModel;
        this.m_fetchSize = n;
        this.m_minSupport = d;
        this.m_minConfidence = d2;
        this.m_bSupport = bl;
        this.m_bConfidence = bl2;
        this.m_selectedAttributeBetween = objectArray;
        this.m_selectedAttributeAnd = objectArray2;
        this.m_antecedentItems = vector;
        this.m_consequentItems = vector2;
        this._realAttributeName = string;
        this.m_ifSelectedAttributes = this.m_selectedAttributeBetween;
        this.m_thenSelectedAttributes = this.m_selectedAttributeAnd;
        if (this.m_antecedentItems != null) {
            this.m_ifUnSelectedAttributes = this.m_antecedentItems.toArray();
        }
        if (this.m_consequentItems != null) {
            this.m_thenUnSelectedAttributes = this.m_antecedentItems.toArray();
        }
        this.jbInit();
    }

    private void btnIfEdit_actionPerformed(ActionEvent actionEvent) {
        try {
            AttributeSelectionDialog attributeSelectionDialog = new AttributeSelectionDialog(this.m_antecedentItems, this.m_parentDialog, this.m_ifUnSelectedAttributes, this.m_ifSelectedAttributes);
            if (attributeSelectionDialog.isOk()) {
                this.m_ifUnSelectedAttributes = attributeSelectionDialog.getUnSelectedAttributeList();
                this.m_ifSelectedAttributes = attributeSelectionDialog.getSelectedAttributeList();
                if (this.m_ifSelectedAttributes != null && this.m_ifSelectedAttributes.length > 0) {
                    this.ifAttributesModel.removeAllElements();
                    for (int i = 0; i < this.m_ifSelectedAttributes.length; ++i) {
                        this.ifAttributesModel.addElement(this.m_ifSelectedAttributes[i]);
                    }
                    this.ifList.setModel(this.ifAttributesModel);
                } else {
                    this.ifAttributesModel.removeAllElements();
                    this.ifAttributesModel.addElement(ANY);
                    this.ifList.setModel(this.ifAttributesModel);
                    this.ifList.setSelectedIndex(0);
                }
            }
            this.processUserInput();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void btnThenEdit_actionPerformed(ActionEvent actionEvent) {
        try {
            AttributeSelectionDialog attributeSelectionDialog = new AttributeSelectionDialog(this.m_consequentItems, this.m_parentDialog, this.m_thenUnSelectedAttributes, this.m_thenSelectedAttributes);
            if (attributeSelectionDialog.isOk()) {
                this.m_thenUnSelectedAttributes = attributeSelectionDialog.getUnSelectedAttributeList();
                this.m_thenSelectedAttributes = attributeSelectionDialog.getSelectedAttributeList();
                if (this.m_thenSelectedAttributes != null && this.m_thenSelectedAttributes.length > 0) {
                    this.thenAttributesModel.removeAllElements();
                    for (int i = 0; i < this.m_thenSelectedAttributes.length; ++i) {
                        this.thenAttributesModel.addElement(this.m_thenSelectedAttributes[i]);
                    }
                    this.thenList.setModel(this.thenAttributesModel);
                } else {
                    this.thenAttributesModel.removeAllElements();
                    this.thenAttributesModel.addElement(ANY);
                    this.thenList.setModel(this.thenAttributesModel);
                    this.thenList.setSelectedIndex(0);
                }
            }
            this.processUserInput();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void jbInit() throws Exception {
        int n = 0;
        GriddedPanel griddedPanel = new GriddedPanel();
        GriddedPanel griddedPanel2 = new GriddedPanel();
        GriddedPanel griddedPanel3 = new GriddedPanel();
        JPanel jPanel = new JPanel(new BorderLayout());
        griddedPanel.setBorder(new TitledBorder(DM4JResourceUtilities.getUIString("ASSOC_RULE_CRITERIA")));
        griddedPanel3.setBorder(new TitledBorder(DM4JResourceUtilities.getUIString("ASSOC_RULE_FILTER_CRITERIA")));
        griddedPanel2.setBorder(new TitledBorder(DM4JResourceUtilities.getUIString("ASSOC_RULE_SORT_CRITERIA")));
        jPanel.add((Component)griddedPanel, "North");
        jPanel.add((Component)griddedPanel3, "Center");
        jPanel.add((Component)griddedPanel2, "South");
        this.add(jPanel);
        JLabel jLabel = new JLabel(DM4JResourceUtilities.getUIString("ASSOC_RULE_BETWEEN"));
        griddedPanel.addAnchoredComponent(jLabel, COL1_LABEL, n, 0, 1, 1, 18);
        JLabel jLabel2 = new JLabel(DM4JResourceUtilities.getUIString("ASSOC_RULE_AND"));
        griddedPanel.addAnchoredComponent(jLabel2, COL1_LABEL, n++, 1, 1, 1, 18);
        this.ifList.setSelectionMode(0);
        this.ifScrollPane.setMinimumSize(new Dimension(150, 200));
        this.ifScrollPane.setPreferredSize(new Dimension(150, 200));
        this.ifScrollPane.setMaximumSize(new Dimension(150, 200));
        griddedPanel.addAnchoredComponent(this.ifScrollPane, COL1_LABEL, n, 0, 1, 1, 18);
        this.thenList.setSelectionMode(0);
        this.thenScrollPane.setMinimumSize(new Dimension(150, 200));
        this.thenScrollPane.setPreferredSize(new Dimension(150, 200));
        this.thenScrollPane.setMaximumSize(new Dimension(150, 200));
        griddedPanel.addAnchoredComponent(this.thenScrollPane, COL1_LABEL, n++, 1, 1, 1, 18);
        this.btnIfEdit.setText(DM4JResourceUtilities.getUIString("COMMON_EDIT"));
        this.btnIfEdit.setMnemonic(DM4JResourceUtilities.getUIMnemonic(res, "COMMON_EDIT"));
        this.btnIfEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ARSortPanel.this.btnIfEdit_actionPerformed(actionEvent);
            }
        });
        griddedPanel.addAnchoredComponent(this.btnIfEdit, COL1_LABEL, n, 0, 1, 1, 12);
        this.btnThenEdit.setText(DM4JResourceUtilities.getUIString("COMMON_EDIT"));
        this.btnThenEdit.setMnemonic(DM4JResourceUtilities.getUIMnemonic(res, "COMMON_EDIT"));
        this.btnThenEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ARSortPanel.this.btnThenEdit_actionPerformed(actionEvent);
            }
        });
        griddedPanel.addAnchoredComponent(this.btnThenEdit, COL1_LABEL, n++, 1, 1, 1, 12);
        griddedPanel.addFilledComponent(new JLabel(), COL1_INDENTED1_LABEL, n, 0, 4, 1, 1);
        n = 0;
        Dimension dimension = new Dimension(50, 20);
        griddedPanel3.addFilledComponent(new JLabel(), COL1_INDENTED1_LABEL, n++, 0, 4, 1, 1);
        this.chkEnabledConfidenceFilter.setSelected(this.m_bConfidence);
        this.chkEnabledConfidenceFilter.setText(DM4JResourceUtilities.getUIString("ASSOC_RULE_MIN_CONFIDENCE"));
        this.chkEnabledConfidenceFilter.setMnemonic(res.getMnemonic("ASSOC_RULE_MIN_CONFIDENCE"));
        this.chkEnabledConfidenceFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ARSortPanel.this.optEnabledchkEnabledConfidenceFilter_actionPerformed(actionEvent);
            }
        });
        griddedPanel3.addFilledComponent(this.chkEnabledConfidenceFilter, COL1_CONTROL, n, 0, 3, 1, 2);
        this.m_ruleminConfidence.setMinimumSize(dimension);
        this.m_ruleminConfidence.setColumns(5);
        this.m_ruleminConfidence.setDecimal(true, 2);
        this.m_ruleminConfidence.setDataType(Float.class);
        this.m_ruleminConfidence.setEnabled(this.m_bConfidence);
        griddedPanel3.addFilledComponent(this.m_ruleminConfidence, COL1_CONTROL, n++, 3, 1, 1, 2);
        this.chkEnabledSupportFilter.setSelected(this.m_bSupport);
        this.chkEnabledSupportFilter.setText(DM4JResourceUtilities.getUIString("ASSOC_RULE_MIN_SUPPORT"));
        this.chkEnabledSupportFilter.setMnemonic(res.getMnemonic("ASSOC_RULE_MIN_SUPPORT"));
        this.chkEnabledSupportFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ARSortPanel.this.optEnabledchkEnabledSupportFilter_actionPerformed(actionEvent);
            }
        });
        griddedPanel3.addFilledComponent(this.chkEnabledSupportFilter, COL1_CONTROL, n, 0, 3, 1, 2);
        this.m_ruleminSupport.setMinimumSize(dimension);
        this.m_ruleminSupport.setColumns(5);
        this.m_ruleminSupport.setDecimal(true, 2);
        this.m_ruleminSupport.setDataType(Float.class);
        this.m_ruleminSupport.setEnabled(this.m_bSupport);
        griddedPanel3.addFilledComponent(this.m_ruleminSupport, COL1_CONTROL, n++, 3, 1, 1, 2);
        JLabel jLabel3 = new JLabel(DM4JResourceUtilities.getUIString("ASSOC_RULE_FETCH_SIZE"));
        jLabel3.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic(res, "ASSOC_RULE_FETCH_SIZE"));
        griddedPanel3.addFilledComponent(jLabel3, COL1_CONTROL, n, 0, 3, 1, 2);
        this.m_ruleFetchSize.setMinimumSize(dimension);
        this.m_ruleFetchSize.setColumns(5);
        jLabel3.setLabelFor(this.m_ruleFetchSize);
        griddedPanel3.addFilledComponent(this.m_ruleFetchSize, COL1_CONTROL, n++, 3, 1, 1, 2);
        griddedPanel3.addFilledComponent(new JLabel(), COL1_INDENTED1_LABEL, n, 0, 4, 1, 1);
        n = 0;
        griddedPanel2.addFilledComponent(new JLabel(), COL1_INDENTED1_LABEL, n++, 0, 4, 1, 1);
        for (int i = 0; i < m_labels.length; ++i) {
            this.m_lblRules[i] = new JLabel();
            this.m_comboRules[i] = new JComboBox();
            this.m_sortRules[i] = new DefaultComboBoxModel();
            this.m_comboRules[i].setModel(this.m_sortRules[i]);
            this.fillSortByCombo(i);
            this.m_comboOrder[i] = new JComboBox();
            this.m_sortOder[i] = new DefaultComboBoxModel();
            this.m_comboOrder[i].setModel(this.m_sortOder[i]);
            this.fillSortOrderCombo(i);
            this.m_lblRules[i].setText(m_labels[i]);
            this.m_lblRules[i].setDisplayedMnemonic(m_labelsMnemonics[i]);
            this.m_lblRules[i].setLabelFor(this.m_comboRules[i]);
            this.m_actionListeners[i] = new ComboActionListener(i);
            this.m_comboRules[i].addActionListener(this.m_actionListeners[i]);
            int n2 = 0;
            griddedPanel2.addFilledComponent(this.m_lblRules[i], COL1_LABEL, n, n2++, 1, 1, 2);
            griddedPanel2.addFilledComponent(this.m_comboRules[i], COL1_CONTROL, n, n2, 2, 1, 2);
            griddedPanel2.addFilledComponent(this.m_comboOrder[i], COL1_CONTROL, n++, n2 += 2, 1, 1, 2);
        }
        griddedPanel2.addFilledComponent(new JLabel(), COL1_INDENTED1_LABEL, n, 0, 4, 1, 1);
        this.loadRulesCriteria();
        this.enableOtherCombos();
        this.addOKHelpCancelListeners();
    }

    protected void optEnabledchkEnabledConfidenceFilter_actionPerformed(ActionEvent actionEvent) {
        this.m_ruleminConfidence.setEnabled(this.chkEnabledConfidenceFilter.isSelected());
    }

    protected void optEnabledchkEnabledSupportFilter_actionPerformed(ActionEvent actionEvent) {
        this.m_ruleminSupport.setEnabled(this.chkEnabledSupportFilter.isSelected());
    }

    private void enableOtherCombos() {
        String string = (String)this.m_comboRules[this.COMBO1].getSelectedItem();
        RuleProperty ruleProperty = (RuleProperty)m_htRuleNames.get(string);
        boolean bl = true;
        this.m_comboRules[this.COMBO2].setEnabled(bl);
        this.m_comboOrder[this.COMBO2].setEnabled(bl);
    }

    private String getRuleNameByValue(RuleProperty ruleProperty) {
        Enumeration enumeration = m_htRuleNames.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            RuleProperty ruleProperty2 = (RuleProperty)m_htRuleNames.get(string);
            if (!ruleProperty.equals(ruleProperty2)) continue;
            return string;
        }
        return null;
    }

    protected void fillSortOrderCombo(int n) {
        this.m_sortOder[n].addElement(ASCENDING);
        this.m_sortOder[n].addElement(DESCENDING);
        if (this.m_oldSortOrder != null && n < this.m_oldSortOrder.length) {
            this.m_sortOder[n].setSelectedItem(this.m_oldSortOrder[n] == true ? ASCENDING : DESCENDING);
        } else {
            this.m_sortOder[n].setSelectedItem(DESCENDING);
        }
    }

    protected void fillSortByCombo(int n) {
        Enumeration enumeration = m_htRuleNames.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            RuleProperty ruleProperty = (RuleProperty)m_htRuleNames.get(string);
            if (n == this.COMBO1) {
                this.m_sortRules[n].addElement(string);
                if (this.m_oldSortSriteria != null && this.m_oldSortSriteria.length > n && this.m_oldSortSriteria[n] != null) {
                    this.m_sortRules[n].setSelectedItem(this.getRuleNameByValue(this.m_oldSortSriteria[n]));
                    continue;
                }
                if (!ruleProperty.equals(RuleProperty.confidence)) continue;
                this.m_sortRules[n].setSelectedItem(string);
                continue;
            }
            if (n == this.COMBO2) {
                this.m_sortRules[n].addElement(string);
                if (this.m_oldSortSriteria != null && this.m_oldSortSriteria.length > n && this.m_oldSortSriteria[n] != null) {
                    this.m_sortRules[n].setSelectedItem(this.getRuleNameByValue(this.m_oldSortSriteria[n]));
                    continue;
                }
                if (!ruleProperty.equals(RuleProperty.support)) continue;
                this.m_sortRules[n].setSelectedItem(string);
                continue;
            }
            String string2 = (String)this.m_sortRules[this.COMBO1].getSelectedItem();
            if (0 == string.compareTo(string2)) {
                this.m_sortRules[n].addElement(NONE);
            } else {
                this.m_sortRules[n].addElement(string);
            }
            if (this.m_oldSortSriteria != null && this.m_oldSortSriteria.length > n && this.m_oldSortSriteria[n] != null) {
                this.m_sortRules[n].setSelectedItem(this.getRuleNameByValue(this.m_oldSortSriteria[n]));
                continue;
            }
            this.m_sortRules[n].setSelectedItem(NONE);
        }
    }

    private Object[] removeArray(Object[] objectArray, Object[] objectArray2) {
        Object[] objectArray3 = null;
        if (objectArray != null && objectArray2 != null) {
            Vector<Object> vector = new Vector<Object>();
            for (int i = 0; i < objectArray.length; ++i) {
                boolean bl = false;
                for (int j = 0; j < objectArray2.length; ++j) {
                    if (!objectArray[i].equals(objectArray2[j])) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                vector.add(objectArray[i]);
            }
            objectArray3 = vector.toArray();
        }
        return objectArray3;
    }

    private void loadRulesCriteria() {
        try {
            int n;
            this.m_ruleFetchSize.setNumber(this.m_fetchSize != null ? this.m_fetchSize : new Integer(100));
            this.m_ruleminConfidence.setNumber(this.m_minConfidence != null ? this.m_minConfidence : new Double(10.0));
            this.m_ruleminSupport.setNumber(this.m_minSupport != null ? this.m_minSupport : new Double(1.0));
            if (this.m_ifSelectedAttributes != null && 0 != this.m_ifSelectedAttributes.length) {
                this.ifAttributesModel.removeAllElements();
                for (n = 0; n < this.m_ifSelectedAttributes.length; ++n) {
                    this.ifAttributesModel.addElement(this.m_ifSelectedAttributes[n].toString());
                }
                this.m_ifUnSelectedAttributes = this.removeArray(this.m_ifUnSelectedAttributes, this.m_ifSelectedAttributes);
                this.ifList.setModel(this.ifAttributesModel);
            } else {
                this.ifAttributesModel.removeAllElements();
                this.ifAttributesModel.addElement(ANY);
                this.ifList.setModel(this.ifAttributesModel);
                this.ifList.setSelectedIndex(0);
            }
            if (this.m_thenSelectedAttributes != null && 0 != this.m_thenSelectedAttributes.length) {
                this.thenAttributesModel.removeAllElements();
                for (n = 0; n < this.m_thenSelectedAttributes.length; ++n) {
                    this.thenAttributesModel.addElement(this.m_thenSelectedAttributes[n].toString());
                }
                this.m_thenUnSelectedAttributes = this.removeArray(this.m_thenUnSelectedAttributes, this.m_thenSelectedAttributes);
                this.thenList.setModel(this.thenAttributesModel);
            } else {
                this.thenAttributesModel.removeAllElements();
                this.thenAttributesModel.addElement(ANY);
                this.thenList.setModel(this.thenAttributesModel);
                this.thenList.setSelectedIndex(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void reloadNextCombo(int n) {
        this.m_actionListeners[n].enable(false);
        this.m_comboRules[n].removeAllItems();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)this.m_sortRules[i].getSelectedItem();
        }
        Enumeration enumeration = m_htRuleNames.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                if (0 != string.compareTo(stringArray[i])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.m_sortRules[n].addElement(string);
        }
        this.m_sortRules[n].addElement(NONE);
        this.m_comboRules[n].setSelectedItem(NONE);
        this.m_actionListeners[n].enable(true);
    }

    protected void comboRule_actionPerformed(int n) {
        try {
            for (int i = n + 1; i <= this.COMBO2; ++i) {
                this.reloadNextCombo(i);
            }
            this.enableOtherCombos();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public RuleProperty[] getSortCriteria() {
        return this.m_selectedRules.toArray(new RuleProperty[this.m_selectedRules.size()]);
    }

    public Boolean[] getSortCriteriaOrder() {
        return this.m_SelectedRulesSortOrder.toArray(new Boolean[this.m_SelectedRulesSortOrder.size()]);
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ARSortPanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        block8: {
            String string = actionEvent.getActionCommand();
            if ("ok" == string) {
                try {
                    String string2 = this.validateFetchSize();
                    if (string2 == null && this.chkEnabledConfidenceFilter.isSelected()) {
                        string2 = this.validatePercntage(this.m_ruleminConfidence, DM4JResourceUtilities.getUIString("ASSOC_RULE_MIN_CONFIDENCE"));
                    }
                    if (string2 == null && this.chkEnabledSupportFilter.isSelected()) {
                        string2 = this.validatePercntage(this.m_ruleminSupport, DM4JResourceUtilities.getUIString("ASSOC_RULE_MIN_SUPPORT"));
                    }
                    DM4JEvent dM4JEvent = (DM4JEvent)actionEvent;
                    if (string2 == null) {
                        this.processUserInput();
                        break block8;
                    }
                    String string3 = DM4JResourceUtilities.getUIString("ERROR_TITLE");
                    JOptionPane.showMessageDialog(BrowserFrame.getMainFrame(), string2, string3, 0);
                    dM4JEvent.cancel();
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                }
            } else if ("cancel" == string) {
                // empty if block
            }
        }
    }

    public int getNumberofRules() {
        return this.m_fetchSize != null ? this.m_fetchSize : 100;
    }

    public double getMinSupport() {
        return this.m_minSupport != null ? this.m_minSupport : 1.0;
    }

    public double getMinConfidence() {
        return this.m_minConfidence != null ? this.m_minConfidence : 10.0;
    }

    public boolean isMinSupport() {
        return this.chkEnabledSupportFilter.isSelected();
    }

    public boolean isMinConfidence() {
        return this.chkEnabledConfidenceFilter.isSelected();
    }

    public Object[] getAttributeBetween() {
        return this.m_selectedAttributeBetween;
    }

    public Object[] getAttributeAnd() {
        return this.m_selectedAttributeAnd;
    }

    private String validateFetchSize() {
        int n = 0;
        Number number = this.m_ruleFetchSize.getNumber();
        boolean bl = true;
        try {
            n = number != null ? number.intValue() : 0;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        boolean bl2 = true;
        if (bl && (n <= 0 || n > Integer.MAX_VALUE)) {
            bl2 = false;
        }
        if (!bl || !bl2) {
            String string = DM4JResourceUtilities.getUIString("ASSOC_RULE_FETCH_SIZE");
            String string2 = DM4JResourceUtilities.getUIString("ERROR_VALUE_INTEGER_ONLY");
            Object[] objectArray = new Object[]{string, "1", "2147483647"};
            String string3 = MessageFormat.format(string2, objectArray);
            return string3;
        }
        return null;
    }

    private String validatePercntage(JTextField jTextField, String string) {
        String string2;
        boolean bl = true;
        String string3 = null;
        try {
            double d;
            string2 = jTextField.getText();
            if (string2 != null && 0 != string2.length() && (d = Double.parseDouble(string2)) < 100.0 && d > 0.0) {
                string3 = null;
                bl = false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl = true;
        }
        if (bl) {
            string2 = DM4JResourceUtilities.getUIString("ERROR_VALUE_DOUBLE_ONLY");
            Object[] objectArray = new Object[]{string, "0", "100"};
            string3 = MessageFormat.format(string2, objectArray);
        }
        return string3;
    }

    protected void processUserInput() {
        Object object;
        this.m_selectedRules = new Vector();
        this.m_SelectedRulesSortOrder = new Vector();
        for (int i = 0; i < this.m_comboRules.length; ++i) {
            object = (String)this.m_comboRules[i].getSelectedItem();
            String string = (String)this.m_comboOrder[i].getSelectedItem();
            RuleProperty ruleProperty = (RuleProperty)m_htRuleNames.get(object);
            if (ruleProperty == null) continue;
            this.m_selectedRules.add(i, ruleProperty);
            this.m_SelectedRulesSortOrder.add(i, new Boolean(0 == string.compareTo(ASCENDING)));
        }
        Number number = this.m_ruleFetchSize.getNumber();
        this.m_fetchSize = new Integer(number != null ? number.intValue() : 100);
        object = null;
        this.m_minSupport = this.chkEnabledSupportFilter.isSelected() ? new Double((object = this.m_ruleminSupport.getNumber()) != null ? ((Number)object).doubleValue() : 1.0) : null;
        this.m_minConfidence = this.chkEnabledConfidenceFilter.isSelected() ? new Double((object = this.m_ruleminConfidence.getNumber()) != null ? ((Number)object).doubleValue() : 10.0) : null;
        this.m_selectedAttributeBetween = this.m_ifSelectedAttributes;
        this.m_selectedAttributeAnd = this.m_thenSelectedAttributes;
        this.m_bConfidence = this.chkEnabledConfidenceFilter.isSelected();
        this.m_bSupport = this.chkEnabledSupportFilter.isSelected();
    }

    public Vector getAntecedentItems() {
        return this.m_antecedentItems;
    }

    public Vector getConsequentItems() {
        return this.m_consequentItems;
    }

    static {
        m_htRuleNames = new Hashtable();
        res = BrowserUtils.getBundleInstance();
        m_labels = new String[]{DM4JResourceUtilities.getUIString("SORT_RULES_SORT_BY"), DM4JResourceUtilities.getUIString("SORT_RULES_THEN_BY1")};
        m_labelsMnemonics = new int[]{DM4JResourceUtilities.getUIMnemonic("SORT_RULES_SORT_BY"), DM4JResourceUtilities.getUIMnemonic("SORT_RULES_THEN_BY1")};
        m_htRuleNames.put(DM4JResourceUtilities.getUIString("SORT_DIALOG_RULE_SUPPORT"), RuleProperty.support);
        m_htRuleNames.put(DM4JResourceUtilities.getUIString("SORT_DIALOG_RULE_CONFIDENCE"), RuleProperty.confidence);
        ASCENDING = DM4JResourceUtilities.getUIString("SORT_DIALOG_SORT_RULES_ASC");
        DESCENDING = DM4JResourceUtilities.getUIString("SORT_DIALOG_SORT_RULES_DESC");
        ANY = BrowserUtils.getBundleInstance().getString("ASSOC_RULE_ANY_ITEM");
    }

    private class ComboActionListener
    implements ActionListener {
        int m_comboNumber = 0;
        boolean m_enable = true;

        ComboActionListener(int n) {
            this.m_comboNumber = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.m_enable) {
                ARSortPanel.this.comboRule_actionPerformed(this.m_comboNumber);
            }
        }

        public void enable(boolean bl) {
            this.m_enable = bl;
        }
    }
}

