/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.results.test;

import java.awt.Color;
import java.awt.Dimension;
import javax.datamining.data.CategoryMatrix;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.grid.ComplexAppearanceManager;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderDataToolTipManager;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.ImmInsets;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTable;
import oracle.dmt.dm4j.browser.viewer.results.test.ConfusionMatrixTableModel;

public final class ConfusionMatrixTable
extends Dm4jSpreadTable {
    private boolean m_bShowFloats = false;

    public ConfusionMatrixTable(Object object) {
        super(object);
        Object[] objectArray = ((CategoryMatrix)object).getCategories().toArray();
        String[] stringArray = null;
        if (objectArray != null) {
            stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = objectArray[i].toString();
            }
            this.setColumnNames(stringArray);
        }
        Grid grid = this.getGrid();
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 0, 0);
        grid.setGridSelectionManager(generalGridSelectionManager);
    }

    public void load() throws Exception {
        CategoryMatrix categoryMatrix = (CategoryMatrix)this.getDataItem();
        if (null == categoryMatrix) {
            throw new Exception("Cannot load data. CategoryMatrix not supplied");
        }
        this.setVerticalSeparatorsVisible(true);
        ConfusionMatrixTableModel confusionMatrixTableModel = new ConfusionMatrixTableModel();
        confusionMatrixTableModel.setShowFloats(this.m_bShowFloats);
        confusionMatrixTableModel.load(categoryMatrix);
        this.setModels((TwoDModel)confusionMatrixTableModel, this.getColModel(), this.getColModel());
        Header header = this.getColumnHeader();
        header.setToolTipManager(new ToolTipHeader(this.getColModel()));
        header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        header.setCanMoveItems(false);
        Header header2 = this.getRowHeader();
        header2.setToolTipManager(new ToolTipHeader(this.getColModel()));
        int n = 0;
        Dimension dimension = null;
        Painter painter = this.getRowHeader().getDefaultPainter();
        for (int i = 0; i < this.getRowHeader().getItemCount(); ++i) {
            int n2 = 0;
            PaintContext paintContext = this.getRowHeader().getItemPaintContext(i);
            dimension = painter.getPreferredSize(paintContext);
            Appearance appearance = this.getRowHeader().getItemAppearance(i);
            ImmInsets immInsets = appearance.getInsets();
            dimension.width += (n2 += 2 * (immInsets.left + immInsets.right));
            if (dimension.width <= n) continue;
            n = dimension.width;
        }
        this.setRowHeaderWidth(n);
    }

    public void showColorDiagonal() throws Exception {
        int n;
        Grid grid = this.getGrid();
        SortableTwoDModel sortableTwoDModel = (SortableTwoDModel)grid.getModel();
        int n2 = sortableTwoDModel.getRowCount();
        if (n2 != (n = sortableTwoDModel.getColumnCount())) {
            throw new Exception("Table is not symmetrical.  Diagonal cannot be displayed");
        }
        ComplexAppearanceManager complexAppearanceManager = new ComplexAppearanceManager();
        grid.setAppearanceManager(complexAppearanceManager);
        for (int i = 0; i < n; ++i) {
            Appearance appearance = complexAppearanceManager.getCellAppearance(i, i);
            appearance.setBackground(new Color(173, 178, 206));
            appearance.setForeground(Color.black);
            complexAppearanceManager.setCellAppearance(i, i, appearance);
        }
    }

    public void setShowFloats(boolean bl) {
        this.m_bShowFloats = bl;
    }

    class ToolTipHeader
    extends HeaderDataToolTipManager {
        ArrayOneDModel m_tips;

        ToolTipHeader(ArrayOneDModel arrayOneDModel) {
            this.m_tips = arrayOneDModel;
        }

        public String getItemToolTipValue(Header header, int n) {
            return (String)this.m_tips.getData(n);
        }
    }
}

