/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.results.build;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import javax.datamining.resource.Connection;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.HyperlinkButtonDataSource;
import oracle.dmt.dm4j.browser.viewer.activity.OutputDataViewerFrame;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.jdm.jdmresult.OraMiningBuildResult;

public class BuildTaskPanel
extends GriddedPanel {
    JTextField m_name = new JTextField();
    JLabel m_target = new JLabel();
    JLabel m_type = new JLabel();
    JTextField m_modelName = new JTextField();
    JLabel m_inSchema = new JLabel();
    HyperlinkButtonDataSource m_inTable = new HyperlinkButtonDataSource();
    JLabel m_startDate = new JLabel();
    JLabel m_startTime = new JLabel();
    JLabel m_endDate = new JLabel();
    JLabel m_endTime = new JLabel();
    OraMiningBuildResult m_parent = null;

    public BuildTaskPanel(OraMiningBuildResult oraMiningBuildResult) {
        try {
            this.m_parent = oraMiningBuildResult;
            this.jbInit();
            this.runTimePanelLoad();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public BuildTaskPanel(String string) {
        try {
            this.m_parent = this.loadBuildTask(string);
            if (this.m_parent != null && this.m_parent.getTaskName().length() > 0) {
                this.jbInit();
                this.runTimePanelLoad();
            } else {
                this.loadNotFoundPanel();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void loadNotFoundPanel() {
        this.addFilledComponent(new JLabel(), TOPLABELITEMINSETS, 0, 0, 4, 1, 2);
        this.addFilledComponent(new JLabel(), TOPLABELITEMINSETS, 1, 0, 1, 1, 2);
        this.addFilledComponent(new JLabel(DM4JResourceUtilities.getUIString("COMMON_TASK_NOT_FOUND")), TOPLABELITEMINSETS, 1, 1, 2, 1, 2);
        this.addFilledComponent(new JLabel(), TOPLABELITEMINSETS, 2, 0, 4, 3, 1);
        this.setPreferredSize(new Dimension(0, 0));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OraMiningBuildResult loadBuildTask(String string) throws Exception {
        Connection connection = null;
        OraMiningBuildResult oraMiningBuildResult = null;
        try {
            try {
                connection = DM4JConnectionManager.getConnection();
                oraMiningBuildResult = (OraMiningBuildResult)OraMiningBuildResult.restore(connection, string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw exception;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            try {
                if (connection == null) throw throwable;
                connection.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (connection == null) return oraMiningBuildResult;
        connection.close();
        return oraMiningBuildResult;
    }

    public String getHelpId() {
        return "BUILD_RESULT";
    }

    private void jbInit() throws Exception {
        int n = 1;
        JLabel jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_NAME"));
        this.m_name.setEditable(false);
        this.m_name.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.addComponent(jLabel, TOPLABELITEMINSETS, n, 1);
        this.addComponent(this.m_name, TOPVALUEITEMINSETS, n++, 2);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_START_DATE"));
        this.addComponent(jLabel, MIDLABELITEMINSETS, n, 1);
        this.addComponent(this.m_startDate, MIDVALUEITEMINSETS, n++, 2);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_START_TIME"));
        this.addComponent(jLabel, MIDLABELITEMINSETS, n, 1);
        this.addComponent(this.m_startTime, MIDVALUEITEMINSETS, n++, 2);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_END_DATE"));
        this.addComponent(jLabel, MIDLABELITEMINSETS, n, 1);
        this.addComponent(this.m_endDate, MIDVALUEITEMINSETS, n++, 2);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_END_TIME"));
        this.addComponent(jLabel, MIDLABELITEMINSETS, n, 1);
        this.addComponent(this.m_endTime, MIDVALUEITEMINSETS, n++, 2);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("BUILD_RESULT_MODEL_NAME"));
        this.addComponent(jLabel, TOPLABELITEMINSETS, n, 1, 1, 1, 17, 0);
        this.m_modelName.setEditable(false);
        this.m_modelName.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.addComponent(this.m_modelName, TOPVALUEITEMINSETS, n++, 2, 1, 1, 16, 0);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_INPUT_DATA"));
        this.addComponent(jLabel, TOPLABELITEMINSETS, n++, 1);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_SCHEMA"));
        this.addComponent(jLabel, MIDINDENTEDLABELITEMINSETS, n, 1);
        this.addComponent(this.m_inSchema, MIDVALUEITEMINSETS, n++, 2);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_TABLE_OR_VIEW"));
        this.addComponent(jLabel, MIDINDENTEDLABELITEMINSETS, n, 1);
        this.addComponent(this.m_inTable, MIDVALUEITEMINSETS, n++, 2);
        this.addFilledComponent(new JLabel(" "), TOPLABELITEMINSETS, n, 1, 4, 2, 1);
    }

    private void runTimePanelLoad() throws Exception {
        String string = this.m_parent.getTaskName();
        this.m_name.setText(string);
        Date date = this.m_parent.getCreationDate();
        Timestamp timestamp = this.m_parent.getCompletionTimestamp();
        DateFormat dateFormat = DateFormat.getDateInstance(3, Locale.getDefault());
        String string2 = null;
        if (date != null) {
            string2 = dateFormat.format(date);
        }
        this.m_startDate.setText(string2);
        dateFormat = DateFormat.getTimeInstance(3, Locale.getDefault());
        String string3 = null;
        if (date != null) {
            string3 = dateFormat.format(date);
        }
        this.m_startTime.setText(string3);
        dateFormat = DateFormat.getDateInstance(3, Locale.getDefault());
        String string4 = dateFormat.format(timestamp);
        this.m_endDate.setText(string4);
        dateFormat = DateFormat.getTimeInstance(3, Locale.getDefault());
        String string5 = dateFormat.format(timestamp);
        this.m_endTime.setText(string5);
        String string6 = this.m_parent.getMiningModel();
        this.m_modelName.setText(string6);
        String string7 = DM4JStringUtils.trimDoubleQuotes(this.m_parent.getSchemaName());
        this.m_inSchema.setText(string7);
        String string8 = DM4JStringUtils.trimDoubleQuotes(this.m_parent.getInputTableName());
        this.m_inTable.setText(string8);
        this.m_inTable.setSchemaName(string7);
        this.m_inTable.setTableName(string8);
        this.m_inTable.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                BuildTaskPanel.this.selectOutputData_actionPerformed(actionEvent);
            }
        });
    }

    private void selectOutputData_actionPerformed(ActionEvent actionEvent) {
        try {
            final HyperlinkButtonDataSource hyperlinkButtonDataSource = (HyperlinkButtonDataSource)actionEvent.getSource();
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void run() {
                    block10: {
                        java.sql.Connection connection = null;
                        connection = DM4JConnectionManager.getDbConnection();
                        if (DatabaseMetadata.isTable(connection, hyperlinkButtonDataSource.getSchemaName(), hyperlinkButtonDataSource.getTableName())) {
                            hyperlinkButtonDataSource.setIsView(false);
                        } else {
                            hyperlinkButtonDataSource.setIsView(true);
                        }
                        OutputDataViewerFrame outputDataViewerFrame = new OutputDataViewerFrame(hyperlinkButtonDataSource);
                        Object var4_4 = null;
                        try {
                            connection.close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        break block10;
                        {
                            catch (Exception exception) {
                                exception.printStackTrace();
                                Object var4_5 = null;
                                try {
                                    connection.close();
                                }
                                catch (Exception exception2) {
                                    exception2.printStackTrace();
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Object var4_6 = null;
                            try {
                                connection.close();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            throw throwable;
                        }
                    }
                }
            };
            Thread thread = new Thread(runnable);
            thread.setPriority(5);
            thread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

