/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.results.apply;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.HyperlinkButtonDataSource;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTableExcelAdapter;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.viewer.activity.OutputDataViewerFrame;
import oracle.dmt.dm4j.browser.viewer.export.ExportDialog;
import oracle.dmt.dm4j.browser.viewer.results.apply.PredictOutputTable;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.jdm.jdmresult.OraMiningPredictResult;

public class PredictResultViewer
extends GriddedPanel {
    JLabel m_name = new JLabel();
    JLabel m_targetAttributeName = new JLabel();
    JLabel m_inSchema = new JLabel();
    HyperlinkButtonDataSource m_inTable = new HyperlinkButtonDataSource();
    JLabel m_outSchema = new JLabel();
    HyperlinkButtonDataSource m_outTable = new HyperlinkButtonDataSource();
    JLabel m_startDate = new JLabel();
    JLabel m_startTime = new JLabel();
    JLabel m_endDate = new JLabel();
    JLabel m_endTime = new JLabel();
    JPanel m_grdPanel = null;
    NumberTextField m_fetchSize = null;
    JScrollPane m_aoPanel = new JScrollPane();
    JLabel m_aoNotFound = null;
    PredictOutputTable m_aoTable = null;
    OraMiningPredictResult m_predict = null;
    static final int MAXNUMROW = 100;

    public PredictResultViewer(LeafNodeData leafNodeData) {
        try {
            this.m_predict = (OraMiningPredictResult)leafNodeData.getOdmObject();
            this.jbInit();
            this.runTimePanelLoad(leafNodeData);
            this.setMinimumSize(BrowserFrame.m_prefRightPaneSize);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getHelpId() {
        return "dm4j_predict_html";
    }

    private void jbInit() throws Exception {
        JTabbedPane jTabbedPane = new JTabbedPane();
        GriddedPanel griddedPanel = new GriddedPanel();
        GriddedPanel griddedPanel2 = new GriddedPanel();
        jTabbedPane.addTab(DM4JResourceUtilities.getUIString("RESULT_PREDICT_OUTPUT_TAB"), null, griddedPanel2, DM4JResourceUtilities.getUIString("RESULT_PREDICT_OUTPUT_TAB"));
        jTabbedPane.addTab(DM4JResourceUtilities.getUIString("RESULT_TASK_TAB"), null, griddedPanel, DM4JResourceUtilities.getUIString("RESULT_TASK_TAB"));
        jTabbedPane.setComponentAt(0, griddedPanel2);
        jTabbedPane.setComponentAt(1, griddedPanel);
        int n = 1;
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        JLabel jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_NAME"));
        griddedPanel.addComponent(jLabel, TOPLABELITEMINSETS, n, 1);
        griddedPanel.addComponent(this.m_name, TOPVALUEITEMINSETS, n++, 2);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_START_DATE"));
        griddedPanel.addComponent(jLabel, MIDLABELITEMINSETS, n, 1);
        griddedPanel.addComponent(this.m_startDate, MIDVALUEITEMINSETS, n++, 2);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_START_TIME"));
        griddedPanel.addComponent(jLabel, MIDLABELITEMINSETS, n, 1);
        griddedPanel.addComponent(this.m_startTime, MIDVALUEITEMINSETS, n++, 2);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_END_DATE"));
        griddedPanel.addComponent(jLabel, MIDLABELITEMINSETS, n, 1);
        griddedPanel.addComponent(this.m_endDate, MIDVALUEITEMINSETS, n++, 2);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_END_TIME"));
        griddedPanel.addComponent(jLabel, MIDLABELITEMINSETS, n, 1);
        griddedPanel.addComponent(this.m_endTime, MIDVALUEITEMINSETS, n++, 2);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_TARGET"));
        jLabel.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_TARGET"));
        griddedPanel.addComponent(jLabel, TOPLABELITEMINSETS, n, 1, 1, 1, 17, 0);
        griddedPanel.addComponent(this.m_targetAttributeName, TOPVALUEITEMINSETS, n++, 2, 1, 1, 16, 0);
        jLabel.setLabelFor(this.m_targetAttributeName);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_INPUT_DATA"));
        griddedPanel.addComponent(jLabel, TOPLABELITEMINSETS, n++, 1);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_SCHEMA"));
        griddedPanel.addComponent(jLabel, MIDINDENTEDLABELITEMINSETS, n, 1);
        griddedPanel.addComponent(this.m_inSchema, MIDVALUEITEMINSETS, n++, 2);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_TABLE_OR_VIEW"));
        griddedPanel.addComponent(jLabel, MIDINDENTEDLABELITEMINSETS, n, 1);
        griddedPanel.addComponent(this.m_inTable, MIDVALUEITEMINSETS, n++, 2);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_OUTPUT_DATA"));
        griddedPanel.addComponent(jLabel, TOPLABELITEMINSETS, n++, 1);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_SCHEMA"));
        griddedPanel.addComponent(jLabel, MIDINDENTEDLABELITEMINSETS, n, 1);
        griddedPanel.addComponent(this.m_outSchema, MIDVALUEITEMINSETS, n++, 2);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_TABLE_OR_VIEW"));
        griddedPanel.addComponent(jLabel, MIDINDENTEDLABELITEMINSETS, n, 1);
        griddedPanel.addComponent(this.m_outTable, MIDVALUEITEMINSETS, n++, 2);
        griddedPanel.addFilledComponent(new JLabel(" "), TOPLABELITEMINSETS, n, 1, 4, 2, 1);
        n = 1;
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("PREDICT_RESULT_SCORE_OUTPUT_TABLE"));
        griddedPanel2.addComponent(jLabel, TOPLABELITEMINSETS, n, 1);
        boolean bl = this.predictOutputExists();
        if (!bl) {
            this.m_aoNotFound = new JLabel(DM4JResourceUtilities.getUIString("PREDICT_RESULT_NO_OUTPUT_TABLE"));
            griddedPanel2.addComponent(this.m_aoNotFound, TOPVALUEITEMINSETS, n++, 2);
            JLabel jLabel2 = new JLabel();
            griddedPanel2.addFilledComponent(jLabel2, TOPLABELITEMINSETS, n, 1, 2, 2, 1);
        } else {
            ++n;
            this.m_grdPanel = new JPanel(new BorderLayout());
            this.m_aoTable = new PredictOutputTable(this.m_predict);
            this.m_aoPanel.getViewport().add(this.m_aoTable);
            this.m_aoPanel.setPreferredSize(null);
            this.m_grdPanel.add((Component)this.m_aoPanel, "Center");
            GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 2, 0);
            this.m_aoTable.getGrid().setGridSelectionManager(generalGridSelectionManager);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(0, 5, 0));
            JLabel jLabel3 = new JLabel(DM4JResourceUtilities.getUIString("COMMON_FETCH_SIZE"));
            jLabel3.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_FETCH_SIZE"));
            this.m_fetchSize = new NumberTextField(new Integer(100), 5);
            this.m_fetchSize.setLocale(Locale.getDefault());
            this.m_fetchSize.setSigned(false);
            jLabel3.setLabelFor(this.m_fetchSize);
            JButton jButton = new JButton(DM4JResourceUtilities.getUIString("COMMON_REFRESH"));
            jButton.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_REFRESH"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PredictResultViewer.this.btnRefresh_actionPerformed(actionEvent);
                }
            });
            jPanel.add(jLabel3);
            jPanel.add(this.m_fetchSize);
            jPanel.add(jButton);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "West");
            JButton jButton2 = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/save.gif"));
            jButton2.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_EXPORT"));
            jPanel2.add((Component)jButton2, "East");
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
                        ExportDialog exportDialog = new ExportDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("COMMON_SAVE_FILE_AS"));
                        if (!exportDialog.isCancelled()) {
                            exportDialog.export(PredictResultViewer.this.m_aoTable);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
            Dm4jSpreadTableExcelAdapter dm4jSpreadTableExcelAdapter = new Dm4jSpreadTableExcelAdapter(this.m_aoTable);
            this.m_grdPanel.add((Component)jPanel2, "North");
            JLabel jLabel4 = new JLabel();
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.add((Component)this.m_grdPanel, "Center");
            griddedPanel2.addFilledComponent(jPanel3, MIDLABELITEMINSETS, n, 1, 2, 2, 1);
        }
        this.addFilledComponent(jTabbedPane, TOPLABELITEMINSETS, 0, 0, 5, 5, 1);
        jTabbedPane.setSelectedIndex(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void btnRefresh_actionPerformed(ActionEvent actionEvent) {
        block8: {
            block7: {
                try {
                    try {
                        this.setCursor(new Cursor(3));
                        int n = 0;
                        boolean bl = true;
                        n = this.m_fetchSize.getNumber().intValue();
                        boolean bl2 = true;
                        if (bl && (n <= 0 || n > Integer.MAX_VALUE)) {
                            bl2 = false;
                        }
                        if (!bl || !bl2) {
                            DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
                            String string = DM4JResourceUtilities.getUIString("COMMON_FETCH_SIZE");
                            String string2 = DM4JResourceUtilities.getUIString("ERROR_TITLE");
                            String string3 = DM4JResourceUtilities.getUIString("ERROR_VALUE_INTEGER_ONLY");
                            Object[] objectArray = new Object[]{string, "1", "2147483647"};
                            String string4 = MessageFormat.format(string3, objectArray);
                            JFrame jFrame = BrowserUtils.getParentFrame((Component)actionEvent.getSource());
                            JOptionPane.showMessageDialog(jFrame, string4, string2, 0);
                            this.m_fetchSize.requestFocus();
                            Object var13_13 = null;
                            break block7;
                        }
                        this.m_aoTable.displayLoadingStatus();
                        this.m_aoTable.load(n);
                        break block8;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        Object var13_15 = null;
                        this.setCursor(new Cursor(0));
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var13_16 = null;
                    this.setCursor(new Cursor(0));
                    throw throwable;
                }
            }
            this.setCursor(new Cursor(0));
            return;
        }
        Object var13_14 = null;
        this.setCursor(new Cursor(0));
    }

    private Double getDouble(Object object) {
        String string = object.toString();
        Double d = null;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = null;
        }
        return d;
    }

    private void runTimePanelLoad(LeafNodeData leafNodeData) throws Exception {
        String string = this.m_predict.getTaskName();
        this.m_name.setText(string);
        Timestamp timestamp = this.m_predict.getStartingTimestamp();
        DateFormat dateFormat = DateFormat.getDateInstance(3, Locale.getDefault());
        String string2 = dateFormat.format(timestamp);
        this.m_startDate.setText(string2);
        dateFormat = DateFormat.getTimeInstance(3, Locale.getDefault());
        String string3 = dateFormat.format(timestamp);
        this.m_startTime.setText(string3);
        Timestamp timestamp2 = this.m_predict.getCompletionTimestamp();
        dateFormat = DateFormat.getDateInstance(3, Locale.getDefault());
        String string4 = dateFormat.format(timestamp2);
        this.m_endDate.setText(string4);
        dateFormat = DateFormat.getTimeInstance(3, Locale.getDefault());
        String string5 = dateFormat.format(timestamp2);
        this.m_endTime.setText(string5);
        String string6 = this.m_predict.getTargetAttributeName();
        this.m_targetAttributeName.setText(string6);
        String string7 = this.m_predict.getSchemaName();
        this.m_inSchema.setText(string7);
        String string8 = this.m_predict.getInputTableName();
        this.m_inTable.setText(string8);
        this.m_inTable.setActive(true);
        this.m_inTable.setSchemaName(DM4JStringUtils.trimDoubleQuotes(string7));
        this.m_inTable.setTableName(DM4JStringUtils.trimDoubleQuotes(string8));
        this.m_inTable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PredictResultViewer.this.selectOutputData_actionPerformed(actionEvent);
            }
        });
        String string9 = DM4JConnectionManager.getUser();
        this.m_outSchema.setText(string9);
        String string10 = this.m_predict.getPredictOutputTableName();
        this.m_outTable.setText(string10);
        this.m_outTable.setActive(true);
        this.m_outTable.setSchemaName(DM4JStringUtils.trimDoubleQuotes(string9));
        this.m_outTable.setTableName(DM4JStringUtils.trimDoubleQuotes(string10));
        this.m_outTable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PredictResultViewer.this.selectOutputData_actionPerformed(actionEvent);
            }
        });
        if (this.m_aoTable != null) {
            this.m_aoTable.load(100);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean predictOutputExists() {
        boolean bl;
        block11: {
            Connection connection = null;
            bl = false;
            connection = DM4JConnectionManager.getDbConnection();
            bl = DatabaseMetadata.datasourceExists(connection, DM4JConnectionManager.getUser(), this.m_predict.getPredictOutputTableName());
            Object var5_3 = null;
            try {
                if (connection != null) {
                    connection.close();
                }
                break block11;
            }
            catch (Exception exception) {}
            break block11;
            {
                catch (Exception exception) {
                    Object var5_4 = null;
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                        break block11;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return bl;
    }

    private void selectOutputData_actionPerformed(ActionEvent actionEvent) {
        try {
            final HyperlinkButtonDataSource hyperlinkButtonDataSource = (HyperlinkButtonDataSource)actionEvent.getSource();
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void run() {
                    block10: {
                        Connection connection = null;
                        connection = DM4JConnectionManager.getDbConnection();
                        if (DatabaseMetadata.isTable(connection, hyperlinkButtonDataSource.getSchemaName(), hyperlinkButtonDataSource.getTableName())) {
                            hyperlinkButtonDataSource.setIsView(false);
                        } else {
                            hyperlinkButtonDataSource.setIsView(true);
                        }
                        OutputDataViewerFrame outputDataViewerFrame = new OutputDataViewerFrame(hyperlinkButtonDataSource);
                        Object var4_4 = null;
                        try {
                            connection.close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        break block10;
                        {
                            catch (Exception exception) {
                                exception.printStackTrace();
                                Object var4_5 = null;
                                try {
                                    connection.close();
                                }
                                catch (Exception exception2) {
                                    exception2.printStackTrace();
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Object var4_6 = null;
                            try {
                                connection.close();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            throw throwable;
                        }
                    }
                }
            };
            Thread thread = new Thread(runnable);
            thread.setPriority(5);
            thread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

